#!/bin/sh
# This file contains some 'visual tests' for ctioga to make sure that when
# I add some features to ctioga, I don't break everything existing.
# As such, it also stands as a 'feature list' for ctioga.

# Various axis stuff

. ./test_style.sh

ctioga -N -t 'Alternate axis' 'sin(x)' --y2 -y 'New $y$' 'x**2'

ctioga -N -t "Tilted title" --angle title 15 'sin(x)'

ctioga -N -t "Small X and Y ticks" --scale xticks 0.6 'sin(x)' \
    --scale yaxis 0.6 

ctioga -N -t "Tilted Y ticks" --angle yticks 15 'sin(x)'


ctioga -N -t "Vertical and horizontal lines" 'sin(x)' \
    --lines-color xaxis Pink --lines-color yaxis Orange 

ctioga -N -t "Bottom left" --xaxis bottom --yaxis left  'sin(x)'

ctioga -N -t "Top right" --xaxis top --yaxis right  'sin(x)'

ctioga -N -t "Axes styles" --xaxis ticks \
    --yaxis majornum  'sin(x)'

ctioga -N -t "Grid and axes" --grid column=2 \
    --xaxis top --yaxis right  'sin(x)' --next \
    'cos(x)' --next \
    --xaxis org --yaxis left  'tan(x)' --next \
    --yaxis org  'x**3 - 100*x'

ctioga -N -t "Non-linear axes" --shift title 2 \
    --xaxis bottom --new-axis EPR top \
    --axis-function EPR 6000/x 6000/x \
    --math-xrange 2500:4000 'sin(sqrt(x))'

