# An example file showing the possible interactions
# between ctioga and Tioga.

require 'CTioga/tioga'

class MyFigures

    include Tioga
    include FigureConstants

    def t
        @figure_maker
    end

    def initialize
        @figure_maker = FigureMaker.default
        t.def_figure("Blue") { blue }
        t.def_figure("Red") { red }
        t.def_figure_ctioga("CTiogaFigure", '--math 3*sin(x)') 
        t.def_figure("CTiogaShowPlot") { row_triplets }
        t.save_dir = 'figures_out'
    end

    def row_triplets
      row_margin = -0.02
      t.rescale(0.7)
      t.subplot(t.row_margins('num_rows' => 3, 'row' => 1,
                              'row_margin' => row_margin)) {
        t.show_plot_ctioga('--math -c Pink cos(x)')
      }
      t.subplot(t.row_margins('num_rows' => 3, 'row' => 2,
                              'row_margin' => row_margin)) {
        t.show_plot_ctioga('--math -c Orange sin(x)')
      }
      t.subplot(t.row_margins('num_rows' => 3, 'row' => 3,
                              'row_margin' => row_margin)) {
        t.show_plot_ctioga('--math -c Violet sin(x)')
      }
    end

    def blue
        t.fill_color = Blue
        t.fill_frame
    end

    def red
        t.fill_color = Red
        t.fill_frame
    end

end

MyFigures.new
