# trim.rb : A trimming filter
# Copyright (C) 2007 Vincent Fourmond

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

module SciYAG

  module Backends

    # Removes a given ratio of points
    class TrimFilter < Filter
      include Dobjects

      describe "trim", "Trim", "Removes a certain number of points"

      init_param 'nb', "Number", Float, 
      "Keep one point for each nb points"

      def initialize(nb) 
        @nb = Float(nb)
        if @nb <= 1
          warn "Invalid parameter nb #{nb}, using 3"
          @nb = 3
        end
      end

      # There you go: a simple averageing filter.
      def apply(f)
        new_x = Dvector.new
        new_y = Dvector.new
        nb = 0.0
        for x,y in f
          if nb < 1
            new_x << x
            new_y << y
          end
          nb += 1
          if nb  >= @nb
            nb -= @nb
          end
        end
        return Function.new(new_x, new_y)
      end

      def apply!(f)
        new_f = apply(f)
        f.x.replace(new_f.x)
        f.y.replace(new_f.y)
      end
    end
  end
end
