# log.rb, copyright (c) 2006 by Vincent Fourmond: 
# The general logging functions for Ctioga
  
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
  
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (in the COPYING file).

module CTioga

  Version::register_svn_info('$Revision: 778 $', '$Date: 2008-03-09 03:44:48 +0100 (Sun, 09 Mar 2008) $')
  
  # A class implementing small shortcuts, that is a set of command-line
  # arguments.
  class Shortcut

    @@shortcut_list = {}
  
    # The name of the shortcut
    attr_accessor :name
    
    # Its arguments
    attr_accessor :arguments

    def initialize(name, *args)
      @name = name
      @arguments = args
      @@shortcut_list[name] = self
    end

    def self.list
      return @@shortcut_list.keys
    end

    def self.has?(name)
      return @@shortcut_list.key?(name)
    end

    def self.args(name)
      return @@shortcut_list[name].arguments
    end

    def self.pretty_print
      for key in @@shortcut_list.keys.sort
        val = @@shortcut_list[key]
        puts "#{key}\t#{val.arguments.join(' ')}"
      end
    end
  end
  
  Shortcut.new('cloud', '--marker', 'auto', '--marker-scale', '0.2',
               '--line-style', 'no')

  Shortcut.new('filled', '--fill', 'y_axis', '--fill-transparency', '0.7')

  Shortcut.new('csv', '--text-separator', '/[;,]/')

  Shortcut.new('semilog', '--math-log', '--xlog')

  Shortcut.new('fulllog', '--math-log', '--xlog', '--ylog')

  Shortcut.new('axis-grid', '--lines-color', 'xaxis', 'Silver', 
               '--lines-color', 'yaxis', 'Silver')
end
