/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#include <iostream>


#include "wxPasswordManager.hh"
#include "CertificateViewer.hh"
#include "Common.hh"

#ifndef __WXMSW__ // en attendant
#include "pics/password.xpm"
#endif


BEGIN_EVENT_TABLE( wxPasswordManager, wxDialog )
    EVT_BUTTON( PM_CV_ID, wxPasswordManager::displayDetails )
END_EVENT_TABLE()

wxPasswordManager::wxPasswordManager(wxWindow *parent, wxWindowID id,  User *u,
				     const wxString &title, const wxString &label):
    wxDialog(NULL ,
	     id,
	     title)
    

{
    user = u;
    cert = NULL;

    wxButton *okBtn = new wxButton(this,wxID_OK,_("OK"));
    cancelBtn = new wxButton(this,wxID_CANCEL,_("Cancel"));
    passwordField = new wxTextCtrl(this, -1, wxEmptyString, wxDefaultPosition, 
				   wxSize(200,22), wxTE_PASSWORD);
    
    cvBtn = new wxButton( this , PM_CV_ID , _("Certificate Properties"));
    cvBtn->Show( FALSE );

   mainSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer *sizer = new wxBoxSizer(wxHORIZONTAL);
    wxBoxSizer *passwordSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer *buttonSizer =  new wxBoxSizer(wxHORIZONTAL);

    wxBitmap bitmap = wxBITMAP(password);
#ifdef __WXMSW__
    bitmap.SetMask( new wxMask(bitmap, wxColour(0xC0,0xC0,0xC0)) );
#endif
    wxStaticBitmap *icon = new wxStaticBitmap(this, -1, bitmap);
    
    labelText = new wxStaticText( this, -1, _T(""), wxDefaultPosition , wxSize(300,20));
    tokenText = new wxStaticText( this, -1, _T(""), wxDefaultPosition , wxSize(300,20));
    


    passwordSizer->Add( labelText ,0,                
			wxALIGN_CENTER | wxALIGN_CENTER_VERTICAL | wxTOP | wxLEFT | wxRIGHT,
			5 );                  
    passwordSizer->Add( tokenText , 0 , wxALIGN_CENTER | wxALIGN_CENTER_VERTICAL | wxLEFT | wxRIGHT,
			5 );                  

    passwordSizer->Add(passwordField, 0,wxEXPAND| wxCENTER |wxALL| wxALIGN_CENTER_VERTICAL,5);
    passwordField->SetFocus();
    
    buttonSizer->Add(cvBtn, 0, wxALIGN_LEFT | wxALL, 5); 
    
    buttonSizer->Add(cancelBtn, 0, wxALIGN_CENTER | wxALL, 5); 
    buttonSizer->Add(okBtn, 0,wxALIGN_CENTER |wxALL,5);
    okBtn->SetDefault();
    
    sizer->Add(icon, 0 ,wxEXPAND | wxALIGN_CENTER_VERTICAL  | wxALL , 10);
    sizer->Add(passwordSizer, 1 , wxEXPAND |wxCENTER |wxALL,5);
    
    mainSizer->Add(sizer, 1 , wxEXPAND |wxCENTER |wxALL, 5);
    mainSizer->Add(buttonSizer, 0 , wxALIGN_BOTTOM | wxALIGN_RIGHT |wxALL, 10 );
    mainSizer->Fit(this);
    SetSizer(mainSizer);
    Center();
  
}



wxPasswordManager::~wxPasswordManager(){

}


bool wxPasswordManager::getPassword(std::string token, std::string object,
				  char **password, int flags, Certificate *c){
    cert = c;
    Center();

    if( flags ) {
				wxString label = _("This token is locked: ");
				labelText->SetLabel( label );
				tokenText->SetLabel( std2wx(token) );
				passwordField->Enable(FALSE);
				cancelBtn->Enable(FALSE);
				ShowModal();
				return false;
    }


    if ( cert ){
				cvBtn->Show( TRUE );
    } else {
				cvBtn->Show( FALSE );
    }
    
    if( token != "" ){
				wxString label = _("Please enter a PIN code to unlock this token: ");
				labelText->SetLabel( label );
				tokenText->SetLabel( std2wx(token) );
    } else {
				labelText->SetLabel(_T(""));
				tokenText->SetLabel( _("Please enter your private key password") );
    }
    
    if(ShowModal() == wxID_OK){
				*password = (char*) malloc ( sizeof(char) * passwordField->GetValue().Len() +1 );
				memset(*password , 0 , passwordField->GetValue().Len() + 1);
				strncpy(*password , wx2std(passwordField->GetValue()).c_str(), passwordField->GetValue().Len());
				
				passwordField->SetValue(_T(""));
				return true;
    } else { //cancel clicked
				return false;
    }
}


void wxPasswordManager::displayDetails(wxCommandEvent &WXUNUSED(event)){
     if(cert){
				 CertificateViewer cv(*cert, user ,this, -1 , _("Certificate details"));
				 cv.showModal(wxSize(435,500) , _("Close"), false); 
     }
}
