/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include <wx/wx.h>
#include <wx/dir.h>
#include <wx/file.h>
#include <wx/string.h>
#include <wx/filename.h>
#include <wx/textdlg.h>
#include <wx/dcclient.h>

#include "LoginFrame.hh"
#include "MainWindow.hh"
#include "PasswordDlg.hh"
#include "gpldialog.hh"
#include "Common.hh"

#include "NewUserWizard.hh"

#include "../User.hh"
#include "../AddressBook.hh"
#include "../Utils.hh"
#include "../AuthoritiesDB.hh"

#ifndef __WXMSW__ 
#include "pics/login.xpm"
//#include "pics/splash.xpm"
#include "pics/verify_ok.xpm"
#include "pics/verify_notok.xpm"
#include "pics/newuser2.xpm"
#endif

BEGIN_EVENT_TABLE (LoginFrame, wxDialog)
  EVT_BUTTON (LOGIN_OK, LoginFrame::OnOk)
  EVT_BUTTON (LOGIN_NEWUSER, LoginFrame::OnNew)
  EVT_BUTTON (LOGIN_QUIT, LoginFrame::OnQuit)
  EVT_PAINT  (LoginFrame::OnPaint)
END_EVENT_TABLE();



  LoginFrame::LoginFrame(wxWindow *parent, wxWindowID id,
			 const wxString &title,
			 const wxPoint &position, const wxSize &size,
			 long style)
    : wxDialog (parent, id, title, position, size , style)
{

  wxGetHomeDir(&dirHome);

#ifndef __WXMSW__  //pour linux
  dirHome += _T("/.cryptonit");
#else // pour windows
  dirHome += _T("\\Cryptonit");
#endif

  newUserLogin = wxEmptyString;
    
  loginBox = new wxComboBox(this, -1, wxEmptyString, wxPoint( 270 ,225), wxSize(100,20) );
  loginBox->SetToolTip(_("Choose your login in the list"));

  fillUsersList();
  loginBox->SetSelection(0);

  pwdCtrl = new wxTextCtrl(this, -1, wxEmptyString ,wxPoint(270 ,250 ), wxSize(100, 20), wxTE_PASSWORD );
  pwdCtrl->SetToolTip(_("Please enter your Cryptonit password here"));
  pwdCtrl->SetFocus();
    
  wxBitmap okIcon = wxBITMAP( verify_ok );
#ifdef __WXMSW__
  okIcon.SetMask( new wxMask( okIcon , wxColour( 0xC0, 0xC0, 0xC0 )));
#endif
  okButton = new wxBitmapButton(this, LOGIN_OK, okIcon , wxPoint( 375 , 225) , wxSize(20,20));
  okButton->SetToolTip(_("OK"));
  okButton->SetDefault();

  wxBitmap quitIcon = wxBITMAP( verify_notok );
#ifdef __WXMSW__
  quitIcon.SetMask( new wxMask( quitIcon , wxColour( 0xC0, 0xC0, 0xC0 )));
#endif
  quitButton = new wxBitmapButton(this, LOGIN_QUIT, quitIcon , wxPoint( 375 , 250 ) , wxSize( 20,20));
  quitButton->SetToolTip(_("Close"));


  wxBitmap newIcon = wxBITMAP( newuser2 );
#ifdef __WXMSW__
  newIcon.SetMask( new wxMask( newIcon , wxColour( 0xC0, 0xC0, 0xC0 )));
#endif

  // LOGIN AND PASSWORD TEXT
  loginText = new wxStaticText(this ,-1 , _("Login") );
  loginText->Show( FALSE );
  passwdText = new wxStaticText(this , -1 , _("Password"));
  passwdText->Show( FALSE );

  // New USER TEXT
  newUserText = new wxStaticText(this , -1 , _("Create a new user") );
  newUserText->Show( FALSE );
  newUserButton = new wxBitmapButton( this , LOGIN_NEWUSER , newIcon, wxPoint(375,275), wxSize(20,20));
  newUserButton->SetToolTip(_("Click here to create a new Cryptonit account"));
  Center();   		
    
  // Check if there is already created users, if not, prompt 
  // for the new user wizard.
  if( loginBox->GetCount() == 0 ) {
    GPLDialog licence( this , -1 );
    if( licence.ShowModal() != wxID_OK ){
      std::exit(-1);
    }

    // wxMessageDialog promptWiz( this, _("It seems that it's the first time you launch Cryptonit, "
    // 					   "do you want to create a new user now? "),
    // 				   _("Question"), wxICON_QUESTION | wxYES_NO );

    // 	if( promptWiz.ShowModal() == wxID_YES ) {
    NewUserWizard* wizi = new NewUserWizard( this );
    newUserLogin = wizi->getNewUserLogin();
    delete wizi;
	
    fillUsersList();
    // 	}
  }

#ifndef USER_AUTHENTICATION
  loginBox->SetValue(std2wx(std::string(USER_NAME)));
  pwdCtrl->SetValue(std2wx(std::string(USER_PASSWD)));
  wxCommandEvent event;
  OnOk(event);
#endif
}

LoginFrame::~LoginFrame()
{ 
  
}


void LoginFrame::OnOk(wxCommandEvent & event)
{
  LOGIN = loginBox->GetValue();
  PWD = pwdCtrl->GetValue();
  
  wxString title = _("Cryptonit: IDEALX Open Source Security Tool - ");

  Cryptonit::User* user = new Cryptonit::User(wx2std(LOGIN));
#ifdef DEBUG  
  std::cerr << "User: " << wx2std(LOGIN) << std::endl;
  std::cerr << "Password: " << wx2std(PWD) << std::endl;
#endif  

  std::string hashc = user->getInfo("Password");
  std::string c = encryptPassword(wx2std(PWD).c_str(), "1" , (getSalt(hashc.c_str())).c_str() );

#ifdef DEBUG
  std::cerr << "Hash: " << hashc << std::endl;
  std::cerr << "Hash: " << c << std::endl;
#endif  

  if((c == hashc) /*|| true*/) {
    /* Use the local stored in the user's preferences */
    std::string language = user->getInfo("Language");
    /* Get a reference on the app
     * for accessing locales methods
     */
    CryptonitGui& app = wxGetApp();
    app.setCurrentLocale(std2wx(language.c_str()));

    /* Loading local address book */
    std::string localAddressBook = "config://";
    localAddressBook += user->getAddressBookFile();
	
    user->addressBook = new Cryptonit::AddressBook( localAddressBook );
	
    if( user->addressBook == NULL ) {
      wxString msg; 
      wxString submsg;
      submsg = (std2wx(user->getAddressBookFile().c_str()));
      msg << _("Cannot load your personnal address book.") 
	  << (wxChar *)" (" << submsg << (wxChar *)")";
      errorMsg( msg );
      return;
    }
	
	
	
    /* Load authorities database */
    std::string authoritiesDB = "config://";
    authoritiesDB += user->getCAFile();
	
    user->authorities = new Cryptonit::AuthoritiesDB( authoritiesDB );
	
    if( user->authorities == NULL ) {
      wxString msg;
      msg << _("Cannot load your personnal certification authorities database.")
	  << (wxChar *)" (" << (wxChar *)(user->getCAFile().c_str()) << (wxChar *)")";
      errorMsg( msg );
      return;
    }
	
	
    // Check if the user have only a certificate request pending
    // no P12 entries in the Preferences file
    std::vector<std::string> pkcs12s;
    pkcs12s = user->getInfos( "PKCS12" );

    if( pkcs12s.size() == 0 ) {
      // a private key and a certificate request in the P12/ dir
      wxDir dir( std2wx(user->getP12Dir().c_str()) );
      if ( dir.IsOpened() ) {
	wxArrayString files;
	// there can be only 2 files: private key and request
	if( dir.GetAllFiles(std2wx(user->getP12Dir().c_str()), &files) == 2 ) {
	  char buffer1[60], buffer2[60];
	  wxString buffer3, buffer4;
	  wxFile first(files[0].c_str()), second(files[1].c_str());

	  first.Read( (void*)buffer1, 60 );
	  second.Read( (void*)buffer2, 60 );
	  buffer3 = wxString( (wxChar *)buffer1 );
	  buffer4 = wxString( (wxChar *)buffer2 );

          if( 
             (buffer3.StartsWith(std2wx("-----BEGIN RSA PRIVATE KEY-----"))
              && buffer4.StartsWith(std2wx("-----BEGIN CERTIFICATE REQUEST-----")))
             
             || (buffer3.StartsWith(std2wx("-----BEGIN CERTIFICATE REQUEST-----"))
                 && buffer4.StartsWith(std2wx("-----BEGIN RSA PRIVATE KEY-----")))
             ) {



	    // We can close the files
	    first.Close();
	    second.Close();

	    // Ok, show the user a message box prompting him for 
	    // importing the signed certificate
	    wxString msg;
	    msg = _("You have a certificate request pending, do you want to import it now? ");
	    wxMessageDialog question( this, msg, _("Question"),  wxYES_NO | wxICON_QUESTION);
	    if( question.ShowModal() == wxID_YES ) {

	      // Prompt the user for the signed certificate
	      wxString wildcard;
	      wildcard << _("All supported formats") << _T("|*.cer;*.der;*.pem")
		       << _T("|") << _("Certificate") << _T(" (*.cer)|*.cer")
		       << _T("|") << _("DER encoded certificate") << _T(" (*.der)|*.der")
		       << _T("|") << _("PEM encoded certificate") << _T(" (*.pem)|*.pem");
	
	      wxFileDialog fileDlg( this, _("Choose a signed certificate request"), wxGetCwd(), wxEmptyString,
				    wildcard, wxOPEN | wxCHANGE_DIR);
			    
	      if( fileDlg.ShowModal() == wxID_OK ) {
		wxFileName certFilename(fileDlg.GetFilename());
		certFilename=wxMyPrepend(certFilename,fileDlg.GetDirectory());
		Certificate certificate;
               
		if( certificate.load(wx2std(certFilename.GetFullPath()).c_str()) != 0 ) {
		  wxMessageBox( _("This certificate seems to be invalid."),
				_("Error"), wxOK | wxICON_ERROR, this );
		  return;
		}

		// Search the corresponding request and private key in the P12/ dir
		std::string privateKey, certificateRequest;
		if( buffer3.StartsWith(std2wx("-----BEGIN RSA PRIVATE KEY-----") )) {
		  // first is the private key, so second is the request
		  privateKey = (char *)files[0].c_str();
		  certificateRequest = (char *)files[1].c_str();
				    
		}
		if( buffer4.StartsWith(std2wx("-----BEGIN RSA PRIVATE KEY-----") )) {
		  // second is the private key, so first is the request
		  privateKey = (char *)files[1].c_str();
		  certificateRequest =  (char *)files[0].c_str();
		}


		// Ask for the identity
		wxString identityName;
		bool again = true;
		std::vector<std::string> identities;
		identities = user->getInfos( "Identities" );

		while( again ) {
		  wxTextEntryDialog identityDlg(this, _("Please enter a name for this new identity, you can leave this field blank:"),
						_("Identity name"), identityName );

		  if( identityDlg.ShowModal() == wxID_OK ) {
		    if( identityDlg.GetValue() != wxEmptyString ) {
		      identityName = identityDlg.GetValue();
		    } else {
		      identityName = _("Default");
		    }
		  }
		  else {
		    // Aborting certificate importation
		    wxMessageBox( _("Aborting certificate importation."), _("Error"),
				  wxOK | wxICON_ERROR, this );
		    return;
		  }

		  // Check if the provided identity already exists
		  std::string tmp ((char *)identityName.c_str());
		  if( find( identities.begin(), identities.end(), tmp )
		      != identities.end() ) {
		    // the identity is already in the list
		    wxMessageBox( _("This identity already exists, please choose another one."), 
				  _("Error"), wxOK | wxICON_ERROR, this );
		    again = true;
		  } else {
		    again = false;
		  }
		}


		// Ask for the private key password.
		wxString privateKeyPass;
		PasswordDlg passwordDlg( this, -1,_("Private key password"),
					 _("Enter the private key password used when generating certificate request: "));
		passwordDlg.addButtons();

		if( passwordDlg.ShowModal() == wxID_OK ) {
		  privateKeyPass = passwordDlg.getPassword();
		}
		else {
		  // Aborting certificate importation
		  wxMessageBox( _("Aborting certificate importation."), _("Error"),
				wxOK | wxICON_ERROR, this );
		  return;
		}


		// Add the identity into the user account
		int ret = user->addIdentityFromP10( std::string((char *)identityName.c_str()),
						    certificateRequest,
						    std::string((char *)certFilename.GetFullPath().c_str()),
						    privateKey, 
						    (char *)privateKeyPass.c_str() );

		wxString errorMsg = wxEmptyString;
		switch( ret ) {
		case 0 : errorMsg = wxEmptyString;
		  break;
		case -1: errorMsg = _("Cannot load the private key generated with the certificate request.");
		  break;
		case -2: errorMsg = _("Cannot load the originating certificate request.");
		  break;
		case -3: errorMsg = _("The private key does not match the certificate request.");
		  break;
		case -4: errorMsg = _("Cannot load the certificate.");
		  break;
		case -5: errorMsg = _("Cannot create the intermediate PKCS#12 object.");
		  break;
		case -6: errorMsg = _("Cannot create temporary file for the PKCS#12 object in your P12 directory.");
		  break;
		case -7: errorMsg = _("Cannot write the temporary PKCS#12 in your P12 directory.");
		  break;
		  // addIdentityFromP12 errors:
		case -51: errorMsg = _("Cannot load the generated PKCS#12.");
		  break;
		case -52: errorMsg = _("This PKCS#12 file already exist for this user.");
		  break;
		case -53: errorMsg = _("This identity is already in the list, please use a different name.");
		  break;
		case -54: errorMsg = _("An error occured while writing certificate on disk.");
		  break;
		case -55: errorMsg = _("Cannot add identity information into the addressbook.");
		  break;
		case -56: errorMsg = _("Cannot write on disk a CA certificate included in the PKCS#12.");
		  break;
		case -57: errorMsg = _("Cannot copy PKCS#12 in your user directory.");
		  break;
		default:  errorMsg << _("Unknown error! ") << (wxChar *)"(" << ret << (wxChar *)")";
		  break;
		}

		if( errorMsg != wxEmptyString ) {
		  wxMessageBox(errorMsg, _("Error"), wxOK | wxICON_ERROR, this);
		  return;
		}
				
		// The import was successfull, we can now remove 
		// the temporary private key and request.
		std::remove((char *)files[0].c_str());
		std::remove((char *)files[1].c_str());
	      }


	    }

	  }
	  first.Close();
	  second.Close();
	}
      }
    }	

    MainWindow *mainWindow = new MainWindow(this, -1,
					    title.append(LOGIN), user,
					    wxPoint(50,50), wxSize(800,300));
    mainWindow->Show(TRUE);
#ifndef USER_AUTHENTICATION
    return;
#endif
    this->Show(FALSE);
  } else{
    wxString msg = _("Login or Password incorrect.");
    errorMsg(msg);
  }
}


void LoginFrame::OnQuit(wxCommandEvent & event)
{
  Destroy();
  std::exit(-1);
}


void LoginFrame::OnNew(wxCommandEvent & event)
{
  NewUserWizard* wizi = new NewUserWizard( this );
  newUserLogin = wizi->getNewUserLogin();
  delete wizi;

  fillUsersList();

}


void LoginFrame::fillUsersList() 
{
  if( !(wxDir::Exists(dirHome)) ) {
    // faut verifier pour les permissions
    wxMkdir(dirHome, 0777);
  }
  
  wxDir dir(dirHome);
  
  wxString filename;
  wxString filespec;
  
  loginBox->Clear();
    
  bool cont = dir.GetFirst(&filename, filespec, wxDIR_DIRS);
    
  while(cont) {
    if(filename.CmpNoCase((wxChar *)"i18n") != 0) {
      loginBox->Append(filename);
    }
    cont = dir.GetNext(&filename);
  }

  // Select the newly created account if it exists
  if( newUserLogin != wxEmptyString ) {
    loginBox->SetSelection( loginBox->FindString(newUserLogin) );
  } 
  // Otherwise, select the first one
  else {
    loginBox->SetSelection( 0 );
  }

}


void LoginFrame::errorMsg(wxString msg) 
{
  wxString title = _("IDEALX Cryptonit: ");
  wxMessageDialog errorMsg(this, msg, title.append(_("Error")), wxOK | wxICON_ERROR);
  errorMsg.ShowModal();
}


void LoginFrame::OnPaint(wxPaintEvent &event){
  wxPaintDC dc( this );
  dc.DrawBitmap( wxBITMAP(login), 0, 0, TRUE );  
  dc.DrawBitmap( wxBITMAP(login), 0, 0, TRUE );  
  
  wxSize loginSize = loginText->GetBestSize();
  wxSize passwdSize = passwdText->GetBestSize();
  wxPoint p;
  
  if( loginSize.x > passwdSize.x ){
    p.x = 266 - loginSize.x;
  } else {
    p.x = 266 - passwdSize.x;
  }
  
  dc.SetFont( loginText->GetFont() );
  dc.DrawText(_("Login") , p.x , 228);
  dc.DrawText(_("Password") , p.x , 252);
  dc.DrawText(_("Create a new user") ,p.x , 275);

}
