/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include "DecryptSettingsDlg.hh"

#include <wx/dialog.h>
#include <wx/dirdlg.h>
#include <wx/dir.h>

//#include "pics/resources.h" //icons 
#ifndef __WXMSW__ // en attendant
#include "pics/folder_mini.xpm"
#endif



BEGIN_EVENT_TABLE (DecryptSettingsDlg, wxDialog)
  EVT_BUTTON (DSD_TARGETDIR_BTN_ID, DecryptSettingsDlg::onTarget)
  EVT_CHECKBOX(DSD_LEAVE_CB_ID, DecryptSettingsDlg::onLeave)
END_EVENT_TABLE()

DecryptSettingsDlg::DecryptSettingsDlg(wxWindow *parent, wxWindowID id,
				       const wxString &title)  
    : CryptonitDlg(parent, id, title)
{
  
  wxStaticBox *frame = new wxStaticBox(this,-1,_("Decrypting settings"));
  wxStaticBoxSizer *settingSizer = new wxStaticBoxSizer(frame,wxVERTICAL);
  
  deleteCB = new wxCheckBox(this, DSD_DELETE_CB_ID, _("Delete encrypted files"));
  deleteCB->SetToolTip( _("If you check this option, encrypted files will be deleted after decryption.") );
  
  leaveCB = new wxCheckBox(this, DSD_LEAVE_CB_ID, _("Leave files at the same place"));
  leaveCB->SetToolTip( _("If you check this option, decrypted files will be put in the same directory than encrypted ones.") );


  wxBoxSizer *dirSizer = new wxBoxSizer(wxHORIZONTAL);
  targetDir = new wxTextCtrl(this,-1,wxGetCwd(),wxDefaultPosition , wxSize(250,20));
  wxBitmap dirIcon = wxBITMAP(folder_mini);
#ifdef __WXMSW__
  dirIcon.SetMask( new wxMask(dirIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif
  dirBtn = new wxBitmapButton(this, DSD_TARGETDIR_BTN_ID, dirIcon);
  

  dirSizer->Add(targetDir, 1, wxCENTER | wxALIGN_LEFT | wxALL, 5);
  dirSizer->Add(dirBtn,    0, wxCENTER | wxALL, 5);
   
  
  settingSizer->Add(new wxStaticText( this, -1, _("Target Directory for decrypted files")), 
		    0, wxALIGN_LEFT | wxTOP | wxLEFT | wxRIGHT , 15); 
  settingSizer->Add(dirSizer, 0, wxALIGN_LEFT | wxLEFT | wxRIGHT | wxBOTTOM | wxEXPAND, 15);
  settingSizer->Add(leaveCB,  0, wxALIGN_LEFT | wxLEFT | wxRIGHT, 15 );
  settingSizer->Add(deleteCB, 0, wxALIGN_LEFT | wxALL, 15);

  mainSizer->Add(settingSizer, 1 ,wxEXPAND |wxCENTER |wxALL,5);
  
  dirBtn->Enable(FALSE);
  targetDir->Enable(FALSE);
  leaveCB->SetValue(TRUE);
  
}




void DecryptSettingsDlg::onTarget(wxCommandEvent &WXUNUSED(event)){

  wxDirDialog dirChooser(this, _("Choose a target directory for decrypted files"),wxGetCwd(), wxDD_NEW_DIR_BUTTON);

  if(dirChooser.ShowModal() == wxID_OK) {

    if( wxDir::Exists(dirChooser.GetPath()) )
      targetDir->SetValue(dirChooser.GetPath());
    else {
      wxMessageDialog errorMsg(this, _("The specified directory does not exist."), _("Error"), wxOK | wxICON_ERROR);
      errorMsg.ShowModal();
      return;
    }
  }
}


bool DecryptSettingsDlg::getDeleteFile(){
  return deleteCB->GetValue();
}


wxString DecryptSettingsDlg::getPath(){
		if(leaveCB->GetValue()) {
				return _T("");
		} else {
				return targetDir->GetValue();
		}
}


void DecryptSettingsDlg::onLeave(wxCommandEvent  &WXUNUSED(event)){
  dirBtn->Enable(!leaveCB->GetValue());
  targetDir->Enable(!leaveCB->GetValue());
}

bool DecryptSettingsDlg::getLeaveFile(){
  return leaveCB->GetValue();
}
