/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _ERROR_HH_
#define _ERROR_HH_

#include <string>

namespace Cryptonit {

  std::string &getErrorMsg(int errorCode);

  /** error code  */
  enum {
    SUCCESS = 0,
       
    /** certificate error class */
    CERTIFICATE_FILE_NOT_FOUND=100,
    CERTIFICATE_PEM_LOAD_ERROR,
    CERTIFICATE_DER_LOAD_ERROR,
    CERTIFICATE_PKCS12_LOAD_ERROR,
    CERTIFICATE_LOAD_ERROR,
      

    /** PKCS#7 error class */
    PKCS7_CREATE_ERROR=200,
    PKCS7_FILE_CREATE_ERROR,
    PKCS7_FILE_NOT_FOUND,
    PKCS7_BIO_WRITE_ERROR,
    PKCS7_BIO_NEW_ERROR,
    PKCS7_BAD_CONTENT_TYPE,
    PKCS7_BAD_FORMAT,
    PKCS7_READ_ERROR,
    PKCS7_SIGN_ERROR,
    PKCS7_SET_CIPHER_ERROR,
    PKCS7_ADD_RECIPIENT_ERROR,
    PKCS7_ADD_SIGN_ERROR,
    PKCS7_DATAINIT_ERROR,
    PKCS7_DATAFINAL_ERROR,
    PKCS7_EXTRACT_ERROR,
    PKCS7_DECRYPT_ERROR,
    PKCS7_ENCRYPT_ERROR,   
    PKCS7_CERT_OR_KEY_NULL,
    PKCS7_PKEY_CERT_MISMATCH,
    PKCS7_STORE_ERROR,
    PKCS7_BAD_SIGNER,
    PKCS7_SIGNATURE_VERIF_FAILED,
    
    /** CRL error class */
    CRL_FILE_NOT_FOUND=300,
    CRL_PEM_LOAD_ERROR,
    CRL_DER_LOAD_ERROR,
    CRL_PKCS7_LOAD_ERROR,
    CRL_LOAD_BAD_FORMAT,
    CRL_LOAD_BIO_NULL,
      
    /** PKCS#12 error class */
    PKCS12_FILE_NOT_FOUND=400,
    PKCS12_LOAD_ERROR,
    PKCS12_PARSE_ERROR,
    PKCS12_BIO_READ_ERROR,
    PKCS12_LOAD_BIO_ERROR,

    KEYSTORE_PASSWORD_NEEDED=500,
    KEYSTORE_PARSE_FAILURE
  };
 
}

#endif
