/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include "Entry.hh"

namespace Cryptonit {

Entry::Entry( )
{
    attributeList.clear();
}

Entry::Entry( const Entry& entry )
{
    attributeList.clear();
    attributeList = entry.attributeList;
}

Entry::Entry( Entry* entry )
{
    attributeList.clear();

    hash_map<const std::string, Attribute*, Entry_hash_str, Entry_eqstr>::iterator itr;

    for( itr = entry->attributeList.begin(); itr != entry->attributeList.end(); itr++ ) {
	attributeList[itr->first] = itr->second;
    }
    //attributeList = entry->attributeList;
}

Entry::Entry( const std::string name )
{
    attributeList.clear();
    if( name != "" )
	attributeList[name] = new Attribute();
}

Entry::Entry( const std::string name, const std::string& val )
{
    attributeList.clear();
    if( name != "" && val != "" )
	attributeList[name] = new Attribute( val );
}

Entry::Entry( const std::string name, const std::string& val, 
					      AttributeType t )
{
    attributeList.clear();
    if( name != "" && val != "" )
	attributeList[name] = new Attribute( val, t );
}

Entry::Entry( const std::string  name, const char* val, 
					      unsigned long len, AttributeType t )
{
    attributeList.clear();
    if( name != "" && val != "" )
	attributeList[name] = new Attribute( val, len, t );
}


Entry::~Entry( )
{
    Entry::iterator itr = Entry::begin();

    while( itr != Entry::end() ) {
	if( itr.second() ) {
	    delete itr.second();
	}
 	itr++;
    }
    clear();
}


Attribute* Entry::getAttribute( const std::string name )
{
    // C'est  l'appelant de vrifier si l'attribut existe (!= NULL)
    if( name != "" && attributeList.find(name) != attributeList.end() )
	return attributeList[name];
    else return NULL;
}


std::vector<std::string> Entry::getAttributeValues( const std::string name )
{
    if( name != "" && attributeList.find(name) != attributeList.end() )
	return attributeList[name]->getValues();
    return std::vector<std::string>(0);
}



std::string Entry::getAttributeFirstValue( const std::string name )
{
    if( name != "" && attributeList.find(name) != attributeList.end() )
	return attributeList[name]->getFirstValue();
    else return std::string("");
}


void Entry::getAttributeFirstValue( const std::string name, std::string& val )
{
    if( name != "" && attributeList.find(name) != attributeList.end() )
	val = attributeList[name]->getFirstValue();
}


std::string Entry::getAttributeLastValue( const std::string name )
{
    if( name != "" && attributeList.find(name) != attributeList.end() )
	return attributeList[name]->getLastValue();
    else return std::string("");;
}


void Entry::getAttributeLastValue( const std::string name, std::string& val )
{
    if( name != "" && attributeList.find(name) != attributeList.end() )
	val = attributeList[name]->getLastValue();
}


bool Entry::appendAttributeValue( const std::string name, const std::string &val )
{
    if( name != "" && attributeList.find(name) == attributeList.end() ) { // The attribute doesn't exist
	attributeList[name] = new Attribute( val );
	return true;
    }
    if( name != "" && attributeList.find(name) != attributeList.end() ) { // The attribute already exists
	return attributeList[name]->append( val );
    }
    return false;
}


bool Entry::appendAttributeValue( const std::string name, const std::string &val, const AttributeType t )
{
    if( name != "" && attributeList.find(name) == attributeList.end() ) { // The attribute doesn't exist
	attributeList[name] = new Attribute( val, t );
	return true;
    }
    if( name != "" && attributeList.find(name) != attributeList.end() ) { // The attribute already exists
	return attributeList[name]->append( val, t );
    }
    return false;
}


bool Entry::appendAttributeValue( const std::string name, const char* val, const unsigned long len, const AttributeType t )
{
    if( name != "" && attributeList.find(name) == attributeList.end() ) { // The attribute doesn't exist
	attributeList[name] = new Attribute( val, len, t );
	return true;
    }
    if( name != "" && attributeList.find(name) != attributeList.end() ) { // The attribute already exists
	return attributeList[name]->append( val, len, t );
    }
    return false;
}



bool Entry::erase( const std::string name )
{
    if( name != "" ) {
	if( attributeList.find(name) == attributeList.end() ) 
	    return true; /* the attribute does not exist */
	else {
	    // Vrifier si le destructeur de attributeList[name]
	    // est bie appel
	    attributeList.erase(name);
	    return true;
	}
    }
    else return false;
}



bool Entry::clear()
{
//     std::hash_map<const std::string, Attribute*,hash<const char*>, DirectoryService_eqstr>::iterator i;

//      for( i = attributeList.begin(); i != attributeList.end(); i++ )
//  	i->second->erase();

    attributeList.clear();
    
    return true;
}



bool Entry::append( const std::string name, 
				    Attribute* attribute )
{
    if( name != "" && attribute ) {
	attributeList[name] = attribute;
	return true;
    }
    else return false;
}





unsigned int Entry::getNbAttribute() const
{
    return attributeList.size();
}


bool Entry::fillEntry( class Entry& entry ) 
{
    hash_map<const std::string, Attribute*, Entry_hash_str, Entry_eqstr>::iterator itr;
    bool flag = false;

    for( itr = entry.attributeList.begin(); itr != entry.attributeList.end(); itr++ ) {

	if( attributeList.find(itr->first) != attributeList.end() ) {
	    itr->second = new Attribute( attributeList[itr->first] );
	    flag = true;
	}

    }

    return flag;
}

} // Namespace
