# cpushare client
# Copyright (C) 2005-2006  Andrea Arcangeli <andrea@cpushare.com>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation;
# only version 2.1 of the License.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from cpushare.config import *
import re, os, sys

def system_check():
	if sys.version_info < ( 2, 3, 3, ):
		raise CHECKERROR, "You need to upgrade python to version 2.3.3 or more recent to run this."

	machine = os.uname()[4]
	if machine != 'i686' and machine != 'x86_64' and machine != 'ppc64' and machine != 'ppc':
		raise CHECKERROR, "Only x86_64, ppc64, i686 and ppc can connect, check with 'uname -m'."

	if [int(x) for x in re.search(r'^(\d+)\.(\d+)\.(\d+)', os.uname()[2]).groups()] < [ 2, 6, 8, ]:
		raise CHECKERROR, "You need to upgrade your kernel to version 2.6.8 or more recent to run this."

	from twisted.copyright import version
	if 'svn-trunk' not in version.lower() and 'hg-cpushare' not in version.lower() and \
	       [int(x) for x in re.search(r'^(\d+)\.(\d+)\.(\d+)',
					  version).groups()] < [ 1, 3, 0, ]:
		raise CHECKERROR, "You need to upgrade twisted to version 1.3.0 or more recent."
