# cpushare client
# Copyright (C) 2005-2006  Andrea Arcangeli <andrea@cpushare.com>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation;
# only version 2.1 of the License.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from twisted.internet import ssl
from OpenSSL import SSL, crypto

# local
from cpushare.config import *
from utils import max_ram_mbytes_per_cpu

class verify_certificate_class(object):
	def __init__(self, factory):
		self.factory = factory

	def verify_certificate(self, conn, cert, errno, depth, retcode):
		return crypto.dump_certificate(crypto.FILETYPE_PEM, cert) == self.factory.server_certificate

class client_context_factory_class(ssl.ClientContextFactory):
	def getContext(self):
		ctx = SSL.Context(self.method)
		verify_certificate = verify_certificate_class(self.factory)
		if hasattr(ctx, 'verify_certificate'):
			raise ERROR, 'verify_certificate collision'
		ctx.set_verify(SSL.VERIFY_PEER, verify_certificate.verify_certificate)
		return ctx

def set_context_factory(factory):
	client_context_factory = client_context_factory_class()
	if hasattr(client_context_factory, 'factory'):
		raise ERROR, 'factory collision'
	client_context_factory.factory = factory
	return client_context_factory

def make_service(config):
	from cpushare.system_check import system_check
	system_check()

	from twisted.application import internet, service
	service_collection = service.MultiService()

	from cpushare.proto import cpushare_factory
	factory = cpushare_factory()
	cpushare_hostname = config.get('cpushare_hostname')

	order = file(config.get('order'))
	if order.readline().strip() != ORDER_MAGIC:
		raise ERROR, 'Order magic string is corrupted'
	factory.order = order.readline().strip().split('_')
	order.close()

	factory.seccomp_loader = config.get('seccomp_loader')
	factory.cache_dir = config.get('cache_dir')

	factory.max_ram_mbytes_per_cpu = max_ram_mbytes_per_cpu()

	server_certificate = file(config.get('cpushare_cert')).read()
	factory.server_certificate = server_certificate
	cpushare_ssl_port = int(config.get('cpushare_port'))
	client_context_factory = set_context_factory(factory)
	internet.SSLClient(cpushare_hostname, cpushare_ssl_port, factory,
			   client_context_factory).setServiceParent(service_collection)

	return service_collection
