import birdbath.ClassAd;
import birdbath.Collector;
import condor.ClassAdStructAttr;
import java.net.URL;
import junit.framework.AssertionFailedError;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ScheddTestSuite
{
    public static void main(String[] arguments)
    {
        try
        {
            String collector_endpoint =
                System.getProperty("COLLECTOR_ENDPOINT",
                                   "http://localhost:9618");

            String schedd_endpoint = System.getProperty("SCHEDD_ENDPOINT");
            if (null == schedd_endpoint)
            {
                Collector collector = new Collector(new URL(collector_endpoint));

                long start_time = System.currentTimeMillis();

                ClassAdStructAttr[][] result = null;
                do
                {
                    result = collector.queryScheddAds("HasSOAPInterface=?=TRUE");
                }
                while (null == result &&
                       3 * 60 > start_time - System.currentTimeMillis());

                ClassAd ad = new ClassAd(result[0]);
                String scheddIpAddr = ad.get("ScheddIpAddr");
                schedd_endpoint =
                    "http://" + scheddIpAddr.substring(1, scheddIpAddr.length() - 1);
            }

            if (null == schedd_endpoint)
            {
                throw new AssertionFailedError("Please set property SCHEDD_ENDPOINT.");
            }

            System.setProperty("SCHEDD_ENDPOINT", schedd_endpoint);

            String owner = System.getProperty("JOB_OWNER");

            if (null == owner)
            {
                System.setProperty("JOB_OWNER", System.getProperty("user.name"));
            }

            TestSuite suite = new TestSuite();

            suite.addTest(new ScheddSendASCIISpoolFileTestCase());
            suite.addTest(new ScheddSendBinarySpoolFileTestCase());
            suite.addTest(new ScheddSendEmptySpoolFileTestCase());
            //suite.addTest(new ScheddSingleJobTestCase1());
            suite.addTest(new ScheddSingleJobTestCase2());
            suite.addTest(new ScheddTestCase1());
            //suite.addTest(new ScheddTestCase2()); // Windows job
            //suite.addTest(new ScheddTestCase3()); // Used to test what happens when things are null, but Axis validates now, so it doesn't work...
            //suite.addTest(new ScheddTestCase4()); // Windows job
            suite.addTest(new ScheddTestCase5());
            //suite.addTest(new ScheddTestCase6()); // Covered by MultipleTransactionSubmitTest2
            //suite.addTest(new ScheddTestCase7()); // This test just doesn't work, sendFile does a DeclareFile...
            suite.addTest(new MultipleTransactionSubmitTest1());
            suite.addTest(new MultipleTransactionSubmitTest2());
            //suite.addTest(new SubmitRemoveTest1());
            //suite.addTest(new SubmitRemoveTest2());
            suite.addTest(new SubmitRemoveTest3());
            suite.addTest(new SubmitRemoveTest4());

            TestResult results = TestRunner.run(suite);

            System.exit(results.failureCount() + results.errorCount());
        }
        catch (Exception exception)
        {
            // Any exception is a failure.
            System.exit(1);
        }
    }
}
