/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt42;

import condor.gahp.CommandHandler;
import condor.gahp.CommandHandlerResponse;
import condor.gahp.GahpInterface;
import condor.gahp.gt42.GSIUtils;
import condor.gahp.gt42.GramJobUtils;
import java.net.URL;
import org.globus.axis.message.addressing.EndpointReferenceType;
import org.globus.exec.generated.ManagedJobFactoryPortType;
import org.globus.exec.utils.ManagedJobFactoryConstants;
import org.globus.exec.utils.client.ManagedJobFactoryClientHelper;
import org.ietf.jgss.GSSCredential;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;

public class Gt42GramPingHandler
implements CommandHandler {
    private GahpInterface gahp;

    public void setGahp(GahpInterface gahpInterface) {
        this.gahp = gahpInterface;
    }

    public CommandHandlerResponse handleCommand(String[] stringArray) {
        Integer n;
        String string = null;
        try {
            n = new Integer(stringArray[1]);
            string = stringArray[2];
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return CommandHandlerResponse.SYNTAX_ERROR;
        }
        GSSCredential gSSCredential = GSIUtils.getCredential(this.gahp);
        MyTask myTask = new MyTask(n, string, this.gahp, gSSCredential);
        return new CommandHandlerResponse("S", (Runnable)myTask);
    }

    class MyTask
    implements Runnable {
        public final String factoryAddr;
        public final Integer requestID;
        private GahpInterface gahp;
        private GSSCredential proxy;

        public MyTask(Integer n, String string, GahpInterface gahpInterface, GSSCredential gSSCredential) {
            this.factoryAddr = string;
            this.requestID = n;
            this.gahp = gahpInterface;
            this.proxy = gSSCredential;
        }

        public void run() {
            String[] stringArray = new String[]{"0", "NULL"};
            try {
                URL uRL = ManagedJobFactoryClientHelper.getServiceURL((String)this.factoryAddr).getURL();
                EndpointReferenceType endpointReferenceType = ManagedJobFactoryClientHelper.getDefaultFactoryEndpoint((String)uRL.toExternalForm());
                ManagedJobFactoryPortType managedJobFactoryPortType = ManagedJobFactoryClientHelper.getPort((EndpointReferenceType)endpointReferenceType);
                GramJobUtils.setDefaultFactoryAttributes(managedJobFactoryPortType, this.proxy);
                GetResourcePropertyResponse getResourcePropertyResponse = managedJobFactoryPortType.getResourceProperty(ManagedJobFactoryConstants.RP_DELEGATION_FACTORY_ENDPOINT);
                if (getResourcePropertyResponse == null) {
                    throw new Exception("Sample query to factory returned null");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                String string = exception.toString();
                if (string == null || string.equals("")) {
                    string = "unknown";
                }
                stringArray = new String[]{"1", string};
            }
            this.gahp.addResult(this.requestID, stringArray);
        }
    }
}

