/*
 * Decompiled with CFR 0.152.
 */
package condor.gahp.gt42;

import condor.gahp.CleanupStep;
import condor.gahp.GahpInterface;
import condor.gahp.gt42.GSIUtils;
import condor.gahp.gt42.GramJobUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.globus.axis.message.addressing.EndpointReferenceType;
import org.globus.exec.client.GramJob;
import org.globus.exec.generated.FaultResourcePropertyType;
import org.globus.exec.generated.FaultType;
import org.globus.exec.generated.ManagedJobPortType;
import org.globus.exec.generated.StateChangeNotificationMessageType;
import org.globus.exec.generated.StateEnumeration;
import org.globus.exec.utils.FaultUtils;
import org.globus.exec.utils.ManagedJobConstants;
import org.globus.exec.utils.NotificationUtil;
import org.globus.exec.utils.client.ManagedJobClientHelper;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.WSNConstants;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.security.descriptor.GSITransportAuthMethod;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.oasis.wsn.FilterType;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsrf.faults.BaseFaultType;

public class CallbackSink
implements CleanupStep,
NotifyCallback {
    private String callbackId;
    private int requestId;
    private GahpInterface gahp;
    private boolean isInitialized = false;
    private NotificationConsumerManager notificationConsumerManager;
    private Integer port = null;
    private EndpointReferenceType notificationConsumerEPR = null;
    public static final String CALLBACK_SINK = "CALLBACK_SINK";
    public static final String CALLBACK_SINK_LIST = "CALLBACK_SINK_LIST";

    public CallbackSink(int n, Integer n2, GahpInterface gahpInterface) throws Exception {
        this.requestId = n;
        this.gahp = gahpInterface;
        this.port = n2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.port != null) {
            hashMap.put("container.port", this.port);
        }
        hashMap.put("container.class", "org.globus.wsrf.container.GSIServiceContainer");
        this.notificationConsumerManager = NotificationConsumerManager.getInstance(hashMap);
        this.notificationConsumerManager.startListening();
        ResourceSecurityDescriptor resourceSecurityDescriptor = new ResourceSecurityDescriptor();
        resourceSecurityDescriptor.setPDP("none");
        Vector<GSITransportAuthMethod> vector = new Vector<GSITransportAuthMethod>();
        vector.add(GSITransportAuthMethod.BOTH);
        resourceSecurityDescriptor.setDefaultAuthMethods(vector);
        LinkedList<QName> linkedList = new LinkedList<QName>();
        linkedList.add(ManagedJobConstants.STATE_CHANGE_INFORMATION_TOPIC_QNAME);
        this.notificationConsumerEPR = this.notificationConsumerManager.createNotificationConsumer(linkedList, (NotifyCallback)this, resourceSecurityDescriptor);
        this.isInitialized = true;
    }

    public void addJobListener(GramJob gramJob, String string) throws Exception {
        ManagedJobPortType managedJobPortType = ManagedJobClientHelper.getPort((EndpointReferenceType)gramJob.getEndpoint());
        Subscribe subscribe = new Subscribe();
        subscribe.setConsumerReference(this.notificationConsumerEPR);
        TopicExpressionType topicExpressionType = new TopicExpressionType();
        topicExpressionType.setDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Simple");
        topicExpressionType.setValue((Object)ManagedJobConstants.STATE_CHANGE_INFORMATION_TOPIC_QNAME);
        MessageElement messageElement = (MessageElement)ObjectSerializer.toSOAPElement((Object)topicExpressionType, (QName)WSNConstants.TOPIC_EXPRESSION);
        FilterType filterType = new FilterType();
        filterType.set_any(new MessageElement[]{messageElement});
        subscribe.setFilter(filterType);
        GramJobUtils.setDefaultJobAttributes(managedJobPortType, GSIUtils.getCredential(this.gahp));
        SubscribeResponse subscribeResponse = managedJobPortType.subscribe(subscribe);
    }

    public void removeJobListener(String string) {
    }

    public synchronized void doCleanup() {
        try {
            this.notificationConsumerManager.removeNotificationConsumer(this.notificationConsumerEPR);
            this.notificationConsumerManager.stopListening();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void deliver(List list, EndpointReferenceType endpointReferenceType, Object object) {
        String string = null;
        String string2 = null;
        int n = -1;
        FaultType[] faultTypeArray = null;
        try {
            string = ManagedJobClientHelper.getHandle((EndpointReferenceType)endpointReferenceType);
            StateChangeNotificationMessageType stateChangeNotificationMessageType = NotificationUtil.getStateChangeNotification((Object)object);
            StateEnumeration stateEnumeration = stateChangeNotificationMessageType.getState();
            string2 = stateEnumeration.getValue();
            if (stateEnumeration.equals((Object)StateEnumeration.Failed)) {
                faultTypeArray = FaultUtils.getConcreteFaults((FaultResourcePropertyType[])stateChangeNotificationMessageType.getFault());
            }
            if (stateEnumeration.equals((Object)StateEnumeration.StageOut) || stateEnumeration.equals((Object)StateEnumeration.Done) || stateEnumeration.equals((Object)StateEnumeration.Failed)) {
                n = stateChangeNotificationMessageType.getExitCode();
            }
        }
        catch (Exception exception) {
            System.err.println("Exception while processing callback");
            exception.printStackTrace(System.err);
            return;
        }
        if (faultTypeArray != null) {
            System.err.println("Full fault for job " + string + ":");
            for (int i = 0; i < faultTypeArray.length; ++i) {
                System.err.println(FaultUtils.faultToString((BaseFaultType)faultTypeArray[i]));
            }
        }
        this.gahp.addResult(this.requestId, new String[]{string, string2, faultTypeArray != null ? FaultUtils.getErrorMessageFromFaults((BaseFaultType[])faultTypeArray) : "NULL", n == -1 ? "NULL" : "" + n});
    }

    private BaseFaultType getFaultFromRP(FaultResourcePropertyType faultResourcePropertyType) {
        if (faultResourcePropertyType == null) {
            return null;
        }
        if (faultResourcePropertyType.getFault() != null) {
            return faultResourcePropertyType.getFault();
        }
        if (faultResourcePropertyType.getCredentialSerializationFault() != null) {
            return faultResourcePropertyType.getCredentialSerializationFault();
        }
        if (faultResourcePropertyType.getExecutionFailedFault() != null) {
            return faultResourcePropertyType.getExecutionFailedFault();
        }
        if (faultResourcePropertyType.getFilePermissionsFault() != null) {
            return faultResourcePropertyType.getFilePermissionsFault();
        }
        if (faultResourcePropertyType.getInsufficientCredentialsFault() != null) {
            return faultResourcePropertyType.getInsufficientCredentialsFault();
        }
        if (faultResourcePropertyType.getInternalFault() != null) {
            return faultResourcePropertyType.getInternalFault();
        }
        if (faultResourcePropertyType.getInvalidCredentialsFault() != null) {
            return faultResourcePropertyType.getInvalidCredentialsFault();
        }
        if (faultResourcePropertyType.getInvalidPathFault() != null) {
            return faultResourcePropertyType.getInvalidPathFault();
        }
        if (faultResourcePropertyType.getServiceLevelAgreementFault() != null) {
            return faultResourcePropertyType.getServiceLevelAgreementFault();
        }
        if (faultResourcePropertyType.getStagingFault() != null) {
            return faultResourcePropertyType.getStagingFault();
        }
        if (faultResourcePropertyType.getUnsupportedFeatureFault() != null) {
            return faultResourcePropertyType.getUnsupportedFeatureFault();
        }
        return null;
    }

    public static void storeCallbackSink(GahpInterface gahpInterface, String string, CallbackSink callbackSink) {
        gahpInterface.storeObject(CALLBACK_SINK + string, callbackSink);
        List list = CallbackSink.getAllCallbackSinks(gahpInterface);
        list.add(callbackSink);
    }

    public static CallbackSink getCallbackSink(GahpInterface gahpInterface, String string) {
        return (CallbackSink)gahpInterface.getObject(CALLBACK_SINK + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllCallbackSinks(GahpInterface gahpInterface) {
        Vector vector = null;
        GahpInterface gahpInterface2 = gahpInterface;
        synchronized (gahpInterface2) {
            vector = (Vector)gahpInterface.getObject(CALLBACK_SINK_LIST);
            if (vector == null) {
                vector = new Vector();
                gahpInterface.storeObject(CALLBACK_SINK_LIST, vector);
            }
        }
        return vector;
    }
}

