/****************************************************************************
 *    lib/b/Compiler.h - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009-2010  Torsten Grote								*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#ifndef BCOMPILER_H
#define BCOMPILER_H

#undef yyFlexLexer
#define yyFlexLexer bFlexLexer
#include <FlexLexer.h>

#include "../main.h"
#include "../options.h"
#include "Parser.h"
#include "Printer.h"

namespace B {

class Compiler : public Coala::AbstractCompiler, public BParser {
	private:
		bFlexLexer lexer;
		Printer* printer_;
		Coala::CompilerOptions* options_;
	
	protected:
		ostream* output_stream_;

	public:
		Compiler(Coala::CompilerOptions*);
		virtual ~Compiler();
		int compile();
		int yylex();
		void yyerror(char*);
		void change_input(std::istream*);

};

};

#endif // BCOMPILER_H
