using Gtk;

namespace Clinica {
    
    public class MedicineTreeView : Gtk.TreeView {
    
        private ListStore medicine_store { get; set; }
        
        private ResourceManager resource_manager { get; set; }
        
        public MedicineTreeView (ResourceManager resources) {
            resource_manager = resources;
            medicine_store = new ListStore (3, typeof (string), typeof (string), typeof (Medicine));
            set_model (medicine_store);
            
            /* Create necessary columns */
            var name_renderer = new CellRendererText ();
            insert_column_with_attributes (0, _("Name"), name_renderer, "text", 0);
            
            var price_renderer = new CellRendererText ();
            insert_column_with_attributes (1, _("Price"), price_renderer, "text", 1);
            
            row_activated.connect (on_row_activated);
            set_rules_hint (true);
        }
        
        private void on_row_activated (TreePath path) {
            TreeIter iter;
            Value medicine;
            
            /* Retrieve the selected row */
            medicine_store.get_iter (out iter, path);
            medicine_store.get_value (iter, 2, out medicine);
            
            /* Display the detail dialog */
            var dialog = new MedicineDetailDialog (resource_manager, medicine as Medicine);
	    dialog.set_transient_for (resource_manager.user_interface.window);            
            dialog.run ();
            dialog.destroy ();
        }
        
        public void clear () {
            medicine_store.clear ();
        }
        
        /**
         * @brief Push a new medicine into the treeview. 
         * 
         * MUST BE CALLED FROM ANOTHER THREAD!
         */
        public void push_medicine (Medicine medicine) {
            Gdk.threads_enter ();
            TreeIter iter;
            medicine_store.append (out iter);
            
            medicine_store.set_value (iter, 0, medicine.name);
            medicine_store.set_value (iter, 1, medicine.price);
            medicine_store.set_value (iter, 2, medicine);
            Gdk.threads_leave ();
        }
    }
}
