#include "cp_types.h"
#include "cp_proto.h"

/* post faces and/or circles in drawingorder, recompute/post as you 
go along. E.g., post 'ghosts'. If pl set, place first face; else, 
leave it where it is. */

int post_in_order(FILE *fp,struct p_data *p,int cflag,int fflag,int pl)
{
  int nf,ind,a,b,c,ccol,col,ck=0,v,n0,indx;

  nf=p->first_face;
  ccol=col=FG_COLOR;
  if (pl) place_face(p,nf,p->faces[nf].index_flag);
  if (cflag & 1) /* circle? */
    {
      ind=p->faces[nf].index_flag;
      a=p->faces[nf].vert[ind];
      b=p->faces[nf].vert[(ind+1) % 3];
      c=p->faces[nf].vert[(ind+2) % 3];
      if (cflag & 16) col=p->packK_ptr[a].color;
      if (cflag & 8) ccol=p->packK_ptr[a].color;
      post_any_circle(fp,p,a,cflag,ccol,col);
      if (cflag & 16) col=p->packK_ptr[b].color;
      if (cflag & 8) ccol=p->packK_ptr[b].color;
      post_any_circle(fp,p,b,cflag,ccol,col);
      if (cflag & 16) col=p->packK_ptr[c].color;
      if (cflag & 8) ccol=p->packK_ptr[c].color;
      post_any_circle(fp,p,c,cflag,ccol,col);
      if (fflag & 1)
	{
	  post_cir_label(fp,p,a);
	  post_cir_label(fp,p,b);
	  post_cir_label(fp,p,c);
	}
    }
  ccol=col=FG_COLOR;
  if (fflag & 1) /* faces? */
    {
      if (fflag & 16) col=p->faces[nf].color;
      if (fflag & 8) ccol=p->faces[nf].color;
      post_any_face(fp,p,nf,fflag,ccol,col);
    }
  if (fflag & 32) post_face_label(fp,p,nf);
  while ( nf>0 && nf <= p->facecount
	  && (nf=p->faces[nf].next_face)!=p->first_face
	  && ck<2*p->facecount)
    {
      v=p->faces[nf].vert[(indx=(p->faces[nf].index_flag+2)%3)];
      n0=nghb(p,v,p->faces[nf].vert[(indx+1)%3]);
      fancy_comp_center(p,v,n0,n0,1,0,1,1,toler);
      col=ccol=FG_COLOR;
      if (cflag & 1) /* circle? */
	{
	  c=p->faces[nf].vert[(p->faces[nf].index_flag + 2) % 3];
	  if (cflag & 16) col=p->packK_ptr[c].color;
	  if (cflag & 8) ccol=p->packK_ptr[c].color;
	  post_any_circle(fp,p,c,cflag,ccol,col); 
				/* new circle */
	}
      ccol=col=FG_COLOR;
      if (fflag & 1) /* faces? */
	{
	  if (fflag & 16) col=p->faces[nf].color;
	  if (fflag & 8) ccol=p->faces[nf].color;
	  post_any_face(fp,p,nf,fflag,ccol,col);
	}
      ck++;
    }
  if (nf!=p->first_face) /* some error */
    return 0;
  return 1;
} /* post_in_order */

