#include "cp_types.h"
#include "cp_proto.h"

/* Set center for vertex v using the average of its original location
   (if its plot_flag is set) and all the locations as computed from 
   pairs of contiguous neighbors with their plot_flags set. */

int molify_center(struct p_data *p,int v)
{
  int count=0,i,j,k;
  double o1,o2,o3;
  complex z;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  /*  if (pK_ptr[v].plot_flag) z=pR_ptr[v].center;*/
  z.re=z.im=0.0;
  for (i=0;i<pK_ptr[v].num;i++)
    if (pK_ptr[(j=pK_ptr[v].flower[i])].plot_flag
	&& pK_ptr[(k=pK_ptr[v].flower[i+1])].plot_flag)
      {
	if (p->overlap_status)
	  {
	    o1=pK_ptr[k].overlaps[nghb(p,k,v)];
	    o2=pK_ptr[v].overlaps[nghb(p,v,j)];
	    o3=pK_ptr[j].overlaps[nghb(p,j,k)];
	  }
	else o1=o2=o3=1.0;
	if (any_compcenter(p->hes,pR_ptr[j].center,pR_ptr[k].center,
		       &pR_ptr[v].center,pR_ptr[j].rad,pR_ptr[k].rad,
		       &pR_ptr[v].rad,o1,o2,o3))
	  {
	    z=cadd(z,pR_ptr[v].center);
	    count++;
	  }
      }
  if (!count) return 0;
  pR_ptr[v].center.re=z.re/(count);
  pR_ptr[v].center.im=z.im/(count);
  return (count);
} /* molify_center */
