#include "cp_types.h"
#include "cp_proto.h"

/* compute angle at vert v. flag indicated incompatibility. */

double comp_single_angle(struct p_data *p,int v,int u,int w,int *flag)
{
  double r,r1,r2;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  r=pR_ptr[v].rad;
  r1=pR_ptr[u].rad;
  r2=pR_ptr[w].rad;
  if (p->hes<-okerr) /* hyperbolic */
    {
      if (r<=0) return 0.0;
      if (!p->overlap_status) 
	return (acos(h_comp_cos(r,r1,r2)));
      else return (acos(h_cos_overlap(r,r1,r2,
				      pK_ptr[u].overlaps[nghb(p,u,w)],
				      pK_ptr[w].overlaps[nghb(p,w,v)],
				      pK_ptr[v].overlaps[nghb(p,v,u)],flag)));
    }
  if (p->hes<okerr) /* euclidean */
    {
      if (!p->overlap_status)
	return (acos(1-2*r1*r2/((r+r1)*(r+r2))));
      else return (acos(e_cos_overlap(r,r1,r2,
				      pK_ptr[u].overlaps[nghb(p,u,w)],
				      pK_ptr[w].overlaps[nghb(p,w,v)],
				      pK_ptr[v].overlaps[nghb(p,v,u)],flag)));
    }
  else /* spherical - no overlaps yet */
    return(s_comp_cos(r,r1,r2,flag));
} /* comp_single_angle */


