#include "cp_types.h"
#include "cp_proto.h"

/* add trivalent verts to faces. */

int add_barys(struct p_data *p,char *datastr)
{
  int count=0,hits,node;
  struct Vertlist *facelist,*trace,*dups;
  char *endptr;

  if ( (facelist=Face_link_parse(p,datastr,&endptr,&hits,&Vlist,&Elist,
				 &Flist,&region,pathlist,pathlength)) == NULL )
    return 0;
  if ( (node=p->nodecount+hits) > (p->sizelimit)
       && !alloc_pack_space(p,node,1) )
    {
      sprintf(msgbuf,
	      "Space allocation problem with adding barycenters.");
      emsg();
      return 0;
    }
  trace=facelist;
  while (trace!=NULL)
    {
      dups=facelist;
      while (dups!=trace)  /* zero out any repeats */

	{
	  if (trace->v==dups->v)
	    { trace->v=0;continue;}
	  dups=dups->next;
	}
      if (trace->v) count += add_barycenter(p,trace->v);
      trace=trace->next;
    }
  vert_free(&facelist);
  if (count)
    {
      complex_count(p,0);
      facedraworder(p,0);
    }
  return count;
} /* add_barys */
