#include "cp_types.h"
#include "cp_proto.h"

/* based on shell_main.c TEMPLATE */

/* Read a *.vl file of a parent packing and light subpackings.
   Put postscript images in a file showing light packings color 
   coded in context of parent packing. Since we use the parent 
   packing for the locations, it should be repacked and fixed 
   already. */

char *emsgbuf,*msgbuf;

int main(int argc,char *argv[])
{
  int i,j,N;
  struct p_data *p;
  struct K_data *pK_ptr;
  struct p_light **plight;
  char line[BUFSIZE],filename[BUFSIZE],cbuf[BUFSIZE],psname[BUFSIZE];
  FILE *fpps;

  set_cp_globals(); /* set up library global variables */

  /* ----------- user code starts here */

  p=init_packing();

  printf("Disp_decomposition: for reading a *.vl file which gives "
	 "a packing and lists of vertices associated with light "
	 "subpackings and showing postsript images."
	 "\n  Enter a *.vl filename:\n");
  fgets(line,sizeof(line),stdin);
  if (!sscanf(line,"%s",filename)
      || !(N=read_parent_child(filename,p,&plight)))
    {
      printf("Failed to open %s.",filename);
      exit(1);
    }

  pK_ptr=p->packK_ptr;
  if (p->hes==0) /* euclidean */
    {
      sprintf(cbuf,"-a 1.0");
      e_norm_scale(p,cbuf); /* normalize packing to have radius 1 */
    }

  /* create postscript file with successive images of light packings
     as subpackings of parent. */

  sprintf(psname,"%s.ps",filename);
  sprintf(cbuf,"-o -c -x"); /* initiate file */
  print_call(&fpps,p,psname,cbuf,"Disp_decompose","7/2001","lpr");

  for (i=1;i<=N;i++)
    {
      for(j=1;j<=p->nodecount;j++) pK_ptr[j].color=BG_COLOR;
      for(j=1;j<=plight[i]->counts[2];j++)
	pK_ptr[plight[i]->orig_indices[j]].color=50; /* blue variable verts */
      for(j=plight[i]->counts[2]+1;j<=plight[i]->counts[0];j++)
	pK_ptr[plight[i]->orig_indices[j]].color=150; /* red fixed verts */
      sprintf(cbuf,"-oa -cf -x");
      print_call(&fpps,p,psname,cbuf,"","","lpr"); 
        /* add new page with next light packing color highlighted */
    }
  sprintf(cbuf,"-xg");
  print_call(&fpps,p,psname,cbuf,"","","lpr"); /* launch ghostview */
  printf("Have save postscript images in %s.",psname);

  /* ----------- user code ends here */
  exit(0);
} /* main */


/* ====== communication routines; user may want to modify ====== */

int emsg()
{
  printf(emsgbuf);return 1;
} /* emsg */

int msg()
{
  printf(msgbuf);return 1;
} /* msg */

int repack_activity_msg(char *datastr)
     /* report progress of repacking */
{
  strcpy(msgbuf,datastr);
  msg();
  return 1;
} /* repack_activity_msg */

int refresh_canvas(struct s_data *q)
     /* some drawing routines want to refresh */
{return 1;} /* refresh_canvas */

/* ================================================================= */

