#include "cp_types.h"
#include "cp_proto.h"

/* Like e_anglesum_overlap, but flag tells about incompatibilities:
(routines need work)
  =0, no incompatibilities; 
  =1, rad too small for one or more faces;
  =2, rad too large for one or more faces;
  =3, mixed, too large for some, small for other(s)
incompat_err accumulates amounts of incompat as sum |cos(x)|-1. */

int e_as_overlap(struct p_data *p,int v,double r,double *c,
		 int *flag,double *incompat_err)
{
  int j1,j2,n;
  double o2,o1,ovlp,r1,r2,m1,m2;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  *c=0; 
  *flag=0;

  j2=pK_ptr[v].flower[0];
  r2=pR_ptr[j2].rad;
  if (!p->overlap_status)
  {
    m2 = r2/(r+r2);
    for (n=1;n<=pK_ptr[v].num;n++)
    {
      m1 = m2;
      r2 = pR_ptr[pK_ptr[v].flower[n]].rad;
      m2 = r2/(r+r2);
      *c +=acos(1-2*m1*m2);
    }
  }
  else
  {
    o2=pK_ptr[v].overlaps[0];
    for (n=1;n<=pK_ptr[v].num;n++)
    {
      j1=j2;r1=r2;o1=o2;
      j2=pK_ptr[v].flower[n];
      r2=pR_ptr[j2].rad;
      o2=pK_ptr[v].overlaps[n];
      ovlp=pK_ptr[j1].overlaps[nghb(p,j1,j2)];
      *c +=acos(e_cos_overlap_special(r,r1,r2,ovlp,o2,o1,flag,incompat_err));
    }
  }
  return 1;
} /* e_as_overlap */
