#include "cp_types.h"
#include "cp_proto.h"

/* ====================  cookie stuff ====================== */

/* Combinatoric routines for cutting out and/or slitting 
   a complex. See also redchain_stuff.c and faceorder_stuff.c */

extern int **face_org;

int cookie_cutter(struct p_data *p,char *datastr,int **newold)
/* cookie out part of pack p based on list of 'poison' vertices or
(default) based on current path. Return 0 on failure, new nodecount
otherwise. Create 'newold' to hold vertex conversion info; calling
routine must reestablish vertex_map. */
{
  int i,j,k,tick,length,seed,return_value=0;
  char *nextpoint,*endptr,next[BUFSIZE];
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;
  struct Vertlist *vertlist=NULL,*trace,*face_order=NULL;
  struct RedList *redlist=NULL;
  struct EdgePair *edge_pair=NULL;
  
  *newold=NULL;
  if (p->locks) return 0;
  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;

/* check datastr for -v flag, giving 'seed' vert; default to alpha */
  nextpoint=datastr;
  stripsp(nextpoint);
  if (*nextpoint=='-' && *(nextpoint+1)=='v')
    {
      nextpoint += 2;
      if (grab_next(&nextpoint,next)
	  && sscanf(next,"%d",&seed) && seed>0 && seed <= p->nodecount
	  && !pK_ptr[seed].bdry_flag);
      else seed=p->alpha;
    }
  else seed=p->alpha;
    
/* identify 'poison' verts from datastr description; set util_flag=-1.
   'tick' should be counting poison verts. */
  tick=p->nodecount;
  if ((vertlist=Node_link_parse(p,nextpoint,&endptr,&length,
       &Vlist,&Elist,&Flist,&region,pathlist,pathlength)))
    /* listed vertices */
    {
      for (i=1;i<=p->nodecount;i++) pK_ptr[i].util_flag=0;
      trace=vertlist;
      while (trace)
	{
	  pK_ptr[trace->v].util_flag=-1;
	  trace=trace->next;
	  tick--;
	}
      vert_free(&vertlist);
    }
  else if((vertlist=Node_link_parse(p,"g",&endptr,&length,
	   &Vlist,&Elist,&Flist,&region,pathlist,pathlength)) )
    /* fixup: need to allow designation of seed vert (default alpha)
       in this call.*/
    /* default: outside path or nghbs to outside. */
    {
      for (i=1;i<=p->nodecount;i++) pK_ptr[i].util_flag=-1;
      trace=vertlist;
      while (trace)
	{
	  pK_ptr[trace->v].util_flag=0;
	  trace=trace->next;
	  tick--;
	}
      /* immediate nghbs to outside are also poison; first
	 set util_flag to 1, then go back and set to -1. */
      for (i=1;i<=p->nodecount;i++)
	for (j=0;j<=pK_ptr[i].num && !pK_ptr[i].util_flag;j++)
	  if (pK_ptr[pK_ptr[i].flower[j]].util_flag==-1)
	    pK_ptr[i].util_flag=1;
      for (i=1;i<=p->nodecount;i++)
	if (pK_ptr[i].util_flag==1) 
	  {
	    pK_ptr[i].util_flag=-1;
	    tick++;
	  }
      vert_free(&vertlist);
    }
  else /* no description given, so assume calling routine has already
	  set util_flag=-1 for poison */
    {
      tick=0;
      for (i=1;i<=p->nodecount;i++) 
	if (pK_ptr[i].util_flag==-1) tick++;
    }

  /* We need to remove isolated poisons */

  for (i=1;i<=p->nodecount;i++) 
    if (pK_ptr[i].util_flag==-1)
      {
	k=0;
	for (j=0;j<=pK_ptr[i].num;j++) 
	  k+= (pK_ptr[pK_ptr[i].flower[j]].util_flag==-1);
	if (!k) /* no poison neighbors */
	  {
	    pK_ptr[i].util_flag=0;
	    tick--;
	  }
      }

  if (!tick || tick==p->nodecount) 
    return 0;      /* no verts or all verts poison */
  
  for (i=1;i<=p->nodecount;i++) /* find interior among non-poison */
    {
      k=pK_ptr[i].util_flag;
      for (j=0;j<=pK_ptr[i].num;j++)
	k += pK_ptr[pK_ptr[i].flower[j]].util_flag;
      if (!k && pK_ptr[i].flower[0]==pK_ptr[i].flower[pK_ptr[i].num]) 
	pK_ptr[i].bdry_flag=0;
    }
  if (pK_ptr[seed].bdry_flag) return 0; /* seed not interior */
  /* fixup: do we need seed to be interior? just non-poison? */

  edge_free(&(p->vertex_map));

/* call build_redchain to defind core of complex from seed,
   stopping at poison verts; need to catalog faces, process 
   the red chain, etc.. Must clean up the catalog, edge_pairs, 
   etc., on leaving. */

  face_order=(struct Vertlist *)
    calloc((size_t)1,sizeof(struct Vertlist));
  edge_pair=(struct EdgePair *)
    calloc((size_t)(3*MAX_COMPONENTS+1),sizeof(struct EdgePair));
  catalog_faces(p);

  if (p->rwb_flags) free(p->rwb_flags);
  p->rwb_flags=(int *)calloc((size_t)(p->facecount+1),sizeof(int));
  if (!(redlist=(struct RedList *)build_redchain(p,seed,face_order)))
    {
      free(p->rwb_flags);
      p->rwb_flags=NULL;
      sprintf(msgbuf,"build_redchain error.");
      emsg();
      destroy_catalog(p->nodecount);
      goto GETOUT;
    }

  redface_comb_info(p,redlist,edge_pair);

/* create new complex; perhaps throw out some vertices,
     may have to clone others */
  if (!rationalize_subcomplex(p,seed,redlist,face_order,newold))
    {
      sprintf(msgbuf,"problem rationalizing subcomplex in cookie.");
      emsg();
      goto GETOUT;
    }
  else return_value=p->nodecount;

 GETOUT:
  free_redfaces(&redlist);
  vert_free(&face_order);
  if (edge_pair) free(edge_pair);
  return return_value;
} /* cookie_cutter */

int rationalize_subcomplex(struct p_data *p,int seed,
			   struct RedList *redlist,
			   struct Vertlist *fdo,int **newold)
/* Given a red chain of faces for p, throw out vertices 
outside it; also may need to clone some vertices. -- 
if they define two or more different boundary verts, if they 
are side-paired poison verts. Result is put back in p; p could be 
corrupted on error. return new nodecount, or zero on error. 
Set alpha to be seed, give list of vert index conversions. 

Main complication is cloning. Need to clone a vert whose flower
is not completely in the subcomplex and moreover the part that is
in the subcomplex may be broken into two or more subfans. In addition,
if fan is partitioned for a 'poison' vert, (indicated by util_flag=-1) 
then need to clone it. Note, don't clone all verts which repeat
in the outer bdry of the red chain --- if not poison
and complete fan is in subcomplex, they don't need to be cloned.
In particular, new complex is not necessarily simply connected.
(Side-paired parts of the red chain which come about because of 
multiple connectedness rather than because of poison verts are
not cloned.) */
{
  int i,ii,j,jj,k,v,vert,indx,num,f,count,Nodes,wflag;
  int *face_ptr,*new_flower,debug=0,old_nodecount,*oldnew=NULL;
  f_data *faces=NULL;
  struct Vertlist *order;
  struct K_data *nK_ptr=NULL,*pK_ptr;
  struct R_data *nR_ptr=NULL,*pR_ptr;
  struct BdryData *bdrydata,*trace,*temp;
  FILE *diagfp;

  if (!(bdrydata=organize_bdry_data(p,redlist))) 
    {
      destroy_catalog(p->nodecount);
      return p->nodecount; 
    }
  /* either error in bdry data, or no change in combinatorics */

  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  Nodes=old_nodecount=p->nodecount; /* Nodes adjusts for new vert indices */

  /* Create new K_data area, save radii, create new faces
     structure */

  if ((nK_ptr=(struct K_data *)
       calloc((size_t)(2*old_nodecount+1),sizeof(struct K_data)))==NULL
      || (nR_ptr=(struct R_data *)
	  calloc((size_t)(2*old_nodecount+1),sizeof(struct R_data)))==NULL)
    {
      if (nK_ptr) free(nK_ptr);
      free_bdrydata(&bdrydata);
      destroy_catalog(old_nodecount);
      return 0;
    }
  for (i=1;i<=old_nodecount;i++)
    {
      nK_ptr[i]=pK_ptr[i];
      nK_ptr[i].util_flag=0;
      nR_ptr[i]=pR_ptr[i];
      nK_ptr[i].flower=(int *)
	calloc((size_t)(nK_ptr[i].num+1),sizeof(int));
      for (j=0;j<=nK_ptr[i].num;j++) 
	nK_ptr[i].flower[j]=pK_ptr[i].flower[j];
    }
  if (p->overlap_status) /* overlaps? replicate data. */
    for (i=1;i<=old_nodecount;i++)
      {
	nK_ptr[i].overlaps=(double *)
	  calloc((size_t)(nK_ptr[i].num+1),sizeof(double));
	for (j=0;j<=nK_ptr[i].num;j++) 
	  nK_ptr[i].overlaps[j]=pK_ptr[i].overlaps[j];
      }
  faces=(f_data *)calloc((size_t)(p->facecount+1),sizeof(f_data));
  for (j=1;j<=p->facecount;j++)
    for (i=0;i<3;i++)
      faces[j].vert[i]=p->faces[j].vert[i];

  /* Create new vert numbers, cloning vert associated with every 
     sub-sublist in bdrydata. Record the new vert numbers in the
     new face structure. (Make up flowers, overlaps later.) */
  
  zero_duty_flags(bdrydata);
  trace=bdrydata;
  while (!trace->duty_flag)
    {
      trace->duty_flag=1;
      vert=trace->v;
      face_ptr=face_org[vert]+1;
      temp=trace;
      wflag=0;
      while (temp!=trace || !(wflag++))
	{
	  temp->duty_flag=1;
	  Nodes=indx=temp->new_indx=Nodes+1; /* new index */
	  nK_ptr[indx].bdry_flag=nK_ptr[indx].plot_flag=1;
	  nK_ptr[indx].num=temp->num;
	  nK_ptr[indx].flower=(int *)
	    calloc((size_t)(nK_ptr[indx].num+1),sizeof(int));
	  if (p->overlap_status) nK_ptr[indx].overlaps=(double *)
	     calloc((size_t)(nK_ptr[indx].num+1),sizeof(double));
	  nK_ptr[indx].color=pK_ptr[vert].color;
	  nR_ptr[indx].rad=pR_ptr[vert].rad;
	  nR_ptr[indx].center=pR_ptr[vert].center;
	  nR_ptr[indx].aim=-.1;
	  i=temp->indx1;
	  if (temp->indx1==temp->indx2) /* just one face */
	    {
	      f=face_ptr[i];
	      j=find_index(p,f,vert);
	      faces[f].vert[j]=temp->new_indx;
	    }
	  else for (i=0;i<temp->num;i++)
	    {
	      ii=(temp->indx1+i) % pK_ptr[vert].num;
	      f=face_ptr[ii];
	      j=find_index(p,f,vert);
	      faces[f].vert[j]=temp->new_indx;
	    }
	  temp=temp->next_v;
	}
      trace=trace->next;
      while (trace->duty_flag && trace!=bdrydata) trace=trace->next;
    } /* end of while */

  /* Go through the fan of faces of each entry of bdrydata, 
     use the new index numbers recorded in the new face structure
     to fix up the flowers of the newly created vertices and
     modify the flowers of the OLD vert numbers. */

  zero_duty_flags(bdrydata);
  trace=bdrydata;
  while (!trace->duty_flag)
    {
      trace->duty_flag=1;
      vert=trace->v;
      face_ptr=face_org[vert]+1;
      /* nghb vert of first face */
      f=face_ptr[trace->indx1];
      j=find_index(p,f,vert); /* distinguished vert index */
      nK_ptr[trace->new_indx].flower[0]=v=faces[f].vert[(j+1) % 3];
      if (v<=old_nodecount)
	{
	  k=nghb(p,v,vert);
	  /* if first vertex v from fan is an old vertex and is interior,
	     then it becomes bdry and flower must be opened. (The
	     vert at the end of fan will be handled likewise below.) */
	  if (!nK_ptr[v].bdry_flag)
	    {
	      num=nK_ptr[v].num;
	      new_flower=(int *)
		calloc((size_t)(num+1),sizeof(int));
	      for (jj=0;jj<num;jj++)
		new_flower[jj]=nK_ptr[v].flower[(k+jj) % num];
/* fixup: need to take care of overlaps
	      if (p->overlap_status)
		{
		  new_overlaps=(double *)
		    calloc((size_t)(num+1),sizeof(int));
		  for (jj=0;jj<num;jj++)
		    new_overlaps[jj]=nK_ptr[v].overlaps[(k+jj) % num];
		  new_overlaps[num]=nK_ptr[v].overlaps[k];
		  nK_ptr[v].overlaps=new_overlaps;
		  free(pK_ptr[v].overlaps);
		}
*/
	      new_flower[num]=trace->new_indx;
	      nK_ptr[v].flower=new_flower;
	      nK_ptr[v].bdry_flag=1;
	      nR_ptr[v].aim=-.1;
	      free(pK_ptr[v].flower);
	      pK_ptr[v].flower=(int *)
		calloc((size_t)(num+1),sizeof(int));
	      for (i=0;i<=num;i++)
		pK_ptr[v].flower[i]=nK_ptr[v].flower[i];
	    }
	  else /* old boundary vert */
	    nK_ptr[v].flower[k]=trace->new_indx;
	}
      /* next verts of rest of faces */
      i=0;
      while (i<trace->num) 
	{
	  f=face_ptr[(trace->indx1+i) % (pK_ptr[vert].num)];
	  jj=(find_index(p,f,vert)+2) % 3; 
	  nK_ptr[trace->new_indx].flower[i+1]=faces[f].vert[jj];
	  /* old vert number; need to adjust its flower */
	  if ((v=faces[f].vert[jj]) <= p->nodecount) 
	    {
	      k=nghb(p,v,vert);
	      /* have to open flower? */
	      if (i==trace->num && !nK_ptr[v].bdry_flag) 
		{
		  num=nK_ptr[v].num;
		  new_flower=(int *)
		    calloc((size_t)(num+1),sizeof(int));
		  for (jj=0;jj<num;jj++)
		    new_flower[jj]=nK_ptr[v].flower[(k+jj) % num];
		  new_flower[0]=trace->new_indx;
		  nK_ptr[v].flower=new_flower;
		  nK_ptr[v].bdry_flag=1;
		  nR_ptr[v].aim=-.1;
		  free(pK_ptr[v].flower);
		  pK_ptr[v].flower=(int *)
		    calloc((size_t)(num+1),sizeof(int));
		  for (i=0;i<=num;i++)
		    pK_ptr[v].flower[i]=nK_ptr[v].flower[i];
		}		  
	      else
		{
		  nK_ptr[v].flower[k]=trace->new_indx;
		  if (k==0 && !nK_ptr[v].bdry_flag)
		    nK_ptr[v].flower[pK_ptr[v].num]=trace->new_indx;
		}
	    }
	  i++;
	}
      trace=trace->next;
    }
  destroy_catalog(old_nodecount);

  /* Must renumber all vertices; new faces structure contains
     all the indices to be saved, throw out rest, put these in
     order, adjust p. Use fdo to figure out which faces are to
     be in the new complex, get vert numbers, mark them using
     nK_ptr util_flags. */

  for (i=1;i<=Nodes;i++) nK_ptr[i].util_flag=0;
  order=fdo;
  while (order!=NULL)
    {
      for (i=0;i<3;i++)
	nK_ptr[faces[order->v].vert[i]].util_flag=1;
      order=order->next;
    }

  count=0;
  for (i=1;i<=Nodes;i++) if (nK_ptr[i].util_flag) count++;

  /* clean out old packing, adjust size */
  alloc_pack_space(p,((int)((count-1)/5000))*5000+5000,0);
  p->status=1;
  p->nodecount=count;
  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;

/* debug */
  if (debug)
    {
      fprintf(stderr,"Verts to keep: ");
      for (i=1;i<=Nodes && i<250;i++)
	if (nK_ptr[i].util_flag)
	  fprintf(stderr," %d,",i);
      fprintf(stderr,"\n");
    }

  *newold=(int *)calloc((size_t)(Nodes+1),sizeof(int));
  oldnew=(int *)calloc((size_t)(Nodes+1),sizeof(int));

  count=0;
  for (i=1;i<=Nodes;i++)
    {
      if (nK_ptr[i].util_flag)
	{
	  count++;
	  oldnew[i]=count;
	  pK_ptr[count]=nK_ptr[i];
	  pR_ptr[count]=nR_ptr[i];
	  if (i<=old_nodecount) (*newold)[count]=i;
	  else /* look up original index of this new vert */
	    {
	      trace=bdrydata;
	      while (trace)
		{
		  if (trace->new_indx==i)
		    {
		      (*newold)[count]=trace->v;
		      trace=NULL;
		    }
		  else trace=trace->next;
		}
	    }
	}
      else free(nK_ptr[i].flower);
    }

  /* update indices in original flowers */
  for (i=1;i<=p->nodecount;i++)
    for (j=0;j<=p->packK_ptr[i].num;j++)
      p->packK_ptr[i].flower[j]=oldnew[p->packK_ptr[i].flower[j]];

/* debug */
  if (debug)
    {
      fprintf(stderr,"Print the flowers: \n");
      for (i=1;i<=p->nodecount && i<250;i++)
	print_flower(nK_ptr,i);
    }

  if (!(p->alpha=oldnew[seed])) choose_alpha(p);
  if (!(p->beta=oldnew[p->beta])) choose_beta(p);
  if (!(p->gamma=oldnew[p->gamma])) choose_gamma(p);
  free(faces);
  /* debug */
  if (debug && bdrydata && (diagfp=fopen("/tmp/bdry.data","w")))
    {
      fprintf(diagfp,"Tmp vert indices to final indices: "
	      "tmp# -> new#,  nodecount=%d\n",
	      p->nodecount);
      for (i=1;i<=Nodes;i++)
	if (oldnew[i]) fprintf(diagfp,"%d -> %d\n",i,oldnew[i]);
      fprintf(diagfp,"\nBdryData info: (orig #) --> (new#)\n"
	      "  orig_nodecount %d, temp new count %d\n",
	      old_nodecount,Nodes);
      count=wflag=0;
      trace=bdrydata;
      while (trace!=bdrydata || !(wflag++))
	{
	  fprintf(diagfp,"%d --> %d\n",trace->v,trace->new_indx);
	  trace=trace->next;
	  count++;
	}
      fprintf(diagfp,"\n  BdryData count=%d\nEND\n",count);
      fclose(diagfp);
    }
  free_bdrydata(&bdrydata);
  free(oldnew);

  complex_count(p,0);
  facedraworder(p,0);
  /* fixup: 
        save inv dist data when possible
  */
  return p->nodecount;
} /* rationalize_subcomplex */

int zero_duty_flags(struct BdryData *bdrydata)
{
  int wflag=0;
  struct BdryData *trace;

  trace=bdrydata;
  while(trace!=bdrydata || !(wflag++))
    {
      trace->duty_flag=0;
      trace=trace->next;
    }
  return 1;
} /* zero_duty_flags */


  
