/* Generated from posixwin.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2009-09-21 21:28
   Version 4.0.1 - SVN rev. 14292
   linux-unix-gnu-x86 [ manyargs dload ptables applyhook ]
   compiled 2009-05-12 on galinha (Linux)
   command line: posixwin.scm -no-trace -optimize-level 2 -include-path . -include-path ./ -explicit-use -unsafe -no-lambda-info -output-file uposixwin.c
   unit: posix
*/

#include "chicken.h"

#ifndef WIN32_LEAN_AND_MEAN
# define WIN32_LEAN_AND_MEAN
#endif

/*
MinGW should have winsock2.h and ws2tcpip.h as well.
The CMake build will set HAVE_WINSOCK2_H and HAVE_WS2TCPIP_H.
However, the _MSC_VER test is still needed for vcbuild.bat.
./configure doesn't test for these.  It should, for MinGW.
*/
#if (_MSC_VER > 1300) || (defined(HAVE_WINSOCK2_H) && defined(HAVE_WS2TCPIP_H))
# include <winsock2.h>
# include <ws2tcpip.h>
#else
# include <winsock.h>
#endif

#include <signal.h>
#include <errno.h>
#include <io.h>
#include <stdio.h>
#include <process.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <direct.h>

#include <time.h>

#define ARG_MAX		256
#define PIPE_BUF	512
#ifndef ENV_MAX
# define ENV_MAX	1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct group *C_group;
static C_TLS int C_pipefds[ 2 ];
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS struct stat C_statbuf;

/* pipe handles */
static C_TLS HANDLE C_rd0, C_wr0, C_wr0_, C_rd1, C_wr1, C_rd1_;
static C_TLS HANDLE C_save0, C_save1; /* saved I/O handles */
static C_TLS char C_rdbuf; /* one-char buffer for read */
static C_TLS int C_exstatus;

/* platform information; initialized for cached testing */
static C_TLS char C_hostname[256] = "";
static C_TLS char C_osver[16] = "";
static C_TLS char C_osrel[16] = "";
static C_TLS char C_processor[16] = "";
static C_TLS char C_shlcmd[256] = "";

/* Windows NT or better */
static int C_isNT = 0;

/* Current user name */
static C_TLS TCHAR C_username[255 + 1] = "";

/* Directory Operations */

#define C_mkdir(str)	    C_fix(mkdir(C_c_string(str)))
#define C_chdir(str)	    C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)	    C_fix(rmdir(C_c_string(str)))

#ifndef __WATCOMC__
/* DIRENT stuff */
struct dirent
{
    char *		d_name;
};

typedef struct
{
    struct _finddata_t	fdata;
    int			handle;
    struct dirent	current;
} DIR;

static DIR * C_fcall
opendir(const char *name)
{
    int name_len = strlen(name);
    DIR *dir = (DIR *)malloc(sizeof(DIR));
    char *what;
    if (!dir)
    {
	errno = ENOMEM;
	return NULL;
    }
    what = (char *)malloc(name_len + 3);
    if (!what)
    {
	free(dir);
	errno = ENOMEM;
	return NULL;
    }
    strcpy(what, name);
    if (strchr("\\/", name[name_len - 1]))
	strcat(what, "*");
    else
	strcat(what, "\\*");

    dir->handle = _findfirst(what, &dir->fdata);
    if (dir->handle == -1)
    {
	free(what);
	free(dir);
	return NULL;
    }
    dir->current.d_name = NULL; /* as the first-time indicator */
    free(what);
    return dir;
}

static int C_fcall
closedir(DIR * dir)
{
    if (dir)
    {
	int res = _findclose(dir->handle);
	free(dir);
	return res;
    }
    return -1;
}

static struct dirent * C_fcall
readdir(DIR * dir)
{
    if (dir)
    {
	if (!dir->current.d_name /* first time after opendir */
	     || _findnext(dir->handle, &dir->fdata) != -1)
	{
	    dir->current.d_name = dir->fdata.name;
	    return &dir->current;
	}
    }
    return NULL;
}
#endif /* ifndef __WATCOMC__ */

#ifdef __WATCOMC__
# define mktemp _mktemp
/* there is no P_DETACH in Watcom CRTL */
# define P_DETACH P_NOWAIT
#endif

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)		(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)	    (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, _popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, _popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)			     C_fix(_pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_getpid	    getpid
#define C_chmod(fn, m)	    C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)	    C_fix(fileno(C_port_file(p)))
#define C_dup(x)	    C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)	    C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)	    C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_pipe(d, m)	    C_fix(_pipe(C_pipefds, PIPE_BUF, C_unfix(m)))
#define C_close(fd)	    C_fix(close(C_unfix(fd)))

#define C_getenventry(i)   environ[ i ]

#define C_putenv(s)	    C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)	    C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)	    C_fix(fstat(C_unfix(f), &C_statbuf))

static C_word C_fcall
C_setenv(C_word x, C_word y)
{
    char *sx = C_data_pointer(x),
	 *sy = C_data_pointer(y);
    int n1 = C_strlen(sx),
	n2 = C_strlen(sy);
    char *buf = (char *)C_malloc(n1 + n2 + 2);
    if (buf == NULL)
	return(C_fix(0));
    else
    {
	C_strcpy(buf, sx);
	buf[ n1 ] = '=';
	C_strcpy(buf + n1 + 1, sy);
	return(C_fix(putenv(buf)));
    }
}

static void C_fcall
C_set_arg_string(char **where, int i, char *dat, int len)
{
    char *ptr;
    if (dat)
    {
	ptr = (char *)C_malloc(len + 1);
	C_memcpy(ptr, dat, len);
	ptr[ len ] = '\0';
    }
    else
	ptr = NULL;
    where[ i ] = ptr;
}

static void C_fcall
C_free_arg_string(char **where) {
  while (*where) C_free(*(where++));
}

#define C_set_exec_arg(i, a, len)	C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)	C_set_arg_string(C_exec_env, i, a, len)

#define C_free_exec_args()		(C_free_arg_string(C_exec_args), C_SCHEME_TRUE)
#define C_free_exec_env()		(C_free_arg_string(C_exec_env), C_SCHEME_TRUE)

#define C_execvp(f)	    C_fix(execvp(C_data_pointer(f), (const char *const *)C_exec_args))
#define C_execve(f)	    C_fix(execve(C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

/* MS replacement for the fork-exec pair */
#define C_spawnvp(m, f)	    C_fix(spawnvp(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args))
#define C_spawnvpe(m, f)    C_fix(spawnvpe(C_unfix(m), C_data_pointer(f), (const char *const *)C_exec_args, (const char *const *)C_exec_env))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)	    C_fix(mktemp(C_c_string(t)))

#define C_ftell(p)	    C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)   C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_flushall()	    C_fix(_flushall())

#define C_ctime(n)	    (C_secs = (n), ctime(&C_secs))

#define C_tm_set_08(v) \
        (memset(&C_tm, 0, sizeof(struct tm)), \
        C_tm.tm_sec = C_unfix(C_block_item(v, 0)), \
        C_tm.tm_min = C_unfix(C_block_item(v, 1)), \
        C_tm.tm_hour = C_unfix(C_block_item(v, 2)), \
        C_tm.tm_mday = C_unfix(C_block_item(v, 3)), \
        C_tm.tm_mon = C_unfix(C_block_item(v, 4)), \
        C_tm.tm_year = C_unfix(C_block_item(v, 5)), \
        C_tm.tm_wday = C_unfix(C_block_item(v, 6)), \
        C_tm.tm_yday = C_unfix(C_block_item(v, 7)), \
        C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE))

#define C_tm_set(v) (C_tm_set_08(v), &C_tm)

#define C_asctime(v)    (asctime(C_tm_set(v)))
#define C_mktime(v)     ((C_temporary_flonum = mktime(C_tm_set(v))) != -1)

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set(v)) ? C_time_string : NULL)

/*
  mapping from Win32 error codes to errno
*/

typedef struct
{
    DWORD   win32;
    int	    libc;
} errmap_t;

static errmap_t errmap[] =
{
    {ERROR_INVALID_FUNCTION,	  EINVAL},
    {ERROR_FILE_NOT_FOUND,	  ENOENT},
    {ERROR_PATH_NOT_FOUND,	  ENOENT},
    {ERROR_TOO_MANY_OPEN_FILES,	  EMFILE},
    {ERROR_ACCESS_DENIED,	  EACCES},
    {ERROR_INVALID_HANDLE,	  EBADF},
    {ERROR_ARENA_TRASHED,	  ENOMEM},
    {ERROR_NOT_ENOUGH_MEMORY,	  ENOMEM},
    {ERROR_INVALID_BLOCK,	  ENOMEM},
    {ERROR_BAD_ENVIRONMENT,	  E2BIG},
    {ERROR_BAD_FORMAT,		  ENOEXEC},
    {ERROR_INVALID_ACCESS,	  EINVAL},
    {ERROR_INVALID_DATA,	  EINVAL},
    {ERROR_INVALID_DRIVE,	  ENOENT},
    {ERROR_CURRENT_DIRECTORY,	  EACCES},
    {ERROR_NOT_SAME_DEVICE,	  EXDEV},
    {ERROR_NO_MORE_FILES,	  ENOENT},
    {ERROR_LOCK_VIOLATION,	  EACCES},
    {ERROR_BAD_NETPATH,		  ENOENT},
    {ERROR_NETWORK_ACCESS_DENIED, EACCES},
    {ERROR_BAD_NET_NAME,	  ENOENT},
    {ERROR_FILE_EXISTS,		  EEXIST},
    {ERROR_CANNOT_MAKE,		  EACCES},
    {ERROR_FAIL_I24,		  EACCES},
    {ERROR_INVALID_PARAMETER,	  EINVAL},
    {ERROR_NO_PROC_SLOTS,	  EAGAIN},
    {ERROR_DRIVE_LOCKED,	  EACCES},
    {ERROR_BROKEN_PIPE,		  EPIPE},
    {ERROR_DISK_FULL,		  ENOSPC},
    {ERROR_INVALID_TARGET_HANDLE, EBADF},
    {ERROR_INVALID_HANDLE,	  EINVAL},
    {ERROR_WAIT_NO_CHILDREN,	  ECHILD},
    {ERROR_CHILD_NOT_COMPLETE,	  ECHILD},
    {ERROR_DIRECT_ACCESS_HANDLE,  EBADF},
    {ERROR_NEGATIVE_SEEK,	  EINVAL},
    {ERROR_SEEK_ON_DEVICE,	  EACCES},
    {ERROR_DIR_NOT_EMPTY,	  ENOTEMPTY},
    {ERROR_NOT_LOCKED,		  EACCES},
    {ERROR_BAD_PATHNAME,	  ENOENT},
    {ERROR_MAX_THRDS_REACHED,	  EAGAIN},
    {ERROR_LOCK_FAILED,		  EACCES},
    {ERROR_ALREADY_EXISTS,	  EEXIST},
    {ERROR_FILENAME_EXCED_RANGE,  ENOENT},
    {ERROR_NESTING_NOT_ALLOWED,	  EAGAIN},
    {ERROR_NOT_ENOUGH_QUOTA,	  ENOMEM},
    {0, 0}
};

static void C_fcall
set_errno(DWORD w32err)
{
    errmap_t *map = errmap;
    for (; errmap->win32; ++map)
    {
	if (errmap->win32 == w32err)
	{
	    errno = errmap->libc;
	    return;
	}
    }
}

static int C_fcall
set_last_errno()
{
    set_errno(GetLastError());
    return 0;
}

/* Functions for creating process with redirected I/O */

static int C_fcall
zero_handles()
{
    C_rd0 = C_wr0 = C_wr0_ = INVALID_HANDLE_VALUE;
    C_rd1 = C_wr1 = C_rd1_ = INVALID_HANDLE_VALUE;
    C_save0 = C_save1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
close_handles()
{
    if (C_rd0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd0);
    if (C_rd1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1);
    if (C_wr0 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0);
    if (C_wr1 != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr1);
    if (C_rd1_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_rd1_);
    if (C_wr0_ != INVALID_HANDLE_VALUE)
	CloseHandle(C_wr0_);
    if (C_save0 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	CloseHandle(C_save0);
    }
    if (C_save1 != INVALID_HANDLE_VALUE)
    {
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	CloseHandle(C_save1);
    }
    return zero_handles();
}

static int C_fcall
redir_io()
{
    SECURITY_ATTRIBUTES sa;
    sa.nLength = sizeof(SECURITY_ATTRIBUTES);
    sa.bInheritHandle = TRUE;
    sa.lpSecurityDescriptor = NULL;

    zero_handles();

    C_save0 = GetStdHandle(STD_INPUT_HANDLE);
    C_save1 = GetStdHandle(STD_OUTPUT_HANDLE);
    if (!CreatePipe(&C_rd0, &C_wr0, &sa, 0)
	    || !SetStdHandle(STD_INPUT_HANDLE, C_rd0)
	    || !DuplicateHandle(GetCurrentProcess(), C_wr0, GetCurrentProcess(),
		&C_wr0_, 0, FALSE, DUPLICATE_SAME_ACCESS)
	    || !CreatePipe(&C_rd1, &C_wr1, &sa, 0)
	    || !SetStdHandle(STD_OUTPUT_HANDLE, C_wr1)
	    || !DuplicateHandle(GetCurrentProcess(), C_rd1, GetCurrentProcess(),
		&C_rd1_, 0, FALSE, DUPLICATE_SAME_ACCESS))
    {
	set_last_errno();
	close_handles();
	return 0;
    }

    CloseHandle(C_wr0);
    C_wr0 = INVALID_HANDLE_VALUE;
    CloseHandle(C_rd1);
    C_rd1 = INVALID_HANDLE_VALUE;
    return 1;
}

static int C_fcall
run_process(char *cmdline)
{
    PROCESS_INFORMATION pi;
    STARTUPINFO si;

    ZeroMemory(&pi, sizeof(PROCESS_INFORMATION));
    ZeroMemory(&si, sizeof(STARTUPINFO));
    si.cb = sizeof(STARTUPINFO);

    C_wr0_ = C_rd1_ = INVALID_HANDLE_VALUE; /* these handles are saved */

    if (CreateProcess(NULL, cmdline, NULL, NULL, TRUE, 0, NULL,
		      NULL, &si, &pi))
    {
	CloseHandle(pi.hThread);

	SetStdHandle(STD_INPUT_HANDLE, C_save0);
	SetStdHandle(STD_OUTPUT_HANDLE, C_save1);
	C_save0 = C_save1 = INVALID_HANDLE_VALUE;

	CloseHandle(C_rd0);
	CloseHandle(C_wr1);
	C_rd0 = C_wr1 = INVALID_HANDLE_VALUE;
	return (int)pi.hProcess;
    }
    else
	return set_last_errno();
}

static int C_fcall
pipe_write(int hpipe, void* buf, int count)
{
    DWORD done = 0;
    if (WriteFile((HANDLE)hpipe, buf, count, &done, NULL))
	return 1;
    else
	return set_last_errno();
}

static int C_fcall
pipe_read(int hpipe)
{
    DWORD done = 0;
    /* TODO:
    if (!pipe_ready(hpipe))
	go_to_sleep;
    */
    if (ReadFile((HANDLE)hpipe, &C_rdbuf, 1, &done, NULL))
    {
	if (done > 0) /* not EOF yet */
	    return 1;
	else
	    return -1;
    }
    return set_last_errno();
}

static int C_fcall
pipe_ready(int hpipe)
{
    DWORD avail = 0;
    if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL) && avail)
	return 1;
    else
    {
	Sleep(0); /* give pipe a chance */
	if (PeekNamedPipe((HANDLE)hpipe, NULL, 0, NULL, &avail, NULL))
	    return (avail > 0);
	else
	    return 0;
    }
}

#define C_zero_handles() C_fix(zero_handles())
#define C_close_handles() C_fix(close_handles())
#define C_redir_io() (redir_io() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_run_process(cmdline) C_fix(run_process(C_c_string(cmdline)))
#define C_pipe_write(h, b, n) (pipe_write(C_unfix(h), C_c_string(b), C_unfix(n)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_pipe_read(h) C_fix(pipe_read(C_unfix(h)))
#define C_pipe_ready(h) (pipe_ready(C_unfix(h)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define close_handle(h) CloseHandle((HANDLE)h)

static int C_fcall
process_wait(int h, int t)
{
    if (WaitForSingleObject((HANDLE)h, (t ? 0 : INFINITE)) == WAIT_OBJECT_0)
    {
	DWORD ret;
	if (GetExitCodeProcess((HANDLE)h, &ret))
	{
	    CloseHandle((HANDLE)h);
	    C_exstatus = ret;
	    return 1;
	}
    }
    return set_last_errno();
}

#define C_process_wait(p, t) (process_wait(C_unfix(p), C_truep(t)) ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sleep(t) (Sleep(C_unfix(t) * 1000), C_SCHEME_UNDEFINED)

static int C_fcall
get_hostname()
{
    /* Do we already have hostname? */
    if (strlen(C_hostname))
    {
	return 1;
    }
    else
    {
	WSADATA wsa;
	if (WSAStartup(MAKEWORD(1, 1), &wsa) == 0)
	{
	    int nok = gethostname(C_hostname, sizeof(C_hostname));
	    WSACleanup();
	    return !nok;
	}
	return 0;
    }
}

static int C_fcall
sysinfo()
{
    /* Do we need to build the sysinfo? */
    if (!strlen(C_osrel))
    {
	OSVERSIONINFO ovf;
	ZeroMemory(&ovf, sizeof(ovf));
	ovf.dwOSVersionInfoSize = sizeof(ovf);
	if (get_hostname() && GetVersionEx(&ovf))
	{
	    SYSTEM_INFO si;
	    _snprintf(C_osver, sizeof(C_osver) - 1, "%d.%d.%d",
			ovf.dwMajorVersion, ovf.dwMinorVersion, ovf.dwBuildNumber);
	    strncpy(C_osrel, "Win", sizeof(C_osrel) - 1);
	    switch (ovf.dwPlatformId)
	    {
	    case VER_PLATFORM_WIN32s:
		strncpy(C_osrel, "Win32s", sizeof(C_osrel) - 1);
		break;
	    case VER_PLATFORM_WIN32_WINDOWS:
		if (ovf.dwMajorVersion == 4)
		{
		    if (ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win95", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 10)
			strncpy(C_osrel, "Win98", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 90)
			strncpy(C_osrel, "WinMe", sizeof(C_osrel) - 1);
		}
		break;
	    case VER_PLATFORM_WIN32_NT:
		C_isNT = 1;
		if (ovf.dwMajorVersion == 6)
		    strncpy(C_osrel, "WinVista", sizeof(C_osrel) - 1);
		else if (ovf.dwMajorVersion == 5)
		{
		    if (ovf.dwMinorVersion == 2)
			strncpy(C_osrel, "WinServer2003", sizeof(C_osrel) - 1);
		    else if (ovf.dwMinorVersion == 1)
			strncpy(C_osrel, "WinXP", sizeof(C_osrel) - 1);
		    else if ( ovf.dwMinorVersion == 0)
			strncpy(C_osrel, "Win2000", sizeof(C_osrel) - 1);
		}
		else if (ovf.dwMajorVersion <= 4)
		   strncpy(C_osrel, "WinNT", sizeof(C_osrel) - 1);
		break;
	    }
	    GetSystemInfo(&si);
	    strncpy(C_processor, "Unknown", sizeof(C_processor) - 1);
	    switch (si.wProcessorArchitecture)
	    {
	    case PROCESSOR_ARCHITECTURE_INTEL:
		strncpy(C_processor, "x86", sizeof(C_processor) - 1);
		break;
#	    ifdef PROCESSOR_ARCHITECTURE_IA64
	    case PROCESSOR_ARCHITECTURE_IA64:
		strncpy(C_processor, "IA64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_AMD64
	    case PROCESSOR_ARCHITECTURE_AMD64:
		strncpy(C_processor, "x64", sizeof(C_processor) - 1);
		break;
#	    endif
#	    ifdef PROCESSOR_ARCHITECTURE_IA32_ON_WIN64
	    case PROCESSOR_ARCHITECTURE_IA32_ON_WIN64:
		strncpy(C_processor, "WOW64", sizeof(C_processor) - 1);
		break;
#	    endif
	    }
	}
	else
	    return set_last_errno();
    }
    return 1;
}

static int C_fcall
get_shlcmd()
{
    /* Do we need to build the shell command pathname? */
    if (!strlen(C_shlcmd))
    {
	if (sysinfo())
	{
	    char *cmdnam = C_isNT ? "\\cmd.exe" : "\\command.com";
	    UINT len = GetSystemDirectory(C_shlcmd, sizeof(C_shlcmd) - strlen(cmdnam));
	    if (len)
		strcpy(C_shlcmd + len, cmdnam);
	    else
		return set_last_errno();
	}
	else
	    return 0;
    }
    return 1;
}

#define C_get_hostname() (get_hostname() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_sysinfo() (sysinfo() ? C_SCHEME_TRUE : C_SCHEME_FALSE)
#define C_get_shlcmd() (get_shlcmd() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* GetUserName */

static int C_fcall
get_user_name()
{
    if (!strlen(C_username))
    {
	DWORD bufCharCount = sizeof(C_username) / sizeof(C_username[0]);
	if (!GetUserName(C_username, &bufCharCount))
	    return set_last_errno();
    }
    return 1;
}

#define C_get_user_name() (get_user_name() ? C_SCHEME_TRUE : C_SCHEME_FALSE)

/* User Information */

#if 0
static int C_fcall
get_netinfo()
{
    HINSTANCE hNet = 0,
	      hLoc = 0;

    if (isNT)
	hNet = LoadLibrary("netapi32.dll");
    else
    {
	hLoc = LoadLibrary("rlocal32.dll");
	hNet = LoadLibrary("radmin32.dll");
	//hNet = LoadLibrary("netapi.dll");
    }

    if (!hNet)
	return 0;

    
}
#endif

/*
    Spawn a process directly.
    Params:
    app		Command to execute.
    cmdlin	Command line (arguments).
    env		Environment for the new process (may be NULL).
    handle, stdin, stdout, stderr
		Spawned process info are returned in integers.
		When spawned process shares standard io stream with the parent
		process the respective value in handle, stdin, stdout, stderr
		is -1.
    params	A bitmask controling operation.
		Bit 1: Child & parent share standard input if this bit is set.
		Bit 2: Share standard output if bit is set.
		Bit 3: Share standard error if bit is set.

    Returns: zero return value indicates failure.
*/
static int C_fcall
C_process(const char * app, const char * cmdlin, const char ** env,
	  int * phandle,
	  int * pstdin_fd, int * pstdout_fd, int * pstderr_fd,
	  int params)
{
    int i;
    int success = TRUE;
    const int f_share_io[3] = { params & 1, params & 2, params & 4};
    int io_fds[3] = { -1, -1, -1 };
    HANDLE
	child_io_handles[3] = { NULL, NULL, NULL },
	standard_io_handles[3] = {
	    GetStdHandle(STD_INPUT_HANDLE),
	    GetStdHandle(STD_OUTPUT_HANDLE),
	    GetStdHandle(STD_ERROR_HANDLE)};
    const char modes[3] = "rww";
    HANDLE cur_process = GetCurrentProcess(), child_process = NULL;
    void* envblk = NULL;

    /****** create io handles & fds ***/

    for (i=0; i<3 && success; ++i)
    {
	if (f_share_io[i])
	{
	    success = DuplicateHandle(
		cur_process, standard_io_handles[i],
		cur_process, &child_io_handles[i],
		0, FALSE, DUPLICATE_SAME_ACCESS);
	}
	else
	{
	    HANDLE a, b;
	    success = CreatePipe(&a,&b,NULL,0);
	    if(success)
	    {
		HANDLE parent_end;
		if (modes[i]=='r') { child_io_handles[i]=a; parent_end=b; }
		else		   { parent_end=a; child_io_handles[i]=b; }
		success = (io_fds[i] = _open_osfhandle((long)parent_end,0)) >= 0;
	    }
	}
    }

    /****** make handles inheritable */

    for (i=0; i<3 && success; ++i)
	success = SetHandleInformation(child_io_handles[i], HANDLE_FLAG_INHERIT, -1);

#if 0 /* Requires a sorted list by key! */
    /****** create environment block if necessary ****/

    if (env && success)
    {
	char** p;
	int len = 0;

	for (p = env; *p; ++p) len += strlen(*p) + 1;

	if (envblk = C_malloc(len + 1))
	{
	    char* pb = (char*)envblk;
	    for (p = env; *p; ++p)
	    {
		strcpy(pb, *p);
		pb += strlen(*p) + 1;
	    }
	    *pb = '\0';
	}
	else
	    success = FALSE;
    }
#endif

    /****** finally spawn process ****/

    if (success)
    {
	PROCESS_INFORMATION pi;
	STARTUPINFO si;

	ZeroMemory(&pi,sizeof pi);
	ZeroMemory(&si,sizeof si);
	si.cb = sizeof si;
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdInput = child_io_handles[0];
	si.hStdOutput = child_io_handles[1];
	si.hStdError = child_io_handles[2];

	/* FIXME passing 'app' param causes failure & possible stack corruption */
	success = CreateProcess(
	    NULL, (char*)cmdlin, NULL, NULL, TRUE, 0, envblk, NULL, &si, &pi);

	if (success)
	{
	    child_process=pi.hProcess;
	    CloseHandle(pi.hThread);
	}
	else
	    set_last_errno();
    }
    else
	set_last_errno();

    /****** cleanup & return *********/

    /* parent must close child end */
    for (i=0; i<3; ++i) CloseHandle(child_io_handles[i]);

    if (success)
    {
	*phandle = (int)child_process;
	*pstdin_fd = io_fds[0];
	*pstdout_fd = io_fds[1];
	*pstderr_fd = io_fds[2];
    }
    else
    {
	for (i=0; i<3; ++i) _close(io_fds[i]);
    }

    return success;
}

static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_files_toplevel)
C_externimport void C_ccall C_files_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_ports_toplevel)
C_externimport void C_ccall C_ports_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[397];
static double C_possibly_force_alignment;


/* from k5430 */
static C_word C_fcall stub1542(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7) C_regparm;
C_regparm static C_word C_fcall stub1542(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5,C_word C_a6,C_word C_a7){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
void * t2=(void * )C_c_pointer_or_null(C_a2);
int *t3=(int *)C_c_pointer_or_null(C_a3);
int *t4=(int *)C_c_pointer_or_null(C_a4);
int *t5=(int *)C_c_pointer_or_null(C_a5);
int *t6=(int *)C_c_pointer_or_null(C_a6);
int t7=(int )C_unfix(C_a7);
C_r=C_mk_bool(C_process(t0,t1,t2,t3,t4,t5,t6,t7));
return C_r;}

/* from current-process-id in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static C_word C_fcall stub1502(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1502(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from k5075 */
static C_word C_fcall stub1327(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1327(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from k5069 */
static C_word C_fcall stub1315(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub1315(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from ex0 */
static C_word C_fcall stub1153(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1153(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
static C_word C_fcall stub1145(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub1145(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char *z = (_daylight ? _tzname[1] : _tzname[0]);
return(z);
C_ret:
#undef return

return C_r;}

/* from strftime */
static C_word C_fcall stub1102(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub1102(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1));
return C_r;}

/* from asctime */
static C_word C_fcall stub1094(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1094(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from ctime */
static C_word C_fcall stub1079(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1079(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from get */
static C_word C_fcall stub1035(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1035(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from strerror */
static C_word C_fcall stub23(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub23(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2641)
static void C_ccall f_2641(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2644)
static void C_ccall f_2644(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2647)
static void C_ccall f_2647(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2650)
static void C_ccall f_2650(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2653)
static void C_ccall f_2653(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2656)
static void C_ccall f_2656(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2659)
static void C_ccall f_2659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3033)
static void C_ccall f_3033(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3037)
static void C_ccall f_3037(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3041)
static void C_ccall f_3041(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3045)
static void C_ccall f_3045(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3049)
static void C_ccall f_3049(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3053)
static void C_ccall f_3053(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3057)
static void C_ccall f_3057(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3061)
static void C_ccall f_3061(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3065)
static void C_ccall f_3065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3069)
static void C_ccall f_3069(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6394)
static void C_ccall f_6394(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6413)
static void C_ccall f_6413(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6398)
static void C_ccall f_6398(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6407)
static void C_ccall f_6407(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6401)
static void C_ccall f_6401(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3134)
static void C_ccall f_3134(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4235)
static void C_ccall f_4235(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6375)
static void C_ccall f_6375(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6372)
static void C_ccall f_6372(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6365)
static void C_ccall f_6365(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6359)
static void C_ccall f_6359(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6353)
static void C_ccall f_6353(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6347)
static void C_ccall f_6347(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6341)
static void C_ccall f_6341(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6335)
static void C_ccall f_6335(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6329)
static void C_ccall f_6329(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6323)
static void C_ccall f_6323(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6317)
static void C_ccall f_6317(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6311)
static void C_ccall f_6311(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6305)
static void C_ccall f_6305(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6299)
static void C_ccall f_6299(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6293)
static void C_ccall f_6293(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6287)
static void C_ccall f_6287(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6281)
static void C_ccall f_6281(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6275)
static void C_ccall f_6275(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6269)
static void C_ccall f_6269(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6263)
static void C_ccall f_6263(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6257)
static void C_ccall f_6257(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6251)
static void C_ccall f_6251(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6245)
static void C_ccall f_6245(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6239)
static void C_ccall f_6239(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6233)
static void C_ccall f_6233(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6227)
static void C_ccall f_6227(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6221)
static void C_ccall f_6221(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6215)
static void C_ccall f_6215(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6209)
static void C_ccall f_6209(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6203)
static void C_ccall f_6203(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6197)
static void C_ccall f_6197(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6191)
static void C_ccall f_6191(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6185)
static void C_ccall f_6185(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6179)
static void C_ccall f_6179(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6173)
static void C_ccall f_6173(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6167)
static void C_ccall f_6167(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6161)
static void C_ccall f_6161(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6155)
static void C_ccall f_6155(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6149)
static void C_ccall f_6149(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6143)
static void C_ccall f_6143(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6137)
static void C_ccall f_6137(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6131)
static void C_ccall f_6131(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6125)
static void C_ccall f_6125(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6119)
static void C_ccall f_6119(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6113)
static void C_ccall f_6113(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5896)
static void C_ccall f_5896(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5896)
static void C_ccall f_5896r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_6047)
static void C_fcall f_6047(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6053)
static void C_ccall f_6053(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6042)
static void C_fcall f_6042(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6037)
static void C_fcall f_6037(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5898)
static void C_fcall f_5898(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6024)
static void C_ccall f_6024(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6032)
static void C_ccall f_6032(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5905)
static void C_fcall f_5905(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6012)
static void C_ccall f_6012(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5915)
static void C_ccall f_5915(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5917)
static void C_fcall f_5917(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5936)
static void C_ccall f_5936(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5998)
static void C_ccall f_5998(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6005)
static void C_ccall f_6005(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5992)
static void C_ccall f_5992(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5951)
static void C_ccall f_5951(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5982)
static void C_ccall f_5982(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5968)
static void C_ccall f_5968(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5980)
static void C_ccall f_5980(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5976)
static void C_ccall f_5976(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5963)
static void C_ccall f_5963(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5961)
static void C_ccall f_5961(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6016)
static void C_ccall f_6016(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5881)
static void C_ccall f_5881(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5891)
static void C_ccall f_5891(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5850)
static void C_ccall f_5850(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5876)
static void C_ccall f_5876(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5861)
static void C_ccall f_5861(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5865)
static void C_ccall f_5865(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5869)
static void C_ccall f_5869(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5873)
static void C_ccall f_5873(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5838)
static void C_ccall f_5838(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5835)
static void C_ccall f_5835(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5778)
static void C_ccall f_5778(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5778)
static void C_ccall f_5778r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5802)
static void C_ccall f_5802(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5812)
static void C_ccall f_5812(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5796)
static void C_ccall f_5796(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5766)
static void C_ccall f_5766(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5689)
static void C_ccall f_5689(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5689)
static void C_ccall f_5689r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5706)
static void C_fcall f_5706(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5701)
static void C_fcall f_5701(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5696)
static void C_fcall f_5696(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5691)
static void C_fcall f_5691(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5612)
static void C_ccall f_5612(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5612)
static void C_ccall f_5612r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5629)
static void C_fcall f_5629(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5624)
static void C_fcall f_5624(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5619)
static void C_fcall f_5619(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5614)
static void C_fcall f_5614(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5550)
static void C_fcall f_5550(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_5606)
static void C_ccall f_5606(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5610)
static void C_ccall f_5610(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5571)
static void C_ccall f_5571(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5574)
static void C_ccall f_5574(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5585)
static void C_ccall f_5585(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_5579)
static void C_ccall f_5579(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5552)
static void C_fcall f_5552(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5561)
static void C_ccall f_5561(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5454)
static void C_ccall f_5454(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...) C_noret;
C_noret_decl(f_5454)
static void C_ccall f_5454r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t10) C_noret;
C_noret_decl(f_5533)
static void C_ccall f_5533(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5461)
static void C_ccall f_5461(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5501)
static void C_ccall f_5501(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5505)
static void C_ccall f_5505(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5509)
static void C_ccall f_5509(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5513)
static void C_ccall f_5513(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5517)
static void C_ccall f_5517(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5408)
static void C_ccall f_5408(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5412)
static void C_ccall f_5412(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5494)
static void C_ccall f_5494(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5474)
static void C_ccall f_5474(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5478)
static void C_ccall f_5478(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5482)
static void C_ccall f_5482(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5374)
static void C_ccall f_5374(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5374)
static void C_ccall f_5374r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5391)
static void C_ccall f_5391(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5395)
static void C_ccall f_5395(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5368)
static void C_ccall f_5368(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5347)
static void C_ccall f_5347(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5351)
static void C_ccall f_5351(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5363)
static void C_ccall f_5363(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5344)
static void C_ccall f_5344(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5260)
static void C_ccall f_5260(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5260)
static void C_ccall f_5260r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_5284)
static void C_fcall f_5284(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5279)
static void C_fcall f_5279(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5274)
static void C_fcall f_5274(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5262)
static void C_fcall f_5262(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5266)
static void C_ccall f_5266(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5176)
static void C_ccall f_5176(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5176)
static void C_ccall f_5176r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5200)
static void C_fcall f_5200(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5195)
static void C_fcall f_5195(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5190)
static void C_fcall f_5190(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5178)
static void C_fcall f_5178(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5182)
static void C_ccall f_5182(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5161)
static void C_fcall f_5161(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5165)
static void C_ccall f_5165(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5128)
static void C_fcall f_5128(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_5135)
static void C_ccall f_5135(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5138)
static void C_ccall f_5138(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5155)
static void C_ccall f_5155(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5141)
static void C_ccall f_5141(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5144)
static void C_ccall f_5144(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5151)
static void C_ccall f_5151(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5078)
static void C_fcall f_5078(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5090)
static void C_fcall f_5090(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5109)
static void C_ccall f_5109(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5072)
static void C_ccall f_5072(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5066)
static void C_ccall f_5066(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4987)
static void C_fcall f_4987(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5030)
static void C_fcall f_5030(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5061)
static void C_ccall f_5061(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5058)
static void C_ccall f_5058(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4992)
static void C_fcall f_4992(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4996)
static void C_ccall f_4996(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5001)
static void C_fcall f_5001(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5025)
static void C_ccall f_5025(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5014)
static void C_ccall f_5014(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4875)
static void C_ccall f_4875(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4875)
static void C_ccall f_4875r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4881)
static void C_fcall f_4881(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4902)
static void C_ccall f_4902(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4976)
static void C_ccall f_4976(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4906)
static void C_ccall f_4906(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4909)
static void C_ccall f_4909(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4916)
static void C_ccall f_4916(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4918)
static void C_fcall f_4918(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4935)
static void C_ccall f_4935(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4945)
static void C_ccall f_4945(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4949)
static void C_ccall f_4949(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4896)
static void C_ccall f_4896(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4816)
static void C_ccall f_4816(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4816)
static void C_ccall f_4816r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4820)
static void C_ccall f_4820(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4826)
static void C_ccall f_4826(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4810)
static void C_ccall f_4810(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4814)
static void C_ccall f_4814(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4794)
static void C_ccall f_4794(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4794)
static void C_ccall f_4794r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4786)
static void C_ccall f_4786(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4771)
static void C_ccall f_4771(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4775)
static void C_ccall f_4775(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4711)
static void C_ccall f_4711(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4711)
static void C_ccall f_4711r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4718)
static void C_ccall f_4718(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4740)
static void C_ccall f_4740(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4737)
static void C_ccall f_4737(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4727)
static void C_ccall f_4727(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4678)
static void C_ccall f_4678(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4682)
static void C_ccall f_4682(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4664)
static void C_ccall f_4664(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4655)
static void C_ccall f_4655(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4636)
static void C_fcall f_4636(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4570)
static void C_ccall f_4570(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4576)
static void C_fcall f_4576(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4580)
static void C_ccall f_4580(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4588)
static void C_fcall f_4588(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4614)
static void C_ccall f_4614(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4618)
static void C_ccall f_4618(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4606)
static void C_ccall f_4606(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4555)
static void C_ccall f_4555(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4563)
static void C_ccall f_4563(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4538)
static void C_ccall f_4538(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4549)
static void C_ccall f_4549(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4553)
static void C_ccall f_4553(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4508)
static void C_ccall f_4508(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4508)
static void C_ccall f_4508r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4515)
static void C_fcall f_4515(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4524)
static void C_ccall f_4524(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4518)
static void C_ccall f_4518(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4473)
static void C_ccall f_4473(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4477)
static void C_ccall f_4477(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4506)
static void C_ccall f_4506(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4492)
static void C_ccall f_4492(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4486)
static void C_ccall f_4486(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4459)
static void C_ccall f_4459(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4459)
static void C_ccall f_4459r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4471)
static void C_ccall f_4471(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4445)
static void C_ccall f_4445(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4445)
static void C_ccall f_4445r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4457)
static void C_ccall f_4457(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4427)
static void C_fcall f_4427(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4431)
static void C_ccall f_4431(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4443)
static void C_ccall f_4443(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4390)
static void C_fcall f_4390(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4398)
static void C_ccall f_4398(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4381)
static void C_ccall f_4381(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4375)
static void C_ccall f_4375(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4369)
static void C_ccall f_4369(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4345)
static void C_fcall f_4345(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4367)
static void C_ccall f_4367(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4363)
static void C_ccall f_4363(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4355)
static void C_ccall f_4355(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4315)
static void C_ccall f_4315(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4343)
static void C_ccall f_4343(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4339)
static void C_ccall f_4339(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4331)
static void C_ccall f_4331(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4259)
static void C_ccall f_4259(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4269)
static void C_ccall f_4269(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4246)
static void C_ccall f_4246(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4237)
static void C_ccall f_4237(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4168)
static void C_ccall f_4168(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4168)
static void C_ccall f_4168r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4184)
static void C_ccall f_4184(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4175)
static void C_ccall f_4175(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4148)
static void C_ccall f_4148(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4148)
static void C_ccall f_4148r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4152)
static void C_ccall f_4152(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4158)
static void C_ccall f_4158(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4158)
static void C_ccall f_4158r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4162)
static void C_ccall f_4162(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4128)
static void C_ccall f_4128(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4128)
static void C_ccall f_4128r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4132)
static void C_ccall f_4132(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4138)
static void C_ccall f_4138(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4138)
static void C_ccall f_4138r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4142)
static void C_ccall f_4142(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4104)
static void C_ccall f_4104(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4104)
static void C_ccall f_4104r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4108)
static void C_ccall f_4108(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4119)
static void C_ccall f_4119(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4119)
static void C_ccall f_4119r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4123)
static void C_ccall f_4123(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4113)
static void C_ccall f_4113(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4080)
static void C_ccall f_4080(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4080)
static void C_ccall f_4080r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4084)
static void C_ccall f_4084(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4095)
static void C_ccall f_4095(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4095)
static void C_ccall f_4095r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4099)
static void C_ccall f_4099(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4089)
static void C_ccall f_4089(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4061)
static void C_ccall f_4061(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4065)
static void C_ccall f_4065(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4068)
static void C_ccall f_4068(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4025)
static void C_ccall f_4025(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4025)
static void C_ccall f_4025r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4056)
static void C_ccall f_4056(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4046)
static void C_ccall f_4046(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4039)
static void C_ccall f_4039(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3989)
static void C_ccall f_3989(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3989)
static void C_ccall f_3989r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4020)
static void C_ccall f_4020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4010)
static void C_ccall f_4010(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4003)
static void C_ccall f_4003(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3971)
static void C_fcall f_3971(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3975)
static void C_ccall f_3975(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3987)
static void C_ccall f_3987(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3965)
static void C_fcall f_3965(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3953)
static C_word C_fcall f_3953(C_word t0);
C_noret_decl(f_3596)
static void C_ccall f_3596(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3943)
static void C_ccall f_3943(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3742)
static void C_fcall f_3742(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3929)
static void C_ccall f_3929(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3918)
static void C_ccall f_3918(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3925)
static void C_ccall f_3925(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3772)
static void C_fcall f_3772(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3911)
static void C_ccall f_3911(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3890)
static void C_ccall f_3890(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3907)
static void C_ccall f_3907(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3896)
static void C_ccall f_3896(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3903)
static void C_ccall f_3903(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3814)
static void C_fcall f_3814(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3887)
static void C_ccall f_3887(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3866)
static void C_ccall f_3866(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3883)
static void C_ccall f_3883(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3872)
static void C_ccall f_3872(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3879)
static void C_ccall f_3879(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3820)
static void C_ccall f_3820(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3863)
static void C_ccall f_3863(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3859)
static void C_ccall f_3859(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3852)
static void C_ccall f_3852(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3848)
static void C_ccall f_3848(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3827)
static void C_ccall f_3827(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3831)
static void C_ccall f_3831(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3808)
static void C_ccall f_3808(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3795)
static void C_ccall f_3795(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3779)
static void C_ccall f_3779(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3783)
static void C_ccall f_3783(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3787)
static void C_ccall f_3787(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3766)
static void C_ccall f_3766(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3753)
static void C_ccall f_3753(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3749)
static void C_ccall f_3749(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3736)
static void C_ccall f_3736(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3603)
static void C_ccall f_3603(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3722)
static void C_ccall f_3722(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3610)
static void C_ccall f_3610(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3612)
static void C_fcall f_3612(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3619)
static void C_ccall f_3619(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3694)
static void C_ccall f_3694(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3703)
static void C_ccall f_3703(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3691)
static void C_fcall f_3691(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3625)
static void C_ccall f_3625(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3672)
static void C_ccall f_3672(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3660)
static void C_ccall f_3660(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3668)
static void C_ccall f_3668(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3664)
static void C_ccall f_3664(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3641)
static void C_ccall f_3641(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3649)
static void C_ccall f_3649(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3645)
static void C_ccall f_3645(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3540)
static void C_fcall f_3540(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3549)
static void C_ccall f_3549(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3573)
static void C_ccall f_3573(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3585)
static void C_ccall f_3585(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3585)
static void C_ccall f_3585r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3591)
static void C_ccall f_3591(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3579)
static void C_ccall f_3579(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3555)
static void C_ccall f_3555(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3561)
static void C_ccall f_3561(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3547)
static void C_ccall f_3547(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3529)
static C_word C_fcall f_3529(C_word t0);
C_noret_decl(f_3524)
static void C_fcall f_3524(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3480)
static void C_ccall f_3480(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3480)
static void C_ccall f_3480r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3493)
static void C_ccall f_3493(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3496)
static void C_ccall f_3496(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3453)
static void C_ccall f_3453(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3478)
static void C_ccall f_3478(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3474)
static void C_ccall f_3474(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3460)
static void C_ccall f_3460(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3296)
static void C_ccall f_3296(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_3296)
static void C_ccall f_3296r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_3404)
static void C_fcall f_3404(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3412)
static void C_ccall f_3412(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3399)
static void C_fcall f_3399(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3298)
static void C_fcall f_3298(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3305)
static void C_ccall f_3305(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3308)
static void C_ccall f_3308(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3311)
static void C_ccall f_3311(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3398)
static void C_ccall f_3398(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3315)
static void C_ccall f_3315(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3332)
static void C_fcall f_3332(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3342)
static void C_ccall f_3342(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3354)
static void C_fcall f_3354(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3364)
static void C_ccall f_3364(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3324)
static void C_ccall f_3324(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3269)
static void C_ccall f_3269(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3294)
static void C_ccall f_3294(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3290)
static void C_ccall f_3290(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3282)
static void C_ccall f_3282(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3242)
static void C_ccall f_3242(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3267)
static void C_ccall f_3267(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3263)
static void C_ccall f_3263(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3255)
static void C_ccall f_3255(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3136)
static void C_ccall f_3136(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3136)
static void C_ccall f_3136r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3211)
static void C_ccall f_3211(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3228)
static void C_ccall f_3228(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3220)
static void C_ccall f_3220(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3149)
static void C_ccall f_3149(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3152)
static void C_ccall f_3152(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3160)
static void C_ccall f_3160(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3165)
static void C_ccall f_3165(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3191)
static void C_ccall f_3191(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3194)
static void C_ccall f_3194(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3171)
static void C_fcall f_3171(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3188)
static void C_ccall f_3188(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3180)
static void C_ccall f_3180(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3071)
static void C_ccall f_3071(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_3071)
static void C_ccall f_3071r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_3084)
static void C_ccall f_3084(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3099)
static void C_ccall f_3099(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3090)
static void C_ccall f_3090(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3093)
static void C_ccall f_3093(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3022)
static void C_fcall f_3022(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3024)
static void C_ccall f_3024(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3017)
static void C_ccall f_3017(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2994)
static void C_ccall f_2994(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3015)
static void C_ccall f_3015(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3001)
static void C_ccall f_3001(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2988)
static void C_ccall f_2988(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2992)
static void C_ccall f_2992(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2982)
static void C_ccall f_2982(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2986)
static void C_ccall f_2986(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2976)
static void C_ccall f_2976(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2980)
static void C_ccall f_2980(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2970)
static void C_ccall f_2970(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2974)
static void C_ccall f_2974(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2964)
static void C_ccall f_2964(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2968)
static void C_ccall f_2968(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2958)
static void C_ccall f_2958(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2962)
static void C_ccall f_2962(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2934)
static void C_ccall f_2934(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2934)
static void C_ccall f_2934r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2941)
static void C_ccall f_2941(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2896)
static void C_fcall f_2896(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2929)
static void C_ccall f_2929(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2925)
static void C_ccall f_2925(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2900)
static void C_ccall f_2900(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2909)
static void C_ccall f_2909(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2858)
static void C_ccall f_2858(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2865)
static void C_ccall f_2865(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2868)
static void C_ccall f_2868(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2888)
static void C_ccall f_2888(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2871)
static void C_ccall f_2871(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2878)
static void C_ccall f_2878(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2816)
static void C_ccall f_2816(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2816)
static void C_ccall f_2816r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2823)
static void C_ccall f_2823(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2838)
static void C_ccall f_2838(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2832)
static void C_ccall f_2832(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2771)
static void C_ccall f_2771(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2771)
static void C_ccall f_2771r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2781)
static void C_ccall f_2781(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2784)
static void C_ccall f_2784(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2796)
static void C_ccall f_2796(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2787)
static void C_ccall f_2787(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2753)
static void C_ccall f_2753(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2766)
static void C_ccall f_2766(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2712)
static void C_ccall f_2712(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2712)
static void C_ccall f_2712r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2745)
static void C_ccall f_2745(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2729)
static void C_ccall f_2729(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2738)
static void C_ccall f_2738(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2732)
static void C_ccall f_2732(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2666)
static void C_ccall f_2666(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_2666)
static void C_ccall f_2666r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_2670)
static void C_ccall f_2670(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2681)
static void C_ccall f_2681(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2677)
static void C_ccall f_2677(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_6047)
static void C_fcall trf_6047(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6047(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6047(t0,t1);}

C_noret_decl(trf_6042)
static void C_fcall trf_6042(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6042(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6042(t0,t1,t2);}

C_noret_decl(trf_6037)
static void C_fcall trf_6037(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6037(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6037(t0,t1,t2,t3);}

C_noret_decl(trf_5898)
static void C_fcall trf_5898(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5898(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5898(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5905)
static void C_fcall trf_5905(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5905(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5905(t0,t1);}

C_noret_decl(trf_5917)
static void C_fcall trf_5917(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5917(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5917(t0,t1,t2,t3);}

C_noret_decl(trf_5706)
static void C_fcall trf_5706(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5706(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5706(t0,t1);}

C_noret_decl(trf_5701)
static void C_fcall trf_5701(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5701(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5701(t0,t1,t2);}

C_noret_decl(trf_5696)
static void C_fcall trf_5696(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5696(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5696(t0,t1,t2,t3);}

C_noret_decl(trf_5691)
static void C_fcall trf_5691(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5691(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5691(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5629)
static void C_fcall trf_5629(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5629(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5629(t0,t1);}

C_noret_decl(trf_5624)
static void C_fcall trf_5624(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5624(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5624(t0,t1,t2);}

C_noret_decl(trf_5619)
static void C_fcall trf_5619(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5619(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5619(t0,t1,t2,t3);}

C_noret_decl(trf_5614)
static void C_fcall trf_5614(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5614(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5614(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5550)
static void C_fcall trf_5550(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5550(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_5550(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_5552)
static void C_fcall trf_5552(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5552(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5552(t0,t1,t2);}

C_noret_decl(trf_5284)
static void C_fcall trf_5284(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5284(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5284(t0,t1);}

C_noret_decl(trf_5279)
static void C_fcall trf_5279(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5279(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5279(t0,t1,t2);}

C_noret_decl(trf_5274)
static void C_fcall trf_5274(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5274(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5274(t0,t1,t2,t3);}

C_noret_decl(trf_5262)
static void C_fcall trf_5262(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5262(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5262(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5200)
static void C_fcall trf_5200(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5200(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5200(t0,t1);}

C_noret_decl(trf_5195)
static void C_fcall trf_5195(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5195(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5195(t0,t1,t2);}

C_noret_decl(trf_5190)
static void C_fcall trf_5190(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5190(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5190(t0,t1,t2,t3);}

C_noret_decl(trf_5178)
static void C_fcall trf_5178(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5178(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5178(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5161)
static void C_fcall trf_5161(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5161(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5161(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5128)
static void C_fcall trf_5128(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5128(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_5128(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_5078)
static void C_fcall trf_5078(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5078(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5078(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5090)
static void C_fcall trf_5090(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5090(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5090(t0,t1,t2,t3);}

C_noret_decl(trf_4987)
static void C_fcall trf_4987(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4987(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4987(t0,t1,t2,t3);}

C_noret_decl(trf_5030)
static void C_fcall trf_5030(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5030(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5030(t0,t1,t2,t3);}

C_noret_decl(trf_4992)
static void C_fcall trf_4992(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4992(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4992(t0,t1,t2);}

C_noret_decl(trf_5001)
static void C_fcall trf_5001(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5001(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5001(t0,t1,t2);}

C_noret_decl(trf_4881)
static void C_fcall trf_4881(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4881(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4881(t0,t1,t2);}

C_noret_decl(trf_4918)
static void C_fcall trf_4918(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4918(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4918(t0,t1,t2);}

C_noret_decl(trf_4636)
static void C_fcall trf_4636(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4636(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4636(t0,t1,t2);}

C_noret_decl(trf_4576)
static void C_fcall trf_4576(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4576(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4576(t0,t1,t2);}

C_noret_decl(trf_4588)
static void C_fcall trf_4588(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4588(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4588(t0,t1,t2);}

C_noret_decl(trf_4515)
static void C_fcall trf_4515(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4515(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4515(t0,t1);}

C_noret_decl(trf_4427)
static void C_fcall trf_4427(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4427(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4427(t0,t1,t2,t3);}

C_noret_decl(trf_4390)
static void C_fcall trf_4390(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4390(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4390(t0,t1,t2);}

C_noret_decl(trf_4345)
static void C_fcall trf_4345(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4345(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4345(t0,t1,t2,t3);}

C_noret_decl(trf_3971)
static void C_fcall trf_3971(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3971(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3971(t0,t1,t2,t3);}

C_noret_decl(trf_3965)
static void C_fcall trf_3965(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3965(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3965(t0,t1);}

C_noret_decl(trf_3742)
static void C_fcall trf_3742(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3742(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3742(t0,t1);}

C_noret_decl(trf_3772)
static void C_fcall trf_3772(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3772(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3772(t0,t1);}

C_noret_decl(trf_3814)
static void C_fcall trf_3814(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3814(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3814(t0,t1);}

C_noret_decl(trf_3612)
static void C_fcall trf_3612(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3612(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3612(t0,t1,t2,t3);}

C_noret_decl(trf_3691)
static void C_fcall trf_3691(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3691(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3691(t0,t1);}

C_noret_decl(trf_3540)
static void C_fcall trf_3540(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3540(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3540(t0,t1);}

C_noret_decl(trf_3524)
static void C_fcall trf_3524(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3524(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3524(t0,t1);}

C_noret_decl(trf_3404)
static void C_fcall trf_3404(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3404(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3404(t0,t1);}

C_noret_decl(trf_3399)
static void C_fcall trf_3399(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3399(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3399(t0,t1,t2);}

C_noret_decl(trf_3298)
static void C_fcall trf_3298(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3298(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3298(t0,t1,t2,t3);}

C_noret_decl(trf_3332)
static void C_fcall trf_3332(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3332(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3332(t0,t1);}

C_noret_decl(trf_3354)
static void C_fcall trf_3354(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3354(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3354(t0,t1);}

C_noret_decl(trf_3171)
static void C_fcall trf_3171(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3171(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3171(t0,t1);}

C_noret_decl(trf_3022)
static void C_fcall trf_3022(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3022(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3022(t0,t1);}

C_noret_decl(trf_2896)
static void C_fcall trf_2896(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2896(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2896(t0,t1);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr9rv)
static void C_fcall tr9rv(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9rv(C_proc9 k){
int n;
C_word *a,t9;
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
n=C_rest_count(0);
a=C_alloc(n+1);
t9=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3130)){
C_save(t1);
C_rereclaim2(3130*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,397);
lf[1]=C_decode_literal(C_heaptop,"\376B\000\000/this function is not available on this platform");
lf[2]=C_h_intern(&lf[2],13,"string-append");
lf[4]=C_h_intern(&lf[4],15,"\003syssignal-hook");
lf[5]=C_decode_literal(C_heaptop,"\376B\000\000\003 - ");
lf[6]=C_h_intern(&lf[6],17,"\003syspeek-c-string");
lf[7]=C_h_intern(&lf[7],16,"\003sysupdate-errno");
lf[8]=C_h_intern(&lf[8],15,"\003sysposix-error");
lf[9]=C_h_intern(&lf[9],8,"pipe/buf");
lf[10]=C_h_intern(&lf[10],11,"open/rdonly");
lf[11]=C_h_intern(&lf[11],11,"open/wronly");
lf[12]=C_h_intern(&lf[12],9,"open/rdwr");
lf[13]=C_h_intern(&lf[13],9,"open/read");
lf[14]=C_h_intern(&lf[14],10,"open/write");
lf[15]=C_h_intern(&lf[15],10,"open/creat");
lf[16]=C_h_intern(&lf[16],11,"open/append");
lf[17]=C_h_intern(&lf[17],9,"open/excl");
lf[18]=C_h_intern(&lf[18],10,"open/trunc");
lf[19]=C_h_intern(&lf[19],11,"open/binary");
lf[20]=C_h_intern(&lf[20],9,"open/text");
lf[21]=C_h_intern(&lf[21],14,"open/noinherit");
lf[22]=C_h_intern(&lf[22],10,"perm/irusr");
lf[23]=C_h_intern(&lf[23],10,"perm/iwusr");
lf[24]=C_h_intern(&lf[24],10,"perm/ixusr");
lf[25]=C_h_intern(&lf[25],10,"perm/irgrp");
lf[26]=C_h_intern(&lf[26],10,"perm/iwgrp");
lf[27]=C_h_intern(&lf[27],10,"perm/ixgrp");
lf[28]=C_h_intern(&lf[28],10,"perm/iroth");
lf[29]=C_h_intern(&lf[29],10,"perm/iwoth");
lf[30]=C_h_intern(&lf[30],10,"perm/ixoth");
lf[31]=C_h_intern(&lf[31],10,"perm/irwxu");
lf[32]=C_h_intern(&lf[32],10,"perm/irwxg");
lf[33]=C_h_intern(&lf[33],10,"perm/irwxo");
lf[34]=C_h_intern(&lf[34],9,"file-open");
lf[35]=C_h_intern(&lf[35],11,"\000file-error");
lf[36]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[37]=C_h_intern(&lf[37],17,"\003sysmake-c-string");
lf[38]=C_h_intern(&lf[38],20,"\003sysexpand-home-path");
lf[39]=C_h_intern(&lf[39],10,"file-close");
lf[40]=C_decode_literal(C_heaptop,"\376B\000\000\021cannot close file");
lf[41]=C_h_intern(&lf[41],11,"make-string");
lf[42]=C_h_intern(&lf[42],9,"file-read");
lf[43]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot read from file");
lf[44]=C_h_intern(&lf[44],11,"\000type-error");
lf[45]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[46]=C_h_intern(&lf[46],10,"file-write");
lf[47]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot write to file");
lf[48]=C_decode_literal(C_heaptop,"\376B\000\000(bad argument type - not a string or blob");
lf[49]=C_h_intern(&lf[49],13,"string-length");
lf[50]=C_h_intern(&lf[50],12,"file-mkstemp");
lf[51]=C_h_intern(&lf[51],13,"\003syssubstring");
lf[52]=C_decode_literal(C_heaptop,"\376B\000\000\034cannot create temporary file");
lf[53]=C_h_intern(&lf[53],8,"seek/set");
lf[54]=C_h_intern(&lf[54],8,"seek/end");
lf[55]=C_h_intern(&lf[55],8,"seek/cur");
lf[57]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot access file");
lf[58]=C_decode_literal(C_heaptop,"\376B\000\000*bad argument type - not a fixnum or string");
lf[59]=C_h_intern(&lf[59],9,"file-stat");
lf[60]=C_h_intern(&lf[60],9,"file-size");
lf[61]=C_h_intern(&lf[61],22,"file-modification-time");
lf[62]=C_h_intern(&lf[62],16,"file-access-time");
lf[63]=C_h_intern(&lf[63],16,"file-change-time");
lf[64]=C_h_intern(&lf[64],10,"file-owner");
lf[65]=C_h_intern(&lf[65],16,"file-permissions");
lf[66]=C_h_intern(&lf[66],13,"regular-file\077");
lf[67]=C_h_intern(&lf[67],13,"\003sysfile-info");
lf[68]=C_h_intern(&lf[68],14,"symbolic-link\077");
lf[69]=C_h_intern(&lf[69],13,"stat-regular\077");
lf[70]=C_h_intern(&lf[70],15,"stat-directory\077");
lf[71]=C_h_intern(&lf[71],12,"stat-device\077");
lf[72]=C_h_intern(&lf[72],17,"character-device\077");
lf[73]=C_h_intern(&lf[73],13,"block-device\077");
lf[74]=C_h_intern(&lf[74],18,"stat-block-device\077");
lf[75]=C_h_intern(&lf[75],10,"stat-fifo\077");
lf[76]=C_h_intern(&lf[76],5,"fifo\077");
lf[77]=C_h_intern(&lf[77],13,"stat-symlink\077");
lf[78]=C_h_intern(&lf[78],7,"socket\077");
lf[79]=C_h_intern(&lf[79],12,"stat-socket\077");
lf[80]=C_h_intern(&lf[80],18,"set-file-position!");
lf[81]=C_decode_literal(C_heaptop,"\376B\000\000\030cannot set file position");
lf[82]=C_h_intern(&lf[82],6,"stream");
lf[83]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[84]=C_h_intern(&lf[84],5,"port\077");
lf[85]=C_h_intern(&lf[85],13,"\000bounds-error");
lf[86]=C_decode_literal(C_heaptop,"\376B\000\000\036invalid negative port position");
lf[87]=C_h_intern(&lf[87],13,"file-position");
lf[88]=C_h_intern(&lf[88],16,"create-directory");
lf[89]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot create directory");
lf[90]=C_h_intern(&lf[90],12,"file-exists\077");
lf[91]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[92]=C_h_intern(&lf[92],12,"\003sysfor-each");
lf[93]=C_h_intern(&lf[93],12,"string-split");
lf[94]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[95]=C_h_intern(&lf[95],14,"canonical-path");
lf[96]=C_h_intern(&lf[96],16,"change-directory");
lf[97]=C_decode_literal(C_heaptop,"\376B\000\000\037cannot change current directory");
lf[98]=C_h_intern(&lf[98],16,"delete-directory");
lf[99]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot delete directory");
lf[100]=C_h_intern(&lf[100],6,"string");
lf[101]=C_h_intern(&lf[101],9,"directory");
lf[102]=C_decode_literal(C_heaptop,"\376B\000\000\025cannot open directory");
lf[103]=C_h_intern(&lf[103],16,"\003sysmake-pointer");
lf[104]=C_h_intern(&lf[104],17,"current-directory");
lf[105]=C_h_intern(&lf[105],10,"directory\077");
lf[106]=C_h_intern(&lf[106],27,"\003sysplatform-fixup-pathname");
lf[107]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current directory");
lf[108]=C_h_intern(&lf[108],5,"null\077");
lf[109]=C_h_intern(&lf[109],6,"char=\077");
lf[110]=C_h_intern(&lf[110],8,"string=\077");
lf[111]=C_h_intern(&lf[111],16,"char-alphabetic\077");
lf[112]=C_h_intern(&lf[112],10,"string-ref");
lf[113]=C_h_intern(&lf[113],18,"string-intersperse");
lf[114]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[115]=C_h_intern(&lf[115],17,"current-user-name");
lf[116]=C_h_intern(&lf[116],9,"condition");
lf[117]=C_decode_literal(C_heaptop,"\376B\000\000\003c:\134");
lf[118]=C_h_intern(&lf[118],22,"with-exception-handler");
lf[119]=C_h_intern(&lf[119],30,"call-with-current-continuation");
lf[120]=C_decode_literal(C_heaptop,"\376B\000\000\000");
lf[121]=C_h_intern(&lf[121],7,"reverse");
lf[122]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[123]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[124]=C_decode_literal(C_heaptop,"\376B\000\000\002/\134");
lf[125]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[126]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[127]=C_decode_literal(C_heaptop,"\376B\000\000\027Documents and Settings\134");
lf[128]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[129]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[130]=C_decode_literal(C_heaptop,"\376B\000\000\001\134");
lf[131]=C_h_intern(&lf[131],5,"\000text");
lf[132]=C_h_intern(&lf[132],9,"\003syserror");
lf[133]=C_decode_literal(C_heaptop,"\376B\000\000#illegal input/output mode specifier");
lf[134]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open pipe");
lf[135]=C_h_intern(&lf[135],13,"\003sysmake-port");
lf[136]=C_h_intern(&lf[136],21,"\003sysstream-port-class");
lf[137]=C_decode_literal(C_heaptop,"\376B\000\000\006(pipe)");
lf[138]=C_h_intern(&lf[138],15,"open-input-pipe");
lf[139]=C_h_intern(&lf[139],7,"\000binary");
lf[140]=C_h_intern(&lf[140],16,"open-output-pipe");
lf[141]=C_h_intern(&lf[141],16,"close-input-pipe");
lf[142]=C_decode_literal(C_heaptop,"\376B\000\000\030error while closing pipe");
lf[143]=C_h_intern(&lf[143],14,"\003syscheck-port");
lf[144]=C_h_intern(&lf[144],17,"close-output-pipe");
lf[145]=C_h_intern(&lf[145],20,"call-with-input-pipe");
lf[146]=C_h_intern(&lf[146],21,"call-with-output-pipe");
lf[147]=C_h_intern(&lf[147],20,"with-input-from-pipe");
lf[148]=C_h_intern(&lf[148],18,"\003sysstandard-input");
lf[149]=C_h_intern(&lf[149],19,"with-output-to-pipe");
lf[150]=C_h_intern(&lf[150],19,"\003sysstandard-output");
lf[151]=C_h_intern(&lf[151],11,"create-pipe");
lf[152]=C_decode_literal(C_heaptop,"\376B\000\000\022cannot create pipe");
lf[153]=C_h_intern(&lf[153],11,"signal/term");
lf[154]=C_h_intern(&lf[154],10,"signal/int");
lf[155]=C_h_intern(&lf[155],10,"signal/fpe");
lf[156]=C_h_intern(&lf[156],10,"signal/ill");
lf[157]=C_h_intern(&lf[157],11,"signal/segv");
lf[158]=C_h_intern(&lf[158],11,"signal/abrt");
lf[159]=C_h_intern(&lf[159],12,"signal/break");
lf[160]=C_h_intern(&lf[160],11,"signal/alrm");
lf[161]=C_h_intern(&lf[161],11,"signal/chld");
lf[162]=C_h_intern(&lf[162],11,"signal/cont");
lf[163]=C_h_intern(&lf[163],10,"signal/hup");
lf[164]=C_h_intern(&lf[164],9,"signal/io");
lf[165]=C_h_intern(&lf[165],11,"signal/kill");
lf[166]=C_h_intern(&lf[166],11,"signal/pipe");
lf[167]=C_h_intern(&lf[167],11,"signal/prof");
lf[168]=C_h_intern(&lf[168],11,"signal/quit");
lf[169]=C_h_intern(&lf[169],11,"signal/stop");
lf[170]=C_h_intern(&lf[170],11,"signal/trap");
lf[171]=C_h_intern(&lf[171],11,"signal/tstp");
lf[172]=C_h_intern(&lf[172],10,"signal/urg");
lf[173]=C_h_intern(&lf[173],11,"signal/usr1");
lf[174]=C_h_intern(&lf[174],11,"signal/usr2");
lf[175]=C_h_intern(&lf[175],13,"signal/vtalrm");
lf[176]=C_h_intern(&lf[176],12,"signal/winch");
lf[177]=C_h_intern(&lf[177],11,"signal/xcpu");
lf[178]=C_h_intern(&lf[178],11,"signal/xfsz");
lf[179]=C_h_intern(&lf[179],12,"signals-list");
lf[180]=C_h_intern(&lf[180],18,"\003sysinterrupt-hook");
lf[181]=C_h_intern(&lf[181],14,"signal-handler");
lf[182]=C_h_intern(&lf[182],19,"set-signal-handler!");
lf[183]=C_h_intern(&lf[183],10,"errno/perm");
lf[184]=C_h_intern(&lf[184],11,"errno/noent");
lf[185]=C_h_intern(&lf[185],10,"errno/srch");
lf[186]=C_h_intern(&lf[186],10,"errno/intr");
lf[187]=C_h_intern(&lf[187],8,"errno/io");
lf[188]=C_h_intern(&lf[188],12,"errno/noexec");
lf[189]=C_h_intern(&lf[189],10,"errno/badf");
lf[190]=C_h_intern(&lf[190],11,"errno/child");
lf[191]=C_h_intern(&lf[191],11,"errno/nomem");
lf[192]=C_h_intern(&lf[192],11,"errno/acces");
lf[193]=C_h_intern(&lf[193],11,"errno/fault");
lf[194]=C_h_intern(&lf[194],10,"errno/busy");
lf[195]=C_h_intern(&lf[195],11,"errno/exist");
lf[196]=C_h_intern(&lf[196],12,"errno/notdir");
lf[197]=C_h_intern(&lf[197],11,"errno/isdir");
lf[198]=C_h_intern(&lf[198],11,"errno/inval");
lf[199]=C_h_intern(&lf[199],11,"errno/mfile");
lf[200]=C_h_intern(&lf[200],11,"errno/nospc");
lf[201]=C_h_intern(&lf[201],11,"errno/spipe");
lf[202]=C_h_intern(&lf[202],10,"errno/pipe");
lf[203]=C_h_intern(&lf[203],11,"errno/again");
lf[204]=C_h_intern(&lf[204],10,"errno/rofs");
lf[205]=C_h_intern(&lf[205],10,"errno/nxio");
lf[206]=C_h_intern(&lf[206],10,"errno/2big");
lf[207]=C_h_intern(&lf[207],10,"errno/xdev");
lf[208]=C_h_intern(&lf[208],11,"errno/nodev");
lf[209]=C_h_intern(&lf[209],11,"errno/nfile");
lf[210]=C_h_intern(&lf[210],11,"errno/notty");
lf[211]=C_h_intern(&lf[211],10,"errno/fbig");
lf[212]=C_h_intern(&lf[212],11,"errno/mlink");
lf[213]=C_h_intern(&lf[213],9,"errno/dom");
lf[214]=C_h_intern(&lf[214],11,"errno/range");
lf[215]=C_h_intern(&lf[215],12,"errno/deadlk");
lf[216]=C_h_intern(&lf[216],17,"errno/nametoolong");
lf[217]=C_h_intern(&lf[217],11,"errno/nolck");
lf[218]=C_h_intern(&lf[218],11,"errno/nosys");
lf[219]=C_h_intern(&lf[219],14,"errno/notempty");
lf[220]=C_h_intern(&lf[220],11,"errno/ilseq");
lf[221]=C_h_intern(&lf[221],16,"change-file-mode");
lf[222]=C_decode_literal(C_heaptop,"\376B\000\000\027cannot change file mode");
lf[223]=C_h_intern(&lf[223],17,"file-read-access\077");
lf[224]=C_h_intern(&lf[224],18,"file-write-access\077");
lf[225]=C_h_intern(&lf[225],20,"file-execute-access\077");
lf[226]=C_h_intern(&lf[226],12,"fileno/stdin");
lf[227]=C_h_intern(&lf[227],13,"fileno/stdout");
lf[228]=C_h_intern(&lf[228],13,"fileno/stderr");
lf[229]=C_h_intern(&lf[229],7,"\000append");
lf[230]=C_decode_literal(C_heaptop,"\376B\000\000\033invalid mode for input file");
lf[231]=C_decode_literal(C_heaptop,"\376B\000\000\001a");
lf[232]=C_decode_literal(C_heaptop,"\376B\000\000\025invalid mode argument");
lf[233]=C_decode_literal(C_heaptop,"\376B\000\000\001r");
lf[234]=C_decode_literal(C_heaptop,"\376B\000\000\001w");
lf[235]=C_decode_literal(C_heaptop,"\376B\000\000\020cannot open file");
lf[236]=C_decode_literal(C_heaptop,"\376B\000\000\010(fdport)");
lf[237]=C_h_intern(&lf[237],16,"open-input-file*");
lf[238]=C_h_intern(&lf[238],17,"open-output-file*");
lf[239]=C_h_intern(&lf[239],12,"port->fileno");
lf[240]=C_decode_literal(C_heaptop,"\376B\000\000\031port has no attached file");
lf[241]=C_decode_literal(C_heaptop,"\376B\000\000%cannot access file-descriptor of port");
lf[242]=C_h_intern(&lf[242],25,"\003syspeek-unsigned-integer");
lf[243]=C_h_intern(&lf[243],16,"duplicate-fileno");
lf[244]=C_decode_literal(C_heaptop,"\376B\000\000 cannot duplicate file descriptor");
lf[245]=C_h_intern(&lf[245],6,"setenv");
lf[246]=C_h_intern(&lf[246],8,"unsetenv");
lf[247]=C_h_intern(&lf[247],9,"substring");
lf[248]=C_h_intern(&lf[248],25,"get-environment-variables");
lf[249]=C_h_intern(&lf[249],19,"current-environment");
lf[251]=C_decode_literal(C_heaptop,"\376B\000\000\025time vector too short");
lf[252]=C_h_intern(&lf[252],19,"seconds->local-time");
lf[253]=C_h_intern(&lf[253],18,"\003sysdecode-seconds");
lf[254]=C_h_intern(&lf[254],17,"seconds->utc-time");
lf[255]=C_h_intern(&lf[255],15,"seconds->string");
lf[256]=C_decode_literal(C_heaptop,"\376B\000\000 cannot convert seconds to string");
lf[257]=C_h_intern(&lf[257],12,"time->string");
lf[258]=C_decode_literal(C_heaptop,"\376B\000\000 time formatting overflows buffer");
lf[259]=C_decode_literal(C_heaptop,"\376B\000\000$cannot convert time vector to string");
lf[260]=C_h_intern(&lf[260],19,"local-time->seconds");
lf[261]=C_h_intern(&lf[261],15,"\003syscons-flonum");
lf[262]=C_decode_literal(C_heaptop,"\376B\000\000%cannot convert time vector to seconds");
lf[263]=C_h_intern(&lf[263],27,"local-timezone-abbreviation");
lf[264]=C_h_intern(&lf[264],5,"_exit");
lf[265]=C_h_intern(&lf[265],14,"terminal-port\077");
lf[266]=C_h_intern(&lf[266],19,"set-buffering-mode!");
lf[267]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot set buffering mode");
lf[268]=C_h_intern(&lf[268],5,"\000full");
lf[269]=C_h_intern(&lf[269],5,"\000line");
lf[270]=C_h_intern(&lf[270],5,"\000none");
lf[271]=C_decode_literal(C_heaptop,"\376B\000\000\026invalid buffering-mode");
lf[272]=C_h_intern(&lf[272],6,"regexp");
lf[273]=C_h_intern(&lf[273],12,"string-match");
lf[274]=C_h_intern(&lf[274],12,"glob->regexp");
lf[275]=C_h_intern(&lf[275],13,"make-pathname");
lf[276]=C_h_intern(&lf[276],18,"decompose-pathname");
lf[277]=C_h_intern(&lf[277],4,"glob");
lf[278]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[279]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[280]=C_h_intern(&lf[280],13,"spawn/overlay");
lf[281]=C_h_intern(&lf[281],10,"spawn/wait");
lf[282]=C_h_intern(&lf[282],12,"spawn/nowait");
lf[283]=C_h_intern(&lf[283],13,"spawn/nowaito");
lf[284]=C_h_intern(&lf[284],12,"spawn/detach");
lf[285]=C_h_intern(&lf[285],16,"char-whitespace\077");
lf[287]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[288]=C_decode_literal(C_heaptop,"\376B\000\000\001\042");
lf[289]=C_h_intern(&lf[289],24,"pathname-strip-directory");
lf[292]=C_h_intern(&lf[292],15,"process-execute");
lf[293]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[294]=C_h_intern(&lf[294],13,"process-spawn");
lf[295]=C_decode_literal(C_heaptop,"\376B\000\000\024cannot spawn process");
lf[296]=C_h_intern(&lf[296],18,"current-process-id");
lf[297]=C_h_intern(&lf[297],17,"\003sysshell-command");
lf[298]=C_decode_literal(C_heaptop,"\376B\000\000 cannot retrieve system directory");
lf[299]=C_h_intern(&lf[299],24,"get-environment-variable");
lf[300]=C_decode_literal(C_heaptop,"\376B\000\000\007COMSPEC");
lf[301]=C_h_intern(&lf[301],27,"\003sysshell-command-arguments");
lf[302]=C_decode_literal(C_heaptop,"\376B\000\000\002/c");
lf[303]=C_h_intern(&lf[303],11,"process-run");
lf[304]=C_h_intern(&lf[304],11,"\003sysprocess");
lf[305]=C_h_intern(&lf[305],14,"\000process-error");
lf[306]=C_decode_literal(C_heaptop,"\376B\000\000\026cannot execute process");
lf[307]=C_h_intern(&lf[307],17,"\003sysmake-locative");
lf[308]=C_h_intern(&lf[308],8,"location");
lf[309]=C_h_intern(&lf[309],7,"process");
lf[310]=C_h_intern(&lf[310],8,"process*");
lf[311]=C_h_intern(&lf[311],16,"\003sysprocess-wait");
lf[312]=C_h_intern(&lf[312],12,"process-wait");
lf[313]=C_decode_literal(C_heaptop,"\376B\000\000 waiting for child process failed");
lf[314]=C_h_intern(&lf[314],5,"sleep");
lf[315]=C_h_intern(&lf[315],13,"get-host-name");
lf[316]=C_decode_literal(C_heaptop,"\376B\000\000\031cannot retrieve host-name");
lf[317]=C_h_intern(&lf[317],18,"system-information");
lf[318]=C_decode_literal(C_heaptop,"\376B\000\000\007windows");
lf[319]=C_decode_literal(C_heaptop,"\376B\000\000\042cannot retrieve system-information");
lf[320]=C_decode_literal(C_heaptop,"\376B\000\000!cannot retrieve current user-name");
lf[321]=C_h_intern(&lf[321],10,"find-files");
lf[322]=C_decode_literal(C_heaptop,"\376B\000\000\001.");
lf[323]=C_decode_literal(C_heaptop,"\376B\000\000\002..");
lf[324]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[325]=C_h_intern(&lf[325],16,"\003sysdynamic-wind");
lf[326]=C_h_intern(&lf[326],13,"pathname-file");
lf[327]=C_decode_literal(C_heaptop,"\376B\000\000\001*");
lf[328]=C_h_intern(&lf[328],17,"change-file-owner");
lf[329]=C_h_intern(&lf[329],5,"error");
lf[330]=C_h_intern(&lf[330],11,"create-fifo");
lf[331]=C_h_intern(&lf[331],14,"create-session");
lf[332]=C_h_intern(&lf[332],20,"create-symbolic-link");
lf[333]=C_h_intern(&lf[333],26,"current-effective-group-id");
lf[334]=C_h_intern(&lf[334],25,"current-effective-user-id");
lf[335]=C_h_intern(&lf[335],27,"current-effective-user-name");
lf[336]=C_h_intern(&lf[336],16,"current-group-id");
lf[337]=C_h_intern(&lf[337],15,"current-user-id");
lf[338]=C_h_intern(&lf[338],18,"map-file-to-memory");
lf[339]=C_h_intern(&lf[339],9,"file-link");
lf[340]=C_h_intern(&lf[340],9,"file-lock");
lf[341]=C_h_intern(&lf[341],18,"file-lock/blocking");
lf[342]=C_h_intern(&lf[342],11,"file-select");
lf[343]=C_h_intern(&lf[343],14,"file-test-lock");
lf[344]=C_h_intern(&lf[344],13,"file-truncate");
lf[345]=C_h_intern(&lf[345],11,"file-unlock");
lf[346]=C_h_intern(&lf[346],10,"get-groups");
lf[347]=C_h_intern(&lf[347],17,"group-information");
lf[348]=C_h_intern(&lf[348],17,"initialize-groups");
lf[349]=C_h_intern(&lf[349],26,"memory-mapped-file-pointer");
lf[350]=C_h_intern(&lf[350],17,"parent-process-id");
lf[351]=C_h_intern(&lf[351],12,"process-fork");
lf[352]=C_h_intern(&lf[352],16,"process-group-id");
lf[353]=C_h_intern(&lf[353],14,"process-signal");
lf[354]=C_h_intern(&lf[354],18,"read-symbolic-link");
lf[355]=C_h_intern(&lf[355],10,"set-alarm!");
lf[356]=C_h_intern(&lf[356],13,"set-group-id!");
lf[357]=C_h_intern(&lf[357],11,"set-groups!");
lf[358]=C_h_intern(&lf[358],21,"set-process-group-id!");
lf[359]=C_h_intern(&lf[359],19,"set-root-directory!");
lf[360]=C_h_intern(&lf[360],16,"set-signal-mask!");
lf[361]=C_h_intern(&lf[361],12,"set-user-id!");
lf[362]=C_h_intern(&lf[362],11,"signal-mask");
lf[363]=C_h_intern(&lf[363],12,"signal-mask!");
lf[364]=C_h_intern(&lf[364],14,"signal-masked\077");
lf[365]=C_h_intern(&lf[365],14,"signal-unmask!");
lf[366]=C_h_intern(&lf[366],13,"terminal-name");
lf[367]=C_h_intern(&lf[367],13,"terminal-size");
lf[368]=C_h_intern(&lf[368],22,"unmap-file-from-memory");
lf[369]=C_h_intern(&lf[369],16,"user-information");
lf[370]=C_h_intern(&lf[370],17,"utc-time->seconds");
lf[371]=C_h_intern(&lf[371],12,"string->time");
lf[372]=C_h_intern(&lf[372],16,"errno/wouldblock");
lf[373]=C_h_intern(&lf[373],19,"memory-mapped-file\077");
lf[374]=C_h_intern(&lf[374],13,"map/anonymous");
lf[375]=C_h_intern(&lf[375],8,"map/file");
lf[376]=C_h_intern(&lf[376],9,"map/fixed");
lf[377]=C_h_intern(&lf[377],11,"map/private");
lf[378]=C_h_intern(&lf[378],10,"map/shared");
lf[379]=C_h_intern(&lf[379],10,"open/fsync");
lf[380]=C_h_intern(&lf[380],11,"open/noctty");
lf[381]=C_h_intern(&lf[381],13,"open/nonblock");
lf[382]=C_h_intern(&lf[382],9,"open/sync");
lf[383]=C_h_intern(&lf[383],10,"perm/isgid");
lf[384]=C_h_intern(&lf[384],10,"perm/isuid");
lf[385]=C_h_intern(&lf[385],10,"perm/isvtx");
lf[386]=C_h_intern(&lf[386],9,"prot/exec");
lf[387]=C_h_intern(&lf[387],9,"prot/none");
lf[388]=C_h_intern(&lf[388],9,"prot/read");
lf[389]=C_h_intern(&lf[389],10,"prot/write");
lf[390]=C_h_intern(&lf[390],11,"make-vector");
lf[391]=C_decode_literal(C_heaptop,"\376B\000\000%cannot retrieve file position of port");
lf[392]=C_decode_literal(C_heaptop,"\376B\000\000\014invalid file");
lf[393]=C_h_intern(&lf[393],18,"getter-with-setter");
lf[394]=C_h_intern(&lf[394],17,"stat-char-device\077");
lf[395]=C_h_intern(&lf[395],17,"register-feature!");
lf[396]=C_h_intern(&lf[396],5,"posix");
C_register_lf2(lf,397,create_ptable());
t2=C_mutate(&lf[0] /* (set! c2031 ...) */,lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2641,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k2639 */
static void C_ccall f_2641(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2641,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2644,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2642 in k2639 */
static void C_ccall f_2644(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2644,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2647,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2645 in k2642 in k2639 */
static void C_ccall f_2647(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2647,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2650,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2650(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2650,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2653,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_files_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2653(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2653,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2656,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_ports_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2656(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2656,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2659,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 930  register-feature! */
t3=*((C_word*)lf[395]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[396]);}

/* k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word ab[46],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2659,2,t0,t1);}
t2=*((C_word*)lf[2]+1);
t3=C_mutate(&lf[3] /* (set! posix-error ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2666,a[2]=t2,tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[8]+1 /* (set! posix-error ...) */,lf[3]);
t5=C_mutate((C_word*)lf[9]+1 /* (set! pipe/buf ...) */,C_fix((C_word)PIPE_BUF));
t6=C_mutate((C_word*)lf[10]+1 /* (set! open/rdonly ...) */,C_fix((C_word)O_RDONLY));
t7=C_mutate((C_word*)lf[11]+1 /* (set! open/wronly ...) */,C_fix((C_word)O_WRONLY));
t8=C_mutate((C_word*)lf[12]+1 /* (set! open/rdwr ...) */,C_fix((C_word)O_RDWR));
t9=C_mutate((C_word*)lf[13]+1 /* (set! open/read ...) */,C_fix((C_word)O_RDWR));
t10=C_mutate((C_word*)lf[14]+1 /* (set! open/write ...) */,C_fix((C_word)O_WRONLY));
t11=C_mutate((C_word*)lf[15]+1 /* (set! open/creat ...) */,C_fix((C_word)O_CREAT));
t12=C_mutate((C_word*)lf[16]+1 /* (set! open/append ...) */,C_fix((C_word)O_APPEND));
t13=C_mutate((C_word*)lf[17]+1 /* (set! open/excl ...) */,C_fix((C_word)O_EXCL));
t14=C_mutate((C_word*)lf[18]+1 /* (set! open/trunc ...) */,C_fix((C_word)O_TRUNC));
t15=C_mutate((C_word*)lf[19]+1 /* (set! open/binary ...) */,C_fix((C_word)O_BINARY));
t16=C_mutate((C_word*)lf[20]+1 /* (set! open/text ...) */,C_fix((C_word)O_TEXT));
t17=C_mutate((C_word*)lf[21]+1 /* (set! open/noinherit ...) */,C_fix((C_word)O_NOINHERIT));
t18=C_mutate((C_word*)lf[22]+1 /* (set! perm/irusr ...) */,C_fix((C_word)S_IREAD));
t19=C_mutate((C_word*)lf[23]+1 /* (set! perm/iwusr ...) */,C_fix((C_word)S_IWRITE));
t20=C_mutate((C_word*)lf[24]+1 /* (set! perm/ixusr ...) */,C_fix((C_word)S_IEXEC));
t21=C_mutate((C_word*)lf[25]+1 /* (set! perm/irgrp ...) */,C_fix((C_word)S_IREAD));
t22=C_mutate((C_word*)lf[26]+1 /* (set! perm/iwgrp ...) */,C_fix((C_word)S_IWRITE));
t23=C_mutate((C_word*)lf[27]+1 /* (set! perm/ixgrp ...) */,C_fix((C_word)S_IEXEC));
t24=C_mutate((C_word*)lf[28]+1 /* (set! perm/iroth ...) */,C_fix((C_word)S_IREAD));
t25=C_mutate((C_word*)lf[29]+1 /* (set! perm/iwoth ...) */,C_fix((C_word)S_IWRITE));
t26=C_mutate((C_word*)lf[30]+1 /* (set! perm/ixoth ...) */,C_fix((C_word)S_IEXEC));
t27=C_mutate((C_word*)lf[31]+1 /* (set! perm/irwxu ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t28=C_mutate((C_word*)lf[32]+1 /* (set! perm/irwxg ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t29=C_mutate((C_word*)lf[33]+1 /* (set! perm/irwxo ...) */,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC));
t30=(C_word)C_u_fixnum_or(C_fix((C_word)S_IREAD),C_fix((C_word)S_IREAD));
t31=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IREAD | S_IWRITE | S_IEXEC),t30);
t32=C_mutate((C_word*)lf[34]+1 /* (set! file-open ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2712,a[2]=t31,tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[39]+1 /* (set! file-close ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2753,tmp=(C_word)a,a+=2,tmp));
t34=*((C_word*)lf[41]+1);
t35=C_mutate((C_word*)lf[42]+1 /* (set! file-read ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2771,a[2]=t34,tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[46]+1 /* (set! file-write ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2816,tmp=(C_word)a,a+=2,tmp));
t37=*((C_word*)lf[49]+1);
t38=C_mutate((C_word*)lf[50]+1 /* (set! file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2858,a[2]=t37,tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[53]+1 /* (set! seek/set ...) */,C_fix((C_word)SEEK_SET));
t40=C_mutate((C_word*)lf[54]+1 /* (set! seek/end ...) */,C_fix((C_word)SEEK_END));
t41=C_mutate((C_word*)lf[55]+1 /* (set! seek/cur ...) */,C_fix((C_word)SEEK_CUR));
t42=C_mutate(&lf[56] /* (set! stat ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2896,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[59]+1 /* (set! file-stat ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2934,tmp=(C_word)a,a+=2,tmp));
t44=C_mutate((C_word*)lf[60]+1 /* (set! file-size ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2958,tmp=(C_word)a,a+=2,tmp));
t45=C_mutate((C_word*)lf[61]+1 /* (set! file-modification-time ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2964,tmp=(C_word)a,a+=2,tmp));
t46=C_mutate((C_word*)lf[62]+1 /* (set! file-access-time ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2970,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[63]+1 /* (set! file-change-time ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2976,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[64]+1 /* (set! file-owner ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2982,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[65]+1 /* (set! file-permissions ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2988,tmp=(C_word)a,a+=2,tmp));
t50=C_mutate((C_word*)lf[66]+1 /* (set! regular-file? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_2994,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[68]+1 /* (set! symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3017,tmp=(C_word)a,a+=2,tmp));
t52=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3022,tmp=(C_word)a,a+=2,tmp);
t53=C_mutate((C_word*)lf[69]+1 /* (set! stat-regular? ...) */,*((C_word*)lf[66]+1));
t54=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3033,a[2]=t52,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1115 stat-type */
f_3022(t54,lf[70]);}

/* k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3033(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3033,2,t0,t1);}
t2=C_mutate((C_word*)lf[70]+1 /* (set! stat-directory? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3037,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1116 stat-type */
f_3022(t3,lf[394]);}

/* k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3037(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3037,2,t0,t1);}
t2=C_mutate((C_word*)lf[71]+1 /* (set! stat-device? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3041,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1117 stat-type */
f_3022(t3,lf[72]);}

/* k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3041(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3041,2,t0,t1);}
t2=C_mutate((C_word*)lf[72]+1 /* (set! character-device? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3045,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1118 stat-type */
f_3022(t3,lf[73]);}

/* k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3045(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3045,2,t0,t1);}
t2=C_mutate((C_word*)lf[73]+1 /* (set! block-device? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3049,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1119 stat-type */
f_3022(t3,lf[74]);}

/* k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3049(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3049,2,t0,t1);}
t2=C_mutate((C_word*)lf[74]+1 /* (set! stat-block-device? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3053,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1120 stat-type */
f_3022(t3,lf[75]);}

/* k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3053(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3053,2,t0,t1);}
t2=C_mutate((C_word*)lf[75]+1 /* (set! stat-fifo? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3057,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1121 stat-type */
f_3022(t3,lf[76]);}

/* k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3057(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3057,2,t0,t1);}
t2=C_mutate((C_word*)lf[76]+1 /* (set! fifo? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3061,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1122 stat-type */
f_3022(t3,lf[77]);}

/* k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3061,2,t0,t1);}
t2=C_mutate((C_word*)lf[77]+1 /* (set! stat-symlink? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3065,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1123 stat-type */
f_3022(t3,lf[78]);}

/* k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3065,2,t0,t1);}
t2=C_mutate((C_word*)lf[78]+1 /* (set! socket? ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3069,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1124 stat-type */
f_3022(t3,lf[79]);}

/* k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3069(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3069,2,t0,t1);}
t2=C_mutate((C_word*)lf[79]+1 /* (set! stat-socket? ...) */,t1);
t3=C_mutate((C_word*)lf[80]+1 /* (set! set-file-position! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3071,tmp=(C_word)a,a+=2,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3134,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6394,tmp=(C_word)a,a+=2,tmp);
/* posixwin.scm: 1141 getter-with-setter */
t6=*((C_word*)lf[393]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,t5,*((C_word*)lf[80]+1));}

/* a6393 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6394(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6394,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6398,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6413,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1143 port? */
t5=*((C_word*)lf[84]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k6411 in a6393 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6413(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[82]);
t4=((C_word*)t0)[2];
f_6398(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_6398(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixwin.scm: 1148 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[44],lf[87],lf[392],((C_word*)t0)[3]);}}}

/* k6396 in a6393 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6398(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6398,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6401,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6407,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1150 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_6401(2,t3,C_SCHEME_UNDEFINED);}}

/* k6405 in k6396 in a6393 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6407(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1151 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[35],lf[87],lf[391],((C_word*)t0)[2]);}

/* k6399 in k6396 in a6393 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6401(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3134(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word ab[94],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3134,2,t0,t1);}
t2=C_mutate((C_word*)lf[87]+1 /* (set! file-position ...) */,t1);
t3=C_mutate((C_word*)lf[88]+1 /* (set! create-directory ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3136,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[96]+1 /* (set! change-directory ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3242,tmp=(C_word)a,a+=2,tmp));
t5=C_mutate((C_word*)lf[98]+1 /* (set! delete-directory ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3269,tmp=(C_word)a,a+=2,tmp));
t6=*((C_word*)lf[2]+1);
t7=*((C_word*)lf[41]+1);
t8=*((C_word*)lf[100]+1);
t9=C_mutate((C_word*)lf[101]+1 /* (set! directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3296,a[2]=t7,tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[105]+1 /* (set! directory? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3453,tmp=(C_word)a,a+=2,tmp));
t11=*((C_word*)lf[41]+1);
t12=C_mutate((C_word*)lf[104]+1 /* (set! current-directory ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3480,a[2]=t11,tmp=(C_word)a,a+=3,tmp));
t13=*((C_word*)lf[108]+1);
t14=*((C_word*)lf[109]+1);
t15=*((C_word*)lf[110]+1);
t16=*((C_word*)lf[111]+1);
t17=*((C_word*)lf[112]+1);
t18=*((C_word*)lf[2]+1);
t19=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3524,tmp=(C_word)a,a+=2,tmp);
t20=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3529,tmp=(C_word)a,a+=2,tmp);
t21=*((C_word*)lf[115]+1);
t22=*((C_word*)lf[104]+1);
t23=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3540,a[2]=t22,tmp=(C_word)a,a+=3,tmp);
t24=C_mutate((C_word*)lf[95]+1 /* (set! canonical-path ...) */,(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_3596,a[2]=t16,a[3]=t14,a[4]=t21,a[5]=t23,a[6]=t15,a[7]=t13,a[8]=t17,a[9]=t19,a[10]=t18,a[11]=t20,tmp=(C_word)a,a+=12,tmp));
t25=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3953,tmp=(C_word)a,a+=2,tmp);
t26=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3965,tmp=(C_word)a,a+=2,tmp);
t27=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_3971,tmp=(C_word)a,a+=2,tmp);
t28=C_mutate((C_word*)lf[138]+1 /* (set! open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3989,a[2]=t26,a[3]=t27,a[4]=t25,tmp=(C_word)a,a+=5,tmp));
t29=C_mutate((C_word*)lf[140]+1 /* (set! open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4025,a[2]=t26,a[3]=t27,a[4]=t25,tmp=(C_word)a,a+=5,tmp));
t30=C_mutate((C_word*)lf[141]+1 /* (set! close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4061,tmp=(C_word)a,a+=2,tmp));
t31=C_mutate((C_word*)lf[144]+1 /* (set! close-output-pipe ...) */,*((C_word*)lf[141]+1));
t32=*((C_word*)lf[138]+1);
t33=*((C_word*)lf[140]+1);
t34=*((C_word*)lf[141]+1);
t35=*((C_word*)lf[144]+1);
t36=C_mutate((C_word*)lf[145]+1 /* (set! call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4080,a[2]=t32,a[3]=t34,tmp=(C_word)a,a+=4,tmp));
t37=C_mutate((C_word*)lf[146]+1 /* (set! call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4104,a[2]=t33,a[3]=t35,tmp=(C_word)a,a+=4,tmp));
t38=C_mutate((C_word*)lf[147]+1 /* (set! with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4128,a[2]=t32,a[3]=t34,tmp=(C_word)a,a+=4,tmp));
t39=C_mutate((C_word*)lf[149]+1 /* (set! with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4148,a[2]=t33,a[3]=t35,tmp=(C_word)a,a+=4,tmp));
t40=C_mutate((C_word*)lf[151]+1 /* (set! create-pipe ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4168,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[153]+1 /* (set! signal/term ...) */,C_fix((C_word)SIGTERM));
t42=C_mutate((C_word*)lf[154]+1 /* (set! signal/int ...) */,C_fix((C_word)SIGINT));
t43=C_mutate((C_word*)lf[155]+1 /* (set! signal/fpe ...) */,C_fix((C_word)SIGFPE));
t44=C_mutate((C_word*)lf[156]+1 /* (set! signal/ill ...) */,C_fix((C_word)SIGILL));
t45=C_mutate((C_word*)lf[157]+1 /* (set! signal/segv ...) */,C_fix((C_word)SIGSEGV));
t46=C_mutate((C_word*)lf[158]+1 /* (set! signal/abrt ...) */,C_fix((C_word)SIGABRT));
t47=C_mutate((C_word*)lf[159]+1 /* (set! signal/break ...) */,C_fix((C_word)SIGBREAK));
t48=C_set_block_item(lf[160] /* signal/alrm */,0,C_fix(0));
t49=C_set_block_item(lf[161] /* signal/chld */,0,C_fix(0));
t50=C_set_block_item(lf[162] /* signal/cont */,0,C_fix(0));
t51=C_set_block_item(lf[163] /* signal/hup */,0,C_fix(0));
t52=C_set_block_item(lf[164] /* signal/io */,0,C_fix(0));
t53=C_set_block_item(lf[165] /* signal/kill */,0,C_fix(0));
t54=C_set_block_item(lf[166] /* signal/pipe */,0,C_fix(0));
t55=C_set_block_item(lf[167] /* signal/prof */,0,C_fix(0));
t56=C_set_block_item(lf[168] /* signal/quit */,0,C_fix(0));
t57=C_set_block_item(lf[169] /* signal/stop */,0,C_fix(0));
t58=C_set_block_item(lf[170] /* signal/trap */,0,C_fix(0));
t59=C_set_block_item(lf[171] /* signal/tstp */,0,C_fix(0));
t60=C_set_block_item(lf[172] /* signal/urg */,0,C_fix(0));
t61=C_set_block_item(lf[173] /* signal/usr1 */,0,C_fix(0));
t62=C_set_block_item(lf[174] /* signal/usr2 */,0,C_fix(0));
t63=C_set_block_item(lf[175] /* signal/vtalrm */,0,C_fix(0));
t64=C_set_block_item(lf[176] /* signal/winch */,0,C_fix(0));
t65=C_set_block_item(lf[177] /* signal/xcpu */,0,C_fix(0));
t66=C_set_block_item(lf[178] /* signal/xfsz */,0,C_fix(0));
t67=(C_word)C_a_i_list(&a,7,*((C_word*)lf[153]+1),*((C_word*)lf[154]+1),*((C_word*)lf[155]+1),*((C_word*)lf[156]+1),*((C_word*)lf[157]+1),*((C_word*)lf[158]+1),*((C_word*)lf[159]+1));
t68=C_mutate((C_word*)lf[179]+1 /* (set! signals-list ...) */,t67);
t69=*((C_word*)lf[180]+1);
t70=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4235,a[2]=((C_word*)t0)[2],a[3]=t69,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1474 make-vector */
t71=*((C_word*)lf[390]+1);
((C_proc4)(void*)(*((C_word*)t71+1)))(4,t71,t70,C_fix(256),C_SCHEME_FALSE);}

/* k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4235(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word ab[225],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4235,2,t0,t1);}
t2=C_mutate((C_word*)lf[181]+1 /* (set! signal-handler ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4237,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[182]+1 /* (set! set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4246,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[180]+1 /* (set! interrupt-hook ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4259,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t5=C_mutate((C_word*)lf[183]+1 /* (set! errno/perm ...) */,C_fix((C_word)EPERM));
t6=C_mutate((C_word*)lf[184]+1 /* (set! errno/noent ...) */,C_fix((C_word)ENOENT));
t7=C_mutate((C_word*)lf[185]+1 /* (set! errno/srch ...) */,C_fix((C_word)ESRCH));
t8=C_mutate((C_word*)lf[186]+1 /* (set! errno/intr ...) */,C_fix((C_word)EINTR));
t9=C_mutate((C_word*)lf[187]+1 /* (set! errno/io ...) */,C_fix((C_word)EIO));
t10=C_mutate((C_word*)lf[188]+1 /* (set! errno/noexec ...) */,C_fix((C_word)ENOEXEC));
t11=C_mutate((C_word*)lf[189]+1 /* (set! errno/badf ...) */,C_fix((C_word)EBADF));
t12=C_mutate((C_word*)lf[190]+1 /* (set! errno/child ...) */,C_fix((C_word)ECHILD));
t13=C_mutate((C_word*)lf[191]+1 /* (set! errno/nomem ...) */,C_fix((C_word)ENOMEM));
t14=C_mutate((C_word*)lf[192]+1 /* (set! errno/acces ...) */,C_fix((C_word)EACCES));
t15=C_mutate((C_word*)lf[193]+1 /* (set! errno/fault ...) */,C_fix((C_word)EFAULT));
t16=C_mutate((C_word*)lf[194]+1 /* (set! errno/busy ...) */,C_fix((C_word)EBUSY));
t17=C_mutate((C_word*)lf[195]+1 /* (set! errno/exist ...) */,C_fix((C_word)EEXIST));
t18=C_mutate((C_word*)lf[196]+1 /* (set! errno/notdir ...) */,C_fix((C_word)ENOTDIR));
t19=C_mutate((C_word*)lf[197]+1 /* (set! errno/isdir ...) */,C_fix((C_word)EISDIR));
t20=C_mutate((C_word*)lf[198]+1 /* (set! errno/inval ...) */,C_fix((C_word)EINVAL));
t21=C_mutate((C_word*)lf[199]+1 /* (set! errno/mfile ...) */,C_fix((C_word)EMFILE));
t22=C_mutate((C_word*)lf[200]+1 /* (set! errno/nospc ...) */,C_fix((C_word)ENOSPC));
t23=C_mutate((C_word*)lf[201]+1 /* (set! errno/spipe ...) */,C_fix((C_word)ESPIPE));
t24=C_mutate((C_word*)lf[202]+1 /* (set! errno/pipe ...) */,C_fix((C_word)EPIPE));
t25=C_mutate((C_word*)lf[203]+1 /* (set! errno/again ...) */,C_fix((C_word)EAGAIN));
t26=C_mutate((C_word*)lf[204]+1 /* (set! errno/rofs ...) */,C_fix((C_word)EROFS));
t27=C_mutate((C_word*)lf[205]+1 /* (set! errno/nxio ...) */,C_fix((C_word)ENXIO));
t28=C_mutate((C_word*)lf[206]+1 /* (set! errno/2big ...) */,C_fix((C_word)E2BIG));
t29=C_mutate((C_word*)lf[207]+1 /* (set! errno/xdev ...) */,C_fix((C_word)EXDEV));
t30=C_mutate((C_word*)lf[208]+1 /* (set! errno/nodev ...) */,C_fix((C_word)ENODEV));
t31=C_mutate((C_word*)lf[209]+1 /* (set! errno/nfile ...) */,C_fix((C_word)ENFILE));
t32=C_mutate((C_word*)lf[210]+1 /* (set! errno/notty ...) */,C_fix((C_word)ENOTTY));
t33=C_mutate((C_word*)lf[211]+1 /* (set! errno/fbig ...) */,C_fix((C_word)EFBIG));
t34=C_mutate((C_word*)lf[212]+1 /* (set! errno/mlink ...) */,C_fix((C_word)EMLINK));
t35=C_mutate((C_word*)lf[213]+1 /* (set! errno/dom ...) */,C_fix((C_word)EDOM));
t36=C_mutate((C_word*)lf[214]+1 /* (set! errno/range ...) */,C_fix((C_word)ERANGE));
t37=C_mutate((C_word*)lf[215]+1 /* (set! errno/deadlk ...) */,C_fix((C_word)EDEADLK));
t38=C_mutate((C_word*)lf[216]+1 /* (set! errno/nametoolong ...) */,C_fix((C_word)ENAMETOOLONG));
t39=C_mutate((C_word*)lf[217]+1 /* (set! errno/nolck ...) */,C_fix((C_word)ENOLCK));
t40=C_mutate((C_word*)lf[218]+1 /* (set! errno/nosys ...) */,C_fix((C_word)ENOSYS));
t41=C_mutate((C_word*)lf[219]+1 /* (set! errno/notempty ...) */,C_fix((C_word)ENOTEMPTY));
t42=C_mutate((C_word*)lf[220]+1 /* (set! errno/ilseq ...) */,C_fix((C_word)EILSEQ));
t43=C_mutate((C_word*)lf[221]+1 /* (set! change-file-mode ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4315,tmp=(C_word)a,a+=2,tmp));
t44=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4345,tmp=(C_word)a,a+=2,tmp);
t45=C_mutate((C_word*)lf[223]+1 /* (set! file-read-access? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4369,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[224]+1 /* (set! file-write-access? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4375,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[225]+1 /* (set! file-execute-access? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4381,a[2]=t44,tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[226]+1 /* (set! fileno/stdin ...) */,C_fix((C_word)0));
t49=C_mutate((C_word*)lf[227]+1 /* (set! fileno/stdout ...) */,C_fix((C_word)1));
t50=C_mutate((C_word*)lf[228]+1 /* (set! fileno/stderr ...) */,C_fix((C_word)2));
t51=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4390,tmp=(C_word)a,a+=2,tmp);
t52=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4427,tmp=(C_word)a,a+=2,tmp);
t53=C_mutate((C_word*)lf[237]+1 /* (set! open-input-file* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4445,a[2]=t51,a[3]=t52,tmp=(C_word)a,a+=4,tmp));
t54=C_mutate((C_word*)lf[238]+1 /* (set! open-output-file* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4459,a[2]=t51,a[3]=t52,tmp=(C_word)a,a+=4,tmp));
t55=C_mutate((C_word*)lf[239]+1 /* (set! port->fileno ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4473,tmp=(C_word)a,a+=2,tmp));
t56=C_mutate((C_word*)lf[243]+1 /* (set! duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4508,tmp=(C_word)a,a+=2,tmp));
t57=C_mutate((C_word*)lf[245]+1 /* (set! setenv ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4538,tmp=(C_word)a,a+=2,tmp));
t58=C_mutate((C_word*)lf[246]+1 /* (set! unsetenv ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4555,tmp=(C_word)a,a+=2,tmp));
t59=*((C_word*)lf[247]+1);
t60=C_mutate((C_word*)lf[248]+1 /* (set! get-environment-variables ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4570,a[2]=t59,tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[249]+1 /* (set! current-environment ...) */,*((C_word*)lf[248]+1));
t62=C_mutate(&lf[250] /* (set! check-time-vector ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4636,tmp=(C_word)a,a+=2,tmp));
t63=C_mutate((C_word*)lf[252]+1 /* (set! seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4655,tmp=(C_word)a,a+=2,tmp));
t64=C_mutate((C_word*)lf[254]+1 /* (set! seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4664,tmp=(C_word)a,a+=2,tmp));
t65=C_mutate((C_word*)lf[255]+1 /* (set! seconds->string ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4678,tmp=(C_word)a,a+=2,tmp));
t66=C_mutate((C_word*)lf[257]+1 /* (set! time->string ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4711,tmp=(C_word)a,a+=2,tmp));
t67=C_mutate((C_word*)lf[260]+1 /* (set! local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4771,tmp=(C_word)a,a+=2,tmp));
t68=C_mutate((C_word*)lf[263]+1 /* (set! local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4786,tmp=(C_word)a,a+=2,tmp));
t69=C_mutate((C_word*)lf[264]+1 /* (set! _exit ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4794,tmp=(C_word)a,a+=2,tmp));
t70=C_mutate((C_word*)lf[265]+1 /* (set! terminal-port? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4810,tmp=(C_word)a,a+=2,tmp));
t71=C_mutate((C_word*)lf[266]+1 /* (set! set-buffering-mode! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_4816,tmp=(C_word)a,a+=2,tmp));
t72=*((C_word*)lf[272]+1);
t73=*((C_word*)lf[273]+1);
t74=*((C_word*)lf[274]+1);
t75=*((C_word*)lf[101]+1);
t76=*((C_word*)lf[275]+1);
t77=*((C_word*)lf[276]+1);
t78=C_mutate((C_word*)lf[277]+1 /* (set! glob ...) */,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4875,a[2]=t74,a[3]=t72,a[4]=t75,a[5]=t73,a[6]=t76,a[7]=t77,tmp=(C_word)a,a+=8,tmp));
t79=C_mutate((C_word*)lf[280]+1 /* (set! spawn/overlay ...) */,C_fix((C_word)P_OVERLAY));
t80=C_mutate((C_word*)lf[281]+1 /* (set! spawn/wait ...) */,C_fix((C_word)P_WAIT));
t81=C_mutate((C_word*)lf[282]+1 /* (set! spawn/nowait ...) */,C_fix((C_word)P_NOWAIT));
t82=C_mutate((C_word*)lf[283]+1 /* (set! spawn/nowaito ...) */,C_fix((C_word)P_NOWAITO));
t83=C_mutate((C_word*)lf[284]+1 /* (set! spawn/detach ...) */,C_fix((C_word)P_DETACH));
t84=*((C_word*)lf[285]+1);
t85=*((C_word*)lf[49]+1);
t86=*((C_word*)lf[112]+1);
t87=*((C_word*)lf[2]+1);
t88=C_mutate(&lf[286] /* (set! $quote-args-list ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4987,a[2]=t87,a[3]=t85,a[4]=t86,a[5]=t84,tmp=(C_word)a,a+=6,tmp));
t89=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5066,tmp=(C_word)a,a+=2,tmp);
t90=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5072,tmp=(C_word)a,a+=2,tmp);
t91=*((C_word*)lf[289]+1);
t92=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5078,tmp=(C_word)a,a+=2,tmp);
t93=C_mutate(&lf[290] /* (set! $exec-setup ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5128,a[2]=t91,a[3]=t89,a[4]=t90,a[5]=t92,tmp=(C_word)a,a+=6,tmp));
t94=C_mutate(&lf[291] /* (set! $exec-teardown ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5161,tmp=(C_word)a,a+=2,tmp));
t95=C_mutate((C_word*)lf[292]+1 /* (set! process-execute ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5176,tmp=(C_word)a,a+=2,tmp));
t96=C_mutate((C_word*)lf[294]+1 /* (set! process-spawn ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5260,tmp=(C_word)a,a+=2,tmp));
t97=C_mutate((C_word*)lf[296]+1 /* (set! current-process-id ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5344,tmp=(C_word)a,a+=2,tmp));
t98=C_mutate((C_word*)lf[297]+1 /* (set! shell-command ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5347,tmp=(C_word)a,a+=2,tmp));
t99=C_mutate((C_word*)lf[301]+1 /* (set! shell-command-arguments ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5368,tmp=(C_word)a,a+=2,tmp));
t100=*((C_word*)lf[294]+1);
t101=*((C_word*)lf[299]+1);
t102=C_mutate((C_word*)lf[303]+1 /* (set! process-run ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5374,a[2]=t100,tmp=(C_word)a,a+=3,tmp));
t103=C_mutate((C_word*)lf[304]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5454,tmp=(C_word)a,a+=2,tmp));
t104=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5550,tmp=(C_word)a,a+=2,tmp);
t105=C_mutate((C_word*)lf[309]+1 /* (set! process ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5612,a[2]=t104,tmp=(C_word)a,a+=3,tmp));
t106=C_mutate((C_word*)lf[310]+1 /* (set! process* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5689,a[2]=t104,tmp=(C_word)a,a+=3,tmp));
t107=C_mutate((C_word*)lf[311]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5766,tmp=(C_word)a,a+=2,tmp));
t108=C_mutate((C_word*)lf[312]+1 /* (set! process-wait ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5778,tmp=(C_word)a,a+=2,tmp));
t109=C_mutate((C_word*)lf[314]+1 /* (set! sleep ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5835,tmp=(C_word)a,a+=2,tmp));
t110=C_mutate((C_word*)lf[315]+1 /* (set! get-host-name ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5838,tmp=(C_word)a,a+=2,tmp));
t111=C_mutate((C_word*)lf[317]+1 /* (set! system-information ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5850,tmp=(C_word)a,a+=2,tmp));
t112=C_mutate((C_word*)lf[115]+1 /* (set! current-user-name ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_5881,tmp=(C_word)a,a+=2,tmp));
t113=*((C_word*)lf[277]+1);
t114=*((C_word*)lf[273]+1);
t115=*((C_word*)lf[275]+1);
t116=*((C_word*)lf[105]+1);
t117=C_mutate((C_word*)lf[321]+1 /* (set! find-files ...) */,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5896,a[2]=t116,a[3]=t115,a[4]=t113,a[5]=t114,tmp=(C_word)a,a+=6,tmp));
t118=C_mutate((C_word*)lf[328]+1 /* (set! change-file-owner ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6113,tmp=(C_word)a,a+=2,tmp));
t119=C_mutate((C_word*)lf[330]+1 /* (set! create-fifo ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6119,tmp=(C_word)a,a+=2,tmp));
t120=C_mutate((C_word*)lf[331]+1 /* (set! create-session ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6125,tmp=(C_word)a,a+=2,tmp));
t121=C_mutate((C_word*)lf[332]+1 /* (set! create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6131,tmp=(C_word)a,a+=2,tmp));
t122=C_mutate((C_word*)lf[333]+1 /* (set! current-effective-group-id ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6137,tmp=(C_word)a,a+=2,tmp));
t123=C_mutate((C_word*)lf[334]+1 /* (set! current-effective-user-id ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6143,tmp=(C_word)a,a+=2,tmp));
t124=C_mutate((C_word*)lf[335]+1 /* (set! current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6149,tmp=(C_word)a,a+=2,tmp));
t125=C_mutate((C_word*)lf[336]+1 /* (set! current-group-id ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6155,tmp=(C_word)a,a+=2,tmp));
t126=C_mutate((C_word*)lf[337]+1 /* (set! current-user-id ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6161,tmp=(C_word)a,a+=2,tmp));
t127=C_mutate((C_word*)lf[338]+1 /* (set! map-file-to-memory ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6167,tmp=(C_word)a,a+=2,tmp));
t128=C_mutate((C_word*)lf[339]+1 /* (set! file-link ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6173,tmp=(C_word)a,a+=2,tmp));
t129=C_mutate((C_word*)lf[340]+1 /* (set! file-lock ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6179,tmp=(C_word)a,a+=2,tmp));
t130=C_mutate((C_word*)lf[341]+1 /* (set! file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6185,tmp=(C_word)a,a+=2,tmp));
t131=C_mutate((C_word*)lf[342]+1 /* (set! file-select ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6191,tmp=(C_word)a,a+=2,tmp));
t132=C_mutate((C_word*)lf[343]+1 /* (set! file-test-lock ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6197,tmp=(C_word)a,a+=2,tmp));
t133=C_mutate((C_word*)lf[344]+1 /* (set! file-truncate ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6203,tmp=(C_word)a,a+=2,tmp));
t134=C_mutate((C_word*)lf[345]+1 /* (set! file-unlock ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6209,tmp=(C_word)a,a+=2,tmp));
t135=C_mutate((C_word*)lf[346]+1 /* (set! get-groups ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6215,tmp=(C_word)a,a+=2,tmp));
t136=C_mutate((C_word*)lf[347]+1 /* (set! group-information ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6221,tmp=(C_word)a,a+=2,tmp));
t137=C_mutate((C_word*)lf[348]+1 /* (set! initialize-groups ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6227,tmp=(C_word)a,a+=2,tmp));
t138=C_mutate((C_word*)lf[349]+1 /* (set! memory-mapped-file-pointer ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6233,tmp=(C_word)a,a+=2,tmp));
t139=C_mutate((C_word*)lf[350]+1 /* (set! parent-process-id ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6239,tmp=(C_word)a,a+=2,tmp));
t140=C_mutate((C_word*)lf[351]+1 /* (set! process-fork ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6245,tmp=(C_word)a,a+=2,tmp));
t141=C_mutate((C_word*)lf[352]+1 /* (set! process-group-id ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6251,tmp=(C_word)a,a+=2,tmp));
t142=C_mutate((C_word*)lf[353]+1 /* (set! process-signal ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6257,tmp=(C_word)a,a+=2,tmp));
t143=C_mutate((C_word*)lf[354]+1 /* (set! read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6263,tmp=(C_word)a,a+=2,tmp));
t144=C_mutate((C_word*)lf[355]+1 /* (set! set-alarm! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6269,tmp=(C_word)a,a+=2,tmp));
t145=C_mutate((C_word*)lf[356]+1 /* (set! set-group-id! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6275,tmp=(C_word)a,a+=2,tmp));
t146=C_mutate((C_word*)lf[357]+1 /* (set! set-groups! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6281,tmp=(C_word)a,a+=2,tmp));
t147=C_mutate((C_word*)lf[358]+1 /* (set! set-process-group-id! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6287,tmp=(C_word)a,a+=2,tmp));
t148=C_mutate((C_word*)lf[359]+1 /* (set! set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6293,tmp=(C_word)a,a+=2,tmp));
t149=C_mutate((C_word*)lf[360]+1 /* (set! set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6299,tmp=(C_word)a,a+=2,tmp));
t150=C_mutate((C_word*)lf[361]+1 /* (set! set-user-id! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6305,tmp=(C_word)a,a+=2,tmp));
t151=C_mutate((C_word*)lf[362]+1 /* (set! signal-mask ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6311,tmp=(C_word)a,a+=2,tmp));
t152=C_mutate((C_word*)lf[363]+1 /* (set! signal-mask! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6317,tmp=(C_word)a,a+=2,tmp));
t153=C_mutate((C_word*)lf[364]+1 /* (set! signal-masked? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6323,tmp=(C_word)a,a+=2,tmp));
t154=C_mutate((C_word*)lf[365]+1 /* (set! signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6329,tmp=(C_word)a,a+=2,tmp));
t155=C_mutate((C_word*)lf[366]+1 /* (set! terminal-name ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6335,tmp=(C_word)a,a+=2,tmp));
t156=C_mutate((C_word*)lf[367]+1 /* (set! terminal-size ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6341,tmp=(C_word)a,a+=2,tmp));
t157=C_mutate((C_word*)lf[368]+1 /* (set! unmap-file-from-memory ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6347,tmp=(C_word)a,a+=2,tmp));
t158=C_mutate((C_word*)lf[369]+1 /* (set! user-information ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6353,tmp=(C_word)a,a+=2,tmp));
t159=C_mutate((C_word*)lf[370]+1 /* (set! utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6359,tmp=(C_word)a,a+=2,tmp));
t160=C_mutate((C_word*)lf[371]+1 /* (set! string->time ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6365,tmp=(C_word)a,a+=2,tmp));
t161=C_set_block_item(lf[372] /* errno/wouldblock */,0,C_fix(0));
t162=C_mutate((C_word*)lf[76]+1 /* (set! fifo? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6372,tmp=(C_word)a,a+=2,tmp));
t163=C_mutate((C_word*)lf[373]+1 /* (set! memory-mapped-file? ...) */,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6375,tmp=(C_word)a,a+=2,tmp));
t164=C_set_block_item(lf[374] /* map/anonymous */,0,C_fix(0));
t165=C_set_block_item(lf[375] /* map/file */,0,C_fix(0));
t166=C_set_block_item(lf[376] /* map/fixed */,0,C_fix(0));
t167=C_set_block_item(lf[377] /* map/private */,0,C_fix(0));
t168=C_set_block_item(lf[378] /* map/shared */,0,C_fix(0));
t169=C_set_block_item(lf[379] /* open/fsync */,0,C_fix(0));
t170=C_set_block_item(lf[380] /* open/noctty */,0,C_fix(0));
t171=C_set_block_item(lf[381] /* open/nonblock */,0,C_fix(0));
t172=C_set_block_item(lf[382] /* open/sync */,0,C_fix(0));
t173=C_set_block_item(lf[383] /* perm/isgid */,0,C_fix(0));
t174=C_set_block_item(lf[384] /* perm/isuid */,0,C_fix(0));
t175=C_set_block_item(lf[385] /* perm/isvtx */,0,C_fix(0));
t176=C_set_block_item(lf[386] /* prot/exec */,0,C_fix(0));
t177=C_set_block_item(lf[387] /* prot/none */,0,C_fix(0));
t178=C_set_block_item(lf[388] /* prot/read */,0,C_fix(0));
t179=C_set_block_item(lf[389] /* prot/write */,0,C_fix(0));
t180=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t180+1)))(2,t180,C_SCHEME_UNDEFINED);}

/* memory-mapped-file? in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6375(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6375,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* fifo? in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6372(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6372,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}

/* string->time in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6365(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6365,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[371],lf[0]);}

/* utc-time->seconds in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6359(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6359,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[370],lf[0]);}

/* user-information in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6353(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6353,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[369],lf[0]);}

/* unmap-file-from-memory in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6347(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6347,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[368],lf[0]);}

/* terminal-size in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6341(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6341,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[367],lf[0]);}

/* terminal-name in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6335(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6335,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[366],lf[0]);}

/* signal-unmask! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6329(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6329,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[365],lf[0]);}

/* signal-masked? in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6323(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6323,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[364],lf[0]);}

/* signal-mask! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6317(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6317,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[363],lf[0]);}

/* signal-mask in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6311(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6311,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[362],lf[0]);}

/* set-user-id! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6305(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6305,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[361],lf[0]);}

/* set-signal-mask! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6299(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6299,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[360],lf[0]);}

/* set-root-directory! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6293(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6293,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[359],lf[0]);}

/* set-process-group-id! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6287(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6287,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[358],lf[0]);}

/* set-groups! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6281(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6281,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[357],lf[0]);}

/* set-group-id! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6275(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6275,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[356],lf[0]);}

/* set-alarm! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6269(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6269,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[355],lf[0]);}

/* read-symbolic-link in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6263(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6263,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[354],lf[0]);}

/* process-signal in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6257(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6257,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[353],lf[0]);}

/* process-group-id in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6251(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6251,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[352],lf[0]);}

/* process-fork in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6245(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6245,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[351],lf[0]);}

/* parent-process-id in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6239(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6239,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[350],lf[0]);}

/* memory-mapped-file-pointer in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6233(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6233,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[349],lf[0]);}

/* initialize-groups in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6227(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6227,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[348],lf[0]);}

/* group-information in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6221(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6221,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[347],lf[0]);}

/* get-groups in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6215(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6215,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[346],lf[0]);}

/* file-unlock in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6209(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6209,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[345],lf[0]);}

/* file-truncate in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6203(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6203,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[344],lf[0]);}

/* file-test-lock in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6197(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6197,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[343],lf[0]);}

/* file-select in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6191(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6191,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[342],lf[0]);}

/* file-lock/blocking in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6185(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6185,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[341],lf[0]);}

/* file-lock in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6179(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6179,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[340],lf[0]);}

/* file-link in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6173(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6173,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[339],lf[0]);}

/* map-file-to-memory in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6167(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6167,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[338],lf[0]);}

/* current-user-id in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6161(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6161,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[337],lf[0]);}

/* current-group-id in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6155(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6155,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[336],lf[0]);}

/* current-effective-user-name in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6149(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6149,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[335],lf[0]);}

/* current-effective-user-id in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6143(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6143,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[334],lf[0]);}

/* current-effective-group-id in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6137(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6137,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[333],lf[0]);}

/* create-symbolic-link in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6131(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6131,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[332],lf[0]);}

/* create-session in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6125(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6125,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[331],lf[0]);}

/* create-fifo in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6119(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6119,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[330],lf[0]);}

/* change-file-owner in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6113(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6113,2,t0,t1);}
/* error */
t2=*((C_word*)lf[329]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[328],lf[0]);}

/* find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5896(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+17)){
C_save_and_reclaim((void*)tr4r,(void*)f_5896r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5896r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5896r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(17);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5898,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6037,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6042,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6047,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action18821967 */
t9=t8;
f_6047(t9,t1);}
else{
t9=(C_word)C_u_i_car(t4);
t10=(C_word)C_slot(t4,C_fix(1));
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id18831963 */
t11=t7;
f_6042(t11,t1,t9);}
else{
t11=(C_word)C_u_i_car(t10);
t12=(C_word)C_slot(t10,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit18841958 */
t13=t6;
f_6037(t13,t1,t9,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
/* body18801890 */
t15=t5;
f_5898(t15,t1,t9,t11,t13);}}}}

/* def-action1882 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_6047(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6047,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6053,tmp=(C_word)a,a+=2,tmp);
/* def-id18831963 */
t3=((C_word*)t0)[2];
f_6042(t3,t1,t2);}

/* a6052 in def-action1882 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6053(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6053,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id1883 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_6042(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6042,NULL,3,t0,t1,t2);}
/* def-limit18841958 */
t3=((C_word*)t0)[2];
f_6037(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit1884 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_6037(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6037,NULL,4,t0,t1,t2,t3);}
/* body18801890 */
t4=((C_word*)t0)[2];
f_5898(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5898(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5898,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[321]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5905,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=t2,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_5905(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6032,a[2]=t4,a[3]=t7,tmp=(C_word)a,a+=4,tmp):t4));}
else{
t10=t8;
f_5905(t10,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f_6024,tmp=(C_word)a,a+=2,tmp));}}

/* f_6024 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6024(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6024,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_6032 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6032(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6032,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5905(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5905,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6016,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5915,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6012,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 2056 make-pathname */
t6=((C_word*)t0)[7];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],lf[327]);}

/* k6010 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6012(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2056 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5915(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5915,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5917,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_5917(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5917(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5917,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_5936,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixwin.scm: 2062 directory? */
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k5934 in loop in k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5936(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5936,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5992,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm: 2063 pathname-file */
t3=*((C_word*)lf[326]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5998,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 2069 pproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}}

/* k5996 in k5934 in loop in k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5998(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5998,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6005,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 2069 action */
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixwin.scm: 2070 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_5917(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k6003 in k5996 in k5934 in loop in k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6005(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2069 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_5917(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k5990 in k5934 in loop in k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5992(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5992,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[322]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[323]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixwin.scm: 2063 loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_5917(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5951,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posixwin.scm: 2064 lproc */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}}

/* k5949 in k5990 in k5934 in loop in k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5951(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5951,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5961,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5963,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5968,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],tmp=(C_word)a,a+=7,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5982,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* ##sys#dynamic-wind */
t11=*((C_word*)lf[325]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
/* posixwin.scm: 2068 loop */
t2=((C_word*)((C_word*)t0)[8])[1];
f_5917(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a5981 in k5949 in k5990 in k5934 in loop in k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5982(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5982,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* a5967 in k5949 in k5990 in k5934 in loop in k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5968(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5968,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5976,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5980,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 2067 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[2],lf[324]);}

/* k5978 in a5967 in k5949 in k5990 in k5934 in loop in k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5980(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2067 glob */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5974 in a5967 in k5949 in k5990 in k5934 in loop in k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5976(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2067 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_5917(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a5962 in k5949 in k5990 in k5934 in loop in k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5963(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5963,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}

/* k5959 in k5949 in k5990 in k5934 in loop in k5913 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5961(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2065 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_5917(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_6016 in k5903 in body1880 in find-files in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_6016(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6016,3,t0,t1,t2);}
/* posixwin.scm: 2054 string-match */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* current-user-name in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5881(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5881,2,t0,t1);}
if(C_truep((C_word)C_get_user_name())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_username),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5891,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 2030 ##sys#update-errno */
t3=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k5889 in current-user-name in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5891(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2031 ##sys#error */
t2=*((C_word*)lf[132]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[115],lf[320]);}

/* system-information in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5850(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5850,2,t0,t1);}
if(C_truep((C_word)C_sysinfo())){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5861,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5876,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 2021 ##sys#update-errno */
t3=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k5874 in system-information in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5876(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 2022 ##sys#error */
t2=*((C_word*)lf[132]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[317],lf[319]);}

/* k5859 in system-information in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5861(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5861,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5865,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osrel),C_fix(0));}

/* k5863 in k5859 in system-information in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5865(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5865,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5869,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_osver),C_fix(0));}

/* k5867 in k5863 in k5859 in system-information in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5869(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5869,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5873,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_processor),C_fix(0));}

/* k5871 in k5867 in k5863 in k5859 in system-information in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5873(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5873,2,t0,t1);}
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,lf[318],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* get-host-name in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5838(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5838,2,t0,t1);}
if(C_truep((C_word)C_get_hostname())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,C_mpointer(&a,(void*)C_hostname),C_fix(0));}
else{
/* posixwin.scm: 2011 ##sys#error */
t2=*((C_word*)lf[132]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,lf[315],lf[316]);}}

/* sleep in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5835(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5835,3,t0,t1,t2);}
t3=(C_word)C_sleep(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_fix(0));}

/* process-wait in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5778(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_5778r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5778r(t0,t1,t2,t3);}}

static void C_ccall f_5778r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(7);
t4=(C_word)C_i_nullp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_u_i_car(t3));
t6=(C_word)C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t3,C_fix(1)));
t8=(C_word)C_i_check_exact_2(t2,lf[312]);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5796,a[2]=t5,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5802,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t9,t10);}

/* a5801 in process-wait in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5802(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5802,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5812,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1993 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
/* posixwin.scm: 1995 values */
C_values(5,0,t1,t2,t3,t4);}}

/* k5810 in a5801 in process-wait in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1994 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[305],lf[312],lf[313],((C_word*)t0)[2]);}

/* a5795 in process-wait in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5796(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5796,2,t0,t1);}
/* posixwin.scm: 1990 ##sys#process-wait */
t2=*((C_word*)lf[311]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5766(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5766,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_process_wait(t2,t3))){
/* posixwin.scm: 1983 values */
C_values(5,0,t1,t2,C_SCHEME_TRUE,C_fix((C_word)C_exstatus));}
else{
/* posixwin.scm: 1984 values */
C_values(5,0,t1,C_fix(-1),C_SCHEME_FALSE,C_SCHEME_FALSE);}}

/* process* in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5689(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr3r,(void*)f_5689r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5689r(t0,t1,t2,t3);}}

static void C_ccall f_5689r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(13);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5691,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5696,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5701,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5706,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args17751798 */
t8=t7;
f_5706(t8,t1);}
else{
t8=(C_word)C_u_i_car(t3);
t9=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t9))){
/* def-env17761794 */
t10=t6;
f_5701(t10,t1,t8);}
else{
t10=(C_word)C_u_i_car(t9);
t11=(C_word)C_slot(t9,C_fix(1));
if(C_truep((C_word)C_i_nullp(t11))){
/* def-exactf17771789 */
t12=t5;
f_5696(t12,t1,t8,t10);}
else{
t12=(C_word)C_u_i_car(t11);
t13=(C_word)C_slot(t11,C_fix(1));
/* body17731783 */
t14=t4;
f_5691(t14,t1,t8,t10,t12);}}}}

/* def-args1775 in process* in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5706(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5706,NULL,2,t0,t1);}
/* def-env17761794 */
t2=((C_word*)t0)[2];
f_5701(t2,t1,C_SCHEME_FALSE);}

/* def-env1776 in process* in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5701(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5701,NULL,3,t0,t1,t2);}
/* def-exactf17771789 */
t3=((C_word*)t0)[2];
f_5696(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf1777 in process* in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5696(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5696,NULL,4,t0,t1,t2,t3);}
/* body17731783 */
t4=((C_word*)t0)[2];
f_5691(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1773 in process* in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5691(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5691,NULL,5,t0,t1,t2,t3,t4);}
/* posixwin.scm: 1977 %process */
f_5550(t1,lf[310],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3,t4);}

/* process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5612(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr3r,(void*)f_5612r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5612r(t0,t1,t2,t3);}}

static void C_ccall f_5612r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(13);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5614,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5619,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5624,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5629,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args17201743 */
t8=t7;
f_5629(t8,t1);}
else{
t8=(C_word)C_u_i_car(t3);
t9=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t9))){
/* def-env17211739 */
t10=t6;
f_5624(t10,t1,t8);}
else{
t10=(C_word)C_u_i_car(t9);
t11=(C_word)C_slot(t9,C_fix(1));
if(C_truep((C_word)C_i_nullp(t11))){
/* def-exactf17221734 */
t12=t5;
f_5619(t12,t1,t8,t10);}
else{
t12=(C_word)C_u_i_car(t11);
t13=(C_word)C_slot(t11,C_fix(1));
/* body17181728 */
t14=t4;
f_5614(t14,t1,t8,t10,t12);}}}}

/* def-args1720 in process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5629(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5629,NULL,2,t0,t1);}
/* def-env17211739 */
t2=((C_word*)t0)[2];
f_5624(t2,t1,C_SCHEME_FALSE);}

/* def-env1721 in process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5624(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5624,NULL,3,t0,t1,t2);}
/* def-exactf17221734 */
t3=((C_word*)t0)[2];
f_5619(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf1722 in process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5619(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5619,NULL,4,t0,t1,t2,t3);}
/* body17181728 */
t4=((C_word*)t0)[2];
f_5614(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1718 in process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5614(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5614,NULL,5,t0,t1,t2,t3,t4);}
/* posixwin.scm: 1974 %process */
f_5550(t1,lf[309],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3,t4);}

/* %process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5550(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5550,NULL,7,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5552,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t12=(C_word)C_i_check_string_2(((C_word*)t8)[1],t2);
t13=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5571,a[2]=t11,a[3]=t1,a[4]=t10,a[5]=t3,a[6]=t6,a[7]=t9,a[8]=t8,a[9]=t2,tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixwin.scm: 1962 chkstrlst */
t14=t11;
f_5552(t14,t13,((C_word*)t9)[1]);}
else{
t14=C_set_block_item(t10,0,C_SCHEME_TRUE);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5606,a[2]=t13,a[3]=t8,a[4]=t9,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1965 ##sys#shell-command-arguments */
t16=*((C_word*)lf[301]+1);
((C_proc3)(void*)(*((C_word*)t16+1)))(3,t16,t15,((C_word*)t8)[1]);}}

/* k5604 in %process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5606(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5606,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5610,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1966 ##sys#shell-command */
t4=*((C_word*)lf[297]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k5608 in k5604 in %process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5610(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_5571(2,t3,t2);}

/* k5569 in %process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5571(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5571,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5574,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[6])){
/* posixwin.scm: 1967 chkstrlst */
t3=((C_word*)t0)[2];
f_5552(t3,t2,((C_word*)t0)[6]);}
else{
t3=t2;
f_5574(2,t3,C_SCHEME_UNDEFINED);}}

/* k5572 in k5569 in %process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5574(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5574,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5579,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5585,a[2]=((C_word*)t0)[4],tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a5584 in k5572 in k5569 in %process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5585(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_5585,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixwin.scm: 1970 values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixwin.scm: 1971 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a5578 in k5572 in k5569 in %process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5579(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5579,2,t0,t1);}
/* posixwin.scm: 1968 ##sys#process */
t2=*((C_word*)lf[304]+1);
((C_proc10)(void*)(*((C_word*)t2+1)))(10,t2,t1,((C_word*)t0)[7],((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[4],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[3],((C_word*)((C_word*)t0)[2])[1]);}

/* chkstrlst in %process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5552(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5552,NULL,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5561,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* for-each */
t5=*((C_word*)lf[92]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t4,t2);}

/* a5560 in chkstrlst in %process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5561(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5561,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5454(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,...){
C_word tmp;
C_word t9;
va_list v;
C_word *a,c2=c;
C_save_rest(t8,c2,9);
if(!C_demand(c*C_SIZEOF_PAIR+14)){
C_save_and_reclaim((void*)tr9rv,(void*)f_5454r,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
else{
a=C_alloc((c-9)*3);
t9=C_restore_rest_vector(a,C_rest_count(0));
f_5454r(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}}

static void C_ccall f_5454r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9){
C_word tmp;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(14);
t10=(C_word)C_vemptyp(t9);
t11=(C_truep(t10)?C_SCHEME_FALSE:(C_word)C_slot(t9,C_fix(0)));
t12=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5461,a[2]=t2,a[3]=t6,a[4]=t7,a[5]=t8,a[6]=t1,a[7]=t3,tmp=(C_word)a,a+=8,tmp);
t13=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5533,a[2]=t12,tmp=(C_word)a,a+=3,tmp);
t14=(C_word)C_a_i_cons(&a,2,t3,t4);
/* posixwin.scm: 1934 $quote-args-list */
t15=lf[286];
f_4987(t15,t13,t14,t11);}

/* k5531 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5533(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1934 string-intersperse */
t2=*((C_word*)lf[113]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5459 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5461(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[25],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5461,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t3=((*(int *)C_data_pointer(t2))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t5=((*(int *)C_data_pointer(t4))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t6=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t7=((*(int *)C_data_pointer(t6))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t8=(C_word)C_a_i_bytevector(&a,1,C_fix(1));
t9=((*(int *)C_data_pointer(t8))=C_unfix(C_fix(-1)),C_SCHEME_UNDEFINED);
t10=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_5501,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=((C_word*)t0)[3],a[5]=t4,a[6]=((C_word*)t0)[4],a[7]=t8,a[8]=((C_word*)t0)[5],a[9]=t2,a[10]=((C_word*)t0)[6],a[11]=t1,a[12]=((C_word*)t0)[7],tmp=(C_word)a,a+=13,tmp);
/* ##sys#make-locative */
t11=*((C_word*)lf[307]+1);
((C_proc6)(void*)(*((C_word*)t11+1)))(6,t11,t10,t2,C_fix(0),C_SCHEME_FALSE,lf[308]);}

/* k5499 in k5459 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5501(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5501,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_5505,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],tmp=(C_word)a,a+=14,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[307]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[5],C_fix(0),C_SCHEME_FALSE,lf[308]);}

/* k5503 in k5499 in k5459 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5505(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5505,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_5509,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],tmp=(C_word)a,a+=15,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[307]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[3],C_fix(0),C_SCHEME_FALSE,lf[308]);}

/* k5507 in k5503 in k5499 in k5459 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5509(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5509,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|15,a[1]=(C_word)f_5513,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],a[15]=((C_word*)t0)[14],tmp=(C_word)a,a+=16,tmp);
/* ##sys#make-locative */
t3=*((C_word*)lf[307]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[7],C_fix(0),C_SCHEME_FALSE,lf[308]);}

/* k5511 in k5507 in k5503 in k5499 in k5459 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5513(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5513,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|16,a[1]=(C_word)f_5517,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=t1,a[12]=((C_word*)t0)[11],a[13]=((C_word*)t0)[12],a[14]=((C_word*)t0)[13],a[15]=((C_word*)t0)[14],a[16]=((C_word*)t0)[15],tmp=(C_word)a,a+=17,tmp);
t3=(C_truep(((C_word*)t0)[6])?C_fix(0):C_fix(1));
t4=(C_truep(((C_word*)t0)[4])?C_fix(0):C_fix(2));
t5=(C_truep(((C_word*)t0)[8])?C_fix(0):C_fix(4));
/* posixwin.scm: 1941 + */
C_plus(5,0,t2,t3,t4,t5);}

/* k5515 in k5511 in k5507 in k5503 in k5499 in k5459 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5517(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5517,2,t0,t1);}
t2=((C_word*)t0)[16];
t3=((C_word*)t0)[15];
t4=((C_word*)t0)[14];
t5=((C_word*)t0)[13];
t6=((C_word*)t0)[12];
t7=((C_word*)t0)[11];
t8=(*a=C_CLOSURE_TYPE|17,a[1]=(C_word)f_5408,a[2]=t3,a[3]=((C_word*)t0)[15],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=t1,a[14]=t7,a[15]=t6,a[16]=t5,a[17]=t4,tmp=(C_word)a,a+=18,tmp);
if(C_truep(t2)){
/* ##sys#make-c-string */
t9=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t9=t8;
f_5408(2,t9,C_SCHEME_FALSE);}}

/* k5406 in k5515 in k5511 in k5507 in k5503 in k5499 in k5459 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5408(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5408,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|17,a[1]=(C_word)f_5412,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=t1,a[14]=((C_word*)t0)[14],a[15]=((C_word*)t0)[15],a[16]=((C_word*)t0)[16],a[17]=((C_word*)t0)[17],tmp=(C_word)a,a+=18,tmp);
if(C_truep(((C_word*)t0)[2])){
/* ##sys#make-c-string */
t3=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t3=t2;
f_5412(2,t3,C_SCHEME_FALSE);}}

/* k5410 in k5406 in k5515 in k5511 in k5507 in k5503 in k5499 in k5459 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5412(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5412,2,t0,t1);}
t2=(C_truep(((C_word*)t0)[17])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[17]):C_SCHEME_FALSE);
t3=(C_truep(((C_word*)t0)[16])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[16]):C_SCHEME_FALSE);
t4=(C_truep(((C_word*)t0)[15])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[15]):C_SCHEME_FALSE);
t5=(C_truep(((C_word*)t0)[14])?(C_word)C_i_foreign_pointer_argumentp(((C_word*)t0)[14]):C_SCHEME_FALSE);
if(C_truep((C_word)stub1542(C_SCHEME_UNDEFINED,((C_word*)t0)[13],t1,C_SCHEME_FALSE,t2,t3,t4,t5,((C_word*)t0)[12]))){
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5474,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[5])){
/* posixwin.scm: 1944 open-input-file* */
t7=*((C_word*)lf[237]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[4]))));}
else{
t7=t6;
f_5474(2,t7,C_SCHEME_FALSE);}}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5494,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[11],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1949 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* k5492 in k5410 in k5406 in k5515 in k5511 in k5507 in k5503 in k5499 in k5459 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5494(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1950 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[305],((C_word*)t0)[3],lf[306],((C_word*)t0)[2]);}

/* k5472 in k5410 in k5406 in k5515 in k5511 in k5507 in k5503 in k5499 in k5459 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5474,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5478,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm: 1945 open-output-file* */
t3=*((C_word*)lf[238]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
t3=t2;
f_5478(2,t3,C_SCHEME_FALSE);}}

/* k5476 in k5472 in k5410 in k5406 in k5515 in k5511 in k5507 in k5503 in k5499 in k5459 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5478(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5478,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5482,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posixwin.scm: 1947 open-input-file* */
t3=*((C_word*)lf[237]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))));}
else{
t3=t2;
f_5482(2,t3,C_SCHEME_FALSE);}}

/* k5480 in k5476 in k5472 in k5410 in k5406 in k5515 in k5511 in k5507 in k5503 in k5499 in k5459 in ##sys#process in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5482(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1943 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],C_fix((C_word)*((int *)C_data_pointer(((C_word*)t0)[2]))),t1);}

/* process-run in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5374(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5374r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5374r(t0,t1,t2,t3);}}

static void C_ccall f_5374r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t5)){
/* posixwin.scm: 1905 process-spawn */
t6=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,*((C_word*)lf[282]+1),t2,t5);}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5391,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1906 ##sys#shell-command */
t7=*((C_word*)lf[297]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}

/* k5389 in process-run in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5391(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5391,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5395,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1906 ##sys#shell-command-arguments */
t3=*((C_word*)lf[301]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k5393 in k5389 in process-run in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5395(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1906 process-spawn */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],*((C_word*)lf[282]+1),((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5368(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5368,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_a_i_list(&a,2,lf[302],t2));}

/* ##sys#shell-command in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5347(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5347,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5351,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1889 get-environment-variable */
t3=*((C_word*)lf[299]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[300]);}

/* k5349 in ##sys#shell-command in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5351(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5351,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
if(C_truep((C_word)C_get_shlcmd())){
/* ##sys#peek-c-string */
t2=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_mpointer(&a,(void*)C_shlcmd),C_fix(0));}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5363,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1893 ##sys#update-errno */
t3=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}}

/* k5361 in k5349 in ##sys#shell-command in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1894 ##sys#error */
t2=*((C_word*)lf[132]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[297],lf[298]);}

/* current-process-id in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5344(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5344,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub1502(C_SCHEME_UNDEFINED));}

/* process-spawn in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5260(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr4r,(void*)f_5260r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5260r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5260r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(13);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5262,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5274,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5279,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5284,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-arglst14631488 */
t9=t8;
f_5284(t9,t1);}
else{
t9=(C_word)C_u_i_car(t4);
t10=(C_word)C_slot(t4,C_fix(1));
if(C_truep((C_word)C_i_nullp(t10))){
/* def-envlst14641484 */
t11=t7;
f_5279(t11,t1,t9);}
else{
t11=(C_word)C_u_i_car(t10);
t12=(C_word)C_slot(t10,C_fix(1));
if(C_truep((C_word)C_i_nullp(t12))){
/* def-exactf14651479 */
t13=t6;
f_5274(t13,t1,t9,t11);}
else{
t13=(C_word)C_u_i_car(t12);
t14=(C_word)C_slot(t12,C_fix(1));
/* body14611471 */
t15=t5;
f_5262(t15,t1,t9,t11,t13);}}}}

/* def-arglst1463 in process-spawn in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5284(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5284,NULL,2,t0,t1);}
/* def-envlst14641484 */
t2=((C_word*)t0)[2];
f_5279(t2,t1,C_SCHEME_FALSE);}

/* def-envlst1464 in process-spawn in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5279(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5279,NULL,3,t0,t1,t2);}
/* def-exactf14651479 */
t3=((C_word*)t0)[2];
f_5274(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf1465 in process-spawn in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5274(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5274,NULL,4,t0,t1,t2,t3);}
/* body14611471 */
t4=((C_word*)t0)[2];
f_5262(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1461 in process-spawn in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5262(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5262,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5266,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1880 $exec-setup */
t6=lf[290];
f_5128(t6,t5,lf[294],((C_word*)t0)[2],t2,t3,t4);}

/* k5264 in body1461 in process-spawn in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5266(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[5])?(C_word)C_spawnvpe(((C_word*)t0)[4],t1):(C_word)C_spawnvp(((C_word*)t0)[4],t1));
/* posixwin.scm: 1881 $exec-teardown */
f_5161(((C_word*)t0)[3],lf[294],lf[295],((C_word*)t0)[2],t2);}

/* process-execute in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5176(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr3r,(void*)f_5176r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5176r(t0,t1,t2,t3);}}

static void C_ccall f_5176r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a=C_alloc(12);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5178,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5190,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5195,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5200,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglst14031428 */
t8=t7;
f_5200(t8,t1);}
else{
t8=(C_word)C_u_i_car(t3);
t9=(C_word)C_slot(t3,C_fix(1));
if(C_truep((C_word)C_i_nullp(t9))){
/* def-envlst14041424 */
t10=t6;
f_5195(t10,t1,t8);}
else{
t10=(C_word)C_u_i_car(t9);
t11=(C_word)C_slot(t9,C_fix(1));
if(C_truep((C_word)C_i_nullp(t11))){
/* def-exactf14051419 */
t12=t5;
f_5190(t12,t1,t8,t10);}
else{
t12=(C_word)C_u_i_car(t11);
t13=(C_word)C_slot(t11,C_fix(1));
/* body14011411 */
t14=t4;
f_5178(t14,t1,t8,t10,t12);}}}}

/* def-arglst1403 in process-execute in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5200(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5200,NULL,2,t0,t1);}
/* def-envlst14041424 */
t2=((C_word*)t0)[2];
f_5195(t2,t1,C_SCHEME_FALSE);}

/* def-envlst1404 in process-execute in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5195(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5195,NULL,3,t0,t1,t2);}
/* def-exactf14051419 */
t3=((C_word*)t0)[2];
f_5190(t3,t1,t2,C_SCHEME_FALSE);}

/* def-exactf1405 in process-execute in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5190(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5190,NULL,4,t0,t1,t2,t3);}
/* body14011411 */
t4=((C_word*)t0)[2];
f_5178(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1401 in process-execute in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5178(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5178,NULL,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5182,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1875 $exec-setup */
t6=lf[290];
f_5128(t6,t5,lf[292],((C_word*)t0)[2],t2,t3,t4);}

/* k5180 in body1401 in process-execute in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5182(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
/* posixwin.scm: 1876 $exec-teardown */
f_5161(((C_word*)t0)[3],lf[292],lf[293],((C_word*)t0)[2],t2);}

/* $exec-teardown in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5161(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5161,NULL,5,t1,t2,t3,t4,t5);}
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5165,a[2]=t4,a[3]=t3,a[4]=t2,a[5]=t1,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1867 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k5163 in $exec-teardown in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5165(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_free_exec_args();
t3=(C_word)C_free_exec_env();
t4=(C_word)C_eqp(((C_word*)t0)[6],C_fix(-1));
if(C_truep(t4)){
/* posixwin.scm: 1871 ##sys#error */
t5=*((C_word*)lf[132]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t5=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[6]);}}

/* $exec-setup in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5128(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5128,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(C_word)C_i_check_string_2(t3,t2);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5135,a[2]=t6,a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t5,a[7]=t2,a[8]=((C_word*)t0)[5],a[9]=t3,a[10]=t1,tmp=(C_word)a,a+=11,tmp);
/* posixwin.scm: 1859 pathname-strip-directory */
t9=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t3);}

/* k5133 in $exec-setup in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5135(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5135,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5138,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t3=(C_word)C_block_size(t1);
/* posixwin.scm: 1860 setarg */
t4=((C_word*)t0)[4];
f_5066(5,t4,t2,C_fix(0),t1,t3);}

/* k5136 in k5133 in $exec-setup in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5138(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5138,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5141,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5155,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[7],a[4]=t2,a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1861 $quote-args-list */
t4=lf[286];
f_4987(t4,t3,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k5153 in k5136 in k5133 in $exec-setup in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5155(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1861 build-exec-argvec */
f_5078(((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2],C_fix(1));}

/* k5139 in k5136 in k5133 in $exec-setup in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5141(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5141,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5144,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1862 build-exec-argvec */
f_5078(t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0));}

/* k5142 in k5139 in k5136 in k5133 in $exec-setup in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5144(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5144,2,t0,t1);}
t2=(C_word)C_flushall();
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5151,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1864 ##sys#expand-home-path */
t4=*((C_word*)lf[38]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k5149 in k5142 in k5139 in k5136 in k5133 in $exec-setup in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5151(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1864 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* build-exec-argvec in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5078(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5078,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep(t3)){
t6=(C_word)C_i_check_list_2(t3,t2);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5090,a[2]=t8,a[3]=t2,a[4]=t4,tmp=(C_word)a,a+=5,tmp));
t10=((C_word*)t8)[1];
f_5090(t10,t1,t3,t5);}
else{
/* posixwin.scm: 1856 argvec-setter */
t6=t4;
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t5,C_SCHEME_FALSE,C_fix(0));}}

/* doloop1341 in build-exec-argvec in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5090(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5090,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
/* posixwin.scm: 1852 argvec-setter */
t4=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t1,t3,C_SCHEME_FALSE,C_fix(0));}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,((C_word*)t0)[3]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5109,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t7=(C_word)C_block_size(t4);
/* posixwin.scm: 1855 argvec-setter */
t8=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,t3,t4,t7);}}

/* k5107 in doloop1341 in build-exec-argvec in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5109(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)((C_word*)t0)[3])[1];
f_5090(t4,((C_word*)t0)[2],t2,t3);}

/* setenv in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5072(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5072,5,t0,t1,t2,t3,t4);}
t5=(C_truep(t3)?t3:C_SCHEME_FALSE);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub1327(C_SCHEME_UNDEFINED,t2,t5,t4));}

/* setarg in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5066(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5066,5,t0,t1,t2,t3,t4);}
t5=(C_truep(t3)?t3:C_SCHEME_FALSE);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub1315(C_SCHEME_UNDEFINED,t2,t5,t4));}

/* $quote-args-list in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4987(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4987,NULL,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4992,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5030,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t6,tmp=(C_word)a,a+=5,tmp));
t8=((C_word*)t6)[1];
f_5030(t8,t1,t2,C_SCHEME_END_OF_LIST);}}

/* loop in $quote-args-list in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5030(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5030,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
/* posixwin.scm: 1833 reverse */
t4=*((C_word*)lf[121]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5058,a[2]=t5,a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5061,a[2]=t4,a[3]=t6,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1838 needs-quoting? */
t8=((C_word*)t0)[2];
f_4992(t8,t7,t4);}}

/* k5059 in loop in $quote-args-list in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5061(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixwin.scm: 1838 string-append */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[287],((C_word*)t0)[2],lf[288]);}
else{
t2=((C_word*)t0)[3];
f_5058(2,t2,((C_word*)t0)[2]);}}

/* k5056 in loop in $quote-args-list in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5058(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5058,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,t1,((C_word*)t0)[5]);
/* posixwin.scm: 1835 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_5030(t3,((C_word*)t0)[3],((C_word*)t0)[2],t2);}

/* needs-quoting? in $quote-args-list in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4992(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4992,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4996,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1825 string-length */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k4994 in needs-quoting? in $quote-args-list in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4996(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4996,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5001,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=t1,tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_5001(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k4994 in needs-quoting? in $quote-args-list in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_5001(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5001,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(t2,((C_word*)t0)[6]);
if(C_truep(t3)){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5014,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5025,a[2]=t4,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1829 string-ref */
t6=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],t2);}}

/* k5023 in loop in k4994 in needs-quoting? in $quote-args-list in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5025(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1829 char-whitespace? */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5012 in loop in k4994 in needs-quoting? in $quote-args-list in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_5014(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}
else{
t2=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1830 loop */
t3=((C_word*)((C_word*)t0)[2])[1];
f_5001(t3,((C_word*)t0)[4],t2);}}

/* glob in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4875(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr2r,(void*)f_4875r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4875r(t0,t1,t2);}}

static void C_ccall f_4875r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(11);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4881,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t4,a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp));
t6=((C_word*)t4)[1];
f_4881(t6,t1,t2);}

/* conc-loop in glob in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4881(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4881,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_u_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4896,a[2]=t3,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4902,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=t2,tmp=(C_word)a,a+=9,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t4,t5);}}

/* a4901 in conc-loop in glob in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4902(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4902,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4906,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],tmp=(C_word)a,a+=10,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4976,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[279]);
/* posixwin.scm: 1787 make-pathname */
t8=((C_word*)t0)[6];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k4974 in a4901 in conc-loop in glob in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4976(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1787 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4904 in a4901 in conc-loop in glob in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4906(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4906,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4909,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm: 1788 regexp */
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k4907 in k4904 in a4901 in conc-loop in glob in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4909(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4909,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4916,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t3=(C_truep(((C_word*)t0)[5])?((C_word*)t0)[5]:lf[278]);
/* posixwin.scm: 1789 directory */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,t3,C_SCHEME_TRUE);}

/* k4914 in k4907 in k4904 in a4901 in conc-loop in glob in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4916(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4916,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4918,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=t3,a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_4918(t5,((C_word*)t0)[2],t1);}

/* loop in k4914 in k4907 in k4904 in a4901 in conc-loop in glob in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4918(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4918,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_slot(((C_word*)t0)[8],C_fix(1));
/* posixwin.scm: 1790 conc-loop */
t4=((C_word*)((C_word*)t0)[7])[1];
f_4881(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4935,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_u_i_car(t2);
/* posixwin.scm: 1791 string-match */
t5=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k4933 in loop in k4914 in k4907 in k4904 in a4901 in conc-loop in glob in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4935(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4935,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4945,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(t1);
/* posixwin.scm: 1792 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
/* posixwin.scm: 1793 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_4918(t3,((C_word*)t0)[6],t2);}}

/* k4943 in k4933 in loop in k4914 in k4907 in k4904 in a4901 in conc-loop in glob in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4945(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4945,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4949,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1792 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_4918(t4,t2,t3);}

/* k4947 in k4943 in k4933 in loop in k4914 in k4907 in k4904 in a4901 in conc-loop in glob in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4949(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4949,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a4895 in conc-loop in glob in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4896(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4896,2,t0,t1);}
/* posixwin.scm: 1786 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* set-buffering-mode! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4816(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_4816r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_4816r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4816r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4820,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1758 ##sys#check-port */
t6=*((C_word*)lf[143]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[266]);}

/* k4818 in set-buffering-mode! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4820(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4820,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4826,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[268]);
if(C_truep(t6)){
t7=t5;
f_4826(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[269]);
if(C_truep(t7)){
t8=t5;
f_4826(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[270]);
if(C_truep(t8)){
t9=t5;
f_4826(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixwin.scm: 1764 ##sys#error */
t9=*((C_word*)lf[132]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[266],lf[271],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k4824 in k4818 in set-buffering-mode! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4826(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[266]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[82],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posixwin.scm: 1770 ##sys#error */
t6=*((C_word*)lf[132]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[266],lf[267],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* terminal-port? in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4810(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4810,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4814,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1748 ##sys#check-port */
t4=*((C_word*)lf[143]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[265]);}

/* k4812 in terminal-port? in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4814(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}

/* _exit in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4794(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr2rv,(void*)f_4794r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_4794r(t0,t1,t2);}}

static void C_ccall f_4794r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
t3=(C_word)C_notvemptyp(t2);
t4=(C_truep(t3)?(C_word)C_slot(t2,C_fix(0)):C_fix(0));
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub1153(C_SCHEME_UNDEFINED,t4));}

/* local-timezone-abbreviation in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4786(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4786,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub1145(t2),C_fix(0));}

/* local-time->seconds in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4771(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4771,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4775,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1730 check-time-vector */
f_4636(t3,lf[260],t2);}

/* k4773 in local-time->seconds in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4775(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixwin.scm: 1732 ##sys#cons-flonum */
t2=*((C_word*)lf[261]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixwin.scm: 1733 ##sys#error */
t2=*((C_word*)lf[132]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[260],lf[262],((C_word*)t0)[3]);}}

/* time->string in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4711(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4711r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4711r(t0,t1,t2,t3);}}

static void C_ccall f_4711r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4718,a[2]=t2,a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1718 check-time-vector */
f_4636(t6,lf[257],t2);}

/* k4716 in time->string in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4718(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4718,2,t0,t1);}
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_i_check_string_2(((C_word*)t0)[4],lf[257]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4727,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4737,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1722 ##sys#make-c-string */
t5=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[4]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4740,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub1094(t4,t3),C_fix(0));}}

/* k4738 in k4716 in time->string in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4740(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_u_fixnum_difference(t2,C_fix(1));
/* posixwin.scm: 1726 ##sys#substring */
t4=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixwin.scm: 1727 ##sys#error */
t2=*((C_word*)lf[132]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[257],lf[259],((C_word*)t0)[2]);}}

/* k4735 in k4716 in time->string in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4737(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4737,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],(C_word)stub1102(t3,t2,t1),C_fix(0));}

/* k4725 in k4716 in time->string in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4727(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}
else{
/* posixwin.scm: 1723 ##sys#error */
t2=*((C_word*)lf[132]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[257],lf[258],((C_word*)t0)[2]);}}

/* seconds->string in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4678(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4678,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4682,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub1079(t5,t4),C_fix(0));}

/* k4680 in seconds->string in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4682(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_block_size(t1);
t3=(C_word)C_u_fixnum_difference(t2,C_fix(1));
/* posixwin.scm: 1711 ##sys#substring */
t4=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],t1,C_fix(0),t3);}
else{
/* posixwin.scm: 1712 ##sys#error */
t2=*((C_word*)lf[132]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[255],lf[256],((C_word*)t0)[2]);}}

/* seconds->utc-time in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4664(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4664,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[254]);
/* posixwin.scm: 1704 ##sys#decode-seconds */
t4=*((C_word*)lf[253]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4655(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4655,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[252]);
/* posixwin.scm: 1700 ##sys#decode-seconds */
t4=*((C_word*)lf[253]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* check-time-vector in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4636(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4636,NULL,3,t1,t2,t3);}
t4=(C_word)C_i_check_vector_2(t3,t2);
t5=(C_word)C_block_size(t3);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixwin.scm: 1696 ##sys#error */
t6=*((C_word*)lf[132]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t1,t2,lf[251],t3);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* get-environment-variables in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4570,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4576,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_4576(t5,t1,C_fix(0));}

/* loop in get-environment-variables in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4576(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4576,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4580,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t6=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub1035(t5,t4),C_fix(0));}

/* k4578 in loop in get-environment-variables in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4580(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4580,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4588,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_4588(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k4578 in loop in get-environment-variables in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4588(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(8);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4588,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4614,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 1685 substring */
t5=((C_word*)t0)[3];
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
/* posixwin.scm: 1686 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k4612 in scan in k4578 in loop in get-environment-variables in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4614,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4618,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[3]);
/* posixwin.scm: 1685 substring */
t5=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

/* k4616 in k4612 in scan in k4578 in loop in get-environment-variables in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4618(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4618,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4606,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1685 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_4576(t5,t3,t4);}

/* k4604 in k4616 in k4612 in scan in k4578 in loop in get-environment-variables in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4606(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4606,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4555(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4555,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[246]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4563,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1673 ##sys#make-c-string */
t5=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k4561 in unsetenv in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4563(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4538(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4538,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[245]);
t5=(C_word)C_i_check_string_2(t3,lf[245]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4549,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1668 ##sys#make-c-string */
t7=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k4547 in setenv in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4549(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4549,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4553,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1668 ##sys#make-c-string */
t3=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4551 in k4547 in setenv in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4553(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* duplicate-fileno in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4508(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4508r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4508r(t0,t1,t2,t3);}}

static void C_ccall f_4508r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[243]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4515,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_4515(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_slot(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[243]);
t8=t5;
f_4515(t8,(C_word)C_dup2(t2,t6));}}

/* k4513 in duplicate-fileno in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4515(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4515,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4518,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4524,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1657 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_4518(2,t3,C_SCHEME_UNDEFINED);}}

/* k4522 in k4513 in duplicate-fileno in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4524(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1658 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[35],lf[243],lf[244],((C_word*)t0)[2]);}

/* k4516 in k4513 in duplicate-fileno in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4518(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4473(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4473,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4477,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1639 ##sys#check-port */
t4=*((C_word*)lf[143]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[239]);}

/* k4475 in port->fileno in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4477(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4477,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4506,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1640 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[242]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k4504 in k4475 in port->fileno in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4506(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4506,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixwin.scm: 1646 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[44],lf[239],lf[240],((C_word*)t0)[2]);}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4486,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4492,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1643 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_4486(2,t4,C_SCHEME_UNDEFINED);}}}

/* k4490 in k4504 in k4475 in port->fileno in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4492(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1644 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[35],lf[239],lf[241],((C_word*)t0)[2]);}

/* k4484 in k4504 in k4475 in port->fileno in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4486(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4459(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4459r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4459r(t0,t1,t2,t3);}}

static void C_ccall f_4459r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[238]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4471,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1635 mode */
f_4390(t5,C_SCHEME_FALSE,t3);}

/* k4469 in open-output-file* in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4471(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4471,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1635 check */
f_4427(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4445(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4445r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4445r(t0,t1,t2,t3);}}

static void C_ccall f_4445r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[237]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4457,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1631 mode */
f_4390(t5,C_SCHEME_TRUE,t3);}

/* k4455 in open-input-file* in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4457(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4457,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixwin.scm: 1631 check */
f_4427(((C_word*)t0)[2],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4427(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4427,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4431,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1622 ##sys#update-errno */
t6=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k4429 in check in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4431(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4431,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 1624 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[35],lf[235],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4443,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1625 ##sys#make-port */
t3=*((C_word*)lf[135]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[136]+1),lf[236],lf[82]);}}

/* k4441 in k4429 in check in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4443(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4390(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4390,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4398,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_u_i_car(t3);
t6=(C_word)C_eqp(t5,lf[229]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixwin.scm: 1617 ##sys#error */
t8=*((C_word*)lf[132]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[230],t5);}
else{
t8=t4;
f_4398(2,t8,lf[231]);}}
else{
/* posixwin.scm: 1618 ##sys#error */
t7=*((C_word*)lf[132]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[232],t5);}}
else{
t5=t4;
f_4398(2,t5,(C_truep(t2)?lf[233]:lf[234]));}}

/* k4396 in mode in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4398(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1613 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-execute-access? in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4381(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4381,3,t0,t1,t2);}
/* posixwin.scm: 1597 check */
f_4345(t1,t2,C_fix((C_word)2),lf[225]);}

/* file-write-access? in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4375(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4375,3,t0,t1,t2);}
/* posixwin.scm: 1596 check */
f_4345(t1,t2,C_fix((C_word)4),lf[224]);}

/* file-read-access? in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4369(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4369,3,t0,t1,t2);}
/* posixwin.scm: 1595 check */
f_4345(t1,t2,C_fix((C_word)2),lf[223]);}

/* check in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_4345(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4345,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4363,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4367,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1592 ##sys#expand-home-path */
t8=*((C_word*)lf[38]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k4365 in check in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4367(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1592 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4361 in check in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4363,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4355,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_4355(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1593 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k4353 in k4361 in check in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4355(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* change-file-mode in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4315(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4315,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[221]);
t5=(C_word)C_i_check_exact_2(t3,lf[221]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4339,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4343,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1581 ##sys#expand-home-path */
t8=*((C_word*)lf[38]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k4341 in change-file-mode in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4343(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1581 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4337 in change-file-mode in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4339(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4339,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4331,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1582 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k4329 in k4337 in change-file-mode in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4331(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1583 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[35],lf[221],lf[222],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#interrupt-hook in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4259(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4259,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4269,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1489 h */
t6=t4;
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
/* posixwin.scm: 1491 oldhook */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t2,t3);}}

/* k4267 in ##sys#interrupt-hook in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4269(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1490 ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4246(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4246,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[182]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_setslot(((C_word*)t0)[2],t2,t3));}

/* signal-handler in k4233 in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4237(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4237,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[181]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4168(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr2rv,(void*)f_4168r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_4168r(t0,t1,t2);}}

static void C_ccall f_4168r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t3=(C_word)C_vemptyp(t2);
t4=(C_truep(t3)?(C_word)C_u_fixnum_or(*((C_word*)lf[19]+1),*((C_word*)lf[21]+1)):(C_word)C_slot(t2,C_fix(0)));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4175,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE,t4),C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4184,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1426 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t5;
f_4175(2,t6,C_SCHEME_UNDEFINED);}}

/* k4182 in create-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4184(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1427 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[35],lf[151],lf[152]);}

/* k4173 in create-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4175(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1428 values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4148(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_4148r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4148r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4148r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[150]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4152,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k4150 in with-output-to-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4152,2,t0,t1);}
t2=C_mutate((C_word*)lf[150]+1 /* (set! standard-output ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4158,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1411 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a4157 in k4150 in with-output-to-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4158(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_4158r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4158r(t0,t1,t2);}}

static void C_ccall f_4158r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4162,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1413 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4160 in a4157 in k4150 in with-output-to-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4162(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[150]+1 /* (set! standard-output ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4128(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_4128r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4128r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4128r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[148]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4132,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k4130 in with-input-from-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4132(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4132,2,t0,t1);}
t2=C_mutate((C_word*)lf[148]+1 /* (set! standard-input ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4138,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1401 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a4137 in k4130 in with-input-from-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4138(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_4138r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4138r(t0,t1,t2);}}

static void C_ccall f_4138r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4142,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1403 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4140 in a4137 in k4130 in with-input-from-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4142(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[148]+1 /* (set! standard-input ...) */,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4104(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_4104r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4104r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4104r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4108,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k4106 in call-with-output-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4108(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4108,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4113,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4119,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1391 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a4118 in k4106 in call-with-output-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4119(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4119r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4119r(t0,t1,t2);}}

static void C_ccall f_4119r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4123,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1394 close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4121 in a4118 in k4106 in call-with-output-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4123(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a4112 in k4106 in call-with-output-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4113(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4113,2,t0,t1);}
/* posixwin.scm: 1392 proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4080(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_4080r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_4080r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4080r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4084,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k4082 in call-with-input-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4084(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4084,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4089,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4095,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1383 ##sys#call-with-values */
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a4094 in k4082 in call-with-input-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4095(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_4095r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4095r(t0,t1,t2);}}

static void C_ccall f_4095r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4099,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1386 close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k4097 in a4094 in k4082 in call-with-input-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4099(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a4088 in k4082 in call-with-input-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4089(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4089,2,t0,t1);}
/* posixwin.scm: 1384 proc */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4061(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4061,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4065,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1370 ##sys#check-port */
t4=*((C_word*)lf[143]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[141]);}

/* k4063 in close-input-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4065(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4065,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4068,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1372 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k4066 in k4063 in close-input-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4068(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
/* posixwin.scm: 1373 ##sys#signal-hook */
t3=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[3],lf[35],lf[141],lf[142],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* open-output-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4025(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_4025r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4025r(t0,t1,t2,t3);}}

static void C_ccall f_4025r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(8);
t4=(C_word)C_i_check_string_2(t2,lf[140]);
t5=f_3953(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4039,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[131]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4046,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1365 ##sys#make-c-string */
t9=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[139]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4056,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1366 ##sys#make-c-string */
t10=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixwin.scm: 1367 badmode */
f_3965(t6,t5);}}}

/* k4054 in open-output-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4056,2,t0,t1);}
t2=((C_word*)t0)[2];
f_4039(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k4044 in open-output-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4046(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4046,2,t0,t1);}
t2=((C_word*)t0)[2];
f_4039(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k4037 in open-output-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1362 check */
f_3971(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3989(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr3r,(void*)f_3989r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3989r(t0,t1,t2,t3);}}

static void C_ccall f_3989r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(8);
t4=(C_word)C_i_check_string_2(t2,lf[138]);
t5=f_3953(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4003,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[131]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4010,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1355 ##sys#make-c-string */
t9=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[139]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4020,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1356 ##sys#make-c-string */
t10=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixwin.scm: 1357 badmode */
f_3965(t6,t5);}}}

/* k4018 in open-input-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4020,2,t0,t1);}
t2=((C_word*)t0)[2];
f_4003(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k4008 in open-input-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4010,2,t0,t1);}
t2=((C_word*)t0)[2];
f_4003(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k4001 in open-input-pipe in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_4003(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1352 check */
f_3971(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3971(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3971,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3975,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1342 ##sys#update-errno */
t6=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k3973 in check in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3975(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3975,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
/* posixwin.scm: 1344 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[35],lf[134],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3987,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1345 ##sys#make-port */
t3=*((C_word*)lf[135]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[136]+1),lf[137],lf[82]);}}

/* k3985 in k3973 in check in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3987(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3965(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3965,NULL,2,t1,t2);}
/* posixwin.scm: 1340 ##sys#error */
t3=*((C_word*)lf[132]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[133],t2);}

/* mode in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static C_word C_fcall f_3953(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[131]));}

/* canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3596(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3596,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[95]);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3603,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],tmp=(C_word)a,a+=9,tmp);
t5=(C_word)C_block_size(t2);
t6=(C_word)C_eqp(C_fix(0),t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3736,a[2]=t4,a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1279 cwd */
t8=((C_word*)t0)[5];
f_3540(t8,t7);}
else{
t7=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3742,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[11],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=t2,a[9]=t4,a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t8=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(3)))){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3943,a[2]=((C_word*)t0)[11],a[3]=t7,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1281 sref */
t10=((C_word*)t0)[8];
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t9,t2,C_fix(0));}
else{
t9=t7;
f_3742(t9,C_SCHEME_FALSE);}}}

/* k3941 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3943(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1281 sep? */
t2=((C_word*)t0)[3];
f_3742(t2,f_3529(t1));}

/* k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3742(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3742,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3749,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3753,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1283 cwd */
t4=((C_word*)t0)[7];
f_3540(t4,t3);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[8]);
t3=(C_word)C_eqp(C_fix(1),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3766,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1286 cwd */
t5=((C_word*)t0)[7];
f_3540(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3772,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3918,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3929,a[2]=t5,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1287 sref */
t7=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,((C_word*)t0)[8],C_fix(0));}}}

/* k3927 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3929(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1287 char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(126),t1);}

/* k3916 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3918(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3918,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3925,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1288 sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_3772(t2,C_SCHEME_FALSE);}}

/* k3923 in k3916 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3925(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1288 sep? */
t2=((C_word*)t0)[3];
f_3772(t2,f_3529(t1));}

/* k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3772(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3772,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3779,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[10],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3795,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1290 cwd */
t4=((C_word*)t0)[6];
f_3540(t4,t3);}
else{
t2=(C_word)C_block_size(((C_word*)t0)[8]);
t3=(C_word)C_eqp(C_fix(2),t2);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3808,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1296 cwd */
t5=((C_word*)t0)[6];
f_3540(t5,t4);}
else{
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3814,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3890,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3911,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1297 sref */
t7=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t6,((C_word*)t0)[8],C_fix(0));}}}

/* k3909 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3911(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1297 alpha? */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3888 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3890(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3890,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3896,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3907,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1298 sref */
t4=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[6];
f_3814(t2,C_SCHEME_FALSE);}}

/* k3905 in k3888 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3907(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1298 char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k3894 in k3888 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3896(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3896,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3903,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1299 sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[5];
f_3814(t2,C_SCHEME_FALSE);}}

/* k3901 in k3894 in k3888 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3903(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1299 sep? */
t2=((C_word*)t0)[3];
f_3814(t2,f_3529(t1));}

/* k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3814(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3814,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[9];
f_3603(2,t2,((C_word*)t0)[8]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3820,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3866,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3887,a[2]=t3,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1301 sref */
t5=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[8],C_fix(0));}}

/* k3885 in k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3887(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1301 char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(47),t1);}

/* k3864 in k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3866(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3866,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3872,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3883,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1302 sref */
t4=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[3],C_fix(1));}
else{
t2=((C_word*)t0)[5];
f_3820(2,t2,C_SCHEME_FALSE);}}

/* k3881 in k3864 in k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3883(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1302 alpha? */
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3870 in k3864 in k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3872(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3872,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3879,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1303 sref */
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(2));}
else{
t2=((C_word*)t0)[4];
f_3820(2,t2,C_SCHEME_FALSE);}}

/* k3877 in k3870 in k3864 in k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3879(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1303 char=? */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],C_make_character(58),t1);}

/* k3818 in k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3820(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3820,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3827,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1305 ##sys#substring */
t3=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,((C_word*)t0)[5],C_fix(1),C_fix(3));}
else{
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3863,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1309 sref */
t3=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[5],C_fix(0));}}

/* k3861 in k3818 in k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3863(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3863,2,t0,t1);}
t2=f_3529(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3848,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3852,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1311 cwd */
t5=((C_word*)t0)[2];
f_3540(t5,t4);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3859,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1314 cwd */
t4=((C_word*)t0)[2];
f_3540(t4,t3);}}

/* k3857 in k3861 in k3818 in k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3859(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1314 sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[130],((C_word*)t0)[2]);}

/* k3850 in k3861 in k3818 in k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3852(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1311 ##sys#substring */
t2=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],t1,C_fix(0),C_fix(2));}

/* k3846 in k3861 in k3818 in k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3848(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1310 sappend */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k3825 in k3818 in k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3827(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3827,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3831,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixwin.scm: 1307 ##sys#substring */
t4=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(3),t3);}

/* k3829 in k3825 in k3818 in k3812 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3831(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1304 sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[129],t1);}

/* k3806 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3808(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1296 sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[128],((C_word*)t0)[2]);}

/* k3793 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3795(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1290 ##sys#substring */
t2=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],t1,C_fix(0),C_fix(3));}

/* k3777 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3779(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3779,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3783,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1292 user */
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k3781 in k3777 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3783(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3783,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3787,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixwin.scm: 1293 ##sys#substring */
t4=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(1),t3);}

/* k3785 in k3781 in k3777 in k3770 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3787(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1289 sappend */
t2=((C_word*)t0)[5];
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],((C_word*)t0)[3],lf[127],((C_word*)t0)[2],t1);}

/* k3764 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3766(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1286 sappend */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],t1,lf[126],((C_word*)t0)[2]);}

/* k3751 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3753(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1283 ##sys#substring */
t2=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],t1,C_fix(0),C_fix(2));}

/* k3747 in k3740 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3749(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1282 sappend */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* k3734 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3736(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1279 sappend */
t2=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],t1,lf[125]);}

/* k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3603(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3603,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3610,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t1,tmp=(C_word)a,a+=10,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3722,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=(C_word)C_block_size(t1);
/* posixwin.scm: 1315 ##sys#substring */
t5=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t3,t1,C_fix(3),t4);}

/* k3720 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3722(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* string-split */
t2=*((C_word*)lf[93]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],t1,lf[124]);}

/* k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3610(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3610,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3612,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp));
t5=((C_word*)t3)[1];
f_3612(t5,((C_word*)t0)[2],t1,C_SCHEME_END_OF_LIST);}

/* loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3612(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3612,NULL,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_3619,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word*)t0)[8],a[11]=((C_word*)t0)[9],a[12]=t1,tmp=(C_word)a,a+=13,tmp);
/* posixwin.scm: 1317 null? */
t5=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k3617 in loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3619(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3619,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_3625,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[12],tmp=(C_word)a,a+=9,tmp);
/* posixwin.scm: 1318 null? */
t3=((C_word*)t0)[5];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[7]);}
else{
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(1));
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3691,a[2]=t2,a[3]=((C_word*)t0)[12],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3694,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[7],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_u_i_car(((C_word*)t0)[4]);
/* posixwin.scm: 1329 string=? */
t6=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,lf[123],t5);}}

/* k3692 in k3617 in loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3694(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3694,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[5];
f_3691(t2,(C_word)C_slot(((C_word*)t0)[4],C_fix(1)));}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3703,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(((C_word*)t0)[3]);
/* posixwin.scm: 1331 string=? */
t4=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[122],t3);}}

/* k3701 in k3692 in k3617 in loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3703(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3703,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
f_3691(t2,((C_word*)t0)[3]);}
else{
t2=(C_word)C_u_i_car(((C_word*)t0)[2]);
t3=((C_word*)t0)[4];
f_3691(t3,(C_word)C_a_i_cons(&a,2,t2,((C_word*)t0)[3]));}}

/* k3689 in k3617 in loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3691(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1327 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_3612(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k3623 in k3617 in loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3625(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3625,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1319 ##sys#substring */
t2=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[8],((C_word*)t0)[7],C_fix(0),C_fix(3));}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3672,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(C_word)C_block_size(((C_word*)t0)[7]);
t4=(C_word)C_a_i_minus(&a,2,t3,C_fix(1));
/* posixwin.scm: 1320 sref */
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,((C_word*)t0)[7],t4);}}

/* k3670 in k3623 in k3617 in loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3672(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3672,2,t0,t1);}
t2=f_3529(t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3641,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1322 ##sys#substring */
t4=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)t0)[2],C_fix(0),C_fix(3));}
else{
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3660,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1325 ##sys#substring */
t4=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)t0)[2],C_fix(0),C_fix(3));}}

/* k3658 in k3670 in k3623 in k3617 in loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3660(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3660,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3664,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3668,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1326 reverse */
t4=*((C_word*)lf[121]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3666 in k3658 in k3670 in k3623 in k3617 in loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1326 isperse */
f_3524(((C_word*)t0)[2],t1);}

/* k3662 in k3658 in k3670 in k3623 in k3617 in loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3664(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1324 sappend */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k3639 in k3670 in k3623 in k3617 in loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3641(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3641,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3645,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3649,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_a_i_cons(&a,2,lf[120],((C_word*)t0)[2]);
/* posixwin.scm: 1323 reverse */
t5=*((C_word*)lf[121]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}

/* k3647 in k3639 in k3670 in k3623 in k3617 in loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3649(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1323 isperse */
f_3524(((C_word*)t0)[2],t1);}

/* k3643 in k3639 in k3670 in k3623 in k3617 in loop in k3608 in k3601 in canonical-path in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3645(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1321 sappend */
t2=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* cwd in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3540(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3540,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3547,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3549,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* call-with-current-continuation */
t4=*((C_word*)lf[119]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* a3548 in cwd in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3549(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3549,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3555,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3573,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* with-exception-handler */
t5=*((C_word*)lf[118]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t3,t4);}

/* a3572 in a3548 in cwd in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3573(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3573,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3579,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3585,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#call-with-values */
C_u_call_with_values(4,0,t1,t2,t3);}

/* a3584 in a3572 in a3548 in cwd in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3585(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2r,(void*)f_3585r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3585r(t0,t1,t2);}}

static void C_ccall f_3585r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3591,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* k581587 */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}

/* a3590 in a3584 in a3572 in a3548 in cwd in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3591(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3591,2,t0,t1);}
C_apply_values(3,0,t1,((C_word*)t0)[2]);}

/* a3578 in a3572 in a3548 in cwd in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3579(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3579,2,t0,t1);}
/* posixwin.scm: 1274 cw */
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* a3554 in a3548 in cwd in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3555(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3555,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3561,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* k581587 */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}

/* a3560 in a3554 in a3548 in cwd in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3561(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3561,2,t0,t1);}
t2=(C_word)C_i_structurep(((C_word*)t0)[2],lf[116]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[2],C_fix(1)):C_SCHEME_FALSE);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,lf[117]);}

/* k3545 in cwd in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* sep? in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static C_word C_fcall f_3529(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_eqp(C_make_character(47),t1);
return((C_truep(t2)?t2:(C_word)C_eqp(C_make_character(92),t1)));}

/* isperse in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3524(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3524,NULL,2,t1,t2);}
/* string-intersperse */
t3=*((C_word*)lf[113]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,lf[114]);}

/* current-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3480(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_3480r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_3480r(t0,t1,t2);}}

static void C_ccall f_3480r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(3);
t3=(C_word)C_vemptyp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_slot(t2,C_fix(0)));
if(C_truep(t4)){
/* posixwin.scm: 1252 change-directory */
t5=*((C_word*)lf[96]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t4);}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3493,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1253 make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,C_fix(256));}}

/* k3491 in current-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3493(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3493,2,t0,t1);}
t2=(C_word)C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3496,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1255 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3494 in k3491 in current-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3496(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
/* posixwin.scm: 1257 ##sys#substring */
t2=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[4]);}
else{
/* posixwin.scm: 1258 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[35],lf[104],lf[107]);}}

/* directory? in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3453(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3453,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[105]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3460,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3474,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3478,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1245 ##sys#expand-home-path */
t7=*((C_word*)lf[38]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k3476 in directory? in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3478(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1245 ##sys#platform-fixup-pathname */
t2=*((C_word*)lf[106]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3472 in directory? in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1244 ##sys#file-info */
t2=*((C_word*)lf[67]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3458 in directory? in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3460(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3296(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_3296r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_3296r(t0,t1,t2);}}

static void C_ccall f_3296r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(9);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3298,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3399,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3404,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec428486 */
t6=t5;
f_3404(t6,t1);}
else{
t6=(C_word)C_u_i_car(t2);
t7=(C_word)C_slot(t2,C_fix(1));
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?429482 */
t8=t4;
f_3399(t8,t1,t6);}
else{
t8=(C_word)C_u_i_car(t7);
t9=(C_word)C_slot(t7,C_fix(1));
/* body426435 */
t10=t3;
f_3298(t10,t1,t6,t8);}}}

/* def-spec428 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3404(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3404,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3412,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1215 current-directory */
t3=*((C_word*)lf[104]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k3410 in def-spec428 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3412(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?429482 */
t2=((C_word*)t0)[3];
f_3399(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?429 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3399(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3399,NULL,3,t0,t1,t2);}
/* body426435 */
t3=((C_word*)t0)[2];
f_3298(t3,t1,t2,C_SCHEME_FALSE);}

/* body426 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3298(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3298,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[101]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3305,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1217 make-string */
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,C_fix(256));}

/* k3303 in body426 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3305(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3305,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3308,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1218 ##sys#make-pointer */
t3=*((C_word*)lf[103]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k3306 in k3303 in body426 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3308(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3308,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3311,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixwin.scm: 1219 ##sys#make-pointer */
t3=*((C_word*)lf[103]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k3309 in k3306 in k3303 in body426 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3311(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3311,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3315,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3398,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1220 ##sys#expand-home-path */
t4=*((C_word*)lf[38]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k3396 in k3309 in k3306 in k3303 in body426 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3398(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1220 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3313 in k3309 in k3306 in k3303 in body426 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3315(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3315,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3324,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1223 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3332,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_3332(t6,((C_word*)t0)[6]);}}

/* loop in k3313 in k3309 in k3306 in k3303 in body426 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3332(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3332,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3342,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1232 ##sys#substring */
t5=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k3340 in loop in k3313 in k3309 in k3306 in k3303 in body426 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3342(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3342,2,t0,t1);}
t2=(C_word)C_subchar(t1,C_fix(0));
t3=(C_word)C_i_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?(C_word)C_subchar(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3354,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t2,C_make_character(46));
if(C_truep(t6)){
t7=(C_word)C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_3354(t8,t7);}
else{
t8=(C_word)C_eqp(t4,C_make_character(46));
t9=(C_truep(t8)?(C_word)C_eqp(((C_word*)t0)[5],C_fix(2)):C_SCHEME_FALSE);
t10=t5;
f_3354(t10,(C_truep(t9)?t9:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t7=t5;
f_3354(t7,C_SCHEME_FALSE);}}

/* k3352 in k3340 in loop in k3313 in k3309 in k3306 in k3303 in body426 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3354(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3354,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixwin.scm: 1239 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_3332(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3364,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1240 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_3332(t3,t2);}}

/* k3362 in k3352 in k3340 in loop in k3313 in k3309 in k3306 in k3303 in body426 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3364(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3364,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k3322 in k3313 in k3309 in k3306 in k3303 in body426 in directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3324(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1224 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[35],lf[101],lf[102],((C_word*)t0)[2]);}

/* delete-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3269(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3269,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[98]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3290,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3294,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1207 ##sys#expand-home-path */
t6=*((C_word*)lf[38]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k3292 in delete-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3294(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1207 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3288 in delete-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3290(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3290,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3282,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1208 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3280 in k3288 in delete-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3282(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1209 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[35],lf[98],lf[99],((C_word*)t0)[2]);}

/* change-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3242(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3242,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[96]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3263,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3267,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1200 ##sys#expand-home-path */
t6=*((C_word*)lf[38]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k3265 in change-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3267(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1200 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3261 in change-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3263(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3263,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3255,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1201 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3253 in k3261 in change-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3255(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1202 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[35],lf[96],lf[97],((C_word*)t0)[2]);}

/* create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3136(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3136r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3136r(t0,t1,t2,t3);}}

static void C_ccall f_3136r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(C_word)C_i_check_string_2(t2,lf[88]);
if(C_truep(t5)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3149,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1188 canonical-path */
t8=*((C_word*)lf[95]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3211,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1189 canonical-path */
t8=*((C_word*)lf[95]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}}

/* k3209 in create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3211(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3211,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3228,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1159 ##sys#make-c-string */
t3=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,t1);}

/* k3226 in k3209 in create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3228(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3228,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3220,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1160 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3218 in k3226 in k3209 in create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3220(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1161 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[35],lf[88],lf[89],((C_word*)t0)[2]);}

/* k3147 in create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3149(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3149,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3152,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1176 string-split */
t3=*((C_word*)lf[93]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,t1,lf[94]);}

/* k3150 in k3147 in create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3152(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3152,2,t0,t1);}
t2=(C_word)C_u_i_car(t1);
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3160,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=(C_word)C_slot(t1,C_fix(1));
/* for-each */
t7=*((C_word*)lf[92]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,((C_word*)t0)[2],t5,t6);}

/* a3159 in k3150 in k3147 in create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3160(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3160,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3165,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1180 string-append */
t4=*((C_word*)lf[2]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,((C_word*)((C_word*)t0)[2])[1],lf[91],t2);}

/* k3163 in a3159 in k3150 in k3147 in create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3165(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3165,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)((C_word*)t0)[3])[1];
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3171,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3191,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1165 file-exists? */
t6=*((C_word*)lf[90]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t3);}

/* k3189 in k3163 in a3159 in k3150 in k3147 in create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3191(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3191,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3194,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1166 ##sys#file-info */
t3=*((C_word*)lf[67]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[3];
f_3171(t2,C_SCHEME_FALSE);}}

/* k3192 in k3189 in k3163 in a3159 in k3150 in k3147 in create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3194(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
f_3171(t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
f_3171(t2,C_SCHEME_FALSE);}}

/* k3169 in k3163 in a3159 in k3150 in k3147 in create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3171(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3171,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3188,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1159 ##sys#make-c-string */
t3=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}}

/* k3186 in k3169 in k3163 in a3159 in k3150 in k3147 in create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3188(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3188,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3180,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1160 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3178 in k3186 in k3169 in k3163 in a3159 in k3150 in k3147 in create-directory in k3132 in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3180(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1161 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[35],lf[88],lf[89],((C_word*)t0)[2]);}

/* set-file-position! in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3071(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_3071r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_3071r(t0,t1,t2,t3,t4);}}

static void C_ccall f_3071r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[80]);
t8=(C_word)C_i_check_exact_2(t6,lf[80]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3084,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixwin.scm: 1131 ##sys#signal-hook */
t10=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[85],lf[80],lf[86],t3,t2);}
else{
t10=t9;
f_3084(2,t10,C_SCHEME_UNDEFINED);}}

/* k3082 in set-file-position! in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3084(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3084,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3090,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3099,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1132 port? */
t4=*((C_word*)lf[84]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k3097 in k3082 in set-file-position! in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3099(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[82]);
t4=((C_word*)t0)[4];
f_3090(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_3090(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixwin.scm: 1136 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[44],lf[80],lf[83],((C_word*)t0)[5]);}}}

/* k3088 in k3082 in set-file-position! in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3090(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3090,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3093,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1137 ##sys#update-errno */
t3=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k3091 in k3088 in k3082 in set-file-position! in k3067 in k3063 in k3059 in k3055 in k3051 in k3047 in k3043 in k3039 in k3035 in k3031 in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3093(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1138 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[35],lf[80],lf[81],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* stat-type in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_3022(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3022,NULL,2,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3024,a[2]=t2,tmp=(C_word)a,a+=3,tmp));}

/* f_3024 in stat-type in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3024(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3024,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* symbolic-link? in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3017(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3017,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[68]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}

/* regular-file? in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2994(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2994,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[66]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3001,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3015,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1102 ##sys#expand-home-path */
t6=*((C_word*)lf[38]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k3013 in regular-file? in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3015(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1102 ##sys#file-info */
t2=*((C_word*)lf[67]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2999 in regular-file? in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_3001(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(0),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* file-permissions in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2988(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2988,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2992,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1098 ##sys#stat */
f_2896(t3,t2);}

/* k2990 in file-permissions in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2992(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2982(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2982,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2986,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1097 ##sys#stat */
f_2896(t3,t2);}

/* k2984 in file-owner in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2986(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2976(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2976,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2980,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1096 ##sys#stat */
f_2896(t3,t2);}

/* k2978 in file-change-time in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2980(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2980,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2970(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2970,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2974,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1095 ##sys#stat */
f_2896(t3,t2);}

/* k2972 in file-access-time in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2974(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2974,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2964(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2964,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2968,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1094 ##sys#stat */
f_2896(t3,t2);}

/* k2966 in file-modification-time in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2968(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2968,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2958(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2958,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2962,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1093 ##sys#stat */
f_2896(t3,t2);}

/* k2960 in file-size in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2962(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size));}

/* file-stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2934(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr3rv,(void*)f_2934r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_2934r(t0,t1,t2,t3);}}

static void C_ccall f_2934r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(3);
t4=(C_word)C_vemptyp(t3);
t5=(C_truep(t4)?C_SCHEME_FALSE:(C_word)C_slot(t3,C_fix(0)));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2941,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1087 ##sys#stat */
f_2896(t6,t2);}

/* k2939 in file-stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2941(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2941,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(0),C_fix(0),C_fix(0),C_fix(0)));}

/* ##sys#stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_fcall f_2896(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2896,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2900,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2900(2,t4,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2925,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2929,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1080 ##sys#expand-home-path */
t6=*((C_word*)lf[38]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
/* posixwin.scm: 1081 ##sys#signal-hook */
t4=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,lf[44],lf[58],t2);}}}

/* k2927 in ##sys#stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2929(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1080 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2923 in ##sys#stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2925(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2900(2,t2,(C_word)C_stat(t1));}

/* k2898 in ##sys#stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2900(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2900,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2909,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1083 ##sys#update-errno */
t3=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k2907 in k2898 in ##sys#stat in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2909(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1084 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[35],lf[57],((C_word*)t0)[2]);}

/* file-mkstemp in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2858(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2858,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[50]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2865,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1049 ##sys#make-c-string */
t5=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2863 in file-mkstemp in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2865(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2865,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2868,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1051 string-length */
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t1);}

/* k2866 in k2863 in file-mkstemp in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2868(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2868,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2871,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2888,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1053 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t2;
f_2871(2,t4,C_SCHEME_UNDEFINED);}}

/* k2886 in k2866 in k2863 in file-mkstemp in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2888(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1054 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[35],lf[50],lf[52],((C_word*)t0)[2]);}

/* k2869 in k2866 in k2863 in file-mkstemp in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2871(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2871,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2878,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_u_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixwin.scm: 1055 ##sys#substring */
t4=*((C_word*)lf[51]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k2876 in k2869 in k2866 in k2863 in file-mkstemp in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2878(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1055 values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2816(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2816r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2816r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2816r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[46]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2823,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_2823(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1036 ##sys#signal-hook */
t8=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[44],lf[46],lf[48],t3);}}

/* k2821 in file-write in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2823(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2823,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[46]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2832,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2838,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1041 ##sys#update-errno */
t9=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}
else{
t8=t6;
f_2832(2,t8,C_SCHEME_UNDEFINED);}}

/* k2836 in k2821 in file-write in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2838(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1042 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[35],lf[46],lf[47],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k2830 in k2821 in file-write in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2832(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2771(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2771r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2771r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2771r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[42]);
t6=(C_word)C_i_check_exact_2(t3,lf[42]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2781,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_2781(2,t8,(C_word)C_slot(t4,C_fix(0)));}
else{
/* posixwin.scm: 1023 make-string */
t8=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t3);}}

/* k2779 in file-read in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2781(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2781,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2784,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_2784(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixwin.scm: 1025 ##sys#signal-hook */
t4=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[44],lf[42],lf[45],t1);}}

/* k2782 in k2779 in file-read in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2784(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2784,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2787,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2796,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixwin.scm: 1028 ##sys#update-errno */
t6=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_2787(2,t5,C_SCHEME_UNDEFINED);}}

/* k2794 in k2782 in k2779 in file-read in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2796(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1029 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[35],lf[42],lf[43],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k2785 in k2782 in k2779 in file-read in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2787(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2787,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2753(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2753,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[39]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2766,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixwin.scm: 1015 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k2764 in file-close in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2766(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1016 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[35],lf[39],lf[40],((C_word*)t0)[2]);}

/* file-open in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2712(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2712r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2712r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2712r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[34]);
t8=(C_word)C_i_check_exact_2(t3,lf[34]);
t9=(C_word)C_i_check_exact_2(t6,lf[34]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2729,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2745,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixwin.scm: 1005 ##sys#expand-home-path */
t12=*((C_word*)lf[38]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t2);}

/* k2743 in file-open in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2745(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1005 ##sys#make-c-string */
t2=*((C_word*)lf[37]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2727 in file-open in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2729(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2729,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2732,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2738,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixwin.scm: 1007 ##sys#update-errno */
t6=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f_2732(2,t5,C_SCHEME_UNDEFINED);}}

/* k2736 in k2727 in file-open in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2738(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 1008 ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[35],lf[34],lf[36],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k2730 in k2727 in file-open in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2732(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* posix-error in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2666(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_2666r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_2666r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_2666r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2670,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixwin.scm: 936  ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k2668 in posix-error in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2670(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2670,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2677,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2681,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,(C_word)stub23(t4,t1),C_fix(0));}

/* k2679 in k2668 in posix-error in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2681(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixwin.scm: 937  string-append */
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[5],t1);}

/* k2675 in k2668 in posix-error in k2657 in k2654 in k2651 in k2648 in k2645 in k2642 in k2639 */
static void C_ccall f_2677(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[4]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[459] = {
{"toplevel:posixwin_scm",(void*)C_posix_toplevel},
{"f_2641:posixwin_scm",(void*)f_2641},
{"f_2644:posixwin_scm",(void*)f_2644},
{"f_2647:posixwin_scm",(void*)f_2647},
{"f_2650:posixwin_scm",(void*)f_2650},
{"f_2653:posixwin_scm",(void*)f_2653},
{"f_2656:posixwin_scm",(void*)f_2656},
{"f_2659:posixwin_scm",(void*)f_2659},
{"f_3033:posixwin_scm",(void*)f_3033},
{"f_3037:posixwin_scm",(void*)f_3037},
{"f_3041:posixwin_scm",(void*)f_3041},
{"f_3045:posixwin_scm",(void*)f_3045},
{"f_3049:posixwin_scm",(void*)f_3049},
{"f_3053:posixwin_scm",(void*)f_3053},
{"f_3057:posixwin_scm",(void*)f_3057},
{"f_3061:posixwin_scm",(void*)f_3061},
{"f_3065:posixwin_scm",(void*)f_3065},
{"f_3069:posixwin_scm",(void*)f_3069},
{"f_6394:posixwin_scm",(void*)f_6394},
{"f_6413:posixwin_scm",(void*)f_6413},
{"f_6398:posixwin_scm",(void*)f_6398},
{"f_6407:posixwin_scm",(void*)f_6407},
{"f_6401:posixwin_scm",(void*)f_6401},
{"f_3134:posixwin_scm",(void*)f_3134},
{"f_4235:posixwin_scm",(void*)f_4235},
{"f_6375:posixwin_scm",(void*)f_6375},
{"f_6372:posixwin_scm",(void*)f_6372},
{"f_6365:posixwin_scm",(void*)f_6365},
{"f_6359:posixwin_scm",(void*)f_6359},
{"f_6353:posixwin_scm",(void*)f_6353},
{"f_6347:posixwin_scm",(void*)f_6347},
{"f_6341:posixwin_scm",(void*)f_6341},
{"f_6335:posixwin_scm",(void*)f_6335},
{"f_6329:posixwin_scm",(void*)f_6329},
{"f_6323:posixwin_scm",(void*)f_6323},
{"f_6317:posixwin_scm",(void*)f_6317},
{"f_6311:posixwin_scm",(void*)f_6311},
{"f_6305:posixwin_scm",(void*)f_6305},
{"f_6299:posixwin_scm",(void*)f_6299},
{"f_6293:posixwin_scm",(void*)f_6293},
{"f_6287:posixwin_scm",(void*)f_6287},
{"f_6281:posixwin_scm",(void*)f_6281},
{"f_6275:posixwin_scm",(void*)f_6275},
{"f_6269:posixwin_scm",(void*)f_6269},
{"f_6263:posixwin_scm",(void*)f_6263},
{"f_6257:posixwin_scm",(void*)f_6257},
{"f_6251:posixwin_scm",(void*)f_6251},
{"f_6245:posixwin_scm",(void*)f_6245},
{"f_6239:posixwin_scm",(void*)f_6239},
{"f_6233:posixwin_scm",(void*)f_6233},
{"f_6227:posixwin_scm",(void*)f_6227},
{"f_6221:posixwin_scm",(void*)f_6221},
{"f_6215:posixwin_scm",(void*)f_6215},
{"f_6209:posixwin_scm",(void*)f_6209},
{"f_6203:posixwin_scm",(void*)f_6203},
{"f_6197:posixwin_scm",(void*)f_6197},
{"f_6191:posixwin_scm",(void*)f_6191},
{"f_6185:posixwin_scm",(void*)f_6185},
{"f_6179:posixwin_scm",(void*)f_6179},
{"f_6173:posixwin_scm",(void*)f_6173},
{"f_6167:posixwin_scm",(void*)f_6167},
{"f_6161:posixwin_scm",(void*)f_6161},
{"f_6155:posixwin_scm",(void*)f_6155},
{"f_6149:posixwin_scm",(void*)f_6149},
{"f_6143:posixwin_scm",(void*)f_6143},
{"f_6137:posixwin_scm",(void*)f_6137},
{"f_6131:posixwin_scm",(void*)f_6131},
{"f_6125:posixwin_scm",(void*)f_6125},
{"f_6119:posixwin_scm",(void*)f_6119},
{"f_6113:posixwin_scm",(void*)f_6113},
{"f_5896:posixwin_scm",(void*)f_5896},
{"f_6047:posixwin_scm",(void*)f_6047},
{"f_6053:posixwin_scm",(void*)f_6053},
{"f_6042:posixwin_scm",(void*)f_6042},
{"f_6037:posixwin_scm",(void*)f_6037},
{"f_5898:posixwin_scm",(void*)f_5898},
{"f_6024:posixwin_scm",(void*)f_6024},
{"f_6032:posixwin_scm",(void*)f_6032},
{"f_5905:posixwin_scm",(void*)f_5905},
{"f_6012:posixwin_scm",(void*)f_6012},
{"f_5915:posixwin_scm",(void*)f_5915},
{"f_5917:posixwin_scm",(void*)f_5917},
{"f_5936:posixwin_scm",(void*)f_5936},
{"f_5998:posixwin_scm",(void*)f_5998},
{"f_6005:posixwin_scm",(void*)f_6005},
{"f_5992:posixwin_scm",(void*)f_5992},
{"f_5951:posixwin_scm",(void*)f_5951},
{"f_5982:posixwin_scm",(void*)f_5982},
{"f_5968:posixwin_scm",(void*)f_5968},
{"f_5980:posixwin_scm",(void*)f_5980},
{"f_5976:posixwin_scm",(void*)f_5976},
{"f_5963:posixwin_scm",(void*)f_5963},
{"f_5961:posixwin_scm",(void*)f_5961},
{"f_6016:posixwin_scm",(void*)f_6016},
{"f_5881:posixwin_scm",(void*)f_5881},
{"f_5891:posixwin_scm",(void*)f_5891},
{"f_5850:posixwin_scm",(void*)f_5850},
{"f_5876:posixwin_scm",(void*)f_5876},
{"f_5861:posixwin_scm",(void*)f_5861},
{"f_5865:posixwin_scm",(void*)f_5865},
{"f_5869:posixwin_scm",(void*)f_5869},
{"f_5873:posixwin_scm",(void*)f_5873},
{"f_5838:posixwin_scm",(void*)f_5838},
{"f_5835:posixwin_scm",(void*)f_5835},
{"f_5778:posixwin_scm",(void*)f_5778},
{"f_5802:posixwin_scm",(void*)f_5802},
{"f_5812:posixwin_scm",(void*)f_5812},
{"f_5796:posixwin_scm",(void*)f_5796},
{"f_5766:posixwin_scm",(void*)f_5766},
{"f_5689:posixwin_scm",(void*)f_5689},
{"f_5706:posixwin_scm",(void*)f_5706},
{"f_5701:posixwin_scm",(void*)f_5701},
{"f_5696:posixwin_scm",(void*)f_5696},
{"f_5691:posixwin_scm",(void*)f_5691},
{"f_5612:posixwin_scm",(void*)f_5612},
{"f_5629:posixwin_scm",(void*)f_5629},
{"f_5624:posixwin_scm",(void*)f_5624},
{"f_5619:posixwin_scm",(void*)f_5619},
{"f_5614:posixwin_scm",(void*)f_5614},
{"f_5550:posixwin_scm",(void*)f_5550},
{"f_5606:posixwin_scm",(void*)f_5606},
{"f_5610:posixwin_scm",(void*)f_5610},
{"f_5571:posixwin_scm",(void*)f_5571},
{"f_5574:posixwin_scm",(void*)f_5574},
{"f_5585:posixwin_scm",(void*)f_5585},
{"f_5579:posixwin_scm",(void*)f_5579},
{"f_5552:posixwin_scm",(void*)f_5552},
{"f_5561:posixwin_scm",(void*)f_5561},
{"f_5454:posixwin_scm",(void*)f_5454},
{"f_5533:posixwin_scm",(void*)f_5533},
{"f_5461:posixwin_scm",(void*)f_5461},
{"f_5501:posixwin_scm",(void*)f_5501},
{"f_5505:posixwin_scm",(void*)f_5505},
{"f_5509:posixwin_scm",(void*)f_5509},
{"f_5513:posixwin_scm",(void*)f_5513},
{"f_5517:posixwin_scm",(void*)f_5517},
{"f_5408:posixwin_scm",(void*)f_5408},
{"f_5412:posixwin_scm",(void*)f_5412},
{"f_5494:posixwin_scm",(void*)f_5494},
{"f_5474:posixwin_scm",(void*)f_5474},
{"f_5478:posixwin_scm",(void*)f_5478},
{"f_5482:posixwin_scm",(void*)f_5482},
{"f_5374:posixwin_scm",(void*)f_5374},
{"f_5391:posixwin_scm",(void*)f_5391},
{"f_5395:posixwin_scm",(void*)f_5395},
{"f_5368:posixwin_scm",(void*)f_5368},
{"f_5347:posixwin_scm",(void*)f_5347},
{"f_5351:posixwin_scm",(void*)f_5351},
{"f_5363:posixwin_scm",(void*)f_5363},
{"f_5344:posixwin_scm",(void*)f_5344},
{"f_5260:posixwin_scm",(void*)f_5260},
{"f_5284:posixwin_scm",(void*)f_5284},
{"f_5279:posixwin_scm",(void*)f_5279},
{"f_5274:posixwin_scm",(void*)f_5274},
{"f_5262:posixwin_scm",(void*)f_5262},
{"f_5266:posixwin_scm",(void*)f_5266},
{"f_5176:posixwin_scm",(void*)f_5176},
{"f_5200:posixwin_scm",(void*)f_5200},
{"f_5195:posixwin_scm",(void*)f_5195},
{"f_5190:posixwin_scm",(void*)f_5190},
{"f_5178:posixwin_scm",(void*)f_5178},
{"f_5182:posixwin_scm",(void*)f_5182},
{"f_5161:posixwin_scm",(void*)f_5161},
{"f_5165:posixwin_scm",(void*)f_5165},
{"f_5128:posixwin_scm",(void*)f_5128},
{"f_5135:posixwin_scm",(void*)f_5135},
{"f_5138:posixwin_scm",(void*)f_5138},
{"f_5155:posixwin_scm",(void*)f_5155},
{"f_5141:posixwin_scm",(void*)f_5141},
{"f_5144:posixwin_scm",(void*)f_5144},
{"f_5151:posixwin_scm",(void*)f_5151},
{"f_5078:posixwin_scm",(void*)f_5078},
{"f_5090:posixwin_scm",(void*)f_5090},
{"f_5109:posixwin_scm",(void*)f_5109},
{"f_5072:posixwin_scm",(void*)f_5072},
{"f_5066:posixwin_scm",(void*)f_5066},
{"f_4987:posixwin_scm",(void*)f_4987},
{"f_5030:posixwin_scm",(void*)f_5030},
{"f_5061:posixwin_scm",(void*)f_5061},
{"f_5058:posixwin_scm",(void*)f_5058},
{"f_4992:posixwin_scm",(void*)f_4992},
{"f_4996:posixwin_scm",(void*)f_4996},
{"f_5001:posixwin_scm",(void*)f_5001},
{"f_5025:posixwin_scm",(void*)f_5025},
{"f_5014:posixwin_scm",(void*)f_5014},
{"f_4875:posixwin_scm",(void*)f_4875},
{"f_4881:posixwin_scm",(void*)f_4881},
{"f_4902:posixwin_scm",(void*)f_4902},
{"f_4976:posixwin_scm",(void*)f_4976},
{"f_4906:posixwin_scm",(void*)f_4906},
{"f_4909:posixwin_scm",(void*)f_4909},
{"f_4916:posixwin_scm",(void*)f_4916},
{"f_4918:posixwin_scm",(void*)f_4918},
{"f_4935:posixwin_scm",(void*)f_4935},
{"f_4945:posixwin_scm",(void*)f_4945},
{"f_4949:posixwin_scm",(void*)f_4949},
{"f_4896:posixwin_scm",(void*)f_4896},
{"f_4816:posixwin_scm",(void*)f_4816},
{"f_4820:posixwin_scm",(void*)f_4820},
{"f_4826:posixwin_scm",(void*)f_4826},
{"f_4810:posixwin_scm",(void*)f_4810},
{"f_4814:posixwin_scm",(void*)f_4814},
{"f_4794:posixwin_scm",(void*)f_4794},
{"f_4786:posixwin_scm",(void*)f_4786},
{"f_4771:posixwin_scm",(void*)f_4771},
{"f_4775:posixwin_scm",(void*)f_4775},
{"f_4711:posixwin_scm",(void*)f_4711},
{"f_4718:posixwin_scm",(void*)f_4718},
{"f_4740:posixwin_scm",(void*)f_4740},
{"f_4737:posixwin_scm",(void*)f_4737},
{"f_4727:posixwin_scm",(void*)f_4727},
{"f_4678:posixwin_scm",(void*)f_4678},
{"f_4682:posixwin_scm",(void*)f_4682},
{"f_4664:posixwin_scm",(void*)f_4664},
{"f_4655:posixwin_scm",(void*)f_4655},
{"f_4636:posixwin_scm",(void*)f_4636},
{"f_4570:posixwin_scm",(void*)f_4570},
{"f_4576:posixwin_scm",(void*)f_4576},
{"f_4580:posixwin_scm",(void*)f_4580},
{"f_4588:posixwin_scm",(void*)f_4588},
{"f_4614:posixwin_scm",(void*)f_4614},
{"f_4618:posixwin_scm",(void*)f_4618},
{"f_4606:posixwin_scm",(void*)f_4606},
{"f_4555:posixwin_scm",(void*)f_4555},
{"f_4563:posixwin_scm",(void*)f_4563},
{"f_4538:posixwin_scm",(void*)f_4538},
{"f_4549:posixwin_scm",(void*)f_4549},
{"f_4553:posixwin_scm",(void*)f_4553},
{"f_4508:posixwin_scm",(void*)f_4508},
{"f_4515:posixwin_scm",(void*)f_4515},
{"f_4524:posixwin_scm",(void*)f_4524},
{"f_4518:posixwin_scm",(void*)f_4518},
{"f_4473:posixwin_scm",(void*)f_4473},
{"f_4477:posixwin_scm",(void*)f_4477},
{"f_4506:posixwin_scm",(void*)f_4506},
{"f_4492:posixwin_scm",(void*)f_4492},
{"f_4486:posixwin_scm",(void*)f_4486},
{"f_4459:posixwin_scm",(void*)f_4459},
{"f_4471:posixwin_scm",(void*)f_4471},
{"f_4445:posixwin_scm",(void*)f_4445},
{"f_4457:posixwin_scm",(void*)f_4457},
{"f_4427:posixwin_scm",(void*)f_4427},
{"f_4431:posixwin_scm",(void*)f_4431},
{"f_4443:posixwin_scm",(void*)f_4443},
{"f_4390:posixwin_scm",(void*)f_4390},
{"f_4398:posixwin_scm",(void*)f_4398},
{"f_4381:posixwin_scm",(void*)f_4381},
{"f_4375:posixwin_scm",(void*)f_4375},
{"f_4369:posixwin_scm",(void*)f_4369},
{"f_4345:posixwin_scm",(void*)f_4345},
{"f_4367:posixwin_scm",(void*)f_4367},
{"f_4363:posixwin_scm",(void*)f_4363},
{"f_4355:posixwin_scm",(void*)f_4355},
{"f_4315:posixwin_scm",(void*)f_4315},
{"f_4343:posixwin_scm",(void*)f_4343},
{"f_4339:posixwin_scm",(void*)f_4339},
{"f_4331:posixwin_scm",(void*)f_4331},
{"f_4259:posixwin_scm",(void*)f_4259},
{"f_4269:posixwin_scm",(void*)f_4269},
{"f_4246:posixwin_scm",(void*)f_4246},
{"f_4237:posixwin_scm",(void*)f_4237},
{"f_4168:posixwin_scm",(void*)f_4168},
{"f_4184:posixwin_scm",(void*)f_4184},
{"f_4175:posixwin_scm",(void*)f_4175},
{"f_4148:posixwin_scm",(void*)f_4148},
{"f_4152:posixwin_scm",(void*)f_4152},
{"f_4158:posixwin_scm",(void*)f_4158},
{"f_4162:posixwin_scm",(void*)f_4162},
{"f_4128:posixwin_scm",(void*)f_4128},
{"f_4132:posixwin_scm",(void*)f_4132},
{"f_4138:posixwin_scm",(void*)f_4138},
{"f_4142:posixwin_scm",(void*)f_4142},
{"f_4104:posixwin_scm",(void*)f_4104},
{"f_4108:posixwin_scm",(void*)f_4108},
{"f_4119:posixwin_scm",(void*)f_4119},
{"f_4123:posixwin_scm",(void*)f_4123},
{"f_4113:posixwin_scm",(void*)f_4113},
{"f_4080:posixwin_scm",(void*)f_4080},
{"f_4084:posixwin_scm",(void*)f_4084},
{"f_4095:posixwin_scm",(void*)f_4095},
{"f_4099:posixwin_scm",(void*)f_4099},
{"f_4089:posixwin_scm",(void*)f_4089},
{"f_4061:posixwin_scm",(void*)f_4061},
{"f_4065:posixwin_scm",(void*)f_4065},
{"f_4068:posixwin_scm",(void*)f_4068},
{"f_4025:posixwin_scm",(void*)f_4025},
{"f_4056:posixwin_scm",(void*)f_4056},
{"f_4046:posixwin_scm",(void*)f_4046},
{"f_4039:posixwin_scm",(void*)f_4039},
{"f_3989:posixwin_scm",(void*)f_3989},
{"f_4020:posixwin_scm",(void*)f_4020},
{"f_4010:posixwin_scm",(void*)f_4010},
{"f_4003:posixwin_scm",(void*)f_4003},
{"f_3971:posixwin_scm",(void*)f_3971},
{"f_3975:posixwin_scm",(void*)f_3975},
{"f_3987:posixwin_scm",(void*)f_3987},
{"f_3965:posixwin_scm",(void*)f_3965},
{"f_3953:posixwin_scm",(void*)f_3953},
{"f_3596:posixwin_scm",(void*)f_3596},
{"f_3943:posixwin_scm",(void*)f_3943},
{"f_3742:posixwin_scm",(void*)f_3742},
{"f_3929:posixwin_scm",(void*)f_3929},
{"f_3918:posixwin_scm",(void*)f_3918},
{"f_3925:posixwin_scm",(void*)f_3925},
{"f_3772:posixwin_scm",(void*)f_3772},
{"f_3911:posixwin_scm",(void*)f_3911},
{"f_3890:posixwin_scm",(void*)f_3890},
{"f_3907:posixwin_scm",(void*)f_3907},
{"f_3896:posixwin_scm",(void*)f_3896},
{"f_3903:posixwin_scm",(void*)f_3903},
{"f_3814:posixwin_scm",(void*)f_3814},
{"f_3887:posixwin_scm",(void*)f_3887},
{"f_3866:posixwin_scm",(void*)f_3866},
{"f_3883:posixwin_scm",(void*)f_3883},
{"f_3872:posixwin_scm",(void*)f_3872},
{"f_3879:posixwin_scm",(void*)f_3879},
{"f_3820:posixwin_scm",(void*)f_3820},
{"f_3863:posixwin_scm",(void*)f_3863},
{"f_3859:posixwin_scm",(void*)f_3859},
{"f_3852:posixwin_scm",(void*)f_3852},
{"f_3848:posixwin_scm",(void*)f_3848},
{"f_3827:posixwin_scm",(void*)f_3827},
{"f_3831:posixwin_scm",(void*)f_3831},
{"f_3808:posixwin_scm",(void*)f_3808},
{"f_3795:posixwin_scm",(void*)f_3795},
{"f_3779:posixwin_scm",(void*)f_3779},
{"f_3783:posixwin_scm",(void*)f_3783},
{"f_3787:posixwin_scm",(void*)f_3787},
{"f_3766:posixwin_scm",(void*)f_3766},
{"f_3753:posixwin_scm",(void*)f_3753},
{"f_3749:posixwin_scm",(void*)f_3749},
{"f_3736:posixwin_scm",(void*)f_3736},
{"f_3603:posixwin_scm",(void*)f_3603},
{"f_3722:posixwin_scm",(void*)f_3722},
{"f_3610:posixwin_scm",(void*)f_3610},
{"f_3612:posixwin_scm",(void*)f_3612},
{"f_3619:posixwin_scm",(void*)f_3619},
{"f_3694:posixwin_scm",(void*)f_3694},
{"f_3703:posixwin_scm",(void*)f_3703},
{"f_3691:posixwin_scm",(void*)f_3691},
{"f_3625:posixwin_scm",(void*)f_3625},
{"f_3672:posixwin_scm",(void*)f_3672},
{"f_3660:posixwin_scm",(void*)f_3660},
{"f_3668:posixwin_scm",(void*)f_3668},
{"f_3664:posixwin_scm",(void*)f_3664},
{"f_3641:posixwin_scm",(void*)f_3641},
{"f_3649:posixwin_scm",(void*)f_3649},
{"f_3645:posixwin_scm",(void*)f_3645},
{"f_3540:posixwin_scm",(void*)f_3540},
{"f_3549:posixwin_scm",(void*)f_3549},
{"f_3573:posixwin_scm",(void*)f_3573},
{"f_3585:posixwin_scm",(void*)f_3585},
{"f_3591:posixwin_scm",(void*)f_3591},
{"f_3579:posixwin_scm",(void*)f_3579},
{"f_3555:posixwin_scm",(void*)f_3555},
{"f_3561:posixwin_scm",(void*)f_3561},
{"f_3547:posixwin_scm",(void*)f_3547},
{"f_3529:posixwin_scm",(void*)f_3529},
{"f_3524:posixwin_scm",(void*)f_3524},
{"f_3480:posixwin_scm",(void*)f_3480},
{"f_3493:posixwin_scm",(void*)f_3493},
{"f_3496:posixwin_scm",(void*)f_3496},
{"f_3453:posixwin_scm",(void*)f_3453},
{"f_3478:posixwin_scm",(void*)f_3478},
{"f_3474:posixwin_scm",(void*)f_3474},
{"f_3460:posixwin_scm",(void*)f_3460},
{"f_3296:posixwin_scm",(void*)f_3296},
{"f_3404:posixwin_scm",(void*)f_3404},
{"f_3412:posixwin_scm",(void*)f_3412},
{"f_3399:posixwin_scm",(void*)f_3399},
{"f_3298:posixwin_scm",(void*)f_3298},
{"f_3305:posixwin_scm",(void*)f_3305},
{"f_3308:posixwin_scm",(void*)f_3308},
{"f_3311:posixwin_scm",(void*)f_3311},
{"f_3398:posixwin_scm",(void*)f_3398},
{"f_3315:posixwin_scm",(void*)f_3315},
{"f_3332:posixwin_scm",(void*)f_3332},
{"f_3342:posixwin_scm",(void*)f_3342},
{"f_3354:posixwin_scm",(void*)f_3354},
{"f_3364:posixwin_scm",(void*)f_3364},
{"f_3324:posixwin_scm",(void*)f_3324},
{"f_3269:posixwin_scm",(void*)f_3269},
{"f_3294:posixwin_scm",(void*)f_3294},
{"f_3290:posixwin_scm",(void*)f_3290},
{"f_3282:posixwin_scm",(void*)f_3282},
{"f_3242:posixwin_scm",(void*)f_3242},
{"f_3267:posixwin_scm",(void*)f_3267},
{"f_3263:posixwin_scm",(void*)f_3263},
{"f_3255:posixwin_scm",(void*)f_3255},
{"f_3136:posixwin_scm",(void*)f_3136},
{"f_3211:posixwin_scm",(void*)f_3211},
{"f_3228:posixwin_scm",(void*)f_3228},
{"f_3220:posixwin_scm",(void*)f_3220},
{"f_3149:posixwin_scm",(void*)f_3149},
{"f_3152:posixwin_scm",(void*)f_3152},
{"f_3160:posixwin_scm",(void*)f_3160},
{"f_3165:posixwin_scm",(void*)f_3165},
{"f_3191:posixwin_scm",(void*)f_3191},
{"f_3194:posixwin_scm",(void*)f_3194},
{"f_3171:posixwin_scm",(void*)f_3171},
{"f_3188:posixwin_scm",(void*)f_3188},
{"f_3180:posixwin_scm",(void*)f_3180},
{"f_3071:posixwin_scm",(void*)f_3071},
{"f_3084:posixwin_scm",(void*)f_3084},
{"f_3099:posixwin_scm",(void*)f_3099},
{"f_3090:posixwin_scm",(void*)f_3090},
{"f_3093:posixwin_scm",(void*)f_3093},
{"f_3022:posixwin_scm",(void*)f_3022},
{"f_3024:posixwin_scm",(void*)f_3024},
{"f_3017:posixwin_scm",(void*)f_3017},
{"f_2994:posixwin_scm",(void*)f_2994},
{"f_3015:posixwin_scm",(void*)f_3015},
{"f_3001:posixwin_scm",(void*)f_3001},
{"f_2988:posixwin_scm",(void*)f_2988},
{"f_2992:posixwin_scm",(void*)f_2992},
{"f_2982:posixwin_scm",(void*)f_2982},
{"f_2986:posixwin_scm",(void*)f_2986},
{"f_2976:posixwin_scm",(void*)f_2976},
{"f_2980:posixwin_scm",(void*)f_2980},
{"f_2970:posixwin_scm",(void*)f_2970},
{"f_2974:posixwin_scm",(void*)f_2974},
{"f_2964:posixwin_scm",(void*)f_2964},
{"f_2968:posixwin_scm",(void*)f_2968},
{"f_2958:posixwin_scm",(void*)f_2958},
{"f_2962:posixwin_scm",(void*)f_2962},
{"f_2934:posixwin_scm",(void*)f_2934},
{"f_2941:posixwin_scm",(void*)f_2941},
{"f_2896:posixwin_scm",(void*)f_2896},
{"f_2929:posixwin_scm",(void*)f_2929},
{"f_2925:posixwin_scm",(void*)f_2925},
{"f_2900:posixwin_scm",(void*)f_2900},
{"f_2909:posixwin_scm",(void*)f_2909},
{"f_2858:posixwin_scm",(void*)f_2858},
{"f_2865:posixwin_scm",(void*)f_2865},
{"f_2868:posixwin_scm",(void*)f_2868},
{"f_2888:posixwin_scm",(void*)f_2888},
{"f_2871:posixwin_scm",(void*)f_2871},
{"f_2878:posixwin_scm",(void*)f_2878},
{"f_2816:posixwin_scm",(void*)f_2816},
{"f_2823:posixwin_scm",(void*)f_2823},
{"f_2838:posixwin_scm",(void*)f_2838},
{"f_2832:posixwin_scm",(void*)f_2832},
{"f_2771:posixwin_scm",(void*)f_2771},
{"f_2781:posixwin_scm",(void*)f_2781},
{"f_2784:posixwin_scm",(void*)f_2784},
{"f_2796:posixwin_scm",(void*)f_2796},
{"f_2787:posixwin_scm",(void*)f_2787},
{"f_2753:posixwin_scm",(void*)f_2753},
{"f_2766:posixwin_scm",(void*)f_2766},
{"f_2712:posixwin_scm",(void*)f_2712},
{"f_2745:posixwin_scm",(void*)f_2745},
{"f_2729:posixwin_scm",(void*)f_2729},
{"f_2738:posixwin_scm",(void*)f_2738},
{"f_2732:posixwin_scm",(void*)f_2732},
{"f_2666:posixwin_scm",(void*)f_2666},
{"f_2670:posixwin_scm",(void*)f_2670},
{"f_2681:posixwin_scm",(void*)f_2681},
{"f_2677:posixwin_scm",(void*)f_2677},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
