/* class LayoutManager
 *
 * Copyright (C) 2001  R M Pitman
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package charva.awt;

import java.util.Vector;

/**
 * Defines the interface for classes that know how to lay out Containers.
 */
public interface LayoutManager
{
    /**
     * Calculate the geometry for the specified list of Components, 
     * and return the size of the rectangle that encloses all the 
     * Components.
     */
    public Dimension minimumSize(Container container_);

    public void doLayout(Container container_);
}
