#ifndef H_CDW_TABS_WINDOW
#define H_CDW_TABS_WINDOW

#include "main.h"
#include "cdw_widgets.h"
#include "cdw_ncurses.h"


typedef struct {
	PANEL *panel; /* ncurses panel; tabbed window is implemented using ncurses panels, private field */
	WINDOW *window;
	WINDOW *subwindow;

	char *label; /* tab-specific label, displayed in right part of tabbed window */
	cdw_id_t id; /* tab ID, to be used mainly by client code */
	int hotkey;  /* key associated with a tab; pressing the key causes switching to associated tab */
} cdw_tab_t;

typedef int (* cdw_tabs_window_driver_reader_t) (void *twindow);

typedef struct {
	cdw_tab_t *tabs;  /* table of tabs */
	int n_tabs;       /* total number of tabs in tabbed window */
	int current_tab;  /* index of currently visible/selected tab */
	char *title;      /* window title, common for all tabs */
	char *subtitle;   /* window subtitle, displayed at the bottom of tabbed window, common for all tabs */

	void *user_data;

	struct {
		int n_lines;
		int n_cols;
		int begin_y;
		int begin_x;
		int tabs_width; /* width of area in which tab labels are displayed; usable area of tab window is n_cols - tabs_width */
	} geometry;

	cdw_tabs_window_driver_reader_t driver_reader;

	int return_keys[N_RETURN_KEYS_MAX]; /* return keys, i.e. "return control after pressing this key" keys; private field */
	int n_return_keys; /* current number of return keys; private field */

} cdw_tabs_window_t;



cdw_tabs_window_t *cdw_tabs_window_init(int n_tabs, const char *title, const char *subtitle);
void               cdw_tabs_window_delete(cdw_tabs_window_t **twindow);

void     cdw_tabs_window_set_geometry(cdw_tabs_window_t *twindow, int n_lines, int n_cols, int begin_y, int begin_x, int tabs_width);
cdw_rv_t cdw_tabs_window_append_tab(cdw_tabs_window_t *twindow, cdw_id_t id, int hotkey, const char *label);
cdw_rv_t cdw_tabs_window_finalize(cdw_tabs_window_t *twindow);
int      cdw_tabs_window_driver(cdw_tabs_window_t *twindow);
void     cdw_tabs_window_draw_tabs(cdw_tabs_window_t *twindow);
cdw_rv_t cdw_tabs_window_show_tab_by_id(cdw_tabs_window_t *twindow, cdw_id_t id);

void cdw_tabs_window_add_return_key(cdw_tabs_window_t *twindow, int key);

#endif /* H_CDW_TABS_WINDOW */
