#ifndef __MAIN_H
#define __MAIN_H



/* default disk name */
#define DEFAULT_VOLUMEID "cdrom"

void clean_before_cdw_exit(void);
int cdw_main_loop(void);


/* these two replace key values: 10 and 27;
   they are different than cdw function return values defined below;
   these two variables should not be used as cdw return values */
#define CDW_ENTER 10
#define CDW_ESCAPE 27


/**
 * Function return values. Introduced to avoid using only numbers
 * and to increase redability of code.
 */
enum cdw_return_value {
	CDW_OK = 0,                 /* use e.g after user pressed CDW_ENTER in buttonless widgets, when selected OK/yes button in widgets with buttons or when function returns with success */
	CDW_CANCEL = -1,            /* use e.g after user pressed CDW_ESCAPE in buttonless widgets, when user selected Cancel in widgets with buttons or when function returns with failure */
	CDW_NO = -2,                /* use after user pressed NO in widgets with buttons */
	CDW_GEN_ERROR = -30,        /* general error, may be used when no other error applies */
	CDW_FILE_INVALID = -31,     /* file properties are diffrent than assumed, eg. is not a directory */
	CDW_PERM_ERROR = -32,        /* file permissions different than assumed */
	CDW_MEM_ERROR = -33,       /* memory error: malloc() returning NULL is a very good example */
	CDW_SYS_ERROR = -34,       /* system function (eg. lstat()) call returns error */

	CDW_FAILSAFE_MODE = -99    /* options module works without reading/writing conf file on disk, because of previous errors */
};

typedef enum cdw_return_value cdw_rv_t;

#endif /* __MAIN */
