/*
  File autogenerated by gengetopt version 2.22.2
  generated with the following command:
  /usr/bin/gengetopt -C --unamed-opts=URL --output-dir ../src --no-version -c cpp 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include "getopt.h"

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: " CMDLINE_PARSER_PACKAGE " [OPTIONS]... [URL]...";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -v, --version                 Print version and exit",
  "      --hosts                   List supported hosts",
  "\nOutput:",
  "  -q, --quiet                   Turn off all output",
  "      --debug                   Turn on libcurl verbose mode",
  "      --emit-csv                Print video details in csv format to stdout",
  "      --print-fname             Print filename before each download starts",
  "\nHTTP:",
  "      --agent=<agentstring>     Identify cclive as agentstring to servers  \n                                  (default=`Mozilla/5.0')",
  "      --proxy=proxyhost[:port]  Use specified proxy",
  "      --no-proxy                Do not use proxy even if http_proxy is defined",
  "      --connect-timeout=<seconds>\n                                Max time allowed connection to server take  \n                                  (default=`30')",
  "      --connect-timeout-socks=<seconds>\n                                Same but works around 'SOCKS proxy connect \n                                  timeout' bug in libcurl  (default=`30')",
  "  -t, --retry=<number>          Number of retries  (default=`5')",
  "      --retry-wait=<seconds>    wait 1..seconds between retries  (default=`1')",
  "\nDownload:",
  "  -O, --output-video=<file>     Write video to file",
  "  -c, --continue                Resume partially downloaded file",
  "  -W, --overwrite               Overwrite existing file",
  "  -n, --no-extract              Do not actually extract video, simulate only",
  "  -l, --limit-rate=<amount>     Limit download speed to amount KB/s",
  "  -f, --format=<formatid>       Download format of video  (possible \n                                  values=\"flv\", \"best\", \"fmt17\", \n                                  \"fmt18\", \"fmt22\", \"fmt34\", \"fmt35\", \n                                  \"hq\", \"3gp\", \"spark-mini\", \"vp6-hq\", \n                                  \"vp6-hd\", \"vp6\", \"h264\", \"hd\", \n                                  \"mp4\", \"high\", \"ipod\", \"vp6_576\", \n                                  \"vp6_928\", \"h264_1400\" default=`flv')",
  "  -M, --format-map=<mapstring>  Specify format for multiple hosts in a string",
  "\nFilename formatting:",
  "  -N, --number-videos           Prepend a numeric prefix to output filenames",
  "  -r, --regexp=<expr>           Regular expression to cleanup video title",
  "  -g, --find-all                Match all occurences, like Perl's /g option",
  "  -F, --filename-format=<formatstring>\n                                Output filename format  (default=`%h_%i.%s')",
  "\nSubsequent:",
  "      --exec=<expr[;|+]>        Command to invoke when transfer finishes",
  "  -e, --exec-run                Invoke command specified with --exec",
  "\nStreaming:",
  "      --stream-exec=<expr>      Stream command to be invoked",
  "  -s, --stream-pass             Pass video link to --stream-exec command",
  "      --stream=<percent>        Invoke --stream-exec when transfer reaches %",
  "\nSee the manual page for examples.",
    0
};

typedef enum {ARG_NO
  , ARG_STRING
  , ARG_INT
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);
struct line_list
{
  char * string_arg;
  struct line_list * next;
};

static struct line_list *cmd_line_list = 0;
static struct line_list *cmd_line_list_tmp = 0;

static void
free_cmd_list(void)
{
  /* free the list of a previous call */
  if (cmd_line_list)
    {
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


const char *cmdline_parser_format_values[] = {"flv", "best", "fmt17", "fmt18", "fmt22", "fmt34", "fmt35", "hq", "3gp", "spark-mini", "vp6-hq", "vp6-hd", "vp6", "h264", "hd", "mp4", "high", "ipod", "vp6_576", "vp6_928", "h264_1400", 0}; /*< Possible values for format. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->hosts_given = 0 ;
  args_info->quiet_given = 0 ;
  args_info->debug_given = 0 ;
  args_info->emit_csv_given = 0 ;
  args_info->print_fname_given = 0 ;
  args_info->agent_given = 0 ;
  args_info->proxy_given = 0 ;
  args_info->no_proxy_given = 0 ;
  args_info->connect_timeout_given = 0 ;
  args_info->connect_timeout_socks_given = 0 ;
  args_info->retry_given = 0 ;
  args_info->retry_wait_given = 0 ;
  args_info->output_video_given = 0 ;
  args_info->continue_given = 0 ;
  args_info->overwrite_given = 0 ;
  args_info->no_extract_given = 0 ;
  args_info->limit_rate_given = 0 ;
  args_info->format_given = 0 ;
  args_info->format_map_given = 0 ;
  args_info->number_videos_given = 0 ;
  args_info->regexp_given = 0 ;
  args_info->find_all_given = 0 ;
  args_info->filename_format_given = 0 ;
  args_info->exec_given = 0 ;
  args_info->exec_run_given = 0 ;
  args_info->stream_exec_given = 0 ;
  args_info->stream_pass_given = 0 ;
  args_info->stream_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->agent_arg = gengetopt_strdup ("Mozilla/5.0");
  args_info->agent_orig = NULL;
  args_info->proxy_arg = NULL;
  args_info->proxy_orig = NULL;
  args_info->connect_timeout_arg = 30;
  args_info->connect_timeout_orig = NULL;
  args_info->connect_timeout_socks_arg = 30;
  args_info->connect_timeout_socks_orig = NULL;
  args_info->retry_arg = 5;
  args_info->retry_orig = NULL;
  args_info->retry_wait_arg = 1;
  args_info->retry_wait_orig = NULL;
  args_info->output_video_arg = NULL;
  args_info->output_video_orig = NULL;
  args_info->limit_rate_orig = NULL;
  args_info->format_arg = gengetopt_strdup ("flv");
  args_info->format_orig = NULL;
  args_info->format_map_arg = NULL;
  args_info->format_map_orig = NULL;
  args_info->regexp_arg = NULL;
  args_info->regexp_orig = NULL;
  args_info->filename_format_arg = gengetopt_strdup ("%h_%i.%s");
  args_info->filename_format_orig = NULL;
  args_info->exec_arg = NULL;
  args_info->exec_orig = NULL;
  args_info->stream_exec_arg = NULL;
  args_info->stream_exec_orig = NULL;
  args_info->stream_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->hosts_help = gengetopt_args_info_help[2] ;
  args_info->quiet_help = gengetopt_args_info_help[4] ;
  args_info->debug_help = gengetopt_args_info_help[5] ;
  args_info->emit_csv_help = gengetopt_args_info_help[6] ;
  args_info->print_fname_help = gengetopt_args_info_help[7] ;
  args_info->agent_help = gengetopt_args_info_help[9] ;
  args_info->proxy_help = gengetopt_args_info_help[10] ;
  args_info->no_proxy_help = gengetopt_args_info_help[11] ;
  args_info->connect_timeout_help = gengetopt_args_info_help[12] ;
  args_info->connect_timeout_socks_help = gengetopt_args_info_help[13] ;
  args_info->retry_help = gengetopt_args_info_help[14] ;
  args_info->retry_wait_help = gengetopt_args_info_help[15] ;
  args_info->output_video_help = gengetopt_args_info_help[17] ;
  args_info->continue_help = gengetopt_args_info_help[18] ;
  args_info->overwrite_help = gengetopt_args_info_help[19] ;
  args_info->no_extract_help = gengetopt_args_info_help[20] ;
  args_info->limit_rate_help = gengetopt_args_info_help[21] ;
  args_info->format_help = gengetopt_args_info_help[22] ;
  args_info->format_map_help = gengetopt_args_info_help[23] ;
  args_info->number_videos_help = gengetopt_args_info_help[25] ;
  args_info->regexp_help = gengetopt_args_info_help[26] ;
  args_info->find_all_help = gengetopt_args_info_help[27] ;
  args_info->filename_format_help = gengetopt_args_info_help[28] ;
  args_info->exec_help = gengetopt_args_info_help[30] ;
  args_info->exec_run_help = gengetopt_args_info_help[31] ;
  args_info->stream_exec_help = gengetopt_args_info_help[33] ;
  args_info->stream_pass_help = gengetopt_args_info_help[34] ;
  args_info->stream_help = gengetopt_args_info_help[35] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);
}

static void print_help_common(void) {
  cmdline_parser_print_version ();

  if (strlen(gengetopt_args_info_purpose) > 0)
    printf("\n%s\n", gengetopt_args_info_purpose);

  if (strlen(gengetopt_args_info_usage) > 0)
    printf("\n%s\n", gengetopt_args_info_usage);

  printf("\n");

  if (strlen(gengetopt_args_info_description) > 0)
    printf("%s\n\n", gengetopt_args_info_description);
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->agent_arg));
  free_string_field (&(args_info->agent_orig));
  free_string_field (&(args_info->proxy_arg));
  free_string_field (&(args_info->proxy_orig));
  free_string_field (&(args_info->connect_timeout_orig));
  free_string_field (&(args_info->connect_timeout_socks_orig));
  free_string_field (&(args_info->retry_orig));
  free_string_field (&(args_info->retry_wait_orig));
  free_string_field (&(args_info->output_video_arg));
  free_string_field (&(args_info->output_video_orig));
  free_string_field (&(args_info->limit_rate_orig));
  free_string_field (&(args_info->format_arg));
  free_string_field (&(args_info->format_orig));
  free_string_field (&(args_info->format_map_arg));
  free_string_field (&(args_info->format_map_orig));
  free_string_field (&(args_info->regexp_arg));
  free_string_field (&(args_info->regexp_orig));
  free_string_field (&(args_info->filename_format_arg));
  free_string_field (&(args_info->filename_format_orig));
  free_string_field (&(args_info->exec_arg));
  free_string_field (&(args_info->exec_orig));
  free_string_field (&(args_info->stream_exec_arg));
  free_string_field (&(args_info->stream_exec_orig));
  free_string_field (&(args_info->stream_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->hosts_given)
    write_into_file(outfile, "hosts", 0, 0 );
  if (args_info->quiet_given)
    write_into_file(outfile, "quiet", 0, 0 );
  if (args_info->debug_given)
    write_into_file(outfile, "debug", 0, 0 );
  if (args_info->emit_csv_given)
    write_into_file(outfile, "emit-csv", 0, 0 );
  if (args_info->print_fname_given)
    write_into_file(outfile, "print-fname", 0, 0 );
  if (args_info->agent_given)
    write_into_file(outfile, "agent", args_info->agent_orig, 0);
  if (args_info->proxy_given)
    write_into_file(outfile, "proxy", args_info->proxy_orig, 0);
  if (args_info->no_proxy_given)
    write_into_file(outfile, "no-proxy", 0, 0 );
  if (args_info->connect_timeout_given)
    write_into_file(outfile, "connect-timeout", args_info->connect_timeout_orig, 0);
  if (args_info->connect_timeout_socks_given)
    write_into_file(outfile, "connect-timeout-socks", args_info->connect_timeout_socks_orig, 0);
  if (args_info->retry_given)
    write_into_file(outfile, "retry", args_info->retry_orig, 0);
  if (args_info->retry_wait_given)
    write_into_file(outfile, "retry-wait", args_info->retry_wait_orig, 0);
  if (args_info->output_video_given)
    write_into_file(outfile, "output-video", args_info->output_video_orig, 0);
  if (args_info->continue_given)
    write_into_file(outfile, "continue", 0, 0 );
  if (args_info->overwrite_given)
    write_into_file(outfile, "overwrite", 0, 0 );
  if (args_info->no_extract_given)
    write_into_file(outfile, "no-extract", 0, 0 );
  if (args_info->limit_rate_given)
    write_into_file(outfile, "limit-rate", args_info->limit_rate_orig, 0);
  if (args_info->format_given)
    write_into_file(outfile, "format", args_info->format_orig, cmdline_parser_format_values);
  if (args_info->format_map_given)
    write_into_file(outfile, "format-map", args_info->format_map_orig, 0);
  if (args_info->number_videos_given)
    write_into_file(outfile, "number-videos", 0, 0 );
  if (args_info->regexp_given)
    write_into_file(outfile, "regexp", args_info->regexp_orig, 0);
  if (args_info->find_all_given)
    write_into_file(outfile, "find-all", 0, 0 );
  if (args_info->filename_format_given)
    write_into_file(outfile, "filename-format", args_info->filename_format_orig, 0);
  if (args_info->exec_given)
    write_into_file(outfile, "exec", args_info->exec_orig, 0);
  if (args_info->exec_run_given)
    write_into_file(outfile, "exec-run", 0, 0 );
  if (args_info->stream_exec_given)
    write_into_file(outfile, "stream-exec", args_info->stream_exec_orig, 0);
  if (args_info->stream_pass_given)
    write_into_file(outfile, "stream-pass", 0, 0 );
  if (args_info->stream_given)
    write_into_file(outfile, "stream", args_info->stream_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char * const *argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  FIX_UNUSED (additional_error);
  int error = 0;

  /* checks for required options */
  
  /* checks for dependences among options */
  if (args_info->find_all_given && ! args_info->regexp_given)
    {
      fprintf (stderr, "%s: '--find-all' ('-g') option depends on option 'regexp'%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  if (args_info->exec_run_given && ! args_info->exec_given)
    {
      fprintf (stderr, "%s: '--exec-run' ('-e') option depends on option 'exec'%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  if (args_info->stream_pass_given && ! args_info->stream_exec_given)
    {
      fprintf (stderr, "%s: '--stream-pass' ('-s') option depends on option 'stream-exec'%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }
  if (args_info->stream_given && ! args_info->stream_exec_given)
    {
      fprintf (stderr, "%s: '--stream' option depends on option 'stream-exec'%s\n", prog_name, (additional_error ? additional_error : ""));
      error = 1;
    }

  return error;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  FIX_UNUSED (field);
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char * const *argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  override = params->override;
  initialize = params->initialize;
  check_required = params->check_required;
  check_ambiguity = params->check_ambiguity;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'v' },
        { "hosts",	0, NULL, 0 },
        { "quiet",	0, NULL, 'q' },
        { "debug",	0, NULL, 0 },
        { "emit-csv",	0, NULL, 0 },
        { "print-fname",	0, NULL, 0 },
        { "agent",	1, NULL, 0 },
        { "proxy",	1, NULL, 0 },
        { "no-proxy",	0, NULL, 0 },
        { "connect-timeout",	1, NULL, 0 },
        { "connect-timeout-socks",	1, NULL, 0 },
        { "retry",	1, NULL, 't' },
        { "retry-wait",	1, NULL, 0 },
        { "output-video",	1, NULL, 'O' },
        { "continue",	0, NULL, 'c' },
        { "overwrite",	0, NULL, 'W' },
        { "no-extract",	0, NULL, 'n' },
        { "limit-rate",	1, NULL, 'l' },
        { "format",	1, NULL, 'f' },
        { "format-map",	1, NULL, 'M' },
        { "number-videos",	0, NULL, 'N' },
        { "regexp",	1, NULL, 'r' },
        { "find-all",	0, NULL, 'g' },
        { "filename-format",	1, NULL, 'F' },
        { "exec",	1, NULL, 0 },
        { "exec-run",	0, NULL, 'e' },
        { "stream-exec",	1, NULL, 0 },
        { "stream-pass",	0, NULL, 's' },
        { "stream",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hvqt:O:cWnl:f:M:Nr:gF:es", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'v':	/* Print version and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->version_given),
              &(local_args_info.version_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "version", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'q':	/* Turn off all output.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->quiet_given),
              &(local_args_info.quiet_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "quiet", 'q',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* Number of retries.  */
        
        
          if (update_arg( (void *)&(args_info->retry_arg), 
               &(args_info->retry_orig), &(args_info->retry_given),
              &(local_args_info.retry_given), optarg, 0, "5", ARG_INT,
              check_ambiguity, override, 0, 0,
              "retry", 't',
              additional_error))
            goto failure;
        
          break;
        case 'O':	/* Write video to file.  */
        
        
          if (update_arg( (void *)&(args_info->output_video_arg), 
               &(args_info->output_video_orig), &(args_info->output_video_given),
              &(local_args_info.output_video_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output-video", 'O',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Resume partially downloaded file.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->continue_given),
              &(local_args_info.continue_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "continue", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'W':	/* Overwrite existing file.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->overwrite_given),
              &(local_args_info.overwrite_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "overwrite", 'W',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* Do not actually extract video, simulate only.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->no_extract_given),
              &(local_args_info.no_extract_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "no-extract", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* Limit download speed to amount KB/s.  */
        
        
          if (update_arg( (void *)&(args_info->limit_rate_arg), 
               &(args_info->limit_rate_orig), &(args_info->limit_rate_given),
              &(local_args_info.limit_rate_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "limit-rate", 'l',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Download format of video.  */
        
        
          if (update_arg( (void *)&(args_info->format_arg), 
               &(args_info->format_orig), &(args_info->format_given),
              &(local_args_info.format_given), optarg, cmdline_parser_format_values, "flv", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "format", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'M':	/* Specify format for multiple hosts in a string.  */
        
        
          if (update_arg( (void *)&(args_info->format_map_arg), 
               &(args_info->format_map_orig), &(args_info->format_map_given),
              &(local_args_info.format_map_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "format-map", 'M',
              additional_error))
            goto failure;
        
          break;
        case 'N':	/* Prepend a numeric prefix to output filenames.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->number_videos_given),
              &(local_args_info.number_videos_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "number-videos", 'N',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Regular expression to cleanup video title.  */
        
        
          if (update_arg( (void *)&(args_info->regexp_arg), 
               &(args_info->regexp_orig), &(args_info->regexp_given),
              &(local_args_info.regexp_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "regexp", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'g':	/* Match all occurences, like Perl's /g option.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->find_all_given),
              &(local_args_info.find_all_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "find-all", 'g',
              additional_error))
            goto failure;
        
          break;
        case 'F':	/* Output filename format.  */
        
        
          if (update_arg( (void *)&(args_info->filename_format_arg), 
               &(args_info->filename_format_orig), &(args_info->filename_format_given),
              &(local_args_info.filename_format_given), optarg, 0, "%h_%i.%s", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "filename-format", 'F',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Invoke command specified with --exec.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->exec_run_given),
              &(local_args_info.exec_run_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "exec-run", 'e',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Pass video link to --stream-exec command.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->stream_pass_given),
              &(local_args_info.stream_pass_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "stream-pass", 's',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* List supported hosts.  */
          if (strcmp (long_options[option_index].name, "hosts") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->hosts_given),
                &(local_args_info.hosts_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "hosts", '-',
                additional_error))
              goto failure;
          
          }
          /* Turn on libcurl verbose mode.  */
          else if (strcmp (long_options[option_index].name, "debug") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->debug_given),
                &(local_args_info.debug_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "debug", '-',
                additional_error))
              goto failure;
          
          }
          /* Print video details in csv format to stdout.  */
          else if (strcmp (long_options[option_index].name, "emit-csv") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->emit_csv_given),
                &(local_args_info.emit_csv_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "emit-csv", '-',
                additional_error))
              goto failure;
          
          }
          /* Print filename before each download starts.  */
          else if (strcmp (long_options[option_index].name, "print-fname") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->print_fname_given),
                &(local_args_info.print_fname_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "print-fname", '-',
                additional_error))
              goto failure;
          
          }
          /* Identify cclive as agentstring to servers.  */
          else if (strcmp (long_options[option_index].name, "agent") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->agent_arg), 
                 &(args_info->agent_orig), &(args_info->agent_given),
                &(local_args_info.agent_given), optarg, 0, "Mozilla/5.0", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "agent", '-',
                additional_error))
              goto failure;
          
          }
          /* Use specified proxy.  */
          else if (strcmp (long_options[option_index].name, "proxy") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->proxy_arg), 
                 &(args_info->proxy_orig), &(args_info->proxy_given),
                &(local_args_info.proxy_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "proxy", '-',
                additional_error))
              goto failure;
          
          }
          /* Do not use proxy even if http_proxy is defined.  */
          else if (strcmp (long_options[option_index].name, "no-proxy") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->no_proxy_given),
                &(local_args_info.no_proxy_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "no-proxy", '-',
                additional_error))
              goto failure;
          
          }
          /* Max time allowed connection to server take.  */
          else if (strcmp (long_options[option_index].name, "connect-timeout") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->connect_timeout_arg), 
                 &(args_info->connect_timeout_orig), &(args_info->connect_timeout_given),
                &(local_args_info.connect_timeout_given), optarg, 0, "30", ARG_INT,
                check_ambiguity, override, 0, 0,
                "connect-timeout", '-',
                additional_error))
              goto failure;
          
          }
          /* Same but works around 'SOCKS proxy connect timeout' bug in libcurl.  */
          else if (strcmp (long_options[option_index].name, "connect-timeout-socks") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->connect_timeout_socks_arg), 
                 &(args_info->connect_timeout_socks_orig), &(args_info->connect_timeout_socks_given),
                &(local_args_info.connect_timeout_socks_given), optarg, 0, "30", ARG_INT,
                check_ambiguity, override, 0, 0,
                "connect-timeout-socks", '-',
                additional_error))
              goto failure;
          
          }
          /* wait 1..seconds between retries.  */
          else if (strcmp (long_options[option_index].name, "retry-wait") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->retry_wait_arg), 
                 &(args_info->retry_wait_orig), &(args_info->retry_wait_given),
                &(local_args_info.retry_wait_given), optarg, 0, "1", ARG_INT,
                check_ambiguity, override, 0, 0,
                "retry-wait", '-',
                additional_error))
              goto failure;
          
          }
          /* Command to invoke when transfer finishes.  */
          else if (strcmp (long_options[option_index].name, "exec") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->exec_arg), 
                 &(args_info->exec_orig), &(args_info->exec_given),
                &(local_args_info.exec_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "exec", '-',
                additional_error))
              goto failure;
          
          }
          /* Stream command to be invoked.  */
          else if (strcmp (long_options[option_index].name, "stream-exec") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->stream_exec_arg), 
                 &(args_info->stream_exec_orig), &(args_info->stream_exec_given),
                &(local_args_info.stream_exec_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "stream-exec", '-',
                additional_error))
              goto failure;
          
          }
          /* Invoke --stream-exec when transfer reaches %.  */
          else if (strcmp (long_options[option_index].name, "stream") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->stream_arg), 
                 &(args_info->stream_orig), &(args_info->stream_given),
                &(local_args_info.stream_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "stream", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



  if (check_required)
    {
      error += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

#ifndef CONFIG_FILE_LINE_SIZE
#define CONFIG_FILE_LINE_SIZE 2048
#endif
#define ADDITIONAL_ERROR " in configuration file "

#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)
/* 3 is for "--" and "=" */

static int
_cmdline_parser_configfile (const char *filename, int *my_argc)
{
  FILE* file;
  char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE+1];
  char linebuf[CONFIG_FILE_LINE_SIZE];
  int line_num = 0;
  int result = 0, equal;
  char *fopt, *farg;
  char *str_index;
  size_t len, next_token;
  char delimiter;

  if ((file = fopen(filename, "r")) == 0)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != 0)
    {
      ++line_num;
      my_argv[0] = '\0';
      len = strlen(linebuf);
      if (len > (CONFIG_FILE_LINE_BUFFER_SIZE-1))
        {
          fprintf (stderr, "%s:%s:%d: Line too long in configuration file\n",
                   CMDLINE_PARSER_PACKAGE, filename, line_num);
          result = EXIT_FAILURE;
          break;
        }

      /* find first non-whitespace character in the line */
      next_token = strspn (linebuf, " \t\r\n");
      str_index  = linebuf + next_token;

      if ( str_index[0] == '\0' || str_index[0] == '#')
        continue; /* empty line or comment line is skipped */

      fopt = str_index;

      /* truncate fopt at the end of the first non-valid character */
      next_token = strcspn (fopt, " \t\r\n=");

      if (fopt[next_token] == '\0') /* the line is over */
        {
          farg  = 0;
          equal = 0;
          goto noarg;
        }

      /* remember if equal sign is present */
      equal = (fopt[next_token] == '=');
      fopt[next_token++] = '\0';

      /* advance pointers to the next token after the end of fopt */
      next_token += strspn (fopt + next_token, " \t\r\n");

      /* check for the presence of equal sign, and if so, skip it */
      if ( !equal )
        if ((equal = (fopt[next_token] == '=')))
          {
            next_token++;
            next_token += strspn (fopt + next_token, " \t\r\n");
          }
      str_index  += next_token;

      /* find argument */
      farg = str_index;
      if ( farg[0] == '\"' || farg[0] == '\'' )
        { /* quoted argument */
          str_index = strchr (++farg, str_index[0] ); /* skip opening quote */
          if (! str_index)
            {
              fprintf
                (stderr,
                 "%s:%s:%d: unterminated string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }
      else
        { /* read up the remaining part up to a delimiter */
          next_token = strcspn (farg, " \t\r\n#\'\"");
          str_index += next_token;
        }

      /* truncate farg at the delimiter and store it for further check */
      delimiter = *str_index, *str_index++ = '\0';

      /* everything but comment is illegal at the end of line */
      if (delimiter != '\0' && delimiter != '#')
        {
          str_index += strspn(str_index, " \t\r\n");
          if (*str_index != '\0' && *str_index != '#')
            {
              fprintf
                (stderr,
                 "%s:%s:%d: malformed string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }

    noarg:
      if (!strcmp(fopt,"include")) {
        if (farg && *farg) {
          result = _cmdline_parser_configfile(farg, my_argc);
        } else {
          fprintf(stderr, "%s:%s:%d: include requires a filename argument.\n",
                  CMDLINE_PARSER_PACKAGE, filename, line_num);
        }
        continue;
      }
      len = strlen(fopt);
      strcat (my_argv, len > 1 ? "--" : "-");
      strcat (my_argv, fopt);
      if (len > 1 && ((farg && *farg) || equal))
        strcat (my_argv, "=");
      if (farg && *farg)
        strcat (my_argv, farg);
      ++(*my_argc);

      cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
      cmd_line_list_tmp->next = cmd_line_list;
      cmd_line_list = cmd_line_list_tmp;
      cmd_line_list->string_arg = gengetopt_strdup(my_argv);
    } /* while */

  if (file)
    fclose(file);
  return result;
}

int
cmdline_parser_configfile (
  const char *filename,
                           struct gengetopt_args_info *args_info,
                           int override, int initialize, int check_required)
{
  struct cmdline_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;
  
  return cmdline_parser_config_file (filename, args_info, &params);
}

int
cmdline_parser_config_file (const char *filename,
                           struct gengetopt_args_info *args_info,
                           struct cmdline_parser_params *params)
{
  int i, result;
  int my_argc = 1;
  char **my_argv_arg;
  char *additional_error;

  /* store the program name */
  cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
  cmd_line_list_tmp->next = cmd_line_list;
  cmd_line_list = cmd_line_list_tmp;
  cmd_line_list->string_arg = gengetopt_strdup (CMDLINE_PARSER_PACKAGE);

  result = _cmdline_parser_configfile(filename, &my_argc);

  if (result != EXIT_FAILURE) {
    my_argv_arg = (char **) malloc((my_argc+1) * sizeof(char *));
    cmd_line_list_tmp = cmd_line_list;

    for (i = my_argc - 1; i >= 0; --i) {
      my_argv_arg[i] = cmd_line_list_tmp->string_arg;
      cmd_line_list_tmp = cmd_line_list_tmp->next;
    }

    my_argv_arg[my_argc] = 0;

    additional_error = (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) + 1);
    strcpy (additional_error, ADDITIONAL_ERROR);
    strcat (additional_error, filename);
    result =
      cmdline_parser_internal (my_argc, my_argv_arg, args_info,
                              params,
                              additional_error);

    free (additional_error);
    free (my_argv_arg);
  }

  free_cmd_list();
  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}
