#ifndef TRACEMODULE_H
#define TRACEMODULE_H

#include <qlistview.h>
#include <qstring.h>

class CTraceManager;

class CTraceModule
{
private:
   CTraceManager *m_pManager;
   QString ModuleName;
   int m_Level;
   char LargeBuffer[2048];

public:
   CTraceModule(CTraceManager *mgr, const QString &name, int level);

   QString GetName() const;
   int GetLevel() const;

   void Enter(const QString &function_name);
   void Enter(const QString &file_name, int line_number);
   void Leave(const QString &function_name);
   void Leave(const QString &file_name, int line_number);
   void Log(int level, const char *fmt, ...);

public slots:
   void IncLevel();
   void DecLevel();
   void SetLevel(int);
};



#endif
