#ifndef VIDEOOPTIONS_HPP
#define VIDEOOPTIONS_HPP

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "OptionsXML.h"

struct CVideoOptions: public COptionsXML
{
private:
   QString m_Name, m_Node;

protected:
   void DeclareVariables();

public:
   enum MiddlePartOption
   {
     Overwrite,
     Timestamp,
     Sequence,
   };

   CVideoOptions();

   virtual void SetXML(const QDomNode &);
   virtual void GetXML(QDomNode &) const;

   QString GetDeviceName() const;
   void SetDeviceName(const QString &name);
   QString GetNodeName() const;
   void SetNodeName(const QString &node);
   QString GetAudioDeviceName() const;
   void SetAudioDeviceName(const QString &name);
   QString GetAudioNode() const;
   void SetAudioNode(const QString &number);

   QString GetBaseName() const;
   void SetBaseName(const QString &basename);
   MiddlePartOption GetMiddlePart() const;
   void SetMiddlePart(MiddlePartOption option);
   QString GetFileFormat() const;
   void SetFileFormat(const QString &format);

   QColor GetTextColor() const;
   void SetTextColor(const QColor &color);
   void SetTextColor(const QString &color_name);
   QFont GetTextFont() const;
   void SetTextFont(const QFont &font);
   bool GetTimeInImage() const;
   void SetTimeInImage(bool value);
///   int GetSaveOption() const;
///   void SetSaveOption(int value);
   int GetSequence() const;
   void SetSequence(int value);
   int GetMaxSequence() const;
   void SetMaxSequence(int max);
   bool GetSaveToDisk() const;
   void SetSaveToDisk(bool value);
   int GetSnapInterval() const;
   void SetSnapInterval(int value);
   bool GetFTPToServer() const;
   void SetFTPToServer(bool value);
   QString GetFTPServer() const;
   void SetFTPServer(const QString &server);
   int GetFTPPort() const;
   void SetFTPPort(int port_number);
   QString GetFTPPath() const;
   void SetFTPPath(const QString &path);
   QString GetFTPUser() const;
   void SetFTPUser(const QString &user);
   QString GetFTPPass() const;
   void SetFTPPass(const QString &pass);
   bool GetFTPPassive() const;
   void SetFTPPassive(bool passive);
   bool GetFTPUnique() const;
   void SetFTPUnique(bool unique);
   bool GetRunCommand() const;
   void SetRunCommand(bool);
   QString GetCommand() const;
   void SetCommand(const QString &command);
   QString GetUserMessage() const;
   void SetUserMessage(const QString &message);
};

#endif
