#ifndef VIDEO_DEVICE_WIN32_HPP
#define VIDEO_DEVICE_WIN32_HPP

#include <qglobal.h>
#include <qwidget.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <windows.h>
#include <vfw.h>

#include "VideoDevice.h"

class CVideoDeviceWin32: public CVideoDevice
{
   Q_OBJECT
private:
   enum Palettes {
     palRGB24 = 24,
     palRGB32 = 32,
     palI420 = 0x30323449,
   };

   int m_CapIndex;
   HWND m_CapHandle;
   CAPSTATUS m_CaptureStatus;
   QWaitCondition m_Capturing;
   int m_Palette;
   int m_BMISize;
   uchar *m_pBMIBuf;
   BITMAPINFO *m_pVideoInfo;

   void CreateImagesRGB();
   void DeleteImagesRGB();
   void CreateImagesYUV();
   void DeleteImagesYUV();

   bool TryPalette(Palettes pal);
   void UpdateCaptureStatus();

   void DumpVideoFormat(const BITMAPINFO *info) const;
   void DumpCaptureParms(const CAPTUREPARMS *cp) const;
   void DumpCaptureStatus(const CAPSTATUS *cs = 0) const;

protected:
   virtual bool Init();
   virtual void Exit();

   virtual bool StartCapture();
   virtual void StopCapture();

   virtual void run();

public:
   CVideoDeviceWin32(int index);
   ~CVideoDeviceWin32();

   virtual long GetDescriptor() const;
   virtual void Mute(bool on) const;
   
   /* Windows only */
   //bool CallbackAudioStream(int id, const QString &text);
   bool CallbackControl(int id);
   bool CallbackError(int id, const QString &text);
   bool CallbackStatus(int id, const QString &text);
   bool CallbackVideoStream(VIDEOHDR *vh);
   bool CallbackYield();

public slots: /* overloaded slots */
   void ShowDisplayDialog();
   void ShowFormatDialog();
   void ShowSourceDialog();
};

#endif
