/* Add functions */

#ifdef HAVE_INTELCPU

#include "video_def.h"

.globl	calc_add
.globl	calc_add_mmx
.globl	calc_add_mmxs
.globl	calc_add128_mmx

	.text

calc_add:
	enter $0, $0
	push %ebx
	push %esi
	push %edi

	mov Number, %ecx
	mov Dst, %edi
	mov Src1, %esi

0:	lodsb
	add %al, (%edi)
	inc %edi
	loop 0b

9:	pop %edi
	pop %esi
	pop %ebx
	leave
	ret

calc_add_mmx:
	enter $0, $0
	push %ebx
	push %esi
	push %edi

	mov Number, %ecx
	mov Dst, %edi
	mov Src1, %esi

	shr $3, %ecx		# Divide by 8 (!)

0:	movq (%esi), %mm0
	add $8, %esi
	movq (%edi), %mm1
	paddb %mm1, %mm0	# add, with overflow
	movq %mm0, (%edi)
	add $8, %edi
	loop 0

9:	pop %edi
	pop %esi
	pop %ebx
	leave
	ret


calc_add_mmxs:
	enter $0, $0
	push %ebx
	push %esi
	push %edi

	mov Number, %ecx
	mov Dst, %edi
	mov Src1, %esi

	shr $3, %ecx		# Divide by 8 (!)

0:	movq (%esi), %mm0
	add $8, %esi
	movq (%edi), %mm1
	paddsb %mm1, %mm0	# add, with saturation
	movq %mm0, (%edi)
	add $8, %edi
	loop 0

9:	pop %edi
	pop %esi
	pop %ebx
	leave
	ret

calc_add128_mmx:
	enter $0, $0
	push %ebx
	push %esi
	push %edi

	mov Number, %ecx
	mov Dst, %edi
	mov Src1, %esi

	shr $3, %ecx		# Divide by 8 (!)
	movq mm_128b, %mm7	# load constant

0:	movq (%esi), %mm0
	add $8, %esi
	psubb %mm7, %mm0	# compensate null-point
	movq (%edi), %mm1
	paddb %mm1, %mm0	# add, with overflow
	movq %mm0, (%edi)
	add $8, %edi
	loop 0

9:	pop %edi
	pop %esi
	pop %ebx
	leave
	ret

#endif /* HAVE_INTELCPU */
