
#include <qimage.h>

#include "CodecImageSubband.h"

static bool DoCompare(const char *file_name)
{
   QImage img;
   CCodecImageSubband sub1, sub2;
   int w, h;

   if (!img.load(file_name))
   {
     qWarning("Could not load '%s'", file_name);
     return false;
   }

   w = img.width();
   h = img.height();
   qDebug("Loaded, size is %dx%d", w, h);
   sub1.Load(w, h, img.bits());
   sub2.Load(w, h, img.bits());
   qDebug("Recursion depth = %d", sub1.GetDepth());
   sub1.SubbandForwardReferenceImp();
   sub2.SubbandForward();
   return (sub1 == sub2);
}


int main(int argc, char *argv[])
{
   int i;

   for (i = 1; i < argc; i++)
   {
     if (!DoCompare(argv[i]))
       return 1;
     else
       qDebug("Subband encodings are the same.");
   }
   return 0;
}
