# CTest instructions to make a continuous build on a computer (Linux / Windows / MacOSX)
# Schedule a task running this script with ctest and launch it using the following command
# "ctest -S build-continuous-debug.cmake -V"

# What this script does ?
# * INFORMATION STEP
#       Configure SITE and BUILD information to be correctly display on dashboard
#       Loads information from the CTestConfig.cmake file.
# * UPDATE STEP
#       use svn to udpdate source code to the latest revision BEFORE Nightly start time, which is defined in the CTestConfig.cmake file.
# * CONFIGURE STEP
#       configure the whole CamiTK project and create a new build directory 
# * BUILD STEP 
#       build each subproject of CamiTK
# For each step a report is sent to the dashboard. This allows any developer to be informed (mailing list) of any problem, even BEFORE the script ends !

# Need to be defined, for the build to run.
set(CTEST_SOURCE_DIRECTORY "C:/dev/CamiTK/opensource/camitk/src_debug/")
set(CTEST_BINARY_DIRECTORY "C:/dev/CamiTK/opensource/camitk/builds_continuous/debug")

# Script configuration, depending of the build, computer running the script
# Update to feat each computer which runs this script
set( CTEST_SITE "MANNONI-WIN7-32")
set( CTEST_BUILD_NAME "Win7-32-MinGW-Debug")
set( CTEST_CMAKE_GENERATOR  "MinGW Makefiles" )
set( CTEST_BUILD_CONFIGURATION "Debug")

# Update source code and send reports
# set( CTEST_UPDATE_COMMAND "svn")
find_program(CTEST_SVN_COMMAND svn)
set( CTEST_UPDATE_COMMAND ${CTEST_SVN_COMMAND})

# CMake configuration (put here all the configure flags)
set( CTEST_CONFIGURE_COMMAND "${CMAKE_COMMAND} -G \"${CTEST_CMAKE_GENERATOR}\"")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCMAKE_BUILD_TYPE:STRING=${CTEST_BUILD_CONFIGURATION}")
set( CTEST_CONFIGURE_COMMAND "${CTEST_CONFIGURE_COMMAND} -DCMAKE_SKIP_RPATH=TRUE -DCEP_IMAGING=TRUE -DCEP_MODELING=TRUE ${CTEST_SOURCE_DIRECTORY}")
# -DCAMITK_INSTALL_ROOT=${CTEST_BINARY_DIRECTORY}

# to get CDash server configuration :
include("${CTEST_SOURCE_DIRECTORY}/CTestConfig.cmake")

# Continuous build parameters
# Update them regarding your project's compilation time
set(CONTINUOUS_BUILD_DURATION 43200) # Duration time of the main loop of the continuous build in seconds, here 12 hours.
set(CONTINUOUS_BUILD_SLEEP 600) # Step to perform each build <=> maximum time for the script to sleep between 2 builds.

# Clean binary directory at the beginning of the day
ctest_empty_binary_directory(${CTEST_BINARY_DIRECTORY})

# Main loop
# During 10 hours from starting this script, CTest will continuously build every 10 min.
while (${CTEST_ELAPSED_TIME} LESS ${CONTINUOUS_BUILD_DURATION})
        # Get start time of the build
        set(START_TIME ${CTEST_ELAPSED_TIME})
        
        # Start CTest in Continuous mode
        ctest_start(Continuous)
        
        # Update source code and get update command result
        ctest_update(SOURCE ${CTEST_SOURCE_DIRECTORY} RETURN_VALUE count)
        ctest_submit(PARTS Update Notes)
        
        if (count GREATER 0) # We have updated source code, thus configure and build modified files
        
                # Configure the whole camitk project and send configure report on the server 
                ctest_configure()
                ctest_submit(PARTS Configure)
                
                # Get subprojects listing (automatically created at confituration step)
                include("${CTEST_BINARY_DIRECTORY}/Subprojects.cmake")
                
                # Update CDash configuration to the server
                # Project.xml file is automatically generated. If someone added an extension to CamiTK, CDash will automatically be updated according to it.
                # To do this, send this file to the server
                ctest_submit(FILES "${CTEST_BINARY_DIRECTORY}/Project.xml") 
                
                # Build each subprojects
                foreach(subproject ${CAMITK_SUBPROJECTS})

                        # tag sub project, tag are used to sort projects according to tests
                        set_property(GLOBAL PROPERTY SubProject ${subproject})
                        set_property(GLOBAL PROPERTY Label ${subproject})

                        # build each sub project
                        set(CTEST_BUILD_TARGET ${subproject})
                        ctest_build()
                        ctest_submit(PARTS Build)
                        # build binary for testing
                        set(CTEST_BUILD_TARGET ${subproject}test)
                        ctest_build()

                        # run tests
                        ctest_test(BUILD "${CTEST_BINARY_DIRECTORY}" INCLUDE_LABEL "${subproject}")
                        ctest_submit(PARTS Test)
                        
                endforeach(subproject)
                        
        endif ()
        
        # Wait maximum the CONTINUOUS_BUILD_SLEEP time (in seconds) to loop again and launch next build
        ctest_sleep( ${START_TIME} ${CONTINUOUS_BUILD_SLEEP} ${CTEST_ELAPSED_TIME})
endwhile()
