/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
// Qt
#include <QMainWindow>
#include <QString>
#include <QList>

#include "ParameterWidget.h"
#include "RemovableLineEdit.h"

#include "ExtensionWindow.h"
// The inclusion is needed as ExtTypeWindow uses the ExtTypeType enumeration.
//class ExtensionWindow;

// Include GUI  automatically generated from the file 
// MedicalViewer.ui (to be modified via QtDesigner).
#include "ui_ExtTypeWindow.h"

#ifndef EXTTYPEWINDOW_H
#define EXTTYPEWINDOW_H

class ExtTypeWindow : public QMainWindow  {
    Q_OBJECT	

	
public:
	ExtTypeWindow(ExtensionWindow * dad, QString workingDirectory, ExtTypeType type);

    void removeParameter(ParameterWidget * param);
    void removeLineEdit(RemovableLineEdit * tag);

public slots:
    virtual void okClicked();
    virtual void cancelClicked();
    virtual void addTagClicked();
    virtual void addParameterClicked();
    virtual void componentComboBoxChanged(QString);

protected:

	void personnalizeInterface();
	bool makeActionXML();
	bool makeApplicationXML();
	bool makeComponentXML();
	bool makeViewerXML();

private:
	 Ui_ExtTypeWindow ui;

	 ExtTypeType type;
     QString typeStr;
	 ExtensionWindow * dad;
     QString workingDirectory;
     QList<ParameterWidget *> parameters;
     QList<RemovableLineEdit *> tags;

	 QString className;



};
#endif
