#include <ncurses.h>
#include <stdlib.h>
#include <string.h>
#include "list.h"
#include "version.h"
#include "parsecfg.h"

char lineas[25][1024];

void
ScrollLines (void)
{
  int i;
  for (i = 0; i < 24; i++)
    {
      memset (lineas[i], 0, 1024);
      strncpy (lineas[i], lineas[i + 1], 1024);
    }
}

void
draw_box (WINDOW * win, int y, int x, int height, int width,
	  chtype box, chtype border)
{
  int i, j;

  wattrset (win, 0);
  for (i = 0; i < height; i++)
    {
      wmove (win, y + i, x);
      for (j = 0; j < width; j++)
	if (!i && !j)
	  waddch (win, border | ACS_ULCORNER);
	else if (i == height - 1 && !j)
	  waddch (win, border | ACS_LLCORNER);
	else if (!i && j == width - 1)
	  waddch (win, box | ACS_URCORNER);
	else if (i == height - 1 && j == width - 1)
	  waddch (win, box | ACS_LRCORNER);
	else if (!i)
	  waddch (win, border | ACS_HLINE);
	else if (i == height - 1)
	  waddch (win, box | ACS_HLINE);
	else if (!j)
	  waddch (win, border | ACS_VLINE);
	else if (j == width - 1)
	  waddch (win, box | ACS_VLINE);
	else
	  waddch (win, box | ' ');
    }
}

void
band (int y, const char *txt)
{
  int i;
  mvprintw (y, 0, "");
  for (i = 0; i < COLS; i++)
    addch (' ');
  mvprintw (y, (COLS - strlen (txt)) / 2, txt);
  refresh ();
}

void
fill (int x, int y, int width, int height)
{
  int i, j;

  for (i = 0; i < height; i++)
    {
      mvprintw (y + i, x, "");
      for (j = 0; j < width; j++)
	addch (' ');
    }
  refresh ();
}

int
FindColor (char *name)
{
  if (!strcmp (name, "default"))
    return -1;
  if (!strcmp (name, "black"))
    return COLOR_BLACK;
  if (!strcmp (name, "red"))
    return COLOR_RED;
  if (!strcmp (name, "green"))
    return COLOR_GREEN;
  if (!strcmp (name, "yellow"))
    return COLOR_YELLOW;
  if (!strcmp (name, "blue"))
    return COLOR_BLUE;
  if (!strcmp (name, "magenta"))
    return COLOR_MAGENTA;
  if (!strcmp (name, "cyan"))
    return COLOR_CYAN;
  if (!strcmp (name, "white"))
    return COLOR_WHITE;

  return -1;
}

void
ParseColors (void)
{
  char *colors[11] = {
    "", "",
    "borderlines",
    "jidonlineselected",
    "jidonline",
    "jidofflineselected",
    "jidoffline",
    "text",
    NULL
  };

  char *tmp = malloc (1024);
  char *color1;
  char *background = CFGRead ("color_background");
  char *backselected = CFGRead ("color_backselected");
  int i = 0;

  while (colors[i])
    {
      //read CFG color
      sprintf (tmp, "color_%s", colors[i]);
      color1 = CFGRead (tmp);

      switch (i + 1)
	{
	case 1:
	  init_pair (1, COLOR_BLACK, COLOR_WHITE);
	  break;
	case 2:
	  init_pair (2, COLOR_WHITE, COLOR_BLACK);
	  break;
	case 3:
	  init_pair (3, FindColor (color1), FindColor (background));
	  break;
	case 4:
	  init_pair (4, FindColor (color1), FindColor (backselected));
	  break;
	case 5:
	  init_pair (5, FindColor (color1), FindColor (background));
	  break;
	case 6:
	  init_pair (6, FindColor (color1), FindColor (backselected));
	  break;
	case 7:
	  init_pair (7, FindColor (color1), FindColor (background));
	  break;
	case 8:
	  init_pair (8, FindColor (color1), FindColor (background));
	  break;
	}
      i++;
    }
}

void
InitCurses (void)
{
  int i;
  initscr ();
  cbreak ();
  noecho ();
  nonl ();
  keypad (stdscr, TRUE);
  start_color ();
  use_default_colors ();

  for (i = 0; i < 25; i++)
    memset (lineas[i], 0, 1024);

  ParseColors ();

/*
  init_pair (1, COLOR_BLACK, COLOR_WHITE);
  init_pair (2, COLOR_WHITE, COLOR_BLACK);
  init_pair (3, COLOR_WHITE, COLOR_BLUE);
  init_pair (4, COLOR_GREEN, COLOR_CYAN); // buddy conectao y seleccionao
  init_pair (5, COLOR_GREEN, COLOR_BLUE); // buddy conectao
  init_pair (6, COLOR_RED, COLOR_CYAN);   // buddy desconectao y seleccionao
  init_pair (7, COLOR_RED, COLOR_BLUE);	  // buddy desconectao
  init_pair (8, COLOR_YELLOW, COLOR_BLUE);
  init_pair (10, COLOR_GREEN, COLOR_BLUE);
  init_pair (11, COLOR_MAGENTA, COLOR_BLUE);
 */
}

void
DoScreen (void)
{
  attrset (COLOR_PAIR (1));
  band (0, VERSION);
  band (LINES - 1, EMAIL);
  attrset (COLOR_PAIR (3));
  fill (0, 1, COLS, LINES - 2);
  draw_box (stdscr, 1, 0, LINES - 5, 20, COLOR_PAIR (3), COLOR_PAIR (3));
  draw_box (stdscr, 1, 20, LINES - 5, COLS - 20, COLOR_PAIR (3),
	    COLOR_PAIR (3));
  draw_box (stdscr, LINES - 4, 0, 3, COLS, COLOR_PAIR (3), COLOR_PAIR (3));
  attrset (COLOR_PAIR (3));
  mvprintw (1, 5, " Contacs ");
  mvprintw (1, 23, " Chat Window ");
  mvprintw (LINES - 4, 3, " Input Window ");
  refresh ();
}

int
DrawRoster (List list, int offset, int selected)
{
  Ptrnode p;
  elementT x;
  int counter = 0;
  int arriba = 0;

  attrset (COLOR_PAIR (3));

  p = FirstInList (list);
  while (offset > 0)
    {
      arriba = 1;
      p = NextInList (p);
      offset--;
    }
  while ((p != NULL) && (counter < LINES - 9))
    {
      x = RetrieveFromList (p);
      p = NextInList (p);

      if (x->connected)
	{
	  if (counter == selected - offset)
	    attrset (COLOR_PAIR (4) | A_BOLD);	// buddy conectao y seleccionao
	  else
	    attrset (COLOR_PAIR (5));	// buddy conectao
	}
      else
	{
	  if (counter == selected - offset)
	    attrset (COLOR_PAIR (6));	// buddy desconectao y seleccionao
	  else
	    attrset (COLOR_PAIR (7));	// buddy desconectao
	}
      mvprintw (3 + counter, 1, "                  ");
      {
	char *tmp = malloc (1024);
	snprintf (tmp, 16, "%s", x->name);
	mvprintw (3 + counter, (18 - strlen (tmp)) / 2, " %s ", tmp);
	free (tmp);
      }
      counter++;
    }

  attrset (COLOR_PAIR (8) | A_BOLD);

  if (arriba)
    {
      mvprintw (2, 16, "(");
      addch (ACS_UARROW);
      addch (')');
    }
  else
    mvprintw (2, 16, "   ");

  if (p != NULL)
    {
      mvprintw (LINES - 6, 16, "(");
      addch (ACS_DARROW);
      addch (')');
    }
  else
    mvprintw (LINES - 6, 16, "   ");

  //winnetou
  attrset (COLOR_PAIR (8));
  refresh ();

  if (p == NULL)
    return 0;
  else
    return 1;
}

void
PrintWrapMessage2 (char *text)
{
  int i;
  int j;
  if (!strcmp (lineas[24], text))
    return;
  ScrollLines ();
  memset (lineas[24], 0, 1024);
  strncpy (lineas[24], text, 1024);
  for (i = 24; i > LINES - 19; i--)
    {
      for (j = 0; j < COLS - 24; j++)
	mvprintw (-5 + i, j + 22, " ");
      mvprintw (-5 + i, 22, "%s", lineas[i]);
    }
  refresh ();
}

char **
Particiona (char *mensaje, int *nsubmsgs, unsigned int maxlong)
{
  // BUGs:    recorta la palabra si la longitud maxlong es menor que la palabra
  //  maxlong = 4
  // mensaje = "peaso bug!"
  // submsgs[0] = "peas"
  // submsgs[1] = "bug!"
  // por lo demas, rula de arte. De todos modos, podrias verificarla ???
  char *running;
  char *aux;
  char *aux2;
  char **submsgs;
  char *buffer = (char *) malloc (strlen (mensaje) * 2);
  int i = 0;

  submsgs = (char **) malloc (50 * sizeof (char *));	//limitamos, a priori, el maximo de lineas devueltas...

  running = strdup (mensaje);	// duplicamos mensaje 
  aux2 = strdup (mensaje);	// hacemos otra copia
  while (strlen (aux2) > maxlong)	// mintras quede texto...
    {
      memset (buffer, 0, strlen (mensaje) * 2);	// borramos el buffer
      running[maxlong] = '\0';	// cortamos la cadena a la maxima longitud
      aux = rindex (running, ' ');	// posicion del ultimo blanco
      if (aux != NULL)		// hay blanco!
	strncpy (buffer, running, strlen (running) - strlen (aux));
      else
	strcpy (buffer, running);	// se supone que esto es pa evitar 
      // el bug explicado arriba, pero no rula

      submsgs[i] = (char *) malloc (strlen (buffer) + 1);	//reservamos memoria
      strcpy (submsgs[i], buffer);	//copiamos el buffer de arriba
      i++;			//aumentamos numero de mensajillos
      aux2 += strlen (buffer) + 1;	//eliminamos texto particionado
      sprintf (running, "%s", aux2);	//y lo copiamos de nuevo a la string de "curro"
    }
  // la ultima parte del mensaje, si la hay ;-)
  if (strlen (aux2) > 0)
    {
      submsgs[i] = (char *) malloc (strlen (aux2) + 1);
      strcpy (submsgs[i], aux2);
      i++;
    }
  (*nsubmsgs) = i;
  free (buffer);
  return submsgs;
}

void
PrintWrapMessage (char *text)
{
  char **submsgs;
  int n = 0;
  int i;

  submsgs = Particiona (text, &n, COLS - 20 - 5);
  for (i = 0; i < n; i++)
    PrintWrapMessage2 (submsgs[i]);

  for (i = 0; i < n; i++)
    free (submsgs[i]);
  free (submsgs);
}
