package buoy.widget;

import javax.swing.*;

/**
 * A BPasswordField is a simple text entry box for typing passwords.  It allows the user to
 * enter a single line of text.  The characters typed into the box are hidden, and an alternate
 * echo character is displayed instead.
 * <p>
 * In addition to the event types generated by all Widgets, BPasswordFields generate the following event types:
 * <ul>
 * <li>{@link buoy.event.SelectionChangedEvent SelectionChangedEvent}</li>
 * <li>{@link buoy.event.ValueChangedEvent ValueChangedEvent}</li>
 * </ul>
 *
 * @author Peter Eastman
 */

public class BPasswordField extends BTextField
{
  /**
   * Create a new BPasswordField.
   */
  
  public BPasswordField()
  {
    super();
  }
  
  /**
   * Create a new BPasswordField.
   *
   * @param text      the initial text contained in the text field (may be null)
   */
  
  public BPasswordField(String text)
  {
    super(text);
  }

  /**
   * Create a new BPasswordField.
   *
   * @param columns   the number of columns this text field should be wide enough to display
   */
  
  public BPasswordField(int columns)
  {
    super(columns);
  }

  /**
   * Create a new BPasswordField.
   *
   * @param text      the initial text contained in the text field (may be null)
   * @param columns   the number of columns this text field should be wide enough to display
   */
  
  public BPasswordField(String text, int columns)
  {
    super(text, columns);
  }
  
  /**
   * Create the JTextField which serves as this Widget's Component.  This overrides the implementation
   * in BTextField.
   */
  
  protected JPasswordField createComponent()
  {
    return new JPasswordField();
  }

  public JPasswordField getComponent()
  {
    return (JPasswordField) component;
  }

  /**
   * Get the echo character to be displayed in the text field.
   */
  
  public char getEchoChar()
  {
    return getComponent().getEchoChar();
  }
  
  /**
   * Set the echo character to be displayed in the text field.
   */
  
  public void setEchoChar(char c)
  {
    getComponent().setEchoChar(c);
  }

  /**
   * Get the text contained in the Widget.
   */
  
  public String getText()
  {
    return new String(getComponent().getPassword());
  }
}
