/*
 * Copyright (C) 2003--2008  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#pragma implementation

#include "config.h"

#include "Environment.h"
#include <wibble/exception.h>

#include <cstdlib>
#include <sys/types.h>  // fork, stat, utimes
#include <unistd.h>     // fork, execl, isatty, pipe
#include <sys/stat.h>   // stat
#include <sys/time.h>   // utimes
#include <sys/wait.h>


#include <errno.h>

#include <stdio.h>
#include <stdarg.h>
#include <signal.h>
/*
#include <fcntl.h>
*/

#include <glibmm/dispatcher.h>

#include <iostream>

using namespace std;
using namespace buffy;
using namespace wibble;

Environment* Environment::instance = 0;

// Dispatcher for sigchld events
static Glib::Dispatcher dispatcher;

static void termination_handler(int signum)
{
	//fprintf(stderr, "SIGNAL %d\n", signum);
	dispatcher.emit();
}

void Environment::init()
{
	if (instance == 0)
		instance = new Environment();
}

void Environment::on_sigchld()
{
	int pid, status;
	while (1)
	{
		pid = waitpid (WAIT_ANY, &status, WNOHANG);
		if (pid < 0)
		{
			//perror ("waitpid");
			break;
		}
		if (pid == 0)
			break;
		::verbose("Child %d exited with status %d\n", (int)pid, (int)status);
		signal_child_exit().emit(pid, status);
	}
}

Environment::Environment()
	: _verbose(false), _debug(false), _config()
{
	// Connect the dispatcher to the child exit signal
	dispatcher.connect(sigc::mem_fun(*this, &Environment::on_sigchld));

	// Setup the SIGCHLD handler
	struct sigaction new_action;
	new_action.sa_handler = termination_handler;
	sigemptyset(&new_action.sa_mask);
	new_action.sa_flags = SA_NOCLDSTOP; //0;
	sigaction(SIGCHLD, &new_action, NULL);
}

void Environment::enumerateFolders(MailFolderConsumer& cons)
{
	vector<string> locations = config().locations().get();
	for (vector<string>::const_iterator i = locations.begin();
			i != locations.end(); i++)
	{
		::verbose("Scanning folder location %s\n", i->c_str());
		MailFolder::enumerateFolders(*i, cons);
	}
}


void Environment::spawnCommand(const std::string& command)
{
	pid_t child = fork();
	if (child == -1)
		throw wibble::exception::System("trying to fork a child process");
	
	if (child == 0)
	{
		// Child code path
		try {
			if (execl("/bin/sh", "/bin/sh", "-c", command.c_str(), 0) == -1)
				throw wibble::exception::System("trying to fork a child process");
			throw wibble::exception::System("trying to fork a child process");
		} catch (wibble::exception::Generic& e) {
			cerr << e.type() << ": " << e.fullInfo() << endl;
		}
		exit(0);
	}
}


void fatal_error(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	fprintf(stderr, "buffy: ");
	va_list ap;
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	fprintf(stderr, "\n");
	exit(1);
}

void error(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	va_list ap;
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
}

void warning(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	va_list ap;
	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
}

void verbose(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	if (Environment::get().verbose())
	{
		va_list ap;
		va_start(ap, fmt);
		vfprintf(stderr, fmt, ap);
		va_end(ap);
	}
}

void debug(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	if (Environment::get().debug())
	{
		va_list ap;
		va_start(ap, fmt);
		vfprintf(stderr, fmt, ap);
		va_end(ap);
	}
}

void feedback(const char* fmt, ...) throw() ATTR_PRINTF(1, 2)
{
	if (isatty(1))
	{
		va_list ap;
		va_start(ap, fmt);
		vfprintf(stdout, fmt, ap);
		va_end(ap);
	}
}



// vim:set ts=4 sw=4:
