/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "bkl-dbus.h"
#include "bkl-internal-marshal.h"

enum {
    URI_CHANGED,
    URI_ADDED,
    URI_DELETED,
    LAST_SIGNAL
};

G_DEFINE_TYPE (BklDBus, bkl_dbus, G_TYPE_OBJECT);

static guint32 signals[LAST_SIGNAL] = {0,};

#include "bkl-dbus-glue.h"

static void
bkl_dbus_class_init (BklDBusClass *klass)
{
    signals[URI_CHANGED] = g_signal_new ("uri-changed",
                                         G_TYPE_FROM_CLASS (klass),
                                         G_SIGNAL_RUN_FIRST |
                                         G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                         bkl_internal_marshal_VOID__STRING_STRING,
                                         G_TYPE_NONE, 2,
                                         G_TYPE_STRING,
                                         G_TYPE_STRING);
    signals[URI_ADDED] = g_signal_new ("uri-added",
                                       G_TYPE_FROM_CLASS (klass),
                                       G_SIGNAL_RUN_FIRST |
                                       G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                       bkl_internal_marshal_VOID__STRING_STRING,
                                       G_TYPE_NONE, 2,
                                       G_TYPE_STRING,
                                       G_TYPE_STRING);
    signals[URI_DELETED] = g_signal_new ("uri-deleted",
                                         G_TYPE_FROM_CLASS (klass),
                                         G_SIGNAL_RUN_FIRST |
                                         G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                         bkl_internal_marshal_VOID__STRING_STRING,
                                         G_TYPE_NONE, 2,
                                         G_TYPE_STRING,
                                         G_TYPE_STRING);

    dbus_g_object_type_install_info (G_TYPE_FROM_CLASS (klass),
                                     &dbus_glib_bkl_dbus_object_info);
}

static void
bkl_dbus_init (BklDBus *self)
{
}

BklDBus *
bkl_dbus_new (void)
{
    return g_object_new (BKL_TYPE_DBUS, NULL);
}

void
bkl_dbus_notify_uri_changed (BklDBus    *self,
                             const char *source,
                             const char *uri)
{
    g_signal_emit (self, signals[URI_CHANGED], 0, source, uri);
}

void
bkl_dbus_notify_uri_added (BklDBus    *self,
                           const char *source,
                           const char *uri)
{
    g_signal_emit (self, signals[URI_ADDED], 0, source, uri);
}

void
bkl_dbus_notify_uri_deleted (BklDBus    *self,
                             const char *source,
                             const char *uri)
{
    g_signal_emit (self, signals[URI_DELETED], 0, source, uri);
}


