(*
**
** Author: Hongwei Xi (gmhwxi AT gmail DOT com)
** Time: August, 2011
*
*)
staload UN = "prelude/SATS/unsafe.sats"
//
staload
STDIO = "libc/SATS/stdio.sats"
staload TIME = "libc/SATS/time.sats"
//
dynload "libatsdoc/dynloadall.dats"
//
staload "libatsdoc/SATS/atsdoc_text.sats"
//
val LT = "<"
val LTSLASH = "</"
val GT = ">"

val COMMENTopn = TEXTstrcst"<!--"
and COMMENTcls = TEXTstrcst("-->")

fun xmltagging (
  tag: string, x: string
) : text = let
  val _opn = TEXTappstr3 (LT, tag, GT)
  val _clo = TEXTappstr3 (LTSLASH, tag, GT)
in
  TEXTapptxt3 (_opn, TEXTstrsub(x), _clo)
end // end of [xmltagging]
//
local
val ATSCODEopn = "<PRE>"
val ATSCODEcls = "</PRE>"
in
fun atscode
  (x: string): text = TEXTappstr3 (ATSCODEopn, x, ATSCODEcls)
fun atscode2xmls (x: string): text = atscode2xml_strcode (0(*dyn*), x)
fun atscode2xmld (x: string): text = atscode2xml_strcode (1(*dyn*), x)
end // end of [local]
//
(* ****** ****** *)

fun timestamp
  (): text = let
  var time = $TIME.time_get ()
  val (fpf | x) = $TIME.ctime (time)
  val x1 = sprintf ("%s", @($UN.castvwtp1(x)))
  prval () = fpf (x)
  val x1 = string_of_strptr (x1)
in
  TEXTstrcst (x1)
end // end of [val]

(* ****** ****** *)

fun comment (x: string): text =
  TEXTapptxt3 (COMMENTopn, TEXTstrsub(x), COMMENTcls)
// end of [comment]

(* ****** ****** *)

(* end of [tutorial.dats] *)
