//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes

#include <qlayout.h>
#include <qpixmap.h>
#include <qlabel.h>
#include <qfont.h>
#include <qpushbutton.h>
#include <qpushbutton.h>
#include <qapplication.h>

//Projectwide includes
#include "welcomeWindow.h"
#include "items.h"
#include "item.h"
#include "../window.h"
#include "../titleWidget.h"
#include "../../config.h"

//==============================================
WelcomeWindow::WelcomeWindow( QWidget* parent,
                                                           const char* name ) :
                                                           QDialog(parent,name)
{
  //--------------------------------------------------------------
  //set window title
  setCaption( tr("Welcome to Album Shaper"));
  //--
  sideImage = new QLabel( this );
  sideImage->setPixmap( QPixmap( QString(IMAGE_PATH) + "miscImages/welcome.png" ) );
  sideImage->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed );
  //--
  QFrame* itemsFrame = new QFrame(this);

  welcomeTitle = new QLabel( QString(tr("Welcome to Album Shaper %1")).arg(ALBUMSHAPER_VERSION), itemsFrame );
  QFont textFont = welcomeTitle->font();
  textFont.setWeight(QFont::Bold);
  textFont.setPointSize( textFont.pointSize() + 2 );
  welcomeTitle->setFont( textFont );
  //--
  welcomeMessage = new QLabel( QString(tr("It appears you are a new Album Shaper user! Before you begin creating photo albums, you may want to explore the following features of this program:" ) ), itemsFrame );
  welcomeMessage->setAlignment( Qt::AlignLeft | Qt::WordBreak | Qt::BreakAnywhere );
  //--
  items = new Items(itemsFrame);
  items->setItemTextPos( QIconView::Right );
  items->setMaxItemWidth(500);
  items->setFrameShape ( QFrame::NoFrame );
  items->setSelectionMode( QIconView::NoSelection ) ;

  items->setSizePolicy( QSizePolicy::Minimum, QSizePolicy::Minimum );

  items->setSpacing( WIDGET_SPACING );

  connect( items, SIGNAL(clicked(QIconViewItem*)), this, SLOT(itemClicked(QIconViewItem*)) );

  help = new Item( items, QPixmap(QString(IMAGE_PATH)+"welcomeImages/handbook.png"),
                    tr("Read short tutorials which cover all of the program's ins and outs.") );
  updates = new Item( items, QPixmap(QString(IMAGE_PATH)+"welcomeImages/updates.png"),
                    tr("Keep up to date. If a new version of Album Shaper is available you'll see a pulsing light bulb appear in the bottom right corner of the application.") );
  upcoming = new Item( items, QPixmap(QString(IMAGE_PATH)+"welcomeImages/upcoming.png"),
                    tr("Take advantage of the power of open source development! Read about ongoing improvements and communicate with developers working on the project.") );

    //set text rects of icons
  int maxWidth = 0;
  QIconViewItem *item;
  for( item = items->firstItem(); item != NULL; item = item->nextItem() )
  {
    if(item->textRect().width() > maxWidth)
      maxWidth = item->textRect().width();
  }
  for( item = items->firstItem(); item != NULL; item = item->nextItem() )
  {
    ((Item*)item)->setTextWidth( maxWidth );
  }


  //--
  closeButton = new QPushButton( 
  //PLATFORM_SPECIFIC_CODE
  #ifndef Q_OS_MACX  
  QPixmap(QString(IMAGE_PATH)+"buttonIcons/button_ok.png"),
  #endif
                              tr("Close"),
                              itemsFrame );
  closeButton->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed );
  closeButton->setDefault(true);
  connect( closeButton, SIGNAL(clicked()), SLOT(close()) );
  //--
  setPaletteBackgroundColor( white );
  closeButton->setEraseColor( white );
  //--
  QGridLayout* grid = new QGridLayout( this, 1, 2, 0);
  grid->addWidget( sideImage, 0, 0 );
  grid->addWidget( itemsFrame, 0, 1 );

  QGridLayout* itemsGrid = new QGridLayout( itemsFrame, 4, 3, 0 );

  itemsGrid->addMultiCellWidget( welcomeTitle,  0, 0, 0, 2 );
  itemsGrid->addMultiCellWidget( welcomeMessage,  1, 1, 0, 2 );
  itemsGrid->addMultiCellWidget( items,  2, 2, 0, 2 );
  itemsGrid->addWidget( closeButton,  3, 1 );

  itemsGrid->setRowStretch( 2, 1 );
  itemsGrid->setColStretch( 0, 1 );
  itemsGrid->setColStretch( 2, 1 );

  itemsGrid->setMargin(WIDGET_SPACING);
  itemsGrid->setSpacing(WIDGET_SPACING);
  //--
  this->show();
  setFixedSize(size());
  //-------------------------------
}
//==============================================
void WelcomeWindow::itemClicked(QIconViewItem* item)
{
  if(item == NULL)
   return;

  TitleWidget* tw =  ((Window*)qApp->mainWidget())->getTitle();

  //help
  if(item == help)
  {
    tw->help();
    return;
  }
  //updates
  else if(item == updates)
  {
    tw->aboutProgram(UPDATES);
    return;
  }
  //upcoming
  else if(item == upcoming)
  {
    tw->aboutProgram(UPCOMING);
    return;
  }
}
//==============================================
