//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qpixmap.h>
#include <qstring.h>
#include <qpainter.h>
#include <qiconview.h>

//Projectwide includes
#include "item.h"

//==============================================
Item::Item( QIconView* parent, QPixmap icon, QString text ) : QIconViewItem(parent, text, icon)
{
  mousedOver = false;
}
//==============================================
void Item::paintItem( QPainter* p, const QColorGroup&)
{
  p->save();
  QRect r = rect();

  //if selected paint dark blue background and outline
  if(isSelected())
  {
    //Draw Selected Color (dark blue)
    p->fillRect( r, QColor(193, 210, 238) );

    //draw selection rectangle (darker blue)
    p->setPen( QColor(49, 106, 197) );
    p->drawRect(r);
  }
  //else if pseudo selected paint ligher blue background with outline
  else if(mousedOver)
  {
    //Draw Pseudo Selected Color (light blue)
    p->fillRect( r, QColor(224, 232, 246) );

    //draw selection rectangle (darker blue)
    p->setPen( QColor(152, 180, 226) );
    p->drawRect(r);
  }

  p->restore();

   p->drawPixmap( x() , y() + ( height() - pixmap()->height() ) / 2, *pixmap());

    int align = AlignLeft | WordBreak | BreakAnywhere;
   p->drawText( textRect( FALSE ), align, text());
}
//==============================================
void Item::setMousedOver(bool val)
{ mousedOver = val; }
//==============================================
void Item::setTextWidth(int w)
{
    QRect pr = pixmapRect();
    pr.moveBy( 3, 3 );
    setPixmapRect( pr );

    QRect tr = textRect();
    tr.moveBy( 3, 3 );
    tr.setRight( tr.left() + w);
    setTextRect( tr );

    int newW = pixmapRect().width() + 6 + w;
    int newH = QMAX( textRect().height(), pixmapRect().height() ) + 6;

    setItemRect( QRect( rect().topLeft(), QSize(newW, newH)) );
}
//==============================================
