//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it 
//  and/or modify it under the terms of the GNU General 
//  Public License as published by the Free Software 
//  Foundation; either version 2 of the License, or  
//  (at your option) any later version.         
//==============================================

#ifndef BACKEND_PHOTO_H
#define BACKEND_PHOTO_H

//define image sizes
#define THUMBNAIL 1
#define SLIDESHOW 2
#define IMAGE 3

//TODO: remove this include
//this is a temporary hack, I the enum for photo transofmrations need to be revealed
//to all classes that include photo.h becaue one private function uses thsi enum, DAMN
#include "tools/imageTools.h"

//--------------------
//forward declarations
class QString;
class QPixmap;
class QImage;
class QDomNode;
class QDateTime;
class Subalbum;
//--------------------

//=====================================
/*! \brief A photo consists of a full size image, 
 *  a smaller slide show image, a very small 
 *  thumbnail image, and a desription.
 */
//=====================================

class Photo
{
//------------------------------------------------------
public:
  ///Sets default information
  Photo(Subalbum* subalbum, Photo* prev, int photoNumber);
  
  ~Photo();
  //----------------------------
  ///Gets thumbnail image
  QImage* getThumbnailImage();

  ///Construct thumbnail and slideshow images, 
  ///load up thumbnail image, and set photo
  ///has being modified
  bool constructSmallerImages();
  
  ///Setup photo using preexisting full size, slideshow, and thumbnail images. We
  ///call this method when loading photos from disk and resizing is not necessary.
  bool setImage(QString imageName,
                QString slideshowName,
                QString thumbnailName);
  
  ///Setup photo using a new image. We'll need to create slideshow and thumbnail images.
  bool setImage(QString imageName, int uniqueID);

  ///Reset photo data after photo editing has taken place. 
  ///Slideshow and thumbnail images need to be regenerated.
  bool setImage(QString editedImageFilename);
  //------------------------------------------
  ///Gets the image filename
  QString getImageFilename();
  
  ///Gets the slideshow filename
  QString getSlideshowFilename();
  
  ///Gets the thumbnail filename
  QString getThumbnailFilename();
  //---------------------------- 
  ///Sets the image filename
  void setImageFilename(QString val);
    
  ///Sets the slideshow filename
  void setSlideshowFilename(QString val);
  
  ///Sets the thumbnail filename
  void setThumbnailFilename(QString val);  
  //---------------------------- 
  ///Get image checksum
  QString getImageChecksum();
  
  ///Get thumbanil checksum
  QString getThumbnailChecksum();
  
  ///Get thumbanil checksum
  QString getSlideshowChecksum();
    
  ///Update image checksum
  void setImageChecksum(QString val);
  
  ///Update thumbnail checksum
  void setThumbnailChecksum(QString val);
  
  ///Update slideshow checksum
  void setSlideshowChecksum(QString val);  
  //------------------------------------------
  ///Gets the description
  QString getDescription();
  
  ///Sets the description
  void setDescription(QString val);
  //---------------------------- 
  ///Returns the previous photo pointer
  Photo* getPrev();
  
  ///Returns next photo pointer
  Photo* getNext();
  
  ///Sets prev photo pointer
  void setPrev(Photo* val);
  
  ///Sets next photo pointer
  void setNext(Photo* val);
  //---------------------------- 
  ///Builds photo from XML DOM node, returns date modified info from xml
  QDateTime* importFromDisk(QDomNode* root);
  
  ///Exports photo to xml
  void exportToXML(QTextStream& stream);
  //------------------------------------------
  ///Rotates image clockwise 90 degrees
  void rotate90();
  
  ///Rotates image clockwise 270 degrees
  void rotate270();
  
  ///Flips image about horizontal axis
  void flipHorizontally();
  
  ///Flips image about vertical axis
  void flipVertically();
  
  ///Apply transformation
  void applyTransformation(TRANSFORM_CODE transformation);
  //------------------------------------------
  ///Returns if the image needs to be saved to its permament location
  bool getNeedsSavingVal();
  
  ///Sets if the image needs to be saved to its permanent location
  void setNeedsSavingVal(bool val);
  //------------------------------------------
  ///Returns if the image has ever been saved to a permanant location
  bool getEverSaved();
  
  ///sets everSaved
  void setEverSaved(bool val);
  //------------------------------------------
  ///revert photo to original form
  void revertPhoto();
  
  ///can photo be reverted to a differnt original form
  bool revertPossible();

  ///was the photo recently reverted? if so ignore the presence of orig files on disk
  bool getRecentlyReverted();
  
  ///reset the recently reverted value to val
  void setRecentlyReverted(bool val);

  ///orig filename
  QString originalImageFilename();
  //------------------------------------------
  ///Returns initial photo number
  int getInitialPhotoNumber();
  
  ///Sets initial photo number
  void setInitialPhotoNumber(int val);
  
  ///Returns initial subalbum number
  int getInitialSubalbumNumber();
  
  ///Sets initial subalbum number
  void setInitialSubalbumNumber(int val);
//------------------------------------------------------
private:
  ///Subalbum photo is in
  Subalbum* subalbum;

  ///Pointer to prev photo
  Photo* prev;
  
  ///Pointer to next photo
  Photo* next;
  
  //Initial photo number
  int initialPhotoNumber;
  
  //Initial subalbum number
  int initialSubalbumNumber;
  
  ///Photo description
  QString description;
  
  ///Thumbnail Image
  QImage* thumbnailImage;
    
  ///Filenames  
  QString imageLocation;
  QString slideshowLocation;
  QString thumbnailLocation;
  
  ///MD5 checksums, used to determine if image/thumbnail have been changed
  QString imageChecksum;
  QString slideshowChecksum;
  QString thumbnailChecksum;
  
  ///Unsaved modifications?
  bool needsSaving;
  
  ///Has the photo ever been saved?
  bool everSaved;
  
  ///Has the photo recently been reverted to it's original form? If so during
  ///the next save the orig file can safely be remove
  bool recentlyReverted;
//------------------------------------------------------
};

#endif //BACKEND_PHOTO_H
