<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:variable name="themeVersion">Metallic v2.0.1, Christian Sandberg</xsl:variable>
<xsl:variable name="pageHeader">
This album was generated by Album Shaper, download it here:
http://albumshaper.sourceforge.net

The theme was created by Christian Sandberg.
http://www.d-play.com
</xsl:variable>

<xsl:output method="html" indent="yes"/>

<xsl:include href="utils.xsl"/>

<xsl:template match="album">

<xsl:variable name="albumAuthor" select="author"/>
<xsl:variable name="albumName" select="name"/>
<xsl:variable name="Myear" select="substring-before(modified, ' ')"/>
<xsl:variable name="Mmonth" select="substring-before( substring-after(modified, ' '), ' ')"/>
<xsl:variable name="Mday" select="substring-after( substring-after(modified, ' '), ' ')"/>


<!--
::::: Album.html ::::::::
-->
<xsl:document method="html" indent="yes" href="{concat($outputPath, '/index.html')}">

<xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
<xsl:value-of select="$pageHeader"/>
<xsl:text disable-output-escaping="yes">--&gt;
</xsl:text>

<html>
<head>
	<title>.:: <xsl:value-of select="$albumName"/> ::.</title>
	<meta name="generator" content="Album Shaper (c.) Will Stokes" />
	<meta name="theme" content="{$themeVersion}" />
	<meta name="author" content="{$albumAuthor}" />
	
<script type="text/javascript">
	
function updateTitle() {
	frameTitle = " - " + parent.mainFrame.document.title;
	if (frameTitle == " - Album Index") frameTitle = "";
	top.document.title = ".:: <xsl:value-of select="$albumName"/> ::." + frameTitle;
}
	
</script>
</head>

<frameset cols="*,750,*" border="0">
	<frame src="resources/blank.html" scrolling="no" noresize="noresize" frameborder="0" />
	<frameset rows="15,*,100" border="0">
		<frame src="resources/blank.html" scrolling="no" noresize="noresize" frameborder="0" />
		<frame src="albumindex.html" name="mainFrame" onload="updateTitle()" marginwidth="0" marginheight="0" noresize="noresize" frameborder="0" />
		<frameset cols="18,*,93" border="0">
			<frame src="resources/leftnav.html" marginwidth="0" marginheight="0" scrolling="no" noresize="noresize" frameborder="0" />
			<frame src="nav.html" marginwidth="0" marginheight="0" noresize="noresize" frameborder="0" />
			<frame src="resources/rightnav.html" marginwidth="0" marginheight="0" scrolling="no" noresize="noresize" frameborder="0" />
		</frameset>
	</frameset>
	<frame src="resources/blank.html" scrolling="no" noresize="noresize" frameborder="0" />
</frameset>

</html>

</xsl:document>








<!--
::::: nav.html ::::::::
-->

<xsl:document method="html" indent="yes" href="{concat($outputPath, '/nav.html')}" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd">

<xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
<xsl:value-of select="$pageHeader"/>
<xsl:text disable-output-escaping="yes">--&gt;
</xsl:text>

<html>
<head>
	<title>Navigation panel</title>
	
	<meta name="generator" content="Album Shaper (c.) Will Stokes" />
	<meta name="theme" content="{$themeVersion}" />
	<meta name="author" content="{$albumAuthor}" />
	
	<link rel="stylesheet" href="resources/style.css" type="text/css" />
</head>

<body style="background:#EEEEEE url(resources/bg.png) repeat-x fixed 0px 18px; margin-top:10px">

<table style="border:0px; height:59px" cellspacing="0" cellpadding="0">
	<tr>
<xsl:for-each select="subalbum">
	<xsl:variable name="subalbumNumber" select="position()"/>
	<xsl:variable name="subalbumName" select="name"/>
	
	<xsl:if test="not($subalbumNumber = 1)">
			<td><img src="resources/spacer.gif" width="5" height="1" alt="" /></td>
	</xsl:if>
	<xsl:if test="thumb">
		<td>
		<table border="0" cellspacing="0" cellpadding="0"><tr><td align="right" valign="bottom">
			<a href="subalbum_{$subalbumNumber}.html" target="mainFrame" title="{$subalbumName}">
			<xsl:variable name="subalbumThumbnail" select="thumb/@path"/>
			<img src="{$subalbumThumbnail}" height="50" class="thumbs" style="border-color:#333333" alt="{$subalbumName}" border="0" /></a>
			</td>
			<td style="width:6px; height:59px; background:url('resources/shadow1.png') no-repeat" rowspan="2"><img src="resources/spacer.gif" width="6" height="1" alt="" /></td>
			</tr><tr>
			<td style="height:7px; background:url('resources/shadow3.png') repeat-x"><img src="resources/shadow2.png" width="8" height="7" alt="" /></td>
			</tr>
		</table>
		</td>
	</xsl:if>
	<xsl:if test="not(thumb)">
		<td><a href="subalbum_{$subalbumNumber}.html" target="mainFrame">
		<span class="text"><xsl:value-of select="name"/></span>
		</a><img src="resources/spacer.gif" width="6" height="1" alt="" /></td>
	</xsl:if>
</xsl:for-each>
	</tr>
</table>

</body>
</html>
</xsl:document>





<!--
::::: albumindex.html ::::::::
-->

<xsl:document method="html" indent="yes" href="{concat($outputPath, '/albumindex.html')}">

<xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
<xsl:value-of select="$pageHeader"/>
<xsl:text disable-output-escaping="yes">--&gt;
</xsl:text>

<html>
<head>
	<title>Album Index</title>
	
	<meta name="generator" content="Album Shaper (c.) Will Stokes" />
	<meta name="theme" content="{$themeVersion}" />
	<meta name="author" content="{$albumAuthor}" />

	<link rel="stylesheet" href="resources/style.css" type="text/css" />
</head>

<body>

<table border="0" width="560" cellpadding="0" cellspacing="10" align="center">
	<tr>
		<td colspan="2" style="text-align:center">
			<span class="bigtitle" style="font-size:28px"><xsl:value-of select="$albumName"/></span><br />
			<span class="text"><xsl:value-of select="description"/></span>
		</td>
	</tr>
	<xsl:if test="thumb">
		<xsl:variable name="albumThumbnail" select="thumb/@path"/>
		<tr><td colspan="2" style="text-align:center"><img src="{$albumThumbnail}" class="thumbs" alt="{$albumName}" /></td></tr>
	</xsl:if>
	<tr><td colspan="2" class="line-x"><img src="resources/spacer.gif" width="1" height="1" alt="" /></td></tr>

<xsl:for-each select="subalbum">

	<xsl:variable name="subalbumNumber" select="position()"/>
	<xsl:variable name="subalbumName" select="name"/>
	<xsl:variable name="numCols">
		<xsl:choose>
			<xsl:when test="($subalbumNumber mod 2) and position() = last()">2</xsl:when>
			<xsl:otherwise>1</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="tdAlign">
		<xsl:choose>
			<xsl:when test="not($subalbumNumber mod 2)">right</xsl:when>
			<xsl:when test="$numCols = '2'">center</xsl:when>
			<xsl:otherwise>left</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
			
	<xsl:if test="$subalbumNumber mod 2"><xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text></xsl:if>
	
	<td colspan="{$numCols}" style="text-align:{$tdAlign}" valign="bottom">
		<a href="subalbum_{$subalbumNumber}.html">
		<xsl:if test="thumb">
			<xsl:variable name="subalbumThumbnail" select="thumb/@path"/>
			<img src="{$subalbumThumbnail}" class="thumbs" alt="{$subalbumName}" border="0" />
		</xsl:if>
		<br />
		<span class="bigtitle" style="font-size:18px"><xsl:value-of select="$subalbumName"/></span></a><br />
		<span class="text"><xsl:value-of select="description"/><br /></span>
	</td>

	<xsl:if test="not($subalbumNumber mod 2) and not(position() = last())">
	<xsl:text disable-output-escaping="yes">&lt;/tr&gt;
	</xsl:text>
	<tr><td colspan="2"><img src="resources/spacer.gif" width="1" height="5" alt="" /></td></tr>
	</xsl:if>

</xsl:for-each>

	<xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
	<tr><td colspan="2" class="text line-x" style="font-size:10px; text-align:center; color:#888888">
	Generated <xsl:value-of select="$Myear" />-<xsl:if test="$Mmonth &lt; 10">0</xsl:if><xsl:value-of select="$Mmonth"/>-<xsl:if test="$Mday &lt; 10">0</xsl:if><xsl:value-of select="$Mday"/> for <xsl:value-of select="author"/> by <a href="http://albumshaper.sourceforge.net" target="_blank">Album Shaper</a>, Metallic theme
	</td></tr>
</table>

</body>
</html>
</xsl:document>





<xsl:for-each select="subalbum">
<xsl:variable name="subalbumNumber" select="position()"/>
<xsl:variable name="numPhotos" select="count(photo)"/>
<xsl:variable name="subalbumName" select="name"/>

<!--
::::: subalbum_x.html ::::::::
-->
<xsl:document method="html" indent="yes" href="{concat($outputPath, '/subalbum_', string(position()), '.html')}">

<xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
<xsl:value-of select="$pageHeader"/>
<xsl:text disable-output-escaping="yes">--&gt;
</xsl:text>

<html>
<head>
	<meta name="generator" content="Album Shaper (c.) Will Stokes"/>
	<meta name="theme" content="{$themeVersion}" />
	<meta name="author" content="{$albumAuthor}" />

	<link rel="stylesheet" href="resources/style.css" type="text/css"/>
	
	<title><xsl:value-of select="$subalbumName"/></title>
</head>

<body>

<table border="0" cellspacing="0" cellpadding="0" align="center">
	<tr>
		<td style="width:580px">
			<span class="bigtitle" style="font-size:22px"><xsl:value-of select="name"/></span>
			<img src="resources/spacer.gif" width="10" height="1" alt="" />
			<span class="text"><xsl:value-of select="description"/></span>
		</td>
		<td style="width:56px; text-align:right" valign="bottom"><a href="slideshow_{$subalbumNumber}.html" title="View slideshow"><img src="resources/slideshow.gif" width="56" height="9" border="0" alt="Slideshow" /></a></td>
	</tr>
	<tr><td class="line-x" colspan="2"><img src="resources/spacer.gif" width="1" height="1" alt="" /></td></tr>
</table>


<table border="0" cellspacing="15" cellpadding="0" align="center">
	<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
<xsl:if test="not(count(photo))">
	<td colspan="3" class="text" style="text-align:center">
		This collection doesn't contain any images.
	</td>
</xsl:if>

<xsl:for-each select="photo">
	<td style="text-align:center; width:202px" valign="middle">
		<a href="slideshow_{$subalbumNumber}.html?{position()}" name="img{position()}"><img src="img/{$subalbumNumber}/{position()}_thumb.jpg" alt="" class="thumbs" border="0" /></a>
	</td>
	<xsl:if test="not(position() mod 3)">
		<xsl:text disable-output-escaping="yes">&lt;/tr&gt;
</xsl:text>

		<xsl:if test="not(position() = $numPhotos)">
			<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
		</xsl:if>
	</xsl:if>
</xsl:for-each>

<xsl:if test="$numPhotos mod 3">
	<xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
</xsl:if>

<tr><td class="line-x text" style="text-align:right; font-size:10px; color:#888888" colspan="3"><xsl:text disable-output-escaping="yes">&amp;</xsl:text>copy; <xsl:value-of select="$Myear" /><xsl:text> </xsl:text><xsl:value-of select="$albumAuthor" /></td></tr>


</table>

</body>
</html>
</xsl:document>



<!--
::::: slideshow_x.html ::::::::
-->

<xsl:document method="html" indent="yes" href="{concat($outputPath, '/slideshow_', string(position()), '.html')}">

<xsl:text disable-output-escaping="yes">&lt;!--</xsl:text>
<xsl:value-of select="$pageHeader"/>
<xsl:text disable-output-escaping="yes">--&gt;
</xsl:text>

<html>
<head>
	<title><xsl:value-of select="$subalbumName"/></title>
	
	<meta name="generator" content="Album Shaper (c.) Will Stokes" />
	<meta name="theme" content="{$themeVersion}" />
	<meta name="author" content="{$albumAuthor}" />
	
	<link rel="stylesheet" href="resources/style.css" type="text/css" />
	
	<script type="text/javascript" src="resources/slideshow.js"></script>
	<script type="text/javascript">
	
	var dontShowLink = <xsl:value-of select="$smallWebExport" />;
	var numberOfImages = <xsl:value-of select="$numPhotos"/>;
	var subalbumNumber = <xsl:value-of select="$subalbumNumber"/>;
	var address = self.location.href.split("?");
	var image = (address[1]) ? parseInt(address[1]) : 1;
	if (image <![CDATA[>]]> numberOfImages || image <![CDATA[<]]> 1) image = 1;
	
	var imageDescription = new Array(numberOfImages);
	<xsl:for-each select="photo">
	<xsl:variable name="photoDescription" select="description"/>
	imageDescription[<xsl:value-of select="position() - 1"/>] = <![CDATA["]]><xsl:call-template name="JavaScriptString"><xsl:with-param name="string" select="$photoDescription"/></xsl:call-template><![CDATA["]]>;</xsl:for-each>
	
	if (numberOfImages > 0) var tempDescription = imageDescription[image - 1];
	
	</script>
	
</head>

<body>

<table align="center" style="border:0px" cellspacing="0" cellpadding="0">
	<tr>
		<td style="width:22px; height:22px; background:url('resources/blur-1.png') no-repeat bottom right"><img src="resources/spacer.gif" width="1" height="1" alt="" /></td>
		
		<td class="text" valign="bottom" style="width:100px; font-size:14px; background:url('resources/blur-2.png') repeat-x bottom">
		<img src="resources/spacer.gif" width="33" height="1" alt="" />
		<script type="text/javascript">
		<![CDATA[
		if (numberOfImages > 0) document.write("<span id=\"page\">" + image + "</span> / " + numberOfImages);
		]]>
		</script>
		</td>
		
		<td class="bigtitle" valign="bottom" style="width:400px; text-align:center; font-size:20px; background:url('resources/blur-2.png') repeat-x bottom">
		<xsl:value-of select="name"/>
		</td>
		
		<td class="text" valign="bottom" style="width:100px; text-align:right; background:url('resources/blur-2.png') repeat-x bottom">
		<script type="text/javascript">
		<![CDATA[
		document.write("<a href=\"subalbum_" + subalbumNumber + ".html#img" + image + "\" id=\"thumbnails\" title=\"Return to thumbnails\"><img src=\"resources/thumbnails.gif\" width=\"63\" height=\"9\" alt=\"Thumbnails\" border=\"0\" /></a>");
		]]>
		</script>
		<img src="resources/spacer.gif" width="33" height="1" alt="" />
		</td>
		
		<td style="width:22px; height:22px; background:url('resources/blur-3.png') no-repeat bottom left"><img src="resources/spacer.gif" width="1" height="1" alt="" /></td>
	</tr>
	<tr>
		<td style="width:40px; text-align:right; background:url('resources/blur-4.png') repeat-y right">
			<script type="text/javascript">
			<![CDATA[
			document.write("<div id=\"prevImage\" style=\"visibility:" + ((image > 1) ? "visible" : "hidden") + "\"><a href=\"javascript:pImage()\"><img src=\"resources/prev.png\" width=\"40\" height=\"40\" border=\"0\" alt=\"Previous Image\" /></a></div>");
			]]>
			</script>
		</td>
		
		<td colspan="3" class="text" style="width:600px; height:400px; background-color:#FFFFFF; text-align:center">
<script type="text/javascript">
<![CDATA[
if (image) {
	if (!dontShowLink && numberOfImages > 0) document.write("<a href=\"img/]]><xsl:value-of select="$subalbumNumber"/><![CDATA[/" + image + ".jpg\" title=\"Click for a larger image\" id=\"large\" target=\"_blank\">");
	if (numberOfImages > 0) document.write("<img src=\"img/]]><xsl:value-of select="$subalbumNumber"/><![CDATA[/" + image + "_slideshow.jpg\" width=\"600\" height=\"400\" id=\"slideshow\" alt=\"\" border=\"0\">");
	else document.write("This collection doesn't contain any images");
	if (!dontShowLink && numberOfImages > 0) document.write("</a>");
	
	if (numberOfImages > 0 && compatible) document.getElementById("slideshow").onload = photoLoaded;
}
]]>
</script>
		<div id="loading" style="position:absolute; left:335px; top:220px; visibility:hidden"><img src="resources/loading.gif" alt="Loading..." /></div>
		</td>
		
		<td style="width:40px; background:url('resources/blur-5.png') repeat-y">
			<script type="text/javascript">
			<![CDATA[
			document.write("<div id=\"nextImage\" style=\"visibility:" + ((image < numberOfImages) ? "visible" : "hidden") + "\"><a href=\"javascript:nImage()\"><img src=\"resources/next.png\" width=\"40\" height=\"40\" border=\"0\" alt=\"Next Image\" /></a></div>");
			]]>
			</script>
		</td>
	</tr>
	<tr>
		<td style="width:22px; height:22px; background:url('resources/blur-6.png') no-repeat top right"><img src="resources/spacer.gif" width="1" height="1" alt="" /></td>
		
		<td colspan="3" class="text" valign="top" style="text-align:center; background:url('resources/blur-7.png') repeat-x">
		<img src="resources/spacer.gif" width="1" height="3" alt="" /><br />
		<script type="text/javascript">
		<![CDATA[
		if (numberOfImages > 0) document.write("<span id=\"description\">" + imageDescription[image - 1] + "</span>");
		]]>
		</script>
		</td>
		
		<td style="width:22px; height:22px; background:url('resources/blur-8.png') no-repeat top left"><img src="resources/spacer.gif" width="1" height="1" alt="" /></td>
	</tr>
</table>

</body>
</html>

</xsl:document>




</xsl:for-each>






</xsl:template>

</xsl:stylesheet>
