/*
 * Copyright (c) 2007-2011 by The Broad Institute of MIT and Harvard.  All Rights Reserved.
 *
 * This software is licensed under the terms of the GNU Lesser General Public License (LGPL),
 * Version 2.1 which is available at http://www.opensource.org/licenses/lgpl-2.1.php.
 *
 * THE SOFTWARE IS PROVIDED "AS IS." THE BROAD AND MIT MAKE NO REPRESENTATIONS OR
 * WARRANTES OF ANY KIND CONCERNING THE SOFTWARE, EXPRESS OR IMPLIED, INCLUDING,
 * WITHOUT LIMITATION, WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, WHETHER
 * OR NOT DISCOVERABLE.  IN NO EVENT SHALL THE BROAD OR MIT, OR THEIR RESPECTIVE
 * TRUSTEES, DIRECTORS, OFFICERS, EMPLOYEES, AND AFFILIATES BE LIABLE FOR ANY DAMAGES
 * OF ANY KIND, INCLUDING, WITHOUT LIMITATION, INCIDENTAL OR CONSEQUENTIAL DAMAGES,
 * ECONOMIC DAMAGES OR INJURY TO PROPERTY AND LOST PROFITS, REGARDLESS OF WHETHER
 * THE BROAD OR MIT SHALL BE ADVISED, SHALL HAVE OTHER REASON TO KNOW, OR IN FACT
 * SHALL KNOW OF THE POSSIBILITY OF THE FOREGOING.
 */

/*
 * GenomeSelectionDialog.java
 *
 * Created on November 8, 2007, 3:51 PM
 */

package org.broad.igv.ui;

import java.awt.*;
import java.awt.Component;
import java.awt.event.*;
import com.jidesoft.combobox.*;
import org.broad.igv.feature.genome.GenomeDescriptor;

import javax.swing.*;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.layout.LayoutStyle;

/**
 * @author eflakes
 */
public class GenomeSelectionDialog extends javax.swing.JDialog {

    private boolean isCanceled = true;

    /**
     * Creates new form GenomeSelectionDialog
     */
    public GenomeSelectionDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        setLocationRelativeTo(parent);
    }

    public void setModel(ComboBoxModel model) {
        genomeComboBox.setModel(model);
    }

    public GenomeDescriptor getSelectedItem() {
        return (isCanceled ? null : (GenomeDescriptor) genomeComboBox.getSelectedItem());
    }

    public boolean isCanceled() {
        return isCanceled;
    }

    public void setCancelingEnabled(boolean isEnabled) {
        cancelButton.setEnabled(isEnabled);
    }

    public void setDefaultGenome(GenomeDescriptor genome) {
        genomeComboBox.setSelectedItem(genome);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    // Generated using JFormDesigner non-commercial license
    private void initComponents() {
        genomeComboBox = new ListComboBox();
        genomeComboBoxLabel = new JLabel();
        okButton = new JButton();
        cancelButton = new JButton();

        //======== this ========
        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Choose Genome");
        setResizable(false);
        Container contentPane = getContentPane();

        //---- genomeComboBox ----
        genomeComboBox.setEditable(false);

        //---- genomeComboBoxLabel ----
        genomeComboBoxLabel.setText("Genome");

        //---- okButton ----
        okButton.setText("Ok");
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                okButtonActionPerformed(e);
            }
        });

        //---- cancelButton ----
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                cancelButtonActionPerformed(e);
            }
        });

        GroupLayout contentPaneLayout = new GroupLayout(contentPane);
        contentPane.setLayout(contentPaneLayout);
        contentPaneLayout.setHorizontalGroup(
            contentPaneLayout.createParallelGroup()
                .add(GroupLayout.TRAILING, contentPaneLayout.createSequentialGroup()
                    .add(24, 24, 24)
                    .add(contentPaneLayout.createParallelGroup()
                        .add(contentPaneLayout.createSequentialGroup()
                            .add(genomeComboBoxLabel)
                            .add(20, 20, 20)
                            .add(genomeComboBox, GroupLayout.DEFAULT_SIZE, 422, Short.MAX_VALUE))
                        .add(GroupLayout.TRAILING, contentPaneLayout.createSequentialGroup()
                            .addPreferredGap(LayoutStyle.RELATED, 120, GroupLayout.PREFERRED_SIZE)
                            .add(okButton)
                            .addPreferredGap(LayoutStyle.RELATED)
                            .add(cancelButton)
                            .add(195, 195, 195)))
                    .addContainerGap())
        );
        contentPaneLayout.linkSize(new Component[] {cancelButton, okButton}, GroupLayout.HORIZONTAL);
        contentPaneLayout.setVerticalGroup(
            contentPaneLayout.createParallelGroup()
                .add(contentPaneLayout.createSequentialGroup()
                    .add(34, 34, 34)
                    .add(contentPaneLayout.createParallelGroup(GroupLayout.BASELINE)
                        .add(genomeComboBoxLabel)
                        .add(genomeComboBox, GroupLayout.PREFERRED_SIZE, 23, GroupLayout.PREFERRED_SIZE))
                    .add(25, 25, 25)
                    .add(contentPaneLayout.createParallelGroup(GroupLayout.BASELINE)
                        .add(okButton)
                        .add(cancelButton))
                    .addContainerGap(130, Short.MAX_VALUE))
        );
        contentPaneLayout.linkSize(new Component[] {cancelButton, okButton}, GroupLayout.VERTICAL);
        pack();
        setLocationRelativeTo(getOwner());
    }// </editor-fold>//GEN-END:initComponents

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        isCanceled = true;
        setVisible(false);
        dispose();
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        isCanceled = false;
        setVisible(false);
        dispose();
    }//GEN-LAST:event_okButtonActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new GenomeSelectionDialog(new javax.swing.JFrame(), true).setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    // Generated using JFormDesigner non-commercial license
    private ListComboBox genomeComboBox;
    private JLabel genomeComboBoxLabel;
    private JButton okButton;
    private JButton cancelButton;
    // End of variables declaration//GEN-END:variables

}
