/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.ServerCertGetAttributesRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.GetServerCertificateRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.GetServerCertificateResult;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ServerCertificateMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMServerCertGetAttributesDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMServerCertGetAttributesDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof ServerCertGetAttributesRequest) {
            ServerCertGetAttributesRequest getRequest = (ServerCertGetAttributesRequest)request;
            LOG.debug((Object)("Getting server certificate attributes: " + getRequest));
            GetServerCertificateRequest getSCRequest = new GetServerCertificateRequest();
            getSCRequest.setServerCertificateName(getRequest.getServerCertificateName());
            GetServerCertificateResult getSCResult = this.getClient().getServerCertificate(getSCRequest);
            ServerCertificateMetadata scMetadata = getSCResult.getServerCertificate().getServerCertificateMetadata();
            LOG.info((Object)scMetadata.getArn());
            LOG.info((Object)scMetadata.getServerCertificateId());
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

