/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.GroupDelRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.DeleteGroupPolicyRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.DeleteGroupRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.GetGroupRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.GetGroupResult;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListGroupPoliciesRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.ListGroupPoliciesResult;
import com.amazonaws.services.awsidentitymanagementv20100508.model.RemoveUserFromGroupRequest;
import com.amazonaws.services.awsidentitymanagementv20100508.model.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMGroupDelDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMGroupDelDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof GroupDelRequest) {
            LOG.debug((Object)("Deleting group " + request));
            GroupDelRequest req = (GroupDelRequest)request;
            if (req.isRecursive()) {
                GetGroupRequest getGroupRequest = new GetGroupRequest();
                getGroupRequest.setGroupName(req.getGroupName());
                LOG.debug((Object)"Listing users in group");
                GetGroupResult getGroupResult = this.getClient().getGroup(getGroupRequest);
                if (!getGroupResult.getUsers().isEmpty()) {
                    if (req.isNoop()) {
                        LOG.info((Object)"users");
                        for (User user : getGroupResult.getUsers()) {
                            LOG.info((Object)("\t" + user.getArn()));
                        }
                    } else {
                        RemoveUserFromGroupRequest removeUserFromGroupRequest = new RemoveUserFromGroupRequest();
                        removeUserFromGroupRequest.setGroupName(req.getGroupName());
                        for (User user : getGroupResult.getUsers()) {
                            removeUserFromGroupRequest.setUserName(user.getUserName());
                            LOG.debug((Object)("Deleting user " + user.getArn()));
                            this.getClient().removeUserFromGroup(removeUserFromGroupRequest);
                        }
                    }
                }
                ListGroupPoliciesRequest listPoliciesRequest = new ListGroupPoliciesRequest();
                listPoliciesRequest.setGroupName(req.getGroupName());
                LOG.debug((Object)"Listing policies in group");
                ListGroupPoliciesResult listPoliciesResult = this.getClient().listGroupPolicies(listPoliciesRequest);
                if (!listPoliciesResult.getPolicyNames().isEmpty()) {
                    if (req.isNoop()) {
                        LOG.info((Object)"policies");
                        for (String policy : listPoliciesResult.getPolicyNames()) {
                            LOG.info((Object)("\t" + policy));
                        }
                    } else {
                        DeleteGroupPolicyRequest deletePolicyRequest = new DeleteGroupPolicyRequest();
                        deletePolicyRequest.setGroupName(req.getGroupName());
                        for (String policy : listPoliciesResult.getPolicyNames()) {
                            deletePolicyRequest.setPolicyName(policy);
                            LOG.debug((Object)("Deleting policy " + policy));
                            this.getClient().deleteGroupPolicy(deletePolicyRequest);
                        }
                    }
                }
            }
            if (!req.isNoop() || !req.isRecursive()) {
                DeleteGroupRequest deleteGroupRequest = new DeleteGroupRequest();
                deleteGroupRequest.setGroupName(req.getGroupName());
                LOG.debug((Object)"deleting group");
                this.getClient().deleteGroup(deleteGroupRequest);
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

