/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001, 2005 SIL International. All rights reserved.

Distributable under the terms of either the Common Public License or the
GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: XftFont.cpp
Responsibility: Keith Stribley
Last reviewed: Tim Eves, Jun 2007'

Description:
    A Font is an object that represents a font-family + bold + italic setting, that contains
  Graphite tables.
----------------------------------------------------------------------------------------------*/
#include <cassert>
#include <iostream>
#include <X11/Xlib.h>
#include "XftGrFont.h"

#include  FT_TRUETYPE_TABLES_H

namespace gr
{


XftGrFont::XftGrFont(XftFont * xftFont, Display * disp, Screen * scrn)
  : FreetypeFont(XftLockFace(xftFont)),
  m_font(xftFont)
{
  assert(m_font); // shouldn't be null but we play safe anyway
//  std::cerr << "XftGrFont(" << std::hex << this << "): locked XftFont(" << std::hex << m_font << ")" << std::endl;
  initializeDPI(disp, scrn);
}


XftGrFont::XftGrFont(const XftGrFont & rhs)
  : FreetypeFont(rhs),
    m_font(rhs.m_font)
{ XftLockFace(m_font);
//  std::cerr << "XftGrFont(" << std::hex << this << "): locked XftFont(" << std::hex << m_font << ")" << std::endl;
}


XftGrFont::~XftGrFont()
{
  XftUnlockFace(m_font);
//  std::cerr << "XftGrFont(" << std::hex << this << "): unlocked XftFont(" << std::hex << m_font << ")" << std::endl;
}
  

void
XftGrFont::initializeDPI(Display * disp, Screen * scrn)
{
  Display * lDisp = disp;
  if (disp == NULL)
  {
    disp = XOpenDisplay(NULL);  // get current display
  }
  // this may fail if the max number of X clients is exceeded
  if (disp != NULL) 
  {
    if (scrn == NULL)
    {
      scrn = DefaultScreenOfDisplay(disp);
    }
    if (scrn != NULL)
    {
      setDPIx(unsigned(WidthOfScreen(scrn) * 25.4 / WidthMMOfScreen(scrn)));
      setDPIy(unsigned(HeightOfScreen(scrn) * 25.4 / HeightMMOfScreen(scrn)));
    }
    if (lDisp == NULL)        // we opened a display so close it
    {
      XCloseDisplay(disp);
    }
  }
}


Font * XftGrFont::copyThis()
{
  XftGrFont * copy = new XftGrFont(*this);
  return copy;
}


bool XftGrFont::FontHasGraphiteTables(XftFont * xftFont)
{
  assert(xftFont != 0);

  const FT_Face face = XftLockFace(xftFont);
  const bool isGraphiteFont = FreetypeFont::FontHasGraphiteTables(face);
  XftUnlockFace(xftFont);

  return isGraphiteFont;
}

} // namespace gr

