#include "HSLPane.hpp"

#include "wx/sizer.h"

#define PADDING 4

using namespace indii::tint;
using namespace indii::tint::gui;

HSLPane::HSLPane(wxWindow* parent, ImageResource* res, 
    ClusterModel* model) : wxScrolledWindow(parent), res(res), model(model) {
  watch(model);

  unsigned int i;
  
  /* thumbnails */
  ThumbHSL* thumb;
  for (i = 0; i < 16; i++) {
    thumb = new ThumbHSL(this, res, model, i);    
    thumbs.push_back(thumb);
  }
  
  /* layout */
  wxFlexGridSizer* sizer = new wxFlexGridSizer(1);
  for (i = 0; i < 16; i++) {
    sizer->Add(thumbs[i], 0, wxALL, PADDING);
    thumbs[i]->Show(i < model->getNumClusters());
  }
  SetScrollRate(10,10);
  SetSizer(sizer);
  int thumbSize = thumbs[0]->GetSize().GetWidth() + 2*PADDING;
  SetClientSize(thumbSize, thumbSize);
  updateLayout();
}

HSLPane::~HSLPane() {
  //
}

void HSLPane::updateLayout() {
  const wxSize& size = GetSize();
  const wxSize& thumbSize = thumbs[0]->GetSize();
  int cols = std::max(size.GetWidth() / (thumbSize.GetWidth()+2*PADDING), 1);
  
  wxFlexGridSizer* sizer = dynamic_cast<wxFlexGridSizer*>(GetSizer());
  sizer->SetCols(cols);
  sizer->FitInside(this);
}

void HSLPane::OnSize(wxSizeEvent& evt) {
  updateLayout();
}

void HSLPane::notifyNumClustersChange() {
  unsigned int i = 0;
  
  while (i < model->getNumClusters()) {
    thumbs[i]->Show(true);
    thumbs[i]->Refresh();
    i++;
  }
  while (i < thumbs.size()) {
    thumbs[i]->Show(false);
    thumbs[i]->Refresh();
    i++;
  }
  updateLayout();
}

BEGIN_EVENT_TABLE(HSLPane, wxWindow)
#ifndef __WXMAC__
// wxFlexGridSizer::SetCols() seems to cause crash on Mac
EVT_SIZE(HSLPane::OnSize)
#endif
END_EVENT_TABLE()

