/*
 * AudioExtractor.cc -- Audio Format Support
 * Copyright (C) 2003 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <config.h>
#include <iostream>
#include <string>
using std::string;

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include "AudioExtractor.h"
#include "AudioImporter.h"
#include "AudioWav.h"

#include <frame.h>

/** Default audio handler - do nothing with it.
*/

class NullAudioExtractor : public AudioExtractor
{
	public:
		bool Initialise( Frame &frame )
		{
			return true;
		}

		bool Output( Frame &frame )
		{
			return true;
		}

		bool Flush( )
		{
			return true;
		}
};

/** Factory method for audio extractor creation
*/

AudioExtractor *AudioExtractor::GetExtractor( string filename )
{
	if ( filename == "" )
		return new NullAudioExtractor( );
	else if ( filename.find( ".mp2" ) != string::npos )
		return new Mp2Exporter( filename );
	else
		return new WavExporter( filename );
}

/** Factory method fo audio importing.
*/

AudioImporter *AudioImporter::GetImporter( string input )
{
	AudioImporter *wav = new WavImporter( );
	if ( wav->Open( input ) )
		return wav;
	else
		delete wav;
	return NULL;
}
